/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xsl.ui.tests.XSLModelXMLTestsPlugin;

public abstract class AbstractXSLUITest
extends TestCase {
    protected static IProject fTestProject;
    private static boolean fTestProjectInitialized;
    protected static final String PROJECT_FILES = "projectfiles";
    protected static final String TEST_PROJECT_NAME = "xsltestfiles";

    protected void setUp() throws Exception {
        super.setUp();
        if (!fTestProjectInitialized) {
            AbstractXSLUITest.getAndCreateProject();
            File srcDir = XSLModelXMLTestsPlugin.getTestFile("/projectfiles");
            String destinationProjectString = fTestProject.getLocation().toOSString();
            String cfr_ignored_0 = String.valueOf(destinationProjectString) + "/";
            File targetDir = new File(destinationProjectString);
            AbstractXSLUITest.copyDir(srcDir, targetDir);
            fTestProject.refreshLocal(2, null);
            fTestProjectInitialized = true;
        }
    }

    private static void getAndCreateProject() throws CoreException {
        IWorkspace workspace = AbstractXSLUITest.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        fTestProject = root.getProject(TEST_PROJECT_NAME);
        AbstractXSLUITest.createProject(fTestProject, null, null);
        fTestProject.refreshLocal(2, null);
        AbstractXSLUITest.assertTrue((boolean)fTestProject.exists());
    }

    private static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("creating test project", 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (Platform.getLocation().equals((Object)locationPath)) {
                    locationPath = null;
                }
                desc.setLocation(locationPath);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void tearDown() throws Exception {
        String projName = TEST_PROJECT_NAME;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        if (project.isAccessible()) {
            project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        AbstractXSLUITest.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        fTestProjectInitialized = false;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private static void copyDir(File src, File target) throws Exception {
        File[] files;
        if (!target.exists()) {
            target.mkdir();
        }
        File[] fileArray = files = src.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            File toFile = new File(target, file.getName());
            if (file.isDirectory()) {
                AbstractXSLUITest.copyDir(file, toFile);
            } else {
                AbstractXSLUITest.copyFile(file, toFile);
            }
            ++n2;
        }
    }

    private static void copyFile(File src, File target) throws Exception {
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(target));
            bis = new BufferedInputStream(new FileInputStream(src));
            while (bis.available() > 0) {
                int size = bis.available();
                if (size > 1024) {
                    size = 1024;
                }
                byte[] b = new byte[size];
                bis.read(b, 0, b.length);
                bos.write(b);
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }
}

