/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.jsdoc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.wst.jsdt.jsdoc.MappingException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XSLTMap {
    private File stylesheet;

    public XSLTMap(File stylesheet) {
        this.stylesheet = stylesheet;
    }

    public String applyMap(String datastring) throws MappingException {
        ByteArrayOutputStream xOutputStream = new ByteArrayOutputStream(1024);
        this.applyMap(datastring, xOutputStream);
        String XMLText = xOutputStream.toString();
        try {
            xOutputStream.close();
        }
        catch (IOException iOException) {}
        return XMLText;
    }

    public void applyMap(String dataString, OutputStream _os) throws MappingException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            byte[] docBytes = dataString.getBytes();
            Document document = builder.parse(new ByteArrayInputStream(docBytes));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(this.stylesheet);
            Transformer transformer = tFactory.newTransformer(stylesource);
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(_os);
            transformer.transform(source, result);
            transformer.clearParameters();
        }
        catch (SAXException sxe) {
            throw new MappingException("Transformer c error:\n" + sxe.getMessage());
        }
        catch (TransformerConfigurationException tce) {
            throw new MappingException("Transformer c error:\n" + tce.getMessage());
        }
        catch (TransformerException te) {
            throw new MappingException("Transformer error:\n" + te.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new MappingException("Transformer factory error:\n" + pce.getMessage());
        }
        catch (IOException ioe) {
            throw new MappingException("I/O Exception error (probably bad/missing XSL map) :\n" + ioe.getMessage());
        }
        catch (Exception ex) {
            throw new MappingException("General exceptioned occured while mapping: " + ex.getMessage());
        }
    }
}

