/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchGenericTests;

public class JavaSearchGenericConstructorTests
extends AbstractJavaSearchGenericTests {
    static /* synthetic */ Class class$0;

    public JavaSearchGenericConstructorTests(String name) {
        super(name, ERASURE_RULE);
    }

    JavaSearchGenericConstructorTests(String name, int matchRule) {
        super(name, matchRule);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.JavaSearchGenericConstructorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return JavaSearchGenericConstructorTests.buildModelTestSuite(clazz);
    }

    long removeFirstTypeArgument(char[] line) {
        int idx = 0;
        int length = line.length;
        while (line[idx++] != '[') {
            if (idx != length) continue;
            return -1L;
        }
        if (line[idx++] != '<') {
            return -1L;
        }
        int start = idx;
        int n = 1;
        while (idx < length && n != 0) {
            switch (line[idx++]) {
                case '<': {
                    ++n;
                    break;
                }
                case '>': {
                    --n;
                }
            }
        }
        if (n != 0) {
            return -1L;
        }
        return ((long)start << 32) + (long)idx;
    }

    void addResultLine(StringBuffer buffer, char[] line) {
        long positions = this.removeFirstTypeArgument(line);
        if (buffer.length() > 0) {
            buffer.append('\n');
        }
        if (positions != -1L) {
            int stop = (int)(positions >>> 32) - 1;
            int restart = (int)positions;
            buffer.append(line, 0, stop);
            buffer.append(line, restart, line.length - restart);
        } else {
            buffer.append(line);
        }
    }

    public void testConstructorReferencesElementPatternSingleTypeParameter01() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/c/def/Single.js").getType("Single");
        IFunction method = type.getFunction("Single", new String[]{"QT;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object())] ERASURE_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(new Object())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(new RuntimeException())] ERASURE_MATCH");
    }

    public void testConstructorReferencesElementPatternSingleTypeParameter02() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/c/def/Single.js").getType("Single");
        IFunction method = type.getFunction("Single", new String[]{"QT;", "QU;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), new Throwable())] ERASURE_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Throwable>Single<Object>(new Object(), new Throwable())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), new RuntimeException())] ERASURE_MATCH");
    }

    public void testConstructorReferencesElementPatternSingleTypeParameter03() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/c/def/Single.js").getType("Single");
        IFunction method = type.getFunction("Single", new String[]{"QSingle<QT;>;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(gs)] ERASURE_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(gs)] ERASURE_MATCH");
    }

    public void testConstructorReferencesElementPatternSingleTypeParameter04() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/c/def/Single.js").getType("Single");
        IFunction method = type.getFunction("Single", new String[]{"QU;", "QSingle<QT;>;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), gs)] ERASURE_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Exception>Single<Object>(new Exception(), gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), gs)] ERASURE_MATCH");
    }

    public void testConstructorReferencesElementPatternMultipleTypeParameter01() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/c/def/Multiple.js").getType("Multiple");
        IFunction method = type.getFunction("Multiple", new String[]{"QT1;", "QT2;", "QT3;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(new Object(), new Object(), new Object())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(new Exception(), new Exception(), new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(), new RuntimeException(), new RuntimeException())] ERASURE_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Object(), new Object())] ERASURE_RAW_MATCH");
    }

    public void testConstructorReferencesElementPatternMultipleTypeParameter02() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/c/def/Multiple.js").getType("Multiple");
        IFunction method = type.getFunction("Multiple", new String[]{"QMultiple<QT1;QT2;QT3;>;", "QU1;", "QU2;", "QU3;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(gm, new Object(), new Throwable(), new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(gm, new Exception(),new Exception(),new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(gm, new RuntimeException(),new RuntimeException(),new RuntimeException())] ERASURE_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm, new Object(), new Throwable(), new Exception())] ERASURE_RAW_MATCH");
    }

    public void testConstructorReferencesElementPatternMultipleTypeParameter03() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/c/def/Multiple.js").getType("Multiple");
        IFunction method = type.getFunction("Multiple", new String[]{"QMultiple<QT1;QT2;QT3;>;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm)] ERASURE_RAW_MATCH");
    }

    public void testConstructorReferencesElementPatternMultipleTypeParameter04() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/c/def/Multiple.js").getType("Multiple");
        IFunction method = type.getFunction("Multiple", new String[]{"QU1;", "QU2;", "QU3;", "QMultiple<QT1;QT2;QT3;>;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(new Object(), new Throwable(), new Exception(), gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(new Exception(),new Exception(),new Exception(), gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(),new RuntimeException(),new RuntimeException(), gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Throwable(), new Exception(), gm)] ERASURE_RAW_MATCH");
    }

    public void testConstructorReferencesElementPatternSingleParamArguments01() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "Single", 9);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(new Object())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(new Exception())] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(new RuntimeException())] ERASURE_MATCH");
    }

    public void testConstructorReferencesElementPatternSingleParamArguments02() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "Single", 10);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), new Throwable())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Throwable>Single<Object>(new Object(), new Throwable())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), new Exception())] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), new RuntimeException())] ERASURE_MATCH");
    }

    public void testConstructorReferencesElementPatternSingleParamArguments03() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "Single", 11);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(gs)] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(gs)] ERASURE_MATCH");
    }

    public void testConstructorReferencesElementPatternSingleParamArguments04() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "Single", 12);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Exception>Single<Object>(new Exception(), gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), gs)] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), gs)] ERASURE_MATCH");
    }

    public void testConstructorReferencesElementPatternSingleParamArguments05() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "Single", 5);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), new Throwable())] EXACT_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Throwable>Single<Object>(new Object(), new Throwable())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), new RuntimeException())] EQUIVALENT_MATCH");
    }

    public void testConstructorReferencesElementPatternSingleParamArguments06() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "Single", 7);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), gs)] EXACT_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Exception>Single<Object>(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), gs)] EQUIVALENT_MATCH");
    }

    public void testConstructorReferencesElementPatternMultipleParamArguments01() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "Multiple", 8);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(new Object(), new Object(), new Object())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(new Exception(), new Exception(), new Exception())] EXACT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(), new RuntimeException(), new RuntimeException())] ERASURE_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Object(), new Object())] EQUIVALENT_RAW_MATCH");
    }

    public void testConstructorReferencesElementPatternMultipleParamArguments02() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "Multiple", 9);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(gm, new Object(), new Throwable(), new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(gm, new Exception(),new Exception(),new Exception())] EXACT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(gm, new RuntimeException(),new RuntimeException(),new RuntimeException())] ERASURE_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm, new Object(), new Throwable(), new Exception())] EQUIVALENT_RAW_MATCH");
    }

    public void testConstructorReferencesElementPatternMultipleParamArguments03() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "Multiple", 10);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(gm)] EXACT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm)] EQUIVALENT_RAW_MATCH");
    }

    public void testConstructorReferencesElementPatternMultipleParamArguments04() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "Multiple", 11);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(new Object(), new Throwable(), new Exception(), gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(new Exception(),new Exception(),new Exception(), gm)] EXACT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(),new RuntimeException(),new RuntimeException(), gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Throwable(), new Exception(), gm)] EQUIVALENT_RAW_MATCH");
    }

    public void testConstructorReferencesElementPatternMultipleParamArguments05() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "Multiple", 5);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(gm, new Object(), new Throwable(), new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(gm, new Exception(),new Exception(),new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(gm, new RuntimeException(),new RuntimeException(),new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm, new Object(), new Throwable(), new Exception())] EXACT_RAW_MATCH");
    }

    public void testConstructorReferencesElementPatternMultipleParamArguments06() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "Multiple", 7);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(new Object(), new Throwable(), new Exception(), gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(new Exception(),new Exception(),new Exception(), gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(),new RuntimeException(),new RuntimeException(), gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Throwable(), new Exception(), gm)] EXACT_RAW_MATCH");
    }

    public void testConstructorReferencesStringPatternSingleParamArguments01() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("<Exception>Single", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), new Throwable())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(new Object())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Throwable>Single<Object>(new Object(), new Throwable())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Exception>Single<Object>(new Exception(), gs)] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(new Exception())] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), new Exception())] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(gs)] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), gs)] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(new RuntimeException())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), new RuntimeException())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), gs)] ERASURE_MATCH");
    }

    public void testConstructorReferencesStringPatternSingleParamArguments02() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("<? extends Exception> Single", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), new Throwable())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(new Object())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Throwable>Single<Object>(new Object(), new Throwable())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Exception>Single<Object>(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), gs)] EQUIVALENT_MATCH");
    }

    public void testConstructorReferencesStringPatternSingleParamArguments03() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("<? super Exception>S?ng*", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), new Throwable())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(new Object())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Throwable>Single<Object>(new Object(), new Throwable())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Exception>Single<Object>(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(new RuntimeException())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), new RuntimeException())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), gs)] ERASURE_MATCH");
    }

    public void testConstructorReferencesStringPatternSingleParamArguments04() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("Single", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object())] EXACT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), new Throwable())] EXACT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(gs)] EXACT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), gs)] EXACT_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(new Object())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Throwable>Single<Object>(new Object(), new Throwable())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Exception>Single<Object>(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), gs)] EQUIVALENT_MATCH");
    }

    public void testConstructorReferencesStringPatternSingleParamArguments05() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("Single(Object)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object())] EXACT_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(new Object())] EQUIVALENT_MATCH");
    }

    public void testConstructorReferencesStringPatternSingleParamArguments06() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("Single(Exception, Single<Exception>)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Exception>Single<Object>(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), gs)] EQUIVALENT_MATCH");
    }

    public void testConstructorReferencesStringPatternSingleParamArguments07() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("Single<Exception>", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), new Throwable())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testSingle() [new Single(new Object(), gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(new Object())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Throwable>Single<Object>(new Object(), new Throwable())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new Single<Object>(gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Exception>Single<Object>(new Exception(), gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(new Exception())] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), new Exception())] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(gs)] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), gs)] EXACT_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(new RuntimeException())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), new RuntimeException())] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new Single<RuntimeException>(gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testRuntimeException() [new <RuntimeException>Single<RuntimeException>(new RuntimeException(), gs)] ERASURE_MATCH");
    }

    public void testConstructorReferencesStringPatternSingleParamArguments08() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("Single<Exception>(Exception)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(new Exception())] EXACT_MATCH");
    }

    public void testConstructorReferencesStringPatternSingleParamArguments09() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("Single<? extends Exception>(Exception, Single<? super Exception>)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testObject() [new <Exception>Single<Object>(new Exception(), gs)] ERASURE_MATCH\nsrc/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new <Exception>Single<Exception>(new Exception(), gs)] EQUIVALENT_MATCH");
    }

    public void testConstructorReferencesStringPatternSingleParamArguments10() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Exception>Single(Exception)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(new Exception())] EXACT_MATCH");
    }

    public void testConstructorReferencesStringPatternSingleParamArguments11() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.c.def.Single<Exception>(Exception)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(new Exception())] EXACT_MATCH");
    }

    public void testConstructorReferencesStringPatternSingleParamArguments12() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.c.def.<? extends Exception>Single<? extends Exception>(Exception)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefSingle.java void g5.c.ref.RefSingle.testException() [new Single<Exception>(new Exception())] EQUIVALENT_MATCH");
    }

    public void testConstructorReferencesStringPatternMultipleParamArguments01() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("<?, ? extends Exception, ? super RuntimeException>Multiple", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(new Object(), new Object(), new Object())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(gm, new Object(), new Throwable(), new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(new Object(), new Throwable(), new Exception(), gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(new Exception(), new Exception(), new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(gm, new Exception(),new Exception(),new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(new Exception(),new Exception(),new Exception(), gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(), new RuntimeException(), new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(gm, new RuntimeException(),new RuntimeException(),new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(),new RuntimeException(),new RuntimeException(), gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Object(), new Object())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm, new Object(), new Throwable(), new Exception())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Throwable(), new Exception(), gm)] EQUIVALENT_RAW_MATCH");
    }

    public void testConstructorReferencesStringPatternMultipleParamArguments02() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("<Object, Exception, RuntimeException>Multiple", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(new Object(), new Object(), new Object())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(gm, new Object(), new Throwable(), new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(new Object(), new Throwable(), new Exception(), gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(new Exception(), new Exception(), new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(gm, new Exception(),new Exception(),new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(new Exception(),new Exception(),new Exception(), gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(), new RuntimeException(), new RuntimeException())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(gm, new RuntimeException(),new RuntimeException(),new RuntimeException())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(),new RuntimeException(),new RuntimeException(), gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Object(), new Object())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm, new Object(), new Throwable(), new Exception())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Throwable(), new Exception(), gm)] EQUIVALENT_RAW_MATCH");
    }

    public void testConstructorReferencesStringPatternMultipleParamArguments03() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("Multiple", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(new Object(), new Object(), new Object())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(gm, new Object(), new Throwable(), new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(new Object(), new Throwable(), new Exception(), gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(new Exception(), new Exception(), new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(gm, new Exception(),new Exception(),new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(new Exception(),new Exception(),new Exception(), gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(), new RuntimeException(), new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(gm, new RuntimeException(),new RuntimeException(),new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(),new RuntimeException(),new RuntimeException(), gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Object(), new Object())] EXACT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm, new Object(), new Throwable(), new Exception())] EXACT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm)] EXACT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Throwable(), new Exception(), gm)] EXACT_RAW_MATCH");
    }

    public void testConstructorReferencesStringPatternMultipleParamArguments04() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("Multiple(Exception,Exception,Exception)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(new Exception(), new Exception(), new Exception())] EQUIVALENT_MATCH");
    }

    public void testConstructorReferencesStringPatternMultipleParamArguments05() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("Multiple(RuntimeException,RuntimeException,RuntimeException,Multiple<RuntimeException, RuntimeException, RuntimeException>)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(),new RuntimeException(),new RuntimeException(), gm)] EQUIVALENT_MATCH");
    }

    public void testConstructorReferencesStringPatternMultipleParamArguments06() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("Multiple<RuntimeException, RuntimeException, RuntimeException>", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(new Object(), new Object(), new Object())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(gm, new Object(), new Throwable(), new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(new Object(), new Throwable(), new Exception(), gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(new Exception(), new Exception(), new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(gm, new Exception(),new Exception(),new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(new Exception(),new Exception(),new Exception(), gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(), new RuntimeException(), new RuntimeException())] EXACT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(gm, new RuntimeException(),new RuntimeException(),new RuntimeException())] EXACT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(gm)] EXACT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(),new RuntimeException(),new RuntimeException(), gm)] EXACT_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Object(), new Object())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm, new Object(), new Throwable(), new Exception())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Throwable(), new Exception(), gm)] EQUIVALENT_RAW_MATCH");
    }

    public void testConstructorReferencesStringPatternMultipleParamArguments07() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("Multiple<?,? extends Throwable,? extends Exception>", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(new Object(), new Object(), new Object())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(gm, new Object(), new Throwable(), new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new <Object, Throwable, Exception>Multiple<Object, Object, Object>(new Object(), new Throwable(), new Exception(), gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(new Exception(), new Exception(), new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(gm, new Exception(),new Exception(),new Exception())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new <Exception, Exception, Exception>Multiple<Exception, Exception, Exception>(new Exception(),new Exception(),new Exception(), gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(), new RuntimeException(), new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(gm, new RuntimeException(),new RuntimeException(),new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new <RuntimeException, RuntimeException, RuntimeException>Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(),new RuntimeException(),new RuntimeException(), gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Object(), new Object())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm, new Object(), new Throwable(), new Exception())] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm)] EQUIVALENT_RAW_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Throwable(), new Exception(), gm)] EQUIVALENT_RAW_MATCH");
    }

    public void testConstructorReferencesStringPatternMultipleParamArguments08() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("<RuntimeException, RuntimeException, RuntimeException>Multiple(*,*,*)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(new Object(), new Object(), new Object())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(new Exception(), new Exception(), new Exception())] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(new RuntimeException(), new RuntimeException(), new RuntimeException())] EXACT_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(new Object(), new Object(), new Object())] EQUIVALENT_RAW_MATCH");
    }

    public void testConstructorReferencesStringPatternMultipleParamArguments09() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.c.ref", false);
        this.search("<?,? extends Throwable,? extends RuntimeException>Multiple(*)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testObject() [new Multiple<Object, Object, Object>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(gm)] ERASURE_MATCH\nsrc/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testRuntimeException() [new Multiple<RuntimeException, RuntimeException, RuntimeException>(gm)] EQUIVALENT_MATCH\nsrc/g5/c/ref/RefRaw.java void g5.c.ref.RefRaw.testMultiple() [new Multiple(gm)] EQUIVALENT_RAW_MATCH");
    }

    public void testConstructorReferencesStringPatternMultipleParamArguments10() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Object,Exception,Exception>Multiple(Exception,Exception,Exception)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(new Exception(), new Exception(), new Exception())] ERASURE_MATCH");
    }

    public void testConstructorReferencesStringPatternMultipleParamArguments11() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.c.def.Multiple<Exception,Exception,Exception>(Exception,Exception,Exception)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(new Exception(), new Exception(), new Exception())] EXACT_MATCH");
    }

    public void testConstructorReferencesStringPatternMultipleParamArguments12() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.c.def.<?,? extends Throwable,? extends Throwable>Multiple<?,? extends Throwable,? extends Exception>(Exception,Exception,Exception)", 3, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/ref/RefMultiple.java void g5.c.ref.RefMultiple.testException() [new Multiple<Exception, Exception, Exception>(new Exception(), new Exception(), new Exception())] EQUIVALENT_MATCH");
    }

    public void testConstructorDeclarationsElementPatternSingleParamArguments01() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "Single", 9);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationsElementPatternSingleParamArguments02() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "Single", 10);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T, U) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationsElementPatternSingleParamArguments03() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "Single", 11);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationsElementPatternSingleParamArguments04() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "Single", 12);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(U, Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationssElementPatternSingleParamArguments05() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "Single", 5);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T, U) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationssElementPatternSingleParamArguments06() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "Single", 7);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(U, Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationsElementPatternMultipleParamArguments01() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "Multiple", 8);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(T1, T2, T3) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationsElementPatternMultipleParamArguments02() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "Multiple", 9);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>, U1, U2, U3) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationsElementPatternMultipleParamArguments03() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "Multiple", 10);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationsElementPatternMultipleParamArguments04() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "Multiple", 11);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(U1, U2, U3, Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationssElementPatternMultipleParamArguments05() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "Multiple", 5);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>, U1, U2, U3) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationssElementPatternMultipleParamArguments06() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/c/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "Multiple", 7);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(U1, U2, U3, Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternSingleParamArguments01() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Exception>Single", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T, U) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(U, Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternSingleParamArguments02() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<T>Single", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T, U) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(U, Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternSingleParamArguments03() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<U>S?ng*", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T, U) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(U, Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternSingleParamArguments04() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Single", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(T, U) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(Single<T>) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(U, Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternSingleParamArguments05() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Single(*)", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternSingleParamArguments06() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Single(*, *)", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T, U) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(U, Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternSingleParamArguments07() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Single<Exception>", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T, U) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(U, Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternSingleParamArguments08() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Single<Exception>(*)", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("");
    }

    public void testConstructorDeclarationsStringPatternSingleParamArguments09() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Single<? extends Exception>(*, *)", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T, U) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(U, Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationssStringPatternSingleParamArguments10() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Exception>Single", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T, U) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(U, Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationssStringPatternSingleParamArguments11() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.c.def.Single<Exception>", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T, U) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(U, Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationssStringPatternSingleParamArguments12() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.c.def.<? extends Exception>Single<? extends Exception>", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Single.java g5.c.def.Single(T, U) [Single] EXACT_MATCH\nsrc/g5/c/def/Single.java g5.c.def.Single(U, Single<T>) [Single] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternMultipleParamArguments01() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<?, ? extends Exception, ? super RuntimeException>Multiple", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>, U1, U2, U3) [Multiple] EXACT_MATCH\nsrc/g5/c/def/Multiple.java g5.c.def.Multiple(U1, U2, U3, Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternMultipleParamArguments02() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Object, Exception, RuntimeException>Multiple", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>, U1, U2, U3) [Multiple] EXACT_MATCH\nsrc/g5/c/def/Multiple.java g5.c.def.Multiple(U1, U2, U3, Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternMultipleParamArguments03() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Multiple", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(T1, T2, T3) [Multiple] EXACT_MATCH\nsrc/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>, U1, U2, U3) [Multiple] EXACT_MATCH\nsrc/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH\nsrc/g5/c/def/Multiple.java g5.c.def.Multiple(U1, U2, U3, Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternMultipleParamArguments04() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Multiple(*,*,*)", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(T1, T2, T3) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternMultipleParamArguments05() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Multiple(*,*,*,*)", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>, U1, U2, U3) [Multiple] EXACT_MATCH\nsrc/g5/c/def/Multiple.java g5.c.def.Multiple(U1, U2, U3, Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternMultipleParamArguments06() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Multiple<RuntimeException, RuntimeException, RuntimeException>", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>, U1, U2, U3) [Multiple] EXACT_MATCH\nsrc/g5/c/def/Multiple.java g5.c.def.Multiple(U1, U2, U3, Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternMultipleParamArguments07() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Multiple<?,? extends Throwable,? extends Exception>", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>, U1, U2, U3) [Multiple] EXACT_MATCH\nsrc/g5/c/def/Multiple.java g5.c.def.Multiple(U1, U2, U3, Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationsStringPatternMultipleParamArguments08() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<RuntimeException, RuntimeException, RuntimeException>Multiple(*,*,*)", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("");
    }

    public void testConstructorDeclarationsStringPatternMultipleParamArguments09() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<?,? extends Throwable,? extends RuntimeException>Multiple", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>, U1, U2, U3) [Multiple] EXACT_MATCH\nsrc/g5/c/def/Multiple.java g5.c.def.Multiple(U1, U2, U3, Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationssStringPatternMultipleParamArguments10() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Object,Exception,Exception>Multiple(*,*,*,*)", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>, U1, U2, U3) [Multiple] EXACT_MATCH\nsrc/g5/c/def/Multiple.java g5.c.def.Multiple(U1, U2, U3, Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationssStringPatternMultipleParamArguments11() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.c.def.Multiple<Object,Exception,Exception>(*,*,*,*)", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>, U1, U2, U3) [Multiple] EXACT_MATCH\nsrc/g5/c/def/Multiple.java g5.c.def.Multiple(U1, U2, U3, Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }

    public void testConstructorDeclarationssStringPatternMultipleParamArguments12() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.c.def.<?,? extends Throwable,? extends Throwable>Multiple<?,? extends Throwable,? extends Exception>(*,*,*,*)", 3, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/c/def/Multiple.java g5.c.def.Multiple(Multiple<T1,T2,T3>, U1, U2, U3) [Multiple] EXACT_MATCH\nsrc/g5/c/def/Multiple.java g5.c.def.Multiple(U1, U2, U3, Multiple<T1,T2,T3>) [Multiple] EXACT_MATCH");
    }
}

