/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;

public class CreateImportsTests
extends AbstractJavaModelTests {
    static /* synthetic */ Class class$0;

    public CreateImportsTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.CreateImportsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return CreateImportsTests.buildModelTestSuite(clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IJavaScriptUnit workingCopy = this.getCompilationUnit("P/X.js");
        workingCopy.becomeWorkingCopy(null, null);
        this.workingCopies = new IJavaScriptUnit[]{workingCopy};
        this.setContents("public class X {\n}");
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.createJavaProject("P", new String[]{""}, new String[]{"JCL15_LIB"}, "", "1.5");
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("P");
        super.tearDownSuite();
    }

    private String createImport(String importName, int flags) throws JavaScriptModelException {
        return this.createImport(importName, flags, null);
    }

    private String createImport(String importName, int flags, IJavaScriptElement sibling) throws JavaScriptModelException {
        IJavaScriptUnit workingCopy = this.workingCopies[0];
        workingCopy.createImport(importName, sibling, flags, null);
        Map options = this.getJavaProject("P").getOptions(true);
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "0");
        CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)options);
        String source = workingCopy.getSource();
        Document document = new Document(source);
        TextEdit edit = formatter.format(8, source, 0, source.length() - 1, 0, "\n");
        try {
            edit.apply((IDocument)document, 0);
        }
        catch (MalformedTreeException malformedTreeException) {
        }
        catch (BadLocationException badLocationException) {}
        return document.get();
    }

    private void setContents(String contents) throws JavaScriptModelException {
        this.workingCopies[0].getBuffer().setContents(contents);
        this.workingCopies[0].makeConsistent(null);
    }

    public void test001() throws JavaScriptModelException {
        String actualSource = this.createImport("java.lang.Math.*", 8);
        this.assertSourceEquals("Unexpected source", "import static java.lang.Math.*;\n\npublic class X {\n}", actualSource);
    }

    public void test002() throws JavaScriptModelException {
        String actualSource = this.createImport("java.util.ZipFile", 0);
        this.assertSourceEquals("Unexpected source", "import java.util.ZipFile;\n\npublic class X {\n}", actualSource);
    }

    public void test003() throws JavaScriptModelException {
        this.setContents("import static java.lang.Math.*;\n\npublic class X {\n}");
        String actualSource = this.createImport("java.lang.Math.*", 8);
        this.assertSourceEquals("Unexpected source", "import static java.lang.Math.*;\n\npublic class X {\n}", actualSource);
    }

    public void test004() throws JavaScriptModelException {
        this.setContents("import java.util.ZipFile;\n\npublic class X {\n}");
        String actualSource = this.createImport("java.util.ZipFile", 0);
        this.assertSourceEquals("Unexpected source", "import java.util.ZipFile;\n\npublic class X {\n}", actualSource);
    }

    public void test005() throws JavaScriptModelException {
        this.setContents("import java.util.ZipFile;\n\npublic class X {\n}");
        String actualSource = this.createImport("java.util.ZipFile.*", 8);
        this.assertSourceEquals("Unexpected source", "import java.util.ZipFile;\nimport static java.util.ZipFile.*;\n\npublic class X {\n}", actualSource);
    }

    public void test006() throws JavaScriptModelException {
        this.setContents("import java.util.ZipFile;\nimport static java.util.ZipFile.*;\n\npublic class X {\n}");
        String actualSource = this.createImport("java.util.ZipFile.*", 0);
        this.assertSourceEquals("Unexpected source", "import java.util.ZipFile;\nimport static java.util.ZipFile.*;\nimport java.util.ZipFile.*;\n\npublic class X {\n}", actualSource);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test007() throws JavaScriptModelException {
        try {
            this.startDeltas();
            this.createImport("java.util.ZipFile", 0);
            this.assertDeltas("Unexpected delta", "<import container>[+]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test008() throws JavaScriptModelException {
        this.setContents("import static java.lang.Math.*;\n\npublic class X {\n}");
        try {
            this.startDeltas();
            this.createImport("java.util.*", 0);
            this.assertDeltas("Unexpected delta", "<import container>[*]: {CHILDREN | FINE GRAINED}\n\timport java.util.*[+]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
    }

    public void test009() throws JavaScriptModelException {
        this.setContents("import static java.lang.Math.*;\n\npublic class X {\n}");
        IImportDeclaration sibling = this.workingCopies[0].getImport("java.lang.Math.*");
        String actualSource = this.createImport("java.util.ZipFile", 0, (IJavaScriptElement)sibling);
        this.assertSourceEquals("Unexpected source", "import java.util.ZipFile;\nimport static java.lang.Math.*;\n\npublic class X {\n}", actualSource);
    }

    public void test010() throws JavaScriptModelException {
        JavaScriptModelException exception = null;
        try {
            this.createImport(null, 8);
        }
        catch (JavaScriptModelException e) {
            exception = e;
        }
        this.assertExceptionEquals("Unexpected exception", "Invalid name specified: null", exception);
    }

    public void test011() throws JavaScriptModelException {
        JavaScriptModelException exception = null;
        try {
            this.createImport("java.,.", 8);
        }
        catch (JavaScriptModelException e) {
            exception = e;
        }
        this.assertExceptionEquals("Unexpected exception", "Invalid name specified: java.,.", exception);
    }
}

