/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.ISourceManipulation;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public abstract class CopyMoveTests
extends ModifyingResourceTests {
    public CopyMoveTests(String name) {
        super(name);
    }

    public void copyNegative(IJavaScriptElement element, IJavaScriptElement destination, IJavaScriptElement sibling, String rename, boolean force, int failureCode) {
        try {
            ((ISourceManipulation)element).copy(destination, sibling, rename, force, null);
        }
        catch (JavaScriptModelException jme) {
            CopyMoveTests.assertTrue((String)("Code not correct for JavaScriptModelException: " + (Object)((Object)jme)), (jme.getStatus().getCode() == failureCode ? 1 : 0) != 0);
            return;
        }
        CopyMoveTests.assertTrue((String)("The copy should have failed for: " + element), (boolean)false);
    }

    public void copyNegative(IJavaScriptElement[] elements, IJavaScriptElement[] destinations, IJavaScriptElement[] siblings, String[] renames, boolean force, int failureCode) {
        try {
            this.getJavaModel().copy(elements, destinations, siblings, renames, force, null);
        }
        catch (JavaScriptModelException jme) {
            CopyMoveTests.assertTrue((String)("Code not correct for JavaScriptModelException: " + (Object)((Object)jme)), (jme.getStatus().getCode() == failureCode ? 1 : 0) != 0);
            return;
        }
        CopyMoveTests.assertTrue((String)"The move should have failed for for multiple elements: ", (boolean)false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IJavaScriptElement copyPositive(IJavaScriptElement element, IJavaScriptElement container, IJavaScriptElement sibling, String rename, boolean force) throws JavaScriptModelException {
        IJavaScriptElement copy;
        if (force) {
            IJavaScriptElement collision = this.generateHandle(element, rename, container);
            CopyMoveTests.assertTrue((String)"Collision does not exist", (boolean)collision.exists());
        }
        try {
            IJavaScriptElementDelta destDelta;
            block11: {
                boolean found;
                IJavaScriptElement[] children;
                block12: {
                    block10: {
                        this.startDeltas();
                        ((ISourceManipulation)element).copy(container, sibling, rename, force, null);
                        CopyMoveTests.assertTrue((String)"The original element must still exist", (boolean)element.exists());
                        copy = this.generateHandle(element, rename, container);
                        CopyMoveTests.assertTrue((String)"Copy should exist", (boolean)copy.exists());
                        if (element.getElementType() <= 5) break block10;
                        this.ensureCorrectPositioning((IParent)container, sibling, copy);
                        break block11;
                    }
                    if (container.getElementType() == 3) break block11;
                    if (!container.getElementName().equals("")) break block12;
                    children = ((IJavaScriptUnit)copy).getChildren();
                    found = false;
                    int i = 0;
                    while (true) {
                        block13: {
                            if (i < children.length) break block13;
                        }
                        if (children[i] instanceof IPackageDeclaration) {
                            found = true;
                        }
                        ++i;
                    }
                    CopyMoveTests.assertTrue((String)"Should not find package decl", (!found ? 1 : 0) != 0);
                    break block11;
                }
                children = ((IJavaScriptUnit)copy).getChildren();
                found = false;
                int i = 0;
                while (true) {
                    if (i >= children.length) {
                        CopyMoveTests.assertTrue((String)"Did not find package decl", (boolean)found);
                        break;
                    }
                    if (children[i] instanceof IPackageDeclaration) {
                        CopyMoveTests.assertTrue((String)"package declaration incorrect", (boolean)((IPackageDeclaration)children[i]).getElementName().equals(container.getElementName()));
                        found = true;
                    }
                    ++i;
                }
            }
            if (copy.getElementType() == 13) {
                container = ((IJavaScriptUnit)container).getImportContainer();
            }
            CopyMoveTests.assertTrue((String)"Destination container not changed", ((destDelta = this.getDeltaFor(container, true)) != null && destDelta.getKind() == 4 ? 1 : 0) != 0);
            IJavaScriptElementDelta[] deltas = destDelta.getAddedChildren();
            CopyMoveTests.assertTrue((String)"Added children not correct for element copy", (boolean)deltas[0].getElement().equals(copy));
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.stopDeltas();
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        this.stopDeltas();
        return copy;
    }

    public IJavaScriptElement generateHandle(IJavaScriptElement original, String rename, IJavaScriptElement container) {
        String name = original.getElementName();
        if (rename != null) {
            name = rename;
        }
        switch (container.getElementType()) {
            case 3: {
                switch (original.getElementType()) {
                    case 4: {
                        return ((IPackageFragmentRoot)container).getPackageFragment(name);
                    }
                }
                CopyMoveTests.assertTrue((String)"illegal child type", (boolean)false);
                break;
            }
            case 4: {
                switch (original.getElementType()) {
                    case 5: {
                        return ((IPackageFragment)container).getJavaScriptUnit(name);
                    }
                }
                CopyMoveTests.assertTrue((String)"illegal child type", (boolean)false);
                break;
            }
            case 5: {
                switch (original.getElementType()) {
                    case 13: {
                        return ((IJavaScriptUnit)container).getImport(name);
                    }
                    case 11: {
                        return ((IJavaScriptUnit)container).getPackageDeclaration(name);
                    }
                    case 7: {
                        if (this.isMainType(original, container)) {
                            container = ((IPackageFragment)container.getParent()).getJavaScriptUnit(String.valueOf(name) + ".js");
                        }
                        return ((IJavaScriptUnit)container).getType(name);
                    }
                }
                CopyMoveTests.assertTrue((String)"illegal child type", (boolean)false);
                break;
            }
            case 7: {
                switch (original.getElementType()) {
                    case 9: {
                        if (name.equals(original.getParent().getElementName())) {
                            return ((IType)container).getFunction(container.getElementName(), ((IFunction)original).getParameterTypes());
                        }
                        return ((IType)container).getFunction(name, ((IFunction)original).getParameterTypes());
                    }
                    case 8: {
                        return ((IType)container).getField(name);
                    }
                    case 7: {
                        return ((IType)container).getType(name);
                    }
                    case 10: {
                        return ((IType)container).getInitializer(1);
                    }
                }
                CopyMoveTests.assertTrue((String)"illegal child type", (boolean)false);
                break;
            }
            default: {
                CopyMoveTests.assertTrue((String)"unsupported container type", (boolean)false);
            }
        }
        CopyMoveTests.assertTrue((String)"should not get here", (boolean)false);
        return null;
    }

    protected boolean isMainType(IJavaScriptElement element, IJavaScriptElement parent) {
        if (parent instanceof IJavaScriptUnit && element instanceof IType) {
            IJavaScriptUnit cu = (IJavaScriptUnit)parent;
            String typeName = cu.getElementName();
            typeName = typeName.substring(0, typeName.length() - 5);
            return element.getElementName().equals(typeName) && element.getParent().equals(cu);
        }
        return false;
    }

    public void moveNegative(IJavaScriptElement element, IJavaScriptElement destination, IJavaScriptElement sibling, String rename, boolean force, int failureCode) {
        try {
            ((ISourceManipulation)element).move(destination, sibling, rename, force, null);
        }
        catch (JavaScriptModelException jme) {
            CopyMoveTests.assertTrue((String)("Code not correct for JavaScriptModelException: " + (Object)((Object)jme)), (jme.getStatus().getCode() == failureCode ? 1 : 0) != 0);
            return;
        }
        CopyMoveTests.assertTrue((String)("The move should have failed for: " + element), (boolean)false);
    }

    public void moveNegative(IJavaScriptElement[] elements, IJavaScriptElement[] destinations, IJavaScriptElement[] siblings, String[] renames, boolean force, int failureCode) {
        try {
            this.getJavaModel().move(elements, destinations, siblings, renames, force, null);
        }
        catch (JavaScriptModelException jme) {
            CopyMoveTests.assertTrue((String)("Code not correct for JavaScriptModelException: " + (Object)((Object)jme)), (jme.getStatus().getCode() == failureCode ? 1 : 0) != 0);
            return;
        }
        CopyMoveTests.assertTrue((String)"The move should have failed for for multiple elements: ", (boolean)false);
    }

    public void movePositive(IJavaScriptElement element, IJavaScriptElement container, IJavaScriptElement sibling, String rename, boolean force) throws JavaScriptModelException {
        IJavaScriptElement[] siblings = new IJavaScriptElement[]{sibling};
        String[] renamings = new String[]{rename};
        if (sibling == null) {
            siblings = null;
        }
        if (rename == null) {
            renamings = null;
        }
        this.movePositive(new IJavaScriptElement[]{element}, new IJavaScriptElement[]{container}, siblings, renamings, force);
    }

    public void movePositive(IJavaScriptElement[] elements, IJavaScriptElement[] destinations, IJavaScriptElement[] siblings, String[] names, boolean force) throws JavaScriptModelException {
        this.movePositive(elements, destinations, siblings, names, force, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void movePositive(IJavaScriptElement[] elements, IJavaScriptElement[] destinations, IJavaScriptElement[] siblings, String[] names, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        if (force) {
            i = 0;
            while (i < elements.length) {
                e = elements[i];
                collision = null;
                collision = names == null ? this.generateHandle(e, null, destinations[i]) : this.generateHandle(e, names[i], destinations[i]);
                CopyMoveTests.assertTrue((String)"Collision does not exist", (boolean)collision.exists());
                ++i;
            }
        }
        try {
            this.startDeltas();
            this.getJavaModel().move(elements, destinations, siblings, names, force, monitor);
            i = 0;
            while (i < elements.length) {
                element = elements[i];
                moved = null;
                moved = names == null ? this.generateHandle(element, null, destinations[i]) : this.generateHandle(element, names[i], destinations[i]);
                if (!destinations[i].equals(element.getParent())) {
                    if (element.getElementType() == 4) {
                        try {
                            members = ((IContainer)element.getUnderlyingResource()).members();
                            if (members.length != 0) ** GOTO lbl28
                            CopyMoveTests.assertTrue((String)"The original element must not exist", (boolean)(element.exists() == false));
                        }
                        catch (CoreException ce) {
                            throw new JavaScriptModelException(ce);
                        }
                    } else {
                        CopyMoveTests.assertTrue((String)"The original element must not exist", (boolean)(element.exists() == false));
                    }
                }
lbl28:
                // 5 sources

                CopyMoveTests.assertTrue((String)"Moved element should exist", (boolean)moved.exists());
                if (element.getElementType() > 5) {
                    if (siblings != null && siblings.length > 0) {
                        this.ensureCorrectPositioning((IParent)moved.getParent(), siblings[i], moved);
                    }
                } else {
                    container = destinations[i];
                    if (container.getElementType() != 3) {
                        if (container.getElementName().equals("")) {
                            children = ((IJavaScriptUnit)moved).getChildren();
                            found = false;
                            j = 0;
                            while (j < children.length) {
                                if (children[j] instanceof IPackageDeclaration) {
                                    found = true;
                                    break;
                                }
                                ++j;
                            }
                            CopyMoveTests.assertTrue((String)"Should not find package decl", (boolean)(found == false));
                        } else {
                            children = ((IJavaScriptUnit)moved).getChildren();
                            found = false;
                            j = 0;
                            while (j < children.length) {
                                if (children[j] instanceof IPackageDeclaration) {
                                    CopyMoveTests.assertTrue((String)"package declaration incorrect", (boolean)((IPackageDeclaration)children[j]).getElementName().equals(container.getElementName()));
                                    found = true;
                                    break;
                                }
                                ++j;
                            }
                            CopyMoveTests.assertTrue((String)"Did not find package decl", (boolean)found);
                        }
                    }
                }
                destDelta = null;
                if (this.isMainType(element, destinations[i]) && names != null && names[i] != null) {
                    destDelta = this.getDeltaFor(moved.getParent());
                    CopyMoveTests.assertTrue((String)"Renamed compilation unit as result of main type not added", (boolean)(destDelta != null && destDelta.getKind() == 1));
                    CopyMoveTests.assertTrue((String)"flag should be F_MOVED_FROM", (boolean)((destDelta.getFlags() & 16) > 0));
                    CopyMoveTests.assertTrue((String)"moved from handle should be original", (boolean)destDelta.getMovedFromElement().equals(element.getParent()));
                } else {
                    destDelta = this.getDeltaFor(destinations[i], true);
                    CopyMoveTests.assertTrue((String)"Destination container not changed", (boolean)(destDelta != null && destDelta.getKind() == 4));
                    deltas = destDelta.getAddedChildren();
                    CopyMoveTests.assertTrue((String)"Added children not correct for element copy", (boolean)deltas[i].getElement().equals(moved));
                    CopyMoveTests.assertTrue((String)"should be K_ADDED", (boolean)(deltas[i].getKind() == 1));
                    sourceDelta = this.getDeltaFor(element, false);
                    CopyMoveTests.assertTrue((String)"should be K_REMOVED", (boolean)(sourceDelta.getKind() == 2));
                }
                ++i;
            }
        }
        catch (Throwable var15_17) {
            var14_18 = null;
            this.stopDeltas();
            throw var15_17;
        }
        {
            var14_19 = null;
        }
        this.stopDeltas();
    }
}

