/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.BufferChangedEvent;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IBufferChangedListener;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class BufferTests
extends ModifyingResourceTests
implements IBufferChangedListener {
    protected ArrayList events = null;
    static /* synthetic */ Class class$0;

    public BufferTests(String name) {
        super(name);
    }

    public void bufferChanged(BufferChangedEvent bufferChangedEvent) {
        this.events.add(bufferChangedEvent);
    }

    protected IBuffer createBuffer(String path, String content) throws CoreException {
        BufferTests.waitUntilIndexesReady();
        this.createFile(path, content);
        IJavaScriptUnit cu = this.getCompilationUnit(path);
        IBuffer buffer = cu.getBuffer();
        buffer.addBufferChangedListener((IBufferChangedListener)this);
        this.events = new ArrayList();
        return buffer;
    }

    protected void deleteBuffer(IBuffer buffer) throws CoreException {
        buffer.removeBufferChangedListener((IBufferChangedListener)this);
        IResource resource = buffer.getUnderlyingResource();
        if (resource != null) {
            this.deleteResource(resource);
        }
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFolder("P/x/y");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
        this.deleteProject("P");
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.BufferTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return BufferTests.buildModelTestSuite(clazz);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAppend() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            int oldLength = buffer.getLength();
            buffer.append("\nclass B {}");
            this.assertBufferEvent(oldLength, 0, "\nclass B {}");
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\npublic class A {\n}\nclass B {}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAppendReadOnly() throws CoreException {
        block4: {
            IBuffer buffer = null;
            try {
                this.createJavaProject("P1", new String[0], new String[]{"JCL_LIB,JCL_SRC,JCL_SRCROOT"}, "");
                IJavaScriptUnit unit = this.getCompilationUnit("P1", this.getExternalJCLPathString(), "", "system.js");
                buffer = unit.getBuffer();
                buffer.addBufferChangedListener((IBufferChangedListener)this);
                this.events = new ArrayList();
                buffer.append("\nclass B {}");
                BufferTests.assertTrue((String)"unexpected event", (boolean)this.events.isEmpty());
                this.assertSourceEquals("unexpected buffer contents", "package java.lang;\n\npublic class String {\n}\n", buffer.getContents());
                BufferTests.assertTrue((String)"should not have unsaved changes", (!buffer.hasUnsavedChanges() ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (buffer != null) {
                    buffer.removeBufferChangedListener((IBufferChangedListener)this);
                }
                this.deleteProject("P1");
                throw throwable;
            }
            {
                Object var3_5 = null;
                if (buffer == null) break block4;
            }
            buffer.removeBufferChangedListener((IBufferChangedListener)this);
        }
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testClose() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            buffer.close();
            this.assertBufferEvent(0, 0, null);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetUnderlyingResource() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        IJavaScriptUnit copy = null;
        try {
            IFile file = this.getFile("P/x/y/A.js");
            BufferTests.assertEquals((String)"Unexpected underlying resource", (Object)file, (Object)buffer.getUnderlyingResource());
            copy = this.getCompilationUnit("P/x/y/A.js").getWorkingCopy(null);
            BufferTests.assertEquals((String)"Unexpected underlying resource 2", (Object)file, (Object)copy.getBuffer().getUnderlyingResource());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteBuffer(buffer);
            if (copy == null) throw throwable;
            copy.discardWorkingCopy();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteBuffer(buffer);
        if (copy == null) return;
        copy.discardWorkingCopy();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteBeginning() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(0, 13, "");
            this.assertBufferEvent(0, 13, null);
            this.assertSourceEquals("unexpected buffer contents", "public class A {\n}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteMiddle() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(13, 7, "");
            this.assertBufferEvent(13, 7, null);
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\nclass A {\n}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteEnd() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(13, 18, "");
            this.assertBufferEvent(13, 18, null);
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\n", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetChar() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            BufferTests.assertEquals((String)"Unexpected char at position 17", (char)'i', (char)buffer.getChar(17));
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetChar2() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        buffer.close();
        try {
            BufferTests.assertEquals((String)"Unexpected char at position 17", (char)'\u0000', (char)buffer.getChar(17));
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetLength() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            BufferTests.assertEquals((String)"Unexpected length", (int)31, (int)buffer.getLength());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetText() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            this.assertSourceEquals("Unexpected text (1)", "p", buffer.getText(0, 1));
            this.assertSourceEquals("Unexpected text (2)", "public", buffer.getText(13, 6));
            this.assertSourceEquals("Unexpected text (3)", "", buffer.getText(10, 0));
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testInsertBeginning() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(0, 0, "/* copyright mycompany */\n");
            this.assertBufferEvent(0, 0, "/* copyright mycompany */\n");
            this.assertSourceEquals("unexpected buffer contents", "/* copyright mycompany */\npackage x.y;\npublic class A {\n}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testReplaceBeginning() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(0, 13, "package other;\n");
            this.assertBufferEvent(0, 13, "package other;\n");
            this.assertSourceEquals("unexpected buffer contents", "package other;\npublic class A {\n}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testReplaceMiddle() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(13, 14, "public class B");
            this.assertBufferEvent(13, 14, "public class B");
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\npublic class B {\n}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testReplaceEnd() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            int end = buffer.getLength();
            buffer.replace(end - 1, 1, "}\n");
            this.assertBufferEvent(end - 1, 1, "}\n");
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\npublic class A {\n}\n", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testInsertMiddle() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(13, 0, "/* class comment */\n");
            this.assertBufferEvent(13, 0, "/* class comment */\n");
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\n/* class comment */\npublic class A {\n}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteBuffer(buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testInsertEnd() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "package x.y;\npublic class A {\n}");
        try {
            int end = buffer.getLength();
            buffer.replace(end, 0, "\nclass B {}");
            this.assertBufferEvent(end, 0, "\nclass B {}");
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\npublic class A {\n}\nclass B {}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteBuffer(buffer);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteBuffer(buffer);
    }

    protected void assertBufferEvent(int offset, int length, String text) {
        BufferTests.assertTrue((String)"events should not be null", (this.events != null ? 1 : 0) != 0);
        BufferTests.assertTrue((String)"events should not be empty", (!this.events.isEmpty() ? 1 : 0) != 0);
        BufferChangedEvent event = (BufferChangedEvent)this.events.get(0);
        BufferTests.assertEquals((String)"unexpected offset", (int)offset, (int)event.getOffset());
        BufferTests.assertEquals((String)"unexpected length", (int)length, (int)event.getLength());
        if (text == null) {
            BufferTests.assertTrue((String)"text should be null", (event.getText() == null ? 1 : 0) != 0);
        } else {
            this.assertSourceEquals("unexpected text", text, event.getText());
        }
    }

    protected void assertBufferEvents(String expected) {
        StringBuffer buffer = new StringBuffer();
        if (this.events == null) {
            buffer.append("<null>");
        } else {
            int i = 0;
            int length = this.events.size();
            while (i < length) {
                BufferChangedEvent event = (BufferChangedEvent)this.events.get(i);
                buffer.append('(');
                buffer.append(event.getOffset());
                buffer.append(", ");
                buffer.append(event.getLength());
                buffer.append(") ");
                buffer.append(event.getText());
                if (i < length - 1) {
                    buffer.append("\n");
                }
                ++i;
            }
        }
        this.assertSourceEquals("Unexpected buffer events", expected, buffer.toString());
    }
}

