/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;

public class ProfilingASTConvertionTest
extends AbstractJavaModelTests {
    private static final int INCREMENTS = 100;
    private static boolean RESOLVE_BINDINGS = false;
    IJavaScriptUnit[] compilationUnits;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ProfilingASTConvertionTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ProfilingASTConvertionTest.buildModelTestSuite(clazz);
    }

    public ProfilingASTConvertionTest(String name) {
        super(name);
    }

    public String display(int value, int numberOfFiguresForRange) {
        int numberOfFigures;
        int n = numberOfFigures = value == 0 ? 1 : (int)(Math.log(value) / Math.log(10.0));
        if (value % 10 == 0) {
            numberOfFigures = (int)(Math.log(value + 1) / Math.log(10.0));
        }
        StringBuffer buffer = new StringBuffer();
        while (numberOfFigures < numberOfFiguresForRange) {
            buffer.append(" ");
            ++numberOfFigures;
        }
        buffer.append(value);
        return String.valueOf(buffer);
    }

    private void printDistribution(long[] array, int increment) {
        int bound = increment;
        int counter = 0;
        int totalCounter = 0;
        int length = array.length;
        long max = array[length - 1];
        int numberOfFiguresForRange = (int)(Math.log(max) / Math.log(10.0));
        if (max % (long)increment == 0L) {
            numberOfFiguresForRange = (int)(Math.log(max + 1L) / Math.log(10.0));
        }
        int numberOfFiguresForCounter = (int)(Math.log(length) / Math.log(10.0));
        if (length % increment == 0) {
            numberOfFiguresForCounter = (int)(Math.log(length + 1) / Math.log(10.0));
        }
        int i = 0;
        while (i < length) {
            if (array[i] < (long)bound) {
                ++counter;
            } else {
                --i;
                this.printRange(counter, bound, increment, totalCounter += counter, length, numberOfFiguresForRange, numberOfFiguresForCounter);
                counter = 0;
                bound += increment;
            }
            ++i;
        }
        this.printRange(counter, bound, increment, totalCounter += counter, length, numberOfFiguresForRange, numberOfFiguresForCounter);
    }

    private void printRange(int counter, int bound, int increment, int totalCounter, int length, int numberOfFiguresForRange, int numberOfFiguresForCounters) {
        if (counter != 0) {
            StringBuffer buffer = new StringBuffer();
            int low = bound - increment;
            if (low != 0) {
                ++low;
            }
            DecimalFormat format = new DecimalFormat("###.##");
            buffer.append(this.display(low, numberOfFiguresForRange)).append(" - ").append(this.display(bound, numberOfFiguresForRange)).append(" : ").append(this.display(counter, numberOfFiguresForCounters)).append("\t\t").append(format.format(100.0 * ((double)totalCounter / (double)length)));
            System.out.println(String.valueOf(buffer));
        }
    }

    private void reportResults(int apiLevel, long totalTime, int length, long[] times, ArrayList arrayList) {
        Result next;
        System.out.println("===============================================================================");
        System.out.print("================================ ");
        switch (apiLevel) {
            case 2: {
                System.out.print("JLS2");
                break;
            }
            case 3: {
                System.out.print("JLS3");
            }
        }
        System.out.print(" BINDING IS ");
        System.out.print(RESOLVE_BINDINGS ? "ON  " : "OFF ");
        System.out.println("==========================");
        System.out.println("===============================================================================");
        Arrays.sort(times);
        System.out.println("===================================== TIMES ===================================");
        System.out.println("Fastest = " + times[0] + "ms");
        long maxTime = times[length - 1];
        System.out.println("Slowest = " + maxTime + "ms");
        System.out.println("Total = " + totalTime + "ms");
        System.out.println("================================== DISTRIBUTION ===============================");
        this.printDistribution(times, 100);
        System.out.println("================================= SORTED BY TIME ==============================");
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            next = (Result)iterator.next();
            System.out.println(String.valueOf(next.unitName) + "(" + next.length + "KB) - " + next.time + "ms");
        }
        System.out.println("================================ SORTED BY LENGTH =============================");
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Result r1 = (Result)o1;
                Result r2 = (Result)o2;
                if (r1.length < r2.length) {
                    return -1;
                }
                if (r1.length == r2.length) {
                    return 0;
                }
                return 1;
            }
        });
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            next = (Result)iterator.next();
            System.out.println(String.valueOf(next.unitName) + "(" + next.length + "KB) - " + next.time + "ms");
        }
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        if (JavaScriptCore.getIncludepathVariable((String)"CONVERTER_JCL_LIB") == null) {
            this.setupExternalJCL("converterJclMin");
            JavaScriptCore.setIncludepathVariables((String[])new String[]{"CONVERTER_JCL_LIB", "CONVERTER_JCL_SRC", "CONVERTER_JCL_SRCROOT"}, (IPath[])new Path[]{new Path(String.valueOf(this.getExternalPath()) + "converterJclMin.jar"), new Path(String.valueOf(this.getExternalPath()) + "converterJclMinsrc.zip"), new Path("")}, null);
        }
        IJavaScriptProject javaProject = this.setUpJavaProject("Compiler", "1.4");
        ProfilingASTConvertionTest.assertNotNull((String)"No java project", (Object)javaProject);
        IPackageFragment[] packageFragments = javaProject.getPackageFragments();
        ProfilingASTConvertionTest.assertNotNull((String)"No package fragments", (Object)packageFragments);
        ArrayList<IJavaScriptUnit> collector = new ArrayList<IJavaScriptUnit>();
        int i = 0;
        int max = packageFragments.length;
        while (i < max) {
            IJavaScriptUnit[] units = packageFragments[i].getJavaScriptUnits();
            if (units != null) {
                int j = 0;
                int max2 = units.length;
                while (j < max2) {
                    collector.add(units[j]);
                    ++j;
                }
            }
            ++i;
        }
        this.compilationUnits = new IJavaScriptUnit[collector.size()];
        collector.toArray(this.compilationUnits);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test0000() throws JavaScriptModelException {
        try {
            RESOLVE_BINDINGS = true;
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(RESOLVE_BINDINGS);
            long totalTime = 0L;
            int length = this.compilationUnits.length;
            long[] times = new long[length];
            ArrayList<Result> arrayList = new ArrayList<Result>(length);
            int i = 0;
            while (i < length) {
                IFile file;
                File f;
                parser.setSource(this.compilationUnits[i]);
                parser.setResolveBindings(RESOLVE_BINDINGS);
                long time = System.currentTimeMillis();
                ASTNode node = parser.createAST(null);
                times[i] = System.currentTimeMillis() - time;
                totalTime += times[i];
                ProfilingASTConvertionTest.assertNotNull((String)"No node", (Object)node);
                ProfilingASTConvertionTest.assertEquals((String)"Wrong type", (int)15, (int)node.getNodeType());
                JavaScriptUnit unit = (JavaScriptUnit)node;
                ProfilingASTConvertionTest.assertEquals((String)"Has problem", (int)0, (int)unit.getProblems().length);
                TypeDeclaration typeDeclaration = (TypeDeclaration)unit.types().get(0);
                StringBuffer buffer = new StringBuffer();
                buffer.append(unit.getPackage().getName()).append(".").append(typeDeclaration.getName());
                IResource resource = this.compilationUnits[i].getResource();
                if (resource instanceof IFile && (f = new File((file = (IFile)resource).getLocation().toOSString())).exists()) {
                    arrayList.add(new Result(String.valueOf(buffer), times[i], f.length()));
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            RESOLVE_BINDINGS = false;
            throw throwable;
        }
        {
            Object var17_17 = null;
            RESOLVE_BINDINGS = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test0001() throws JavaScriptModelException {
        try {
            RESOLVE_BINDINGS = true;
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(RESOLVE_BINDINGS);
            long totalTime = 0L;
            int length = this.compilationUnits.length;
            long[] times = new long[length];
            ArrayList<Result> arrayList = new ArrayList<Result>(length);
            int i = 0;
            while (true) {
                IFile file;
                File f;
                block5: {
                    if (i < length) break block5;
                    this.reportResults(3, totalTime, length, times, arrayList);
                    break;
                }
                parser.setSource(this.compilationUnits[i]);
                parser.setResolveBindings(RESOLVE_BINDINGS);
                long time = System.currentTimeMillis();
                ASTNode node = parser.createAST(null);
                times[i] = System.currentTimeMillis() - time;
                totalTime += times[i];
                ProfilingASTConvertionTest.assertNotNull((String)"No node", (Object)node);
                ProfilingASTConvertionTest.assertEquals((String)"Wrong type", (int)15, (int)node.getNodeType());
                JavaScriptUnit unit = (JavaScriptUnit)node;
                ProfilingASTConvertionTest.assertEquals((String)"Has problem", (int)0, (int)unit.getProblems().length);
                TypeDeclaration typeDeclaration = (TypeDeclaration)unit.types().get(0);
                StringBuffer buffer = new StringBuffer();
                buffer.append(unit.getPackage().getName()).append(".").append(typeDeclaration.getName());
                IResource resource = this.compilationUnits[i].getResource();
                if (resource instanceof IFile && (f = new File((file = (IFile)resource).getLocation().toOSString())).exists()) {
                    arrayList.add(new Result(String.valueOf(buffer), times[i], f.length()));
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            RESOLVE_BINDINGS = false;
            throw throwable;
        }
        {
            Object var17_17 = null;
            RESOLVE_BINDINGS = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test0002() throws JavaScriptModelException {
        try {
            RESOLVE_BINDINGS = false;
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(RESOLVE_BINDINGS);
            long totalTime = 0L;
            int length = this.compilationUnits.length;
            long[] times = new long[length];
            ArrayList<Result> arrayList = new ArrayList<Result>(length);
            int i = 0;
            while (true) {
                IFile file;
                File f;
                block5: {
                    if (i < length) break block5;
                    this.reportResults(3, totalTime, length, times, arrayList);
                    break;
                }
                parser.setSource(this.compilationUnits[i]);
                parser.setResolveBindings(RESOLVE_BINDINGS);
                long time = System.currentTimeMillis();
                ASTNode node = parser.createAST(null);
                times[i] = System.currentTimeMillis() - time;
                totalTime += times[i];
                ProfilingASTConvertionTest.assertNotNull((String)"No node", (Object)node);
                ProfilingASTConvertionTest.assertEquals((String)"Wrong type", (int)15, (int)node.getNodeType());
                JavaScriptUnit unit = (JavaScriptUnit)node;
                ProfilingASTConvertionTest.assertEquals((String)"Has problem", (int)0, (int)unit.getProblems().length);
                TypeDeclaration typeDeclaration = (TypeDeclaration)unit.types().get(0);
                StringBuffer buffer = new StringBuffer();
                buffer.append(unit.getPackage().getName()).append(".").append(typeDeclaration.getName());
                IResource resource = this.compilationUnits[i].getResource();
                if (resource instanceof IFile && (f = new File((file = (IFile)resource).getLocation().toOSString())).exists()) {
                    arrayList.add(new Result(String.valueOf(buffer), times[i], f.length()));
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            RESOLVE_BINDINGS = false;
            throw throwable;
        }
        {
            Object var17_17 = null;
            RESOLVE_BINDINGS = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test0003() throws JavaScriptModelException {
        try {
            RESOLVE_BINDINGS = true;
            ASTParser parser = ASTParser.newParser((int)2);
            parser.setResolveBindings(RESOLVE_BINDINGS);
            long totalTime = 0L;
            int length = this.compilationUnits.length;
            long[] times = new long[length];
            ArrayList<Result> arrayList = new ArrayList<Result>(length);
            int i = 0;
            while (true) {
                IFile file;
                File f;
                block5: {
                    if (i < length) break block5;
                    this.reportResults(2, totalTime, length, times, arrayList);
                    break;
                }
                parser.setSource(this.compilationUnits[i]);
                parser.setResolveBindings(RESOLVE_BINDINGS);
                long time = System.currentTimeMillis();
                ASTNode node = parser.createAST(null);
                times[i] = System.currentTimeMillis() - time;
                totalTime += times[i];
                ProfilingASTConvertionTest.assertNotNull((String)"No node", (Object)node);
                ProfilingASTConvertionTest.assertEquals((String)"Wrong type", (int)15, (int)node.getNodeType());
                JavaScriptUnit unit = (JavaScriptUnit)node;
                ProfilingASTConvertionTest.assertEquals((String)"Has problem", (int)0, (int)unit.getProblems().length);
                TypeDeclaration typeDeclaration = (TypeDeclaration)unit.types().get(0);
                StringBuffer buffer = new StringBuffer();
                buffer.append(unit.getPackage().getName()).append(".").append(typeDeclaration.getName());
                IResource resource = this.compilationUnits[i].getResource();
                if (resource instanceof IFile && (f = new File((file = (IFile)resource).getLocation().toOSString())).exists()) {
                    arrayList.add(new Result(String.valueOf(buffer), times[i], f.length()));
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            RESOLVE_BINDINGS = false;
            throw throwable;
        }
        {
            Object var17_17 = null;
            RESOLVE_BINDINGS = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test0004() throws JavaScriptModelException {
        try {
            RESOLVE_BINDINGS = false;
            ASTParser parser = ASTParser.newParser((int)2);
            parser.setResolveBindings(RESOLVE_BINDINGS);
            long totalTime = 0L;
            int length = this.compilationUnits.length;
            long[] times = new long[length];
            ArrayList<Result> arrayList = new ArrayList<Result>(length);
            int i = 0;
            while (true) {
                IFile file;
                File f;
                block5: {
                    if (i < length) break block5;
                    this.reportResults(2, totalTime, length, times, arrayList);
                    break;
                }
                parser.setSource(this.compilationUnits[i]);
                parser.setResolveBindings(RESOLVE_BINDINGS);
                long time = System.currentTimeMillis();
                ASTNode node = parser.createAST(null);
                times[i] = System.currentTimeMillis() - time;
                totalTime += times[i];
                ProfilingASTConvertionTest.assertNotNull((String)"No node", (Object)node);
                ProfilingASTConvertionTest.assertEquals((String)"Wrong type", (int)15, (int)node.getNodeType());
                JavaScriptUnit unit = (JavaScriptUnit)node;
                ProfilingASTConvertionTest.assertEquals((String)"Has problem", (int)0, (int)unit.getProblems().length);
                TypeDeclaration typeDeclaration = (TypeDeclaration)unit.types().get(0);
                StringBuffer buffer = new StringBuffer();
                buffer.append(unit.getPackage().getName()).append(".").append(typeDeclaration.getName());
                IResource resource = this.compilationUnits[i].getResource();
                if (resource instanceof IFile && (f = new File((file = (IFile)resource).getLocation().toOSString())).exists()) {
                    arrayList.add(new Result(String.valueOf(buffer), times[i], f.length()));
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            RESOLVE_BINDINGS = false;
            throw throwable;
        }
        {
            Object var17_17 = null;
            RESOLVE_BINDINGS = false;
            return;
        }
    }

    static class Result
    implements Comparable {
        long length;
        long time;
        String unitName;

        Result(String unitName, long time, long length) {
            this.time = time;
            this.unitName = unitName;
            this.length = length / 1024L;
        }

        public int compareTo(Object o) {
            Result result = (Result)o;
            if (this.time < result.time) {
                return -1;
            }
            if (this.time == result.time) {
                return 0;
            }
            return 1;
        }
    }
}

