/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.future.compiler.regression;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;

public class AnnotationTest
extends AbstractComparableTest {
    String reportMissingJavadocComments = null;
    static /* synthetic */ Class class$0;

    public AnnotationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return AnnotationTest.buildComparableTestSuite(AnnotationTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.future.compiler.regression.AnnotationTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", "enabled");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "error");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", "error");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
        }
        return options;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.reportMissingJavadocComments = null;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public @interface X { \n\tString value(); \n}"}, "");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public @Foo class X {\n}\n\n@interface Foo {\n\tString value();\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic @Foo class X {\n\t       ^^^^\nThe annotation @Foo must define the attribute value\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"Foo.java", "public @interface Foo {\n\tBar value();\n}\n\n@interface Bar {\n\tFoo value();\n}\n"}, "----------\n1. ERROR in Foo.java (at line 2)\n\tBar value();\n\t^^^\nCycle detected: a cycle exists between annotation attributes of Foo and Bar\n----------\n2. ERROR in Foo.java (at line 6)\n\tFoo value();\n\t^^^\nCycle detected: a cycle exists between annotation attributes of Bar and Foo\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "@interface Nested {\n\tString name() default \"Hans\";\n\tN2 nest();\n}\n@interface N2 {\n\tNested n2() default @Nested(name=\"Haus\", nest= @N2);\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tN2 nest();\n\t^^\nCycle detected: a cycle exists between annotation attributes of Nested and N2\n----------\n2. ERROR in X.java (at line 6)\n\tNested n2() default @Nested(name=\"Haus\", nest= @N2);\n\t^^^^^^\nCycle detected: a cycle exists between annotation attributes of N2 and Nested\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"Foo.java", "public @interface Foo {\n\tFoo value();\n}\n"}, "----------\n1. ERROR in Foo.java (at line 2)\n\tFoo value();\n\t^^^\nCycle detected: the annotation type Foo cannot contain attributes of the annotation type itself\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"Foo.java", "public @interface Foo extends Object {\n}\n"}, "----------\n1. ERROR in Foo.java (at line 1)\n\tpublic @interface Foo extends Object {\n\t                  ^^^\nAnnotation type declaration cannot have an explicit superclass\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"Foo.java", "public @interface Foo implements Cloneable {\n}\n"}, "----------\n1. ERROR in Foo.java (at line 1)\n\tpublic @interface Foo implements Cloneable {\n\t                  ^^^\nAnnotation type declaration cannot have explicit superinterfaces\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"Foo.java", "public @interface Foo {\n\tString value(int i);\n}\n"}, "----------\n1. ERROR in Foo.java (at line 2)\n\tString value(int i);\n\t       ^^^^^^^^^^^^\nAnnotation attributes cannot have parameters\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"Foo.java", "public @interface Foo {\n\t<T> T value();\n}\n"}, "----------\n1. ERROR in Foo.java (at line 2)\n\t<T> T value();\n\t    ^\nInvalid type T for the annotation attribute Foo.value; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof\n----------\n2. ERROR in Foo.java (at line 2)\n\t<T> T value();\n\t      ^^^^^^^\nAnnotation attributes cannot be generic\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\t\n\tRunnable value();\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tRunnable value();\n\t^^^^^^^^\nInvalid type Runnable for the annotation attribute X.value; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\t\n\tvalue();\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvalue();\n\t^^^^^^^\nReturn type for the method is missing\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "@Object\npublic class X {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Object\n\t ^^^^^^\nType mismatch: cannot convert from Object to Annotation\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "@Foo @Foo\npublic class X {\n}\n@interface Foo {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Foo @Foo\n\t^^^^\nDuplicate annotation @Foo\n----------\n2. ERROR in X.java (at line 1)\n\t@Foo @Foo\n\t     ^^^^\nDuplicate annotation @Foo\n----------\n");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "@Foo(\"hello\") public class X {\n}\n\n@interface Foo {\n\tString id() default \"\";\n\tString value() default \"\";\n}\n"}, "");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", "@Foo(\"hello\") public class X {\n}\n\n@interface Foo {\n\tString id() default \"\";\n\tString value() default \"\";\n\tString foo();\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Foo(\"hello\") public class X {\n\t^^^^\nThe annotation @Foo must define the attribute foo\n----------\n");
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", "@Foo(\n\t\tid = \"hello\") public class X {\n}\n\n@interface Foo {\n\tString id() default \"\";\n\tString value() default \"\";\n\tString foo();\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Foo(\n\t^^^^\nThe annotation @Foo must define the attribute foo\n----------\n");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "@interface Name {\n\tString first();\n\tString last();\n}\n@interface Author {\n\tName name();\n}\npublic class X {\n\t\n\t@Author(name = @Name(first=\"Bill\", last=\"Yboy\")) \n\tvoid foo() {\n\t}\n}\n"}, "");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "@interface Name {\n\tString first();\n\tString last();\n}\n@interface Author {\n\tName name();\n}\n@Author(@Name(first=\"Joe\",last=\"Hacker\")) \npublic class X {\n\t\n\t@Author(name = @Name(first=\"Bill\", last=\"Yboy\")) \n\tvoid foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t@Author(@Name(first=\"Joe\",last=\"Hacker\")) \n\t^^^^^^^\nThe annotation @Author must define the attribute name\n----------\n2. ERROR in X.java (at line 8)\n\t@Author(@Name(first=\"Joe\",last=\"Hacker\")) \n\t        ^^^^^\nThe attribute value is undefined for the annotation type Author\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "@interface Name {\n\tString first();\n\tString last();\n}\n@interface Author {\n\tName name();\n}\npublic class X {\n\t\n\t@Author(name = @Name(first=\"Bill\", last=\"Yboy\", last=\"dup\")) \n\tvoid foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\t@Author(name = @Name(first=\"Bill\", last=\"Yboy\", last=\"dup\")) \n\t                                   ^^^^\nDuplicate attribute last in annotation @Name\n----------\n2. ERROR in X.java (at line 10)\n\t@Author(name = @Name(first=\"Bill\", last=\"Yboy\", last=\"dup\")) \n\t                                                ^^^^\nDuplicate attribute last in annotation @Name\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", "@interface Foo {\n\tClass value() default X.clazz();\n}\n\npublic class X {\n\t@Foo( clazz() )\n\tvoid foo() {}\n\tstatic Class clazz() { return X.class; }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tClass value() default X.clazz();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 2)\n\tClass value() default X.clazz();\n\t                      ^^^^^^^^^\nThe value for annotation attribute Foo.value must be a class literal\n----------\n3. ERROR in X.java (at line 6)\n\t@Foo( clazz() )\n\t      ^^^^^^^\nThe value for annotation attribute Foo.value must be a class literal\n----------\n4. WARNING in X.java (at line 8)\n\tstatic Class clazz() { return X.class; }\n\t       ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "@interface Foo {\n\tint value() default X.val();\n}\n\npublic class X {\n\t@Foo( val() )\n\tvoid foo() {}\n\tstatic int val() { return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint value() default X.val();\n\t                    ^^^^^^^\nThe value for annotation attribute Foo.value must be a constant expression\n----------\n2. ERROR in X.java (at line 6)\n\t@Foo( val() )\n\t      ^^^^^\nThe value for annotation attribute Foo.value must be a constant expression\n----------\n");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.java", "@interface Foo {\n\tString value() default X.val();\n}\n\npublic class X {\n\t@Foo( val() )\n\tvoid foo() {}\n\tstatic String val() { return \"\"; }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tString value() default X.val();\n\t                       ^^^^^^^\nThe value for annotation attribute Foo.value must be a constant expression\n----------\n2. ERROR in X.java (at line 6)\n\t@Foo( val() )\n\t      ^^^^^\nThe value for annotation attribute Foo.value must be a constant expression\n----------\n");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.java", "@interface Foo {\n\tString[] value() default null;\n}\n\npublic class X {\n\t@Foo( null )\n\tvoid foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tString[] value() default null;\n\t                         ^^^^\nThe value for annotation attribute Foo.value must be a constant expression\n----------\n2. ERROR in X.java (at line 6)\n\t@Foo( null )\n\t      ^^^^\nThe value for annotation attribute Foo.value must be a constant expression\n----------\n");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "@interface Foo {\n\tString[] value() default {};\n}\n\npublic class X {\n\t@Foo( {} )\n\tvoid foo() {}\n}\n"}, "");
    }

    public void test024() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\tString[] value() default {};\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo({})\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test025() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\tString[] value() default {};\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test026() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tint value() default 8;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test027() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tbyte value() default (byte)255;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test028() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tboolean value() default true;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test029() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tchar value() default ' ';\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test030() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tshort value() default (short)1024;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test031() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tdouble value() default 0.0;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test032() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tfloat value() default -0.0f;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test033() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tlong value() default 1234567890L;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test034() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tString value() default \"Hello, World\";\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test035() {
        this.runConformTest(new String[]{"Foo.java", "enum E {\n\tCONST1\n}\n@interface Foo {\n\tE value() default E.CONST1;\n}"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test036() {
        this.runConformTest(new String[]{"Foo.java", "@interface Foo {\n\tClass value() default Object.class;\n}"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test037() {
        this.runConformTest(new String[]{"Foo.java", "@interface Y {\n\tint id() default 8;\n\tClass type();\n}\npublic @interface Foo {\n\tY value() default @Y(id=10,type=Object.class);\n}"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test038() {
        this.runConformTest(new String[]{"Foo.java", "@interface Foo {\n\tint id() default 8;\n\tClass type();\n}"}, "");
        this.runConformTest(new String[]{"X.java", "@Foo(type=String.class) public class X {\r\n}"}, "", null, false, null);
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tnative int id() default 0;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tnative int id() default 0;\n\t           ^^^^\nIllegal modifier for the annotation attribute X.id; only public & abstract are permitted\n----------\n");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tint[] tab;\n\tint[] value();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint[] tab;\n\t      ^^^\nThe blank final field tab may not have been initialized\n----------\n");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tint[] tab = value();\n\tint[] value();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint[] tab = value();\n\t            ^^^^^\nCannot make a static reference to the non-static method value() from the type X\n----------\n");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "public @interface X {\n\tint[] tab = { 0 , \"aaa\".length() };\n}\n"}, "");
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tint value;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint value;\n\t    ^^^^^\nThe blank final field value may not have been initialized\n----------\n");
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tprotected int value = 0;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tprotected int value = 0;\n\t              ^^^^^\nIllegal modifier for the annotation field X.value; only public, static & final are permitted\n----------\n");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "@interface X {\n    int id () default 10L; \n    int[] ids() default { 10L };\n    Class cls() default new Object();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint id () default 10L; \n\t                  ^^^\nType mismatch: cannot convert from long to int\n----------\n2. ERROR in X.java (at line 3)\n\tint[] ids() default { 10L };\n\t                      ^^^\nType mismatch: cannot convert from long to int\n----------\n3. WARNING in X.java (at line 4)\n\tClass cls() default new Object();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n4. ERROR in X.java (at line 4)\n\tClass cls() default new Object();\n\t                    ^^^^^^^^^^^^\nType mismatch: cannot convert from Object to Class\n----------\n");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n    boolean val() default true;\n}\n\npublic class X {\n\n\tboolean bar() {\n\t\treturn false;\n\t}\n    @I(val = bar()) void foo() {\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\t@I(val = bar()) void foo() {\n\t         ^^^^^\nThe value for annotation attribute I.val must be a constant expression\n----------\n");
    }

    public void test048() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n     boolean[] value();\n}\n\npublic class X {\n     @I(value={false, X.class != null }) void foo() {\n     }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t@I(value={false, X.class != null }) void foo() {\n\t                 ^^^^^^^^^^^^^^^\nThe value for annotation attribute I.value must be a constant expression\n----------\n");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.*;\n\n@Documented\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.TYPE)\n@interface MyAnn {\n  String value() default \"Default Message\";\n}\n\n@MyAnn\npublic class X {\n\tpublic @MyAnn void something() { }\t\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\r\n\tpublic @MyAnn void something() { }\t\r\n\t       ^^^^^^\nThe annotation @MyAnn is disallowed for this location\n----------\n");
    }

    public void test067() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n    int value() default 0L;\n}\n\npublic class X {\n    @I(2) void foo() {\n    }\n}\n\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint value() default 0L;\n\t                    ^^\nType mismatch: cannot convert from long to int\n----------\n");
    }

    public void test068() {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    short[] value() default 2;\n}\n\npublic class X {\n    @I(2) void foo() {\n    }\n}\n"}, "");
    }

    public void test069() {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    short[] value() default { 2 };\n}\n\npublic class X {\n    @I(2) void foo() {\n    }\n}\n"}, "");
    }

    public void test070() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n    int[][] ids();\n    Object[][] obs();\n}\n\npublic class X {\n\n    @I(ids = {{1 , 2}, { 3 }}) public void foo(){\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint[][] ids();\n\t^^^^^^^\nInvalid type int[][] for the annotation attribute I.ids; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof\n----------\n2. ERROR in X.java (at line 3)\n\tObject[][] obs();\n\t^^^^^^^^^^\nInvalid type Object[][] for the annotation attribute I.obs; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof\n----------\n3. ERROR in X.java (at line 8)\n\t@I(ids = {{1 , 2}, { 3 }}) public void foo(){\n\t^^\nThe annotation @I must define the attribute obs\n----------\n4. ERROR in X.java (at line 8)\n\t@I(ids = {{1 , 2}, { 3 }}) public void foo(){\n\t          ^^^^^^^\nThe value for annotation attribute I.ids must be a constant expression\n----------\n5. ERROR in X.java (at line 8)\n\t@I(ids = {{1 , 2}, { 3 }}) public void foo(){\n\t                   ^^^^^\nThe value for annotation attribute I.ids must be a constant expression\n----------\n");
    }

    public void test071() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n\tint hashCode();\n\tObject clone();\n}\n\npublic class X {\n    @I(hashCode = 0) public void foo(){\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint hashCode();\n\t    ^^^^^^^^^^\nThe annotation type I cannot override the method Annotation.hashCode()\n----------\n2. ERROR in X.java (at line 3)\n\tObject clone();\n\t^^^^^^\nInvalid type Object for the annotation attribute I.clone; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof\n----------\n3. ERROR in X.java (at line 3)\n\tObject clone();\n\t       ^^^^^^^\nThe annotation type I cannot override the method Object.clone()\n----------\n4. ERROR in X.java (at line 7)\n\t@I(hashCode = 0) public void foo(){\n\t^^\nThe annotation @I must define the attribute clone\n----------\n");
    }

    public void test072() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n}\n\npublic class X {\n    @I(hashCode = 0) public void foo(){\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t@I(hashCode = 0) public void foo(){\n\t   ^^^^^^^^\nThe attribute hashCode is undefined for the annotation type I\n----------\n");
    }

    public void test075() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n\n@Target ({FIELD, FIELD})\n@interface Tgt {\n\tE[] foo();\n\tint[] bar();\n}\nenum E {\n\tBLEU, BLANC, ROUGE\n}\n\n@Tgt( foo = { E.BLEU, E.BLEU}, bar = { 0, 0} )\npublic class X {\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@Target ({FIELD, FIELD})\n\t                 ^^^^^\nDuplicate element FIELD specified in annotation @Target\n----------\n2. ERROR in X.java (at line 13)\n\t@Tgt( foo = { E.BLEU, E.BLEU}, bar = { 0, 0} )\n\t^^^^\nThe annotation @Tgt is disallowed for this location\n----------\n");
    }

    public void test076() {
        this.runNegativeTest(new String[]{"X.java", "private @interface TestAnnot {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tprivate @interface TestAnnot {\n\t                   ^^^^^^^^^\nIllegal modifier for the annotation type TestAnnot; only public & abstract are permitted\n----------\n");
    }

    public void test077() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. ERROR in X.java (at line 14)\n\tvoid foo() {}\n\t     ^^^^^\nThe method foo() of type X must override a superclass method\n----------\n2. ERROR in X.java (at line 18)\n\tpublic void baz() {}\n\t            ^^^^^\nThe method baz() of type X must override a superclass method\n----------\n" : "----------\n1. ERROR in X.java (at line 14)\n\tvoid foo() {}\n\t     ^^^^^\nThe method foo() of type X must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "class Further {\n\tvoid bar() {}\n}\n\nclass Other extends Further {\n}\n\ninterface Baz {\n\tvoid baz();\n}\n\npublic class X extends Other implements Baz {\n\t@Override\n\tvoid foo() {}\n\t@Override\n\tvoid bar() {}\n\t@Override\n\tpublic void baz() {}\n}\n"}, expectedOutput);
    }

    public void test078() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tX() {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tX() {}\n\t^^^\nAnnotation type declaration cannot have a constructor\n----------\n");
    }

    public void test079() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(RUNTIME)\n@Target({TYPE})\n@interface Attr {\n  public int tst() default -1;\n}\n\n@Attr \npublic class X {\n  public static void main(String args[]) {\n  \tObject e = X.class.getAnnotation(Attr.class);\n  \tSystem.out.print(e);\n  }\n}"}, "@Attr(tst=-1)");
    }

    public void test080() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(CLASS)\n@Target({TYPE})\n@interface Attr {\n  public int tst() default -1;\n}\n\n@Attr \npublic class X {\n  public static void main(String args[]) {\n  \tObject e = X.class.getAnnotation(Attr.class);\n  \tSystem.out.print(e);\n  }\n}"}, "null");
    }

    public void test081() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(SOURCE)\n@Target({TYPE})\n@interface Attr {\n  public int tst() default -1;\n}\n\n@Attr \npublic class X {\n  public static void main(String args[]) {\n  \tObject e = X.class.getAnnotation(Attr.class);\n  \tSystem.out.print(e);\n  }\n}"}, "null");
    }

    public void test082() {
        this.runConformTest(new String[]{"Attr.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(SOURCE)\n@Target({TYPE})\n@interface Attr {\n  public int tst() default -1;\n}"}, "");
        this.runConformTest(new String[]{"X.java", "@Attr \npublic class X {\n  public static void main(String args[]) {\n  \tObject e = X.class.getAnnotation(Attr.class);\n  \tSystem.out.print(e);\n  }\n}"}, "null", null, false, null);
    }

    public void test083() {
        this.runConformTest(new String[]{"Attr.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(CLASS)\n@Target({TYPE})\n@interface Attr {\n  public int tst() default -1;\n}"}, "");
        this.runConformTest(new String[]{"X.java", "@Attr \npublic class X {\n  public static void main(String args[]) {\n  \tObject e = X.class.getAnnotation(Attr.class);\n  \tSystem.out.print(e);\n  }\n}"}, "null", null, false, null);
    }

    public void test084() {
        this.runConformTest(new String[]{"Attr.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(RUNTIME)\n@Target({TYPE})\n@interface Attr {\n  public int tst() default -1;\n}"}, "");
        this.runConformTest(new String[]{"X.java", "@Attr \npublic class X {\n  public static void main(String args[]) {\n  \tObject e = X.class.getAnnotation(Attr.class);\n  \tSystem.out.print(e);\n  }\n}"}, "@Attr(tst=-1)", null, false, null);
    }

    public void test085() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\n\npublic class X {\n\n  @Retention(RetentionPolicy.RUNTIME) @Target(ElementType.TYPE) @interface\nTestAnnotation {\n\n    String testAttribute();\n\n  }\n  @TestAnnotation(testAttribute = \"test\") class A {\n  }\n\n  public static void main(String[] args) {\n    System.out.print(A.class.isAnnotationPresent(TestAnnotation.class));\n  }\n\n}"}, "true");
    }

    public void test086() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\n\n@Target({}) @interface I {}\n@I public class X {}"}, "----------\n1. ERROR in X.java (at line 4)\n\t@I public class X {}\n\t^^\nThe annotation @I is disallowed for this location\n----------\n");
    }

    public void test087() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n\n@Target(TYPE)\n@interface Annot {\n}\n\n@Annot\npublic @interface X {\n}\n"}, "");
    }

    public void test088() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n\n@Target(LOCAL_VARIABLE)\n@interface Annot {\n}\n\npublic class X {\n\tvoid foo(@Annot int i) {\n\t\t@Annot int j;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tvoid foo(@Annot int i) {\n\t         ^^^^^^\nThe annotation @Annot is disallowed for this location\n----------\n");
    }

    public void test089() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n\npublic class X {\n\n    @Target(ElementType.PARAMETER) @interface I {}\n    \n    void m(@I int i){\n    }\n}"}, "");
    }

    public void test090() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n\npublic class X {\n\n    @Target(ElementType.TYPE) @interface Annot1 {}\n    \n    @Annot1 @interface Annot2 {}\n}"}, "");
    }

    public void test091() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n\npublic class X {\n\n    @Target(ElementType.TYPE) @interface Marker {}\n    \n    @Marker static int i = 123;\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\t@Marker static int i = 123;\n\t^^^^^^^\nThe annotation @X.Marker is disallowed for this location\n----------\n");
    }

    public void test092() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n\npublic class X {\n\n    @Target(ElementType.FIELD) @interface Marker {}\n    \n    @Marker static int i = 123;\n}"}, "");
    }

    public void test093() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Inherited;\n\n@Deprecated\n@Inherited\nclass A {\n}\n\nclass B extends A {\n}\n\nclass C extends B {\n}\n\npublic class X {\n\tC c;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\r\n\t@Inherited\r\n\t^^^^^^^^^^\nThe annotation @Inherited is disallowed for this location\n----------\n");
    }

    public void test094() {
        this.runConformTest(new String[]{"I.java", "import java.lang.annotation.Target;\n\n@Target({}) @interface I {}"}, "");
        this.runNegativeTest(new String[]{"X.java", "@I public class X {}"}, "----------\n1. ERROR in X.java (at line 1)\n\t@I public class X {}\n\t^^\nThe annotation @I is disallowed for this location\n----------\n", null, false, null);
    }

    public void test095() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\n\n@Retention(RetentionPolicy.RUNTIME)\n@interface Ann {}\n\npublic class X {\n\t@Ann\n\tvoid foo() {}\n}\n"}, "");
    }

    public void test096() {
        this.runConformTest(new String[]{"X.java", "import static java.lang.annotation.RetentionPolicy.*;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.Annotation;\nimport java.lang.reflect.Method;\n\n@Retention(CLASS) @interface Attr {\n}\n\n@Retention(RUNTIME) @interface Foo {\n\tint id() default 0;\n}\n@Foo(id=5) @Attr public class X {\n\tpublic void foo(@Foo(id=5) @Attr final int j, @Attr final int k, int n) {\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tClass c = X.class;\n\t\t\tAnnotation[] annots = c.getAnnotations();\n\t\t\tSystem.out.print(annots.length);\n\t\t\tMethod method = c.getMethod(\"foo\", Integer.TYPE, Integer.TYPE, Integer.TYPE);\n\t\t\tAnnotation[][] annotations = method.getParameterAnnotations();\n\t\t\tfinal int length = annotations.length;\n\t\t\tSystem.out.print(length);\n\t\t\tif (length == 3) {\n\t\t\t\tSystem.out.print(annotations[0].length);\n\t\t\t\tSystem.out.print(annotations[1].length);\n\t\t\t\tSystem.out.print(annotations[2].length);\n\t\t\t}\n\t\t} catch(NoSuchMethodException e) {\n\t\t}\n\t}\n}"}, "13100");
    }

    public void test097() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n\tint id default 0;\n}\n\n@I() public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.println(X.class.getAnnotation(I.class));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tint id default 0;\n\t       ^^^^^^^\nSyntax error on token \"default\", = expected\n----------\n");
    }

    public void test098() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n\tint id default 0;\n}\n\n@I() public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.println(X.class.getAnnotation(I.class));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tint id default 0;\n\t       ^^^^^^^\nSyntax error on token \"default\", = expected\n----------\n");
    }

    public void test100() {
        this.runConformTest(new String[]{"X.java", "abstract class Foo {\n\tabstract protected boolean accept(Object o);\n}\n\npublic class X extends Foo {\n\t@Override \n\tprotected boolean accept(Object o) { return false; }\n}\n"}, "");
    }

    public void test101() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\n\n@Target(Element)\npublic @interface X {\n\t\n\tboolean UML() default false;\n\tboolean platformDependent() default true;\n\tboolean OSDependent() default true;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\r\n\t@Target(Element)\r\n\t        ^^^^^^^\nElement cannot be resolved\n----------\n");
    }

    public void test102() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  @TestAnnotation(testAttribute = \"test\") class A {\n  }\n  public static void main(String[] args) {\n    System.out.print(A.class.isAnnotationPresent(TestAnnotation.class));\n  }\n}", "TestAnnotation.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\n@Retention(RetentionPolicy.RUNTIME) @Target(ElementType.TYPE) public @interface\nTestAnnotation {\n    String testAttribute();\n}\n"}, "true");
    }

    public void test103() {
        this.runConformTest(new String[]{"TestAnnotation.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\n@Retention(RetentionPolicy.RUNTIME) @Target(ElementType.TYPE) public @interface\nTestAnnotation {\n    String testAttribute();\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n  @TestAnnotation(testAttribute = \"test\") class A {\n  }\n  public static void main(String[] args) {\n    System.out.print(A.class.isAnnotationPresent(TestAnnotation.class));\n  }\n}"}, "true", null, false, null);
    }

    public void test104() {
        this.runConformTest(new String[]{"X.java", "@interface ValuesAnnotation {\n\tbyte[] byteArrayValue();\n\tchar[] charArrayValue();\n\tboolean[] booleanArrayValue();\n\tint[] intArrayValue();\n\tshort[] shortArrayValue();\n\tlong[] longArrayValue();\n\tfloat[] floatArrayValue();\n\tdouble[] doubleArrayValue();\n\tString[] stringArrayValue();\n\tValuesEnum[] enumArrayValue();\n\tValueAttrAnnotation[] annotationArrayValue();\n\tClass[] classArrayValue();\n\tbyte byteValue();\n\tchar charValue();\n\tboolean booleanValue();\n\tint intValue();\n\tshort shortValue();\n\tlong longValue();\n\tfloat floatValue();\n\tdouble doubleValue();\n\tString stringValue();\n\tValuesEnum enumValue();\n\tValueAttrAnnotation annotationValue();\n\tClass classValue();\n}\nenum ValuesEnum {\n\tONE, TWO;\n}\n\n@interface ValueAttrAnnotation {\n\tString value() default \"\";\n}\n@interface ValueAttrAnnotation1 {\n\tString value();\n}\n@interface ValueAttrAnnotation2 {\n\tString value();\n}\n@ValuesAnnotation(\n  byteValue = 1,\n  charValue = 'A',\n  booleanValue = true,\n  intValue = 1,\n  shortValue = 1,\n  longValue = 1L,\n  floatValue = 1.0f,\n  doubleValue = 1.0d,\n  stringValue = \"A\",\n\n  enumValue = ValuesEnum.ONE,\n  annotationValue = @ValueAttrAnnotation( \"annotation\"),\n  classValue = X.class,\n\n  byteArrayValue = { 1, -1},\n  charArrayValue = { 'c', 'b', (char)-1},\n  booleanArrayValue = {true, false},\n  intArrayValue = { 1, -1},\n  shortArrayValue = { (short)1, (short)-1},\n  longArrayValue = { 1L, -1L},\n  floatArrayValue = { 1.0f, -1.0f},\n  doubleArrayValue = { 1.0d, -1.0d},\n  stringArrayValue = { \"aa\", \"bb\"},\n\n  enumArrayValue = {ValuesEnum.ONE, ValuesEnum.TWO},\n  annotationArrayValue = {@ValueAttrAnnotation( \"annotation1\"),\n@ValueAttrAnnotation( \"annotation2\")},\n  classArrayValue = {X.class, X.class}\n)\n@ValueAttrAnnotation1( \"classAnnotation1\")\n@ValueAttrAnnotation2( \"classAnnotation2\")\npublic class X {\n\n  @ValueAttrAnnotation1( \"fieldAnnotation1\")\n  @ValueAttrAnnotation2( \"fieldAnnotation2\")\n  public String testfield = \"test\";\n\n  @ValueAttrAnnotation1( \"methodAnnotation1\")\n  @ValueAttrAnnotation2( \"methodAnnotation2\")\n  @ValueAttrAnnotation()\n  public void testMethod( \n      @ValueAttrAnnotation1( \"param1Annotation1\") \n      @ValueAttrAnnotation2( \"param1Annotation2\") String param1, \n      @ValueAttrAnnotation1( \"param2Annotation1\") \n      @ValueAttrAnnotation2( \"param2Annotation2\") int param2) {\n    // @ValueAttrAnnotation( \"codeAnnotation\")\n  }\n}\n"}, "");
    }

    public void test106() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n    int[] bar() default null;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tint[] bar() default null;\n\t                    ^^^^\nThe value for annotation attribute X.bar must be a constant expression\n----------\n");
    }

    public void test107() {
        this.runNegativeTest(new String[]{"X.java", "@interface Ann {\n    int[] bar();\n}\n@Ann(bar=null) class X {}"}, "----------\n1. ERROR in X.java (at line 4)\n\t@Ann(bar=null) class X {}\n\t         ^^^^\nThe value for annotation attribute Ann.bar must be a constant expression\n----------\n");
    }

    public void test108() {
        this.runNegativeTest(new String[]{"X.java", "@interface Foo {}\n\n@interface Bar {\n    Foo[] foo() default null;\n}\n\n@Bar(foo=null)\npublic class X { \n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tFoo[] foo() default null;\n\t                    ^^^^\nThe value for annotation attribute Bar.foo must be some @Foo annotation \n----------\n2. ERROR in X.java (at line 7)\n\t@Bar(foo=null)\n\t         ^^^^\nThe value for annotation attribute Bar.foo must be some @Foo annotation \n----------\n");
    }

    public void test109() {
        this.runNegativeTest(new String[]{"X.java", "@interface Foo {}\n\n@interface Bar {\n    Foo[] foo() default \"\";\n}\n\n@Bar(foo=\"\")\npublic class X { \n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tFoo[] foo() default \"\";\n\t                    ^^\nThe value for annotation attribute Bar.foo must be some @Foo annotation \n----------\n2. ERROR in X.java (at line 7)\n\t@Bar(foo=\"\")\n\t         ^^\nThe value for annotation attribute Bar.foo must be some @Foo annotation \n----------\n");
    }

    public void test110() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.util.Arrays;\n\n@interface Ann {\n}\n\ninterface Iface extends Ann {\n}\n\nabstract class Klass implements Ann {\n}\n\nclass SubKlass extends Klass {\n\tpublic Class<? extends Annotation> annotationType() {\n\t\treturn null;\n\t}\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tClass c = SubKlass.class;\n\t\tSystem.out.print(\"Classes:\");\n\t\twhile (c != Object.class) {\n\t\t\tSystem.out.print(\"-> \" + c.getName());\n\t\t\tc = c.getSuperclass();\n\t\t}\n\n\t\tSystem.out.print(\", Interfaces:\");\n\t\tc = SubKlass.class;\n\t\twhile (c != Object.class) {\n\t\t\tClass[] i = c.getInterfaces();\n\t\t\tSystem.out.print(\"-> \" + Arrays.asList(i));\n\t\t\tc = c.getSuperclass();\n\t\t}\n\t}\n}\n"}, "Classes:-> SubKlass-> Klass, Interfaces:-> []-> [interface Ann]");
    }

    public void test111() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.util.Arrays;\n\n@interface Ann {\n\tint foo();\n}\n\ninterface Iface extends Ann {\n}\n\nabstract class Klass implements Ann {\n}\n\nclass SubKlass extends Klass {\n\tpublic Class<? extends Annotation> annotationType() {\n\t\treturn null;\n\t}\n}\n\nclass AnnImpl implements Ann {\n    public boolean equals(Object obj) { return false; }\n    public int hashCode() { return 0; }\n    public String toString() { return null; }\n    public Class<? extends Annotation> annotationType() { return null; }\n    public int foo() { return 0; }\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tClass c = SubKlass.class;\n\t\tSystem.out.println(\"Classes:\");\n\t\twhile (c != Object.class) {\n\t\t\tSystem.out.println(\"-> \" + c.getName());\n\t\t\tc = c.getSuperclass();\n\t\t}\n\n\t\tSystem.out.println();\n\t\tSystem.out.println(\"Interfaces:\");\n\t\tc = SubKlass.class;\n\t\twhile (c != Object.class) {\n\t\t\tClass[] i = c.getInterfaces();\n\t\t\tSystem.out.println(\"-> \" + Arrays.asList(i));\n\t\t\tc = c.getSuperclass();\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tinterface Iface extends Ann {\n\t                        ^^^\nThe annotation type Ann should not be used as a superinterface for Iface\n----------\n2. WARNING in X.java (at line 11)\n\tabstract class Klass implements Ann {\n\t                                ^^^\nThe annotation type Ann should not be used as a superinterface for Klass\n----------\n3. ERROR in X.java (at line 14)\n\tclass SubKlass extends Klass {\n\t      ^^^^^^^^\nThe type SubKlass must implement the inherited abstract method Ann.foo()\n----------\n4. WARNING in X.java (at line 20)\n\tclass AnnImpl implements Ann {\n\t                         ^^^\nThe annotation type Ann should not be used as a superinterface for AnnImpl\n----------\n5. WARNING in X.java (at line 21)\n\tpublic boolean equals(Object obj) { return false; }\n\t               ^^^^^^^^^^^^^^^^^^\nThe method equals(Object) of type AnnImpl should be tagged with @Override since it actually overrides a superclass method\n----------\n6. WARNING in X.java (at line 22)\n\tpublic int hashCode() { return 0; }\n\t           ^^^^^^^^^^\nThe method hashCode() of type AnnImpl should be tagged with @Override since it actually overrides a superclass method\n----------\n7. WARNING in X.java (at line 23)\n\tpublic String toString() { return null; }\n\t              ^^^^^^^^^^\nThe method toString() of type AnnImpl should be tagged with @Override since it actually overrides a superclass method\n----------\n8. WARNING in X.java (at line 30)\n\tClass c = SubKlass.class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n9. WARNING in X.java (at line 41)\n\tClass[] i = c.getInterfaces();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n");
    }

    public void test112() {
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n  String foo1() default \"\";\n}\n@Annot(foo1=zzz)\npublic class X {\n  static final String zzz =  \"\";\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@Annot(foo1=zzz)\n\t            ^^^\nzzz cannot be resolved\n----------\n");
    }

    public void test113() {
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n\tString foo();\n}\n@Annot( foo = new String(){} )\npublic class X {\n\t\n\t\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@Annot( foo = new String(){} )\n\t              ^^^^^^^^^^^^^^\nThe value for annotation attribute Annot.foo must be a constant expression\n----------\n2. ERROR in X.java (at line 4)\n\t@Annot( foo = new String(){} )\n\t                  ^^^^^^\nAn anonymous class cannot subclass the final class String\n----------\n");
    }

    public void test114() {
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n\tClass foo();\n}\n@Annot( foo = M.class )\npublic class X {\n\tclass M {}\n\t\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tClass foo();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 4)\n\t@Annot( foo = M.class )\n\t              ^\nM cannot be resolved to a type\n----------\n");
    }

    public void test115() {
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n\tClass foo();\n\tString bar() default \"\";\n}\n@Annot(foo = M.class, bar = baz()+s)\npublic class X {\n\tclass M {\n\t}\n\tfinal static String s = \"\";\n\tString baz() { return null; }\n\t@Annot(foo = T.class, bar = s)\n\t<T> T foo(T t, String s) {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tClass foo();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\t@Annot(foo = M.class, bar = baz()+s)\n\t             ^\nM cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\t@Annot(foo = M.class, bar = baz()+s)\n\t                            ^^^\nThe method baz() is undefined for the type X\n----------\n4. ERROR in X.java (at line 5)\n\t@Annot(foo = M.class, bar = baz()+s)\n\t                                  ^\ns cannot be resolved\n----------\n5. ERROR in X.java (at line 11)\n\t@Annot(foo = T.class, bar = s)\n\t             ^^^^^^^\nIllegal class literal for the type parameter T\n----------\n6. WARNING in X.java (at line 12)\n\t<T> T foo(T t, String s) {\n\t                      ^\nThe parameter s is hiding a field from type X\n----------\n");
    }

    public void test116() {
        this.runNegativeTest(new String[]{"X.java", "/** @deprecated */\n@Deprecated\npublic class X {\n}\n", "Y.java", "public class Y {\n\tX x;\n\tZork z;\n}\n"}, "----------\n1. WARNING in Y.java (at line 2)\n\tX x;\n\t^\nThe type X is deprecated\n----------\n2. ERROR in Y.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test117() {
        this.runNegativeTest(new String[]{"X.java", "@Deprecated\npublic class X {\n}\n", "Y.java", "public class Y {\n\tX x;\n\tZork z;\n}\n"}, "----------\n1. WARNING in Y.java (at line 2)\n\tX x;\n\t^\nThe type X is deprecated\n----------\n2. ERROR in Y.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test118() {
        this.runNegativeTest(new String[]{"X.java", "@interface Deprecated {}\n\n@Deprecated // not the real @Deprecated interface\npublic class X {\n}\n", "Y.java", "public class Y {\n\tX x;\n\tZork z;\n}\n"}, "----------\n1. ERROR in Y.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test119() {
        this.runNegativeTest(new String[]{"X.java", "@Deprecated\npublic class X {\n\tvoid foo(){}\n}\n", "Y.java", "public class Y extends X {\n\tvoid foo(){ super.foo(); }\n\tZork z;\n}\n"}, "----------\n1. WARNING in Y.java (at line 1)\n\tpublic class Y extends X {\n\t                       ^\nThe type X is deprecated\n----------\n2. WARNING in Y.java (at line 2)\n\tvoid foo(){ super.foo(); }\n\t     ^^^^^\nThe method foo() of type Y should be tagged with @Override since it actually overrides a superclass method\n----------\n3. WARNING in Y.java (at line 2)\n\tvoid foo(){ super.foo(); }\n\t            ^^^^^^^^^^^\nThe method foo() from the type X is deprecated\n----------\n4. ERROR in Y.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test120() {
        this.runNegativeTest(new String[]{"X.java", "@Deprecated\npublic class X {\n\tvoid foo(){}\n}\n", "Y.java", "public class Y extends X {\n\tvoid foo(){ super.foo(); }\n\tZork z;\n}\n"}, "----------\n1. WARNING in Y.java (at line 1)\n\tpublic class Y extends X {\n\t                       ^\nThe type X is deprecated\n----------\n2. WARNING in Y.java (at line 2)\n\tvoid foo(){ super.foo(); }\n\t     ^^^^^\nThe method foo() of type Y should be tagged with @Override since it actually overrides a superclass method\n----------\n3. WARNING in Y.java (at line 2)\n\tvoid foo(){ super.foo(); }\n\t            ^^^^^^^^^^^\nThe method foo() from the type X is deprecated\n----------\n4. ERROR in Y.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test121() {
        this.runNegativeTest(new String[]{"X.java", "/** @deprecated */\npublic class X {\n\t/** @deprecated */\n\tpublic static class Y {\n\t}\n\t/** @deprecated */\n\tint i;\n\t/** @deprecated */\n\tpublic void flag() {}\n\tvoid doNotFlag() {}\n  Zork z;\n} \n"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic class X {\n\t             ^\nThe deprecated type X should be annotated with @Deprecated\n----------\n2. WARNING in X.java (at line 4)\n\tpublic static class Y {\n\t                    ^\nThe deprecated type X.Y should be annotated with @Deprecated\n----------\n3. WARNING in X.java (at line 7)\n\tint i;\n\t    ^\nThe deprecated field X.i should be annotated with @Deprecated\n----------\n4. WARNING in X.java (at line 9)\n\tpublic void flag() {}\n\t            ^^^^^^\nThe deprecated method flag() of type X should be annotated with @Deprecated\n----------\n5. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test122() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.lang.reflect.Method;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nclass GenericWithInnerAnnotation<T> {\n    @Retention(RetentionPolicy.RUNTIME)\n    @Target(ElementType.METHOD)\n    public @interface MyAnnotation {\n    }\n}\npublic class X extends GenericWithInnerAnnotation<Integer> {\n    @MyAnnotation\n    public void aMethod() {\n    }\n    \n    public static void main(String[] args) {\n       try {\n           Method method = X.class.getDeclaredMethod(\"aMethod\", new Class[]{});\n           System.out.print(method.getName());\n           Annotation[] annotations = method.getAnnotations();\n           System.out.println(annotations.length);\n       } catch(NoSuchMethodException e) {\n       }\n    }\n}"}, "aMethod1");
    }

    public void test123() {
        this.runNegativeTest(new String[]{"X.java", "class SuperX {\n\n    static void notOverridden() {\n        return;\n    }\n}\n\npublic class X extends SuperX {\n\n    static void notOverridden() {\n        return;\n    }\n  Zork z;\n} \n"}, "----------\n1. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test124() {
        this.runNegativeTest(new String[]{"X.java", "class SuperX {\n\n    void notOverridden() {\n        return;\n    }\n}\n\npublic class X extends SuperX {\n\n    void notOverridden() {\n        return;\n    }\n  Zork z;\n} \n"}, "----------\n1. WARNING in X.java (at line 10)\n\tvoid notOverridden() {\n\t     ^^^^^^^^^^^^^^^\nThe method notOverridden() of type X should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test125() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\n\npublic class X implements Ann {\n\t\n\tAnn ann = new X();\n\tpublic Class<? extends Annotation>  annotationType() {\n\t\treturn null;\n\t}\n}\n\n@interface Ann {}\n\n"}, "");
    }

    public void test126() {
        this.runNegativeTest(new String[]{"X.java", "public interface X {\n   Zork z;\n   X clone();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test127() {
        this.runNegativeTest(new String[]{"X.java", "@Deprecated\npublic class X {\n   void foo(){}\n}\n", "Y.java", "public class Y extends X {\n  @SuppressWarnings(\"all\")\n   void foo(){ super.foo(); }\n   Zork z;\n}\n"}, "----------\n1. WARNING in Y.java (at line 1)\n\tpublic class Y extends X {\n\t                       ^\nThe type X is deprecated\n----------\n2. ERROR in Y.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test128() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n    void foo(List list) {\n        List<String> ls1 = list;\n    }\n    @SuppressWarnings(\"unchecked\")\n    void bar(List list) {\n        List<String> ls2 = list;\n    }\n   Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid foo(List list) {\n\t         ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tList<String> ls1 = list;\n\t                   ^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<String>\n----------\n3. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test129() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n@SuppressWarnings(\"unchecked\")\npublic class X {\n\tvoid foo() {\n\t\tMap<String, String>[] map = new HashMap[10];\n\t}\n   Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test130() {
        Hashtable<String, String> customOptions = new Hashtable<String, String>();
        String[] warnings = CompilerOptions.warningOptionNames();
        int i = 0;
        int ceil = warnings.length;
        while (i < ceil) {
            customOptions.put(warnings[i], "warning");
            ++i;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X {\n\t             ^\nJavadoc: Missing comment for public declaration\n----------\n2. WARNING in X.java (at line 2)\n\tpublic static void main(String[] args) {\n\t                   ^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for public declaration\n----------\n3. WARNING in X.java (at line 2)\n\tpublic static void main(String[] args) {\n  }\n\t                                       ^^^^^\nEmpty block should be documented\n----------\n", null, true, customOptions);
    }

    public void test131() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"all\")\npublic class X {\n  public static void main(String[] args) {\n    Zork z;\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test132() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\nimport java.util.Vector;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tW.deprecated();\n\t\tList<X> l = new Vector();\n\t\tl.size();\n\t\ttry {\n\t\t\t// do nothing\n\t\t} finally {\n\t\t\tthrow new Error();\n\t\t}\n\t\t// Zork z;\n\t}\n\n\tclass S implements Serializable {\n\t\tString dummy;\n\t}\n}", "W.java", "public class W {\n\t// @deprecated\n\t@Deprecated\n\tstatic void deprecated() {\n\t\t// do nothing\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tW.deprecated();\n\t^^^^^^^^^^^^^^\nThe method deprecated() from the type W is deprecated\n----------\n2. WARNING in X.java (at line 8)\n\tList<X> l = new Vector();\n\t            ^^^^^^^^^^^^\nType safety: The expression of type Vector needs unchecked conversion to conform to List<X>\n----------\n3. WARNING in X.java (at line 8)\n\tList<X> l = new Vector();\n\t                ^^^^^^\nVector is a raw type. References to generic type Vector<E> should be parameterized\n----------\n4. WARNING in X.java (at line 12)\n\t} finally {\n\t\t\tthrow new Error();\n\t\t}\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nfinally block does not complete normally\n----------\n5. WARNING in X.java (at line 18)\n\tclass S implements Serializable {\n\t      ^\nThe serializable class S does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test133() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\nimport java.util.Vector;\n\n@SuppressWarnings( { \"deprecation\",//$NON-NLS-1$\n\t\t\"finally\",//$NON-NLS-1$\n\t\t\"serial\",//$NON-NLS-1$\n\t\t\"unchecked\"//$NON-NLS-1$\n})\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tW.deprecated();\n\t\tList<X> l = new Vector();\n\t\tl.size();\n\t\ttry {\n\t\t\t// do nothing\n\t\t} finally {\n\t\t\tthrow new Error();\n\t\t}\n\t\tZork z;\n\t}\n\n\tclass S implements Serializable {\n\t\tString dummy;\n\t}\n}", "W.java", "public class W {\n\t// @deprecated\n\t@Deprecated\n\tstatic void deprecated() {\n\t\t// do nothing\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 20)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test134() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\nimport java.util.Vector;\n\npublic class X {\n\t@SuppressWarnings( { \"deprecation\",//$NON-NLS-1$\n\t\t\t\"finally\",//$NON-NLS-1$\n\t\t\t\"unchecked\"//$NON-NLS-1$\n\t})\n\tpublic static void main(String[] args) {\n\t\tW.deprecated();\n\t\tList<X> l = new Vector();\n\t\tl.size();\n\t\ttry {\n\t\t\t// do nothing\n\t\t} finally {\n\t\t\tthrow new Error();\n\t\t}\n\t\tZork z;\n\t}\n\n\t@SuppressWarnings(\"unchecked\"//$NON-NLS-1$\n\t)\n\tList<X> l = new Vector();\n\n\t@SuppressWarnings(\"serial\"//$NON-NLS-1$\n\t)\n\tclass S implements Serializable {\n\t\tString dummy;\n\t}\n}", "W.java", "public class W {\n\t// @deprecated\n\t@Deprecated\n\tstatic void deprecated() {\n\t\t// do nothing\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 19)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void _test135() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"all\")//$NON-NLS-1$\nimport java.util.List;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tif (false) {\n\t\t\t;\n\t\t} else {\n\t\t}\n\t\tZork z;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test136() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"unused\"//$NON-NLS-1$\n\t)\n\tprivate static final String marker = \"never used mark\"; //$NON-NLS-1$\n\n\tpublic static void main(String[] args) {\n\t\tZork z;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test137() {
        Hashtable<String, String> customOptions = new Hashtable<String, String>();
        String[] warnings = CompilerOptions.warningOptionNames();
        int i = 0;
        int ceil = warnings.length;
        while (i < ceil) {
            customOptions.put(warnings[i], "warning");
            ++i;
        }
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.suppressWarnings", "disabled");
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\nimport java.util.Vector;\n\n@SuppressWarnings(\"all\")\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tW.deprecated();\n\t\tList<X> l = new Vector();\n\t\tl.size();\n\t\ttry {\n\t\t\t// do nothing\n\t\t} finally {\n\t\t\tthrow new Error();\n\t\t}\n\t\tZork z;\n\t}\n\n\tclass S implements Serializable {\n\t\tString dummy;\n\t}\n}", "W.java", "public class W {\n\t// @deprecated\n\t@Deprecated\n\tstatic void deprecated() {\n\t\t// do nothing\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tpublic class X {\n\t             ^\nJavadoc: Missing comment for public declaration\n----------\n2. WARNING in X.java (at line 7)\n\tpublic static void main(String[] args) {\n\t                   ^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for public declaration\n----------\n3. WARNING in X.java (at line 8)\n\tW.deprecated();\n\t^^^^^^^^^^^^^^\nThe method deprecated() from the type W is deprecated\n----------\n4. WARNING in X.java (at line 9)\n\tList<X> l = new Vector();\n\t            ^^^^^^^^^^^^\nType safety: The expression of type Vector needs unchecked conversion to conform to List<X>\n----------\n5. WARNING in X.java (at line 9)\n\tList<X> l = new Vector();\n\t                ^^^^^^\nVector is a raw type. References to generic type Vector<E> should be parameterized\n----------\n6. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n7. WARNING in X.java (at line 19)\n\tclass S implements Serializable {\n\t      ^\nThe serializable class S does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. WARNING in W.java (at line 1)\n\tpublic class W {\n\t             ^\nJavadoc: Missing comment for public declaration\n----------\n", null, true, customOptions);
    }

    public void test140() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. ERROR in X.java (at line 6)\r\n\tstatic void foo(){}\t\r\n\t            ^^^^^\nThe method foo() of type Bar must override a superclass method\n----------\n" : "----------\n1. ERROR in X.java (at line 6)\n\tstatic void foo(){}\t\n\t            ^^^^^\nThe method foo() of type Bar must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void foo(){}\n}\nclass Bar extends X {\n  @Override\n  static void foo(){}\t\n}\n\n"}, expectedOutput);
    }

    public void test141() {
        this.runNegativeTest(new String[]{"X.java", "@interface X1 {\n\tClass<? extends Throwable>[] expected1() default {};\n\tClass<? super Throwable>[] expected2() default {};\n\tClass<?>[] expected3() default {};\n}\n\npublic class X {\n\t@X1(expected1=Throwable.class, expected2={})\n\tpublic static void main(String[] args) {\n\t\t\n\t}\n\tvoid foo() {\n\t\tClass<? extends Throwable>[] c1 = {};\n\t\tClass<? super Throwable>[] c2 = {};\n\t\tClass<?>[] c3 = {};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tClass<? extends Throwable>[] c1 = {};\n\t                                  ^^\nCannot create a generic array of Class<? extends Throwable>\n----------\n2. ERROR in X.java (at line 14)\n\tClass<? super Throwable>[] c2 = {};\n\t                                ^^\nCannot create a generic array of Class<? super Throwable>\n----------\n");
    }

    public void test142() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"deprecation\")\npublic class X extends p.OldStuff {\n\t/**\n\t * @see p.OldStuff#foo()\n\t */\n\t@Override\n\tpublic void foo() {\n\t\tsuper.foo();\n\t}\n}\n", "p/OldStuff.java", "package p;\n@Deprecated\npublic class OldStuff {\n\tpublic void foo() {\n\t}\t\n  Zork z;\n}\n"}, "----------\n1. ERROR in p\\OldStuff.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null);
    }

    public void test142b() {
        HashMap<String, String> raiseInvalidJavadocSeverity = new HashMap<String, String>(2);
        raiseInvalidJavadocSeverity.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "error");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"deprecation\")\npublic class X extends p.OldStuff {\n\t/**\n\t * @see p.OldStuff#foo()\n\t */\n\t@Override\n\tpublic void foo() {\n\t\tsuper.foo();\n\t}\n}\n", "p/OldStuff.java", "package p;\n@Deprecated\npublic class OldStuff {\n\tpublic void foo() {\n\t}\t\n  Zork z;\n}\n"}, "----------\n1. ERROR in p\\OldStuff.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, raiseInvalidJavadocSeverity);
    }

    public void test142c() {
        HashMap<String, String> raiseDeprecationReduceInvalidJavadocSeverity = new HashMap<String, String>(2);
        raiseDeprecationReduceInvalidJavadocSeverity.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecation", "error");
        raiseDeprecationReduceInvalidJavadocSeverity.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"deprecation\")\npublic class X extends p.OldStuff {\n\t/**\n\t * @see p.OldStuff#foo()\n\t */\n\t@Override\n\tpublic void foo() {\n\t\tsuper.foo();\n\t}\n}\n", "p/OldStuff.java", "package p;\n@Deprecated\npublic class OldStuff {\n\tpublic void foo() {\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X extends p.OldStuff {\n\t                       ^^^^^^^^^^\nThe type OldStuff is deprecated\n----------\n2. ERROR in X.java (at line 8)\n\tsuper.foo();\n\t^^^^^^^^^^^\nThe method foo() from the type OldStuff is deprecated\n----------\n", null, true, raiseDeprecationReduceInvalidJavadocSeverity);
    }

    public void test143() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends p.OldStuff {\n\t@SuppressWarnings(\"all\")\n\tpublic void foo() {\n\t\tsuper.foo();\n\t}\n}\n", "p/OldStuff.java", "package p;\n@Deprecated\npublic class OldStuff {\n\tpublic void foo() {\n\t}\t\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X extends p.OldStuff {\n\t                       ^^^^^^^^^^\nThe type OldStuff is deprecated\n----------\n----------\n1. ERROR in p\\OldStuff.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test144() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tZork z;\n\t@SuppressWarnings(\"all\")  \n\tpublic static class EverythingWrong {\n\t\tprivate EverythingWrong() {}\n\t\t@BeforeClass public void notStaticBC() {}\n\t\t@BeforeClass static void notPublicBC() {}\n\t\t@BeforeClass public static int nonVoidBC() { return 0; }\n\t\t@BeforeClass public static void argumentsBC(int i) {}\n\t\t@BeforeClass public static void fineBC() {}\n\t\t@AfterClass public void notStaticAC() {}\n\t\t@AfterClass static void notPublicAC() {}\n\t\t@AfterClass public static int nonVoidAC() { return 0; }\n\t\t@AfterClass public static void argumentsAC(int i) {}\n\t\t@AfterClass public static void fineAC() {}\n\t\t@After public static void staticA() {}\n\t\t@After void notPublicA() {}\n\t\t@After public int nonVoidA() { return 0; }\n\t\t@After public void argumentsA(int i) {}\n\t\t@After public void fineA() {}\n\t\t@Before public static void staticB() {}\n\t\t@Before void notPublicB() {}\n\t\t@Before public int nonVoidB() { return 0; }\n\t\t@Before public void argumentsB(int i) {}\n\t\t@Before public void fineB() {}\n\t\t@Test public static void staticT() {}\n\t\t@Test void notPublicT() {}\n\t\t@Test public int nonVoidT() { return 0; }\n\t\t@Test public void argumentsT(int i) {}\n\t\t@Test public void fineT() {}\n\t}\n\t@Test public void testFailures() throws Exception {\n\t\tList<Exception> problems= new TestIntrospector(EverythingWrong.class).validateTestMethods();\n\t\tint errorCount= 1 + 4 * 5; // missing constructor plus four invalid methods for each annotation */\n\t\tassertEquals(errorCount, problems.size());\n\t}\n\tpublic static junit.framework.Test suite() {\n\t\treturn null; // new JUnit4TestAdapter(TestMethodTest.class);\n\t}\n\tvoid assertEquals(int i, int j) {\n\t}\n}\n@interface BeforeClass {}\n@interface AfterClass {}\n@interface Test {}\n@interface After {}\n@interface Before {}\nclass TestIntrospector {\n\tTestIntrospector(Class c) {}\n\tList validateTestMethods() { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 34)\n\tList<Exception> problems= new TestIntrospector(EverythingWrong.class).validateTestMethods();\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Exception>\n----------\n3. ERROR in X.java (at line 38)\n\tpublic static junit.framework.Test suite() {\n\t              ^^^^^\njunit cannot be resolved to a type\n----------\n4. WARNING in X.java (at line 50)\n\tTestIntrospector(Class c) {}\n\t                 ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n5. WARNING in X.java (at line 51)\n\tList validateTestMethods() { return null; }\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test145() {
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n  int foo();\n  int bar();\n}\n\npublic class X {\n  static final int yyy = 0;\n  @Annot(foo=zzz, bar = yyy)\n  static final int zzz = 0;\n}\n\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t@Annot(foo=zzz, bar = yyy)\n\t           ^^^\nCannot reference a field before it is defined\n----------\n");
    }

    public void test146() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(value={})\npublic class X {\n}\n"}, "");
    }

    public void test147() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings({\"nls\"})\npublic class X<T> {\n\t String test= \"\";\n}"}, "", null, true, options);
    }

    public void test148() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate static void foo() {\n\t\t @interface Bar {\n\t\t\tpublic String bar = \"BUG\";\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\t@interface Bar {\n\t           ^^^\nThe member annotation Bar can only be defined inside a top-level class or interface\n----------\n");
    }

    public void test149() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar() {\n\t\t@Annot(foo = zzz)\n\t\tfinal int zzz = 0;\n\n\t\t@Annot(foo = kkk)\n\t\tint kkk = 1;\n\n\t}\n\t@Annot(foo = fff)\n\tfinal int fff = 0;\n\t\n\t@Annot(foo = Member.ttt)\n\tstatic class Member {\n\t\tfinal static int ttt = 2;\n\t}\n}\n@interface Annot {\n\tint foo();\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t@Annot(foo = kkk)\n\t             ^^^\nThe value for annotation attribute Annot.foo must be a constant expression\n----------\n2. ERROR in X.java (at line 10)\n\t@Annot(foo = fff)\n\t             ^^^\nCannot reference a field before it is defined\n----------\n");
    }

    public void test150() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"assertIdentifier\")\nclass X {}"}, "----------\n1. WARNING in X.java (at line 1)\n\t@SuppressWarnings(\"assertIdentifier\")\n\t                  ^^^^^^^^^^^^^^^^^^\nUnhandled warning token assertIdentifier\n----------\n");
    }

    public void test151() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.autoboxing", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings({\"boxing\"})\npublic class X {\n\t static void foo(int i) {}\n\t public static void main(String[] args) {\n\t\tfoo(new Integer(0));\n\t }\n}"}, "", null, true, options);
    }

    public void test152() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.autoboxing", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings({\"boxing\"})\npublic class X {\n\t static void foo(Integer i) {}\n\t public static void main(String[] args) {\n\t\tfoo(0);\n\t }\n}"}, "", null, true, options);
    }

    public void test154() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fieldHiding", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t static int i;\n    @SuppressWarnings({\"hiding\"})\n\t public static void main(String[] args) {\n\t\tfor (int i = 0, max = args.length; i < max; i++) {\n\t\t\tSystem.out.println(args[i]);\n\t\t}\n\t }\n}"}, "", null, true, options);
    }

    public void test155() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.localVariableHiding", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings({\"hiding\"})\npublic class X {\t\n\t{ int x = \n\t\tnew Object() { \t\n\t\t\tint foo() {\t\n\t\t\t\tint x = 0;\n\t\t\t\treturn x;\t\n\t\t\t}\t\n\t\t}.foo();\t\n\t}\t\n}\n"}, "", null, true, options);
    }

    public void test156() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.typeParameterHiding", "warning");
        this.runNegativeTest(new String[]{"X.java", "class T {}\n@SuppressWarnings({\"hiding\"})\npublic class X<T> {\n}\n"}, "", null, true, options);
    }

    public void test157() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.hiddenCatchBlock", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   @SuppressWarnings({\"hiding\"})\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new BX();\n\t\t} catch(BX e) {\n\t\t} catch(AX e) {\n\t\t}\n\t}\n} \n@SuppressWarnings({\"serial\"})\nclass AX extends Exception {}\n@SuppressWarnings({\"serial\"})\nclass BX extends AX {}\n"}, "", null, true, options);
    }

    public void test158() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.finallyBlockNotCompletingNormally", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   @SuppressWarnings({\"finally\"})\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new AX();\n\t\t} finally {\n\t\t\treturn;\n\t\t}\n\t}\n} \n@SuppressWarnings({\"serial\"})\nclass AX extends Exception {}"}, "", null, true, options);
    }

    public void test159() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.indirectStaticAccess", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings({\"static-access\"})\npublic class X extends XZ {\n\t\n\tvoid foo() {\n\t\tint j = X.S;\n\t\tint k = super.S;\n\t\tint l = XZ.S;\n\t\tint m = XY.S;\n\t\t\n\t\tbar();\n\t\tX.bar();\n\t\tXY.bar();\n\t\tXZ.bar();\n\t}\n}\nclass XY {\n\tstatic int S = 10;\n\tstatic void bar(){}\n}\nclass XZ extends XY {\n}"}, "", null, true, options);
    }

    public void test160() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.staticAccessReceiver", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"static-access\")\npublic class X {\n\tvoid foo() {\n\t\tint m = new XY().S;\n\t}\n}\nclass XY {\n\tstatic int S = 10;\n}"}, "", null, true, options);
    }

    public void test161() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unqualifiedFieldAccess", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"unqualified-field-access\")\npublic class X {\n\tint i;\n\tint foo() {\n\t\treturn i;\n\t}\n}"}, "", null, true, options);
    }

    public void test162() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.uncheckedTypeOperation", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"unchecked\")\npublic class X<T> {\n    \n    public static void main(String[] args) {\n        AX ax = new AX();\n        AX ax2 = ax.p;\n        ax.p = new AX<String>();\n        ax.q = new AX<String>();\n        ax.r = new AX<Object>();\n        System.out.println(ax2);\n    }\n}\n\nclass AX <P> {\n    AX<P> p;\n    AX<Object> q;\n    AX<String> r;\n    BX<String> s;\n}\n\nclass BX<Q> {\n}\n"}, "", null, true, options);
    }

    public void test163() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "warning");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedParameter", "warning");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", "warning");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedDeclaredThrownException", "warning");
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\n@SuppressWarnings(\"unused\")\npublic class X<T> {\n    \n    public void foo(int i) throws java.io.IOException {\n       int j = 0;\n\t\tclass C {\n\t\t\tprivate void bar() {}\n\t\t}\n    }\n}", "Y.java", "public class Y extends Zork {\n}\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tpublic class Y extends Zork {\n\t                       ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, options);
    }

    public void test165() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "enabled");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecationInDeprecatedCode", "enabled");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecation", "warning");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "warning");
        options.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", "enabled");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
        this.runNegativeTest(new String[]{"X.java", "/**\n * @see Y\n */\n@SuppressWarnings(\"deprecation\")\npublic class X extends Y {\n\t /**\n\t  * @see Y#foo()\n\t  * @see Y#j\n\t  */\n    public void foo() {\n\t\tsuper.foo();\n    }\n}", "Y.java", "/**\n * @deprecated\n */\npublic class Y {\n\t/**\n\t * @deprecated\n\t */\n\tpublic void foo() {}\n\t/**\n\t * @deprecated\n\t */\n\tpublic int j;\n}"}, "", null, true, options);
    }

    public void test167() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic foo(@Deprecated() String s) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic foo(@Deprecated() String s) {\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nReturn type for the method is missing\n----------\n");
    }

    public void test168() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. ERROR in X.java (at line 2)\n\t@Override I clone();\n\t            ^^^^^^^\nThe method clone() of type I must override a superclass method\n----------\n2. ERROR in X.java (at line 7)\n\t@Override void foo();\n\t               ^^^^^\nThe method foo() of type J must override a superclass method\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\t@Override I clone();\n\t            ^^^^^^^\nThe method clone() of type I must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\t@Override I clone();\n\tvoid foo();\n}\n\ninterface J extends I {\n\t@Override void foo();\n}\n"}, expectedOutput);
    }

    public void test169() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"serial\")\npublic class X extends Exception {\n\tString s = \"Hello\"; \n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tString s = \"Hello\"; \n\t           ^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, true, customOptions);
    }

    public void test170() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runConformTest(new String[]{"X.java", "public class X extends Exception {\n   @SuppressWarnings(\"nls\")\n\tString s = \"Hello\"; \n}"}, "", null, true, null, customOptions, null);
    }

    public void test171() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X extends Exception {\n   @SuppressWarnings(\"nls\")\n\tString s = \"Hello\"; \n   @SuppressWarnings(\"serial\")\n\tString s2 = \"Hello2\"; \n}"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X extends Exception {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 5)\n\tString s2 = \"Hello2\"; \n\t            ^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, true, customOptions);
    }

    public void test172() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"serial\")\npublic class X extends Exception {\n   @SuppressWarnings(\"nls\")\n\tString s = \"Hello\"; \n   @SuppressWarnings(\"serial\")\n\tString s2 = \"Hello2\"; \n}"}, "----------\n1. WARNING in X.java (at line 6)\n\tString s2 = \"Hello2\"; \n\t            ^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, true, customOptions);
    }

    public void test173() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n    String value() default \"NONE\";\n}\n@Annot(\"serial\")\npublic class X extends Exception {\n   @SuppressWarnings(\"nls\")\n\tString s = \"Hello\"; \n   @SuppressWarnings(\"serial\")\n\tString s2 = \"Hello2\"; \n}"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic class X extends Exception {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 9)\n\tString s2 = \"Hello2\"; \n\t            ^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, true, customOptions);
    }

    public void test174() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n    int value() default 0;\n}\n@interface Annot2 {\n    String value();\n}\n@Annot(value=5)\npublic class X {\n   @Annot2(value=\"nls\")\n\tString s = null; \n   @SuppressWarnings(\"serial\")\n\tString s2 = \"Hello2\"; \n}"}, "----------\n1. WARNING in X.java (at line 12)\n\tString s2 = \"Hello2\"; \n\t            ^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, true, customOptions);
    }

    public void test175() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n    int value() default 0;\n}\n@interface Annot2 {\n    String value();\n}\n@Annot(value=5)\npublic class X {\n   @Annot2(value=\"nls\") String s = \"value\"; \n   @SuppressWarnings(\"serial\")\n\tString s2 = \"Hello2\"; \n}"}, "----------\n1. WARNING in X.java (at line 9)\n\t@Annot2(value=\"nls\") String s = \"value\"; \n\t                                ^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n2. WARNING in X.java (at line 11)\n\tString s2 = \"Hello2\"; \n\t            ^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, true, customOptions);
    }

    public void test176() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n    int value() default 0;\n}\n@interface Annot2 {\n    String value();\n}\n@Annot(value=5)\npublic class X {\n   @Annot2(value=\"nls\") String s = \"value\"; \n   @SuppressWarnings({\"serial\", \"nls\"})\n\tString s2 = \"Hello2\"; \n\t@Annot(value=5) void foo() {}\n}"}, "----------\n1. WARNING in X.java (at line 9)\n\t@Annot2(value=\"nls\") String s = \"value\"; \n\t                                ^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, true, customOptions);
    }

    public void test177() {
        this.runConformTest(new String[]{"X.java", "public @interface X {\n  public static final Integer foo = B.zzz; \n  public static final int foo3 = B.zzz2; \n}\nclass B {\n  public static final Integer zzz = new Integer(0);\n  public static final int zzz2 = 0;\n}\n"}, "");
    }

    public void test178() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tprivate void testme(boolean check) {\n\t\tArrayList<Integer> aList = new ArrayList<Integer>();\n\t\tfor (@SuppressWarnings(\"unusedLocal\")\n\t\tInteger i : aList) {\n\t\t\tSystem.out.println(\"checking\");\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test179() {
        this.runConformTest(new String[]{"X.java", "import static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\n@Target({TYPE, FIELD, METHOD,\r\n         PARAMETER, CONSTRUCTOR,\r\n         LOCAL_VARIABLE, PACKAGE,})\r\n@Retention(CLASS)\r\npublic @interface X {}"}, "");
    }

    public void test180() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Field;\n\npublic class X {\n  @Deprecated public static Object x, y, z;\n\n  public static void main(String[] args) {\n    Class c = X.class;\n    int counter = 0;\n    for (Field f : c.getFields()) {\n      counter += f.getDeclaredAnnotations().length;\n    }\n    System.out.print(counter);\n  }\n}"}, "3");
    }

    public void test181() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Field;\n\npublic class X {\n  public static Object x, y, z;\n\n  public static void main(String[] args) {\n    Class c = X.class;\n    int counter = 0;\n    for (Field f : c.getFields()) {\n      counter += f.getDeclaredAnnotations().length;\n    }\n    System.out.print(counter);\n  }\n}"}, "0");
    }

    public void test182() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Y y) {\n\t\ty.initialize(null, null, null);\n\t}\n}\n\n\n", "Y.java", "public class Y {\n\n\t/**\n\t * @deprecated\n\t */\n\tpublic void initialize(Zork z, String s) {\n\t}\n\n\tpublic void initialize(Zork z, String s, Thread t) {\n\t}\n}\n\n\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ty.initialize(null, null, null);\n\t  ^^^^^^^^^^\nThe method initialize(null, null, null) is undefined for the type Y\n----------\n----------\n1. ERROR in Y.java (at line 6)\n\tpublic void initialize(Zork z, String s) {\n\t                       ^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in Y.java (at line 9)\n\tpublic void initialize(Zork z, String s, Thread t) {\n\t                       ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test183() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Y y) {\n\t\tint i = y.initialize;\n\t}\n}\n\n", "Y.java", "public class Y {\n\n\t/**\n\t * @deprecated\n\t */\n\tpublic Zork initialize;\n}\n\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint i = y.initialize;\n\t        ^^^^^^^^^^^^\ny.initialize cannot be resolved or is not a field\n----------\n----------\n1. ERROR in Y.java (at line 6)\n\tpublic Zork initialize;\n\t       ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test184() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tY.initialize i;\n\t}\n}\n\n\n", "Y.java", "public class Y {\n\n\t/**\n\t * @deprecated\n\t */\n\tpublic class initialize extends Zork {\n\t}\n}\n\n\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tY.initialize i;\n\t^^^^^^^^^^^^\nThe type Y.initialize is deprecated\n----------\n----------\n1. WARNING in Y.java (at line 6)\n\tpublic class initialize extends Zork {\n\t             ^^^^^^^^^^\nThe deprecated type Y.initialize should be annotated with @Deprecated\n----------\n2. ERROR in Y.java (at line 6)\n\tpublic class initialize extends Zork {\n\t                                ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test185() {
        this.runNegativeTest(new String[]{"X.java", "import p.A;\n@SuppressWarnings(\"all\")\npublic class X {\n\tvoid foo(A a) {\n\t\tZork z;\n\t}\n}\n\nclass Y {\n\tA a;\n}\n", "p/A.java", "package p;\n@Deprecated\npublic class A {\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 10)\n\tA a;\n\t^\nThe type A is deprecated\n----------\n");
    }

    public void test186() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic class X {\n\t@Deprecated\n\tclass Y implements p2.I {\n\t\tZork z;\n\t}\n}\n", "p2/I.java", "package p2;\n@Deprecated\npublic interface I {\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test187() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\nimport p2.I;\n@Deprecated\npublic class X {\n\tZork z;\n}\n", "p2/I.java", "package p2;\n@Deprecated\npublic interface I {\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test188() {
        this.runNegativeTest(new String[]{"X.java", "@interface A1 {\n\tint[] values();\n}\n@A1(values = new int[] { 1, 2 })\npublic class X {\n\tpublic static void main(String[] args) {\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t@A1(values = new int[] { 1, 2 })\n\t             ^^^^^^^^^^^^^^^^^^\nThe value for annotation attribute A1.values must be an array initializer\n----------\n");
    }

    public void test189() {
        this.runConformTest(new String[]{"A1.java", "@A2(@A1(m1 = \"u\"))\npublic @interface A1 {\n  String m1();\n  String m2() default \"v\";\n}\n", "A2.java", "@A2(@A1(m1 = \"u\", m2 = \"w\"))\npublic @interface A2 {\n  A1[] value();\n}\n"}, "");
        this.runConformTest(new String[]{"A1.java", "@A2(@A1(m1 = \"u\"))\npublic @interface A1 {\n  String m1();\n  String m3() default \"v\";\n}\n"}, "", null, false, null);
    }

    public void test190() {
        this.runConformTest(new String[]{"A.java", "public @interface A {\n  int value();\n}\n"}, "");
        String binName1 = String.valueOf(OUTPUT_DIR) + File.separator + "bin1";
        File bin1 = new File(binName1);
        bin1.mkdir();
        String[] javaClassLibs = Util.getJavaClassLibs();
        int javaClassLibsLength = javaClassLibs.length;
        String[] xClassLibs = new String[javaClassLibsLength + 2];
        System.arraycopy(javaClassLibs, 0, xClassLibs, 0, javaClassLibsLength);
        xClassLibs[javaClassLibsLength] = OUTPUT_DIR;
        xClassLibs[javaClassLibsLength + 1] = binName1;
        new File(String.valueOf(OUTPUT_DIR) + File.separator + "A.class").renameTo(new File(String.valueOf(binName1) + File.separator + "A.class"));
        this.runConformTest(new String[]{"X.java", "public class X {\n    @A(0)\n    void foo() {\n        System.out.println(\"SUCCESS\");\n    }\n    public static void main(String args[]) {\n        new X().foo();\n    }\n}"}, "SUCCESS", xClassLibs, false, null);
        String binName2 = String.valueOf(OUTPUT_DIR) + File.separator + "bin2";
        File bin2 = new File(binName2);
        bin2.mkdir();
        new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class").renameTo(new File(String.valueOf(binName2) + File.separator + "X.class"));
        String[] yClassLibs = new String[javaClassLibsLength + 2];
        System.arraycopy(javaClassLibs, 0, yClassLibs, 0, javaClassLibsLength);
        yClassLibs[javaClassLibsLength] = OUTPUT_DIR;
        yClassLibs[javaClassLibsLength + 1] = binName2;
        this.runConformTest(new String[]{"Y.java", "public class Y {\n    public static void main(String args[]) {\n        new X().foo();\n    }\n}"}, "SUCCESS", yClassLibs, false, null);
    }

    public void test191() {
        this.runConformTest(new String[]{"A.java", "@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)\npublic @interface A {\n  int value();\n}\n"}, "");
        String binName1 = String.valueOf(OUTPUT_DIR) + File.separator + "bin1";
        File bin1 = new File(binName1);
        bin1.mkdir();
        String[] javaClassLibs = Util.getJavaClassLibs();
        int javaClassLibsLength = javaClassLibs.length;
        String[] xClassLibs = new String[javaClassLibsLength + 2];
        System.arraycopy(javaClassLibs, 0, xClassLibs, 0, javaClassLibsLength);
        xClassLibs[javaClassLibsLength] = OUTPUT_DIR;
        xClassLibs[javaClassLibsLength + 1] = binName1;
        new File(String.valueOf(OUTPUT_DIR) + File.separator + "A.class").renameTo(new File(String.valueOf(binName1) + File.separator + "A.class"));
        this.runConformTest(new String[]{"X.java", "public class X {\n    @A(0)\n    void foo() {\n        System.out.println(\"SUCCESS\");\n    }\n    public static void main(String args[]) {\n        new X().foo();\n    }\n}"}, "SUCCESS", xClassLibs, false, null);
        String binName2 = String.valueOf(OUTPUT_DIR) + File.separator + "bin2";
        File bin2 = new File(binName2);
        bin2.mkdir();
        new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class").renameTo(new File(String.valueOf(binName2) + File.separator + "X.class"));
        String[] yClassLibs = new String[javaClassLibsLength + 2];
        System.arraycopy(javaClassLibs, 0, yClassLibs, 0, javaClassLibsLength);
        yClassLibs[javaClassLibsLength] = OUTPUT_DIR;
        yClassLibs[javaClassLibsLength + 1] = binName2;
        this.runConformTest(new String[]{"Y.java", "public class Y {\n    public static void main(String args[]) {\n        new X().foo();\n    }\n}"}, "SUCCESS", yClassLibs, false, null);
    }

    public void test192() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@ATest(groups={\"a\",\"b\"})\n\tvoid foo(){\n\t}\n\t@ATest(groups=\"c\")\n\tvoid bar(){\n\t}\n}\n@interface ATest {\n\tString[] groups();\n}\n"}, "");
    }

    public void test193() {
        this.runNegativeTest(new String[]{"A.java", "public @interface A {\n\tA circular1();\n}\n@interface B {\n\tA circular2();\n}"}, "----------\n1. ERROR in A.java (at line 2)\r\n\tA circular1();\r\n\t^\nCycle detected: the annotation type A cannot contain attributes of the annotation type itself\n----------\n");
        this.runNegativeTest(new String[]{"A.java", "public @interface A {\n\tB circular2();\n\tA circular1();\n}\n@interface B {\n\tA circular();\n}"}, "----------\n1. ERROR in A.java (at line 2)\r\n\tB circular2();\r\n\t^\nCycle detected: a cycle exists between annotation attributes of A and B\n----------\n2. ERROR in A.java (at line 3)\r\n\tA circular1();\r\n\t^\nCycle detected: the annotation type A cannot contain attributes of the annotation type itself\n----------\n3. ERROR in A.java (at line 6)\r\n\tA circular();\r\n\t^\nCycle detected: a cycle exists between annotation attributes of B and A\n----------\n");
        this.runNegativeTest(new String[]{"A.java", "public @interface A {\n\tA circular1();\n\tB circular2();\n}\n@interface B {\n\tA circular();\n}"}, "----------\n1. ERROR in A.java (at line 2)\r\n\tA circular1();\r\n\t^\nCycle detected: the annotation type A cannot contain attributes of the annotation type itself\n----------\n2. ERROR in A.java (at line 3)\r\n\tB circular2();\r\n\t^\nCycle detected: a cycle exists between annotation attributes of A and B\n----------\n3. ERROR in A.java (at line 6)\r\n\tA circular();\r\n\t^\nCycle detected: a cycle exists between annotation attributes of B and A\n----------\n");
    }

    public void test194() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. ERROR in X.java (at line 5)\n\t@Override\n\t^^^^^^^^^\nThe annotation @Override is disallowed for this location\n----------\n2. ERROR in X.java (at line 9)\n\tpublic static void foo() {}\n\t                   ^^^^^\nThe method foo() of type X must override a superclass method\n----------\n" : "----------\n1. ERROR in X.java (at line 5)\n\t@Override\n\t^^^^^^^^^\nThe annotation @Override is disallowed for this location\n----------\n2. ERROR in X.java (at line 9)\n\tpublic static void foo() {}\n\t                   ^^^^^\nThe method foo() of type X must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "class Base {\n    public static void foo() {}\n}\npublic class X extends Base {\n\t@Override\n\tX(){}\n\t\n    @Override\n    public static void foo() {}\n}\n"}, expectedOutput);
    }

    public void test195() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"cast\")\n\tvoid foo() {\n\t\tString s = (String) \"hello\";\n\t}\n\tvoid bar() {\n\t\tString s = (String) \"hello\";\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tString s = (String) \"hello\";\n\t           ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n2. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test196() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n    enum MyEnum {\n        VAL_1, VAL_2\n    }\n    public MyEnum theValue() default null;\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic MyEnum theValue() default null;\n\t                                 ^^^^\nThe value for annotation attribute X.theValue must be an enum constant expression\n----------\n");
    }

    public void test197() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. WARNING in p\\X.java (at line 4)\n\tvoid foo() {\n\t     ^^^^^\nThe method X.foo() does not override the inherited method from OldStuff since it is private to a different package\n----------\n2. ERROR in p\\X.java (at line 4)\n\tvoid foo() {\n\t     ^^^^^\nThe method foo() of type X must override a superclass method\n----------\n" : "----------\n1. WARNING in p\\X.java (at line 4)\n\tvoid foo() {\n\t     ^^^^^\nThe method X.foo() does not override the inherited method from OldStuff since it is private to a different package\n----------\n2. ERROR in p\\X.java (at line 4)\n\tvoid foo() {\n\t     ^^^^^\nThe method foo() of type X must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X extends q.OldStuff {\n\t@Override\n\tvoid foo() {\n\t}\n}\n", "q/OldStuff.java", "package q;\npublic class OldStuff {\n\tvoid foo() {\n\t}\t\n}\n"}, expectedOutput);
    }

    public void test198() {
        this.runNegativeTest(new String[]{"X.java", "@interface Anno {\n        boolean b() default false;\n        String[] c() default \"\";\n}\n@Anno(b = {})\npublic class X {\n\t@Anno(c = { 0 })\n\tvoid foo(){}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t@Anno(b = {})\n\t          ^^\nType mismatch: cannot convert from Object[] to boolean\n----------\n2. ERROR in X.java (at line 7)\n\t@Anno(c = { 0 })\n\t            ^\nType mismatch: cannot convert from int to String\n----------\n");
    }

    public void test199() {
        this.runConformTest(new String[]{"X.java", "@interface AttributeOverrides {\n\tAttributeOverride[] value();\n}\n@interface AttributeOverride {\n\tString name();\n\tColumn column();\n}\n@interface Column {\n\tString name();\n}\n@AttributeOverrides({\n    @AttributeOverride( name=\"city\", column=@Column( name=\"DIAB99C_TXCTY\" )),\n    @AttributeOverride( name=\"state\", column=@Column( name=\"DIAB99C_TXSTAT\" )),\n    @AttributeOverride( name=\"zipCode\", column=@Column( name=\"DIAB99C_TXZIP\")),\n}) public class X {}"}, "");
    }

    public void test200() {
        this.runNegativeTest(new String[]{"X.java", "@interface X {\n  int clone();\n  String finalize();\n  boolean getClass();\n  long notify();\n  double notifyAll();\n  float wait();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint clone();\n\t    ^^^^^^^\nThe annotation type X cannot override the method Object.clone()\n----------\n2. ERROR in X.java (at line 3)\n\tString finalize();\n\t       ^^^^^^^^^^\nThe annotation type X cannot override the method Object.finalize()\n----------\n3. ERROR in X.java (at line 4)\n\tboolean getClass();\n\t        ^^^^^^^^^^\nThe annotation type X cannot override the method Object.getClass()\n----------\n4. ERROR in X.java (at line 5)\n\tlong notify();\n\t     ^^^^^^^^\nThe annotation type X cannot override the method Object.notify()\n----------\n5. ERROR in X.java (at line 6)\n\tdouble notifyAll();\n\t       ^^^^^^^^^^^\nThe annotation type X cannot override the method Object.notifyAll()\n----------\n6. ERROR in X.java (at line 7)\n\tfloat wait();\n\t      ^^^^^^\nThe annotation type X cannot override the method Object.wait()\n----------\n");
    }

    public void test201() {
        this.runNegativeTest(new String[]{"X.java", "@interface X {\n  char hashCode();\n  int annotationType();\n  Class toString();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tchar hashCode();\n\t     ^^^^^^^^^^\nThe annotation type X cannot override the method Annotation.hashCode()\n----------\n2. ERROR in X.java (at line 3)\n\tint annotationType();\n\t    ^^^^^^^^^^^^^^^^\nThe annotation type X cannot override the method Annotation.annotationType()\n----------\n3. WARNING in X.java (at line 4)\n\tClass toString();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n4. ERROR in X.java (at line 4)\n\tClass toString();\n\t      ^^^^^^^^^^\nThe annotation type X cannot override the method Annotation.toString()\n----------\n");
    }

    public void test202() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n @Ann(m=Object)\n private int foo;\n private NonExisting bar;\n }\n @interface Ann {\n String m();\n }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Ann(m=Object)\n\t       ^^^^^^\nObject cannot be resolved\n----------\n2. ERROR in X.java (at line 4)\n\tprivate NonExisting bar;\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n");
    }

    public void test203() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@Ann(m=Object())\n\tprivate void foo(){}\n\tprivate NonExisting bar(){}\n}\n@interface Ann {\n    String m();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Ann(m=Object())\n\t       ^^^^^^\nThe method Object() is undefined for the type X\n----------\n2. ERROR in X.java (at line 4)\n\tprivate NonExisting bar(){}\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n");
    }

    public void test204() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@Ann(m=bar(null))\n\tprivate void foo(){}\n\tprivate NonExisting bar(NonExisting ne){}\n}\n@interface Ann {\n    String m();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Ann(m=bar(null))\n\t       ^^^\nThe method bar(null) is undefined for the type X\n----------\n2. ERROR in X.java (at line 4)\n\tprivate NonExisting bar(NonExisting ne){}\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\tprivate NonExisting bar(NonExisting ne){}\n\t                        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n");
    }

    public void test205() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@Ann(m=foo())\n\tprivate void foo(){}\n\tprivate NonExisting bar(NonExisting ne){}\n}\n@interface Ann {\n    String m();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Ann(m=foo())\n\t       ^^^^^\nType mismatch: cannot convert from void to String\n----------\n2. ERROR in X.java (at line 4)\n\tprivate NonExisting bar(NonExisting ne){}\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\tprivate NonExisting bar(NonExisting ne){}\n\t                        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n");
    }

    public void test206() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@Ann(m=bar())\n\tprivate void foo(){}\n\tprivate NonExisting bar(){}\n}\n@interface Ann {\n    String m();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Ann(m=bar())\n\t       ^^^\nThe method bar() is undefined for the type X\n----------\n2. ERROR in X.java (at line 4)\n\tprivate NonExisting bar(){}\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n");
    }

    public void test207() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n@Ann(m=foo)\n private NonExisting foo;\n private NonExisting bar;\n }\n @interface Ann {\n String m();\n }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Ann(m=foo)\n\t       ^^^\nfoo cannot be resolved\n----------\n2. ERROR in X.java (at line 3)\n\tprivate NonExisting foo;\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\tprivate NonExisting bar;\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n");
    }

    public void test208() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n@Retention(RUNTIME) @interface MyAnnotation {\n    public MyEnum value();\n}\nenum MyEnum {\n    ONE, TWO, THREE\n}\n@MyAnnotation(X.FOO) class MyClass {\n}\npublic class X {\n    public static final MyEnum FOO = MyEnum.TWO;\n    public static void main(String[] args) {\n        MyAnnotation annotation =\n                MyClass.class.getAnnotation(MyAnnotation.class);\n        System.out.println(annotation.value().toString());\n    }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t@MyAnnotation(X.FOO) class MyClass {\n\t              ^^^^^\nThe value for annotation attribute MyAnnotation.value must be an enum constant expression\n----------\n");
    }

    public void test209() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n@Retention(RUNTIME) @interface MyAnnotation {\n    public MyEnum value();\n}\nenum MyEnum {\n    ONE, TWO, THREE\n}\n@MyAnnotation(value=X.FOO) class MyClass {\n}\npublic class X {\n    public static final MyEnum FOO = MyEnum.TWO;\n    public static void main(String[] args) {\n        MyAnnotation annotation =\n                MyClass.class.getAnnotation(MyAnnotation.class);\n        System.out.println(annotation.value().toString());\n    }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t@MyAnnotation(value=X.FOO) class MyClass {\n\t                    ^^^^^\nThe value for annotation attribute MyAnnotation.value must be an enum constant expression\n----------\n");
    }

    public void test210() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n@Retention(RUNTIME) @interface MyAnnotation {\n    public MyEnum[] value();\n}\nenum MyEnum {\n    ONE, TWO, THREE\n}\n@MyAnnotation(value= { X.FOO }) class MyClass {\n}\npublic class X {\n    public static final MyEnum FOO = MyEnum.TWO;\n    public static void main(String[] args) {\n        MyAnnotation annotation =\n                MyClass.class.getAnnotation(MyAnnotation.class);\n        System.out.println(annotation.value().toString());\n    }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t@MyAnnotation(value= { X.FOO }) class MyClass {\n\t                       ^^^^^\nThe value for annotation attribute MyAnnotation.value must be an enum constant expression\n----------\n");
    }

    public void test211() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n@Retention(RUNTIME) @interface MyAnnotation {\n    public MyEnum[] value();\n}\nenum MyEnum {\n    ONE, TWO, THREE\n}\n@MyAnnotation(value= { null }) class MyClass {\n}\npublic class X {\n    public static final MyEnum FOO = MyEnum.TWO;\n    public static void main(String[] args) {\n        MyAnnotation annotation =\n                MyClass.class.getAnnotation(MyAnnotation.class);\n        System.out.println(annotation.value().toString());\n    }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t@MyAnnotation(value= { null }) class MyClass {\n\t                       ^^^^\nThe value for annotation attribute MyAnnotation.value must be an enum constant expression\n----------\n");
    }

    public void test212() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n@Retention(RUNTIME) @interface MyAnnotation {\n    public MyEnum[] values();\n}\nenum MyEnum {\n    ONE, TWO, THREE\n}\npublic class X {\n\n\t\tprivate static final MyEnum[] myValues = { MyEnum.ONE, MyEnum.TWO };\n       @MyAnnotation(values=myValues) \n       public void dothetrick(){} \n\n        public static void main(String[] args)throws Exception {\n                MyAnnotation sluck = X.class.getMethod(\"dothetrick\", new Class[0]).getAnnotation(MyAnnotation.class);\n                System.out.println(sluck.values().length);\n        }\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\t@MyAnnotation(values=myValues) \n\t                     ^^^^^^^^\nThe value for annotation attribute MyAnnotation.values must be an array initializer\n----------\n");
    }

    public void test213() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n@Retention(RUNTIME) @interface MyAnnotation {\n    public int[] values();\n}\npublic class X {\n\n\t\tprivate static final int[] myValues = { 1, 2, 3 };\n       @MyAnnotation(values=myValues) \n       public void dothetrick(){} \n\n        public static void main(String[] args)throws Exception {\n                MyAnnotation sluck = X.class.getMethod(\"dothetrick\", new Class[0]).getAnnotation(MyAnnotation.class);\n                System.out.println(sluck.values().length);\n        }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t@MyAnnotation(values=myValues) \n\t                     ^^^^^^^^\nThe value for annotation attribute MyAnnotation.values must be an array initializer\n----------\n");
    }

    public void test214() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo();\n\t     ^^^^^\nThe method foo() of type I must override a superclass method\n----------\n2. ERROR in X.java (at line 8)\n\tpublic void foo() {}\n\t            ^^^^^\nThe method foo() of type X must override a superclass method\n----------\n3. ERROR in X.java (at line 13)\n\tvoid foo();\n\t     ^^^^^\nThe method foo() of type J must override a superclass method\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo();\n\t     ^^^^^\nThe method foo() of type I must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  @Override\n  void foo();\n  void bar();\n}\npublic class X implements I {\n  @Override\n  public void foo() {}\n  public void bar() {}\n}\ninterface J extends I {\n\t@Override\n\tvoid foo();\n}\n"}, expectedOutput);
    }

    public void test215() {
        String[] sources = new String[]{"I.java", "public interface I {\n  void foo();\n}\n", "X.java", "abstract class X implements I {\n}\n", "Y.java", "class Y extends X {\n  @Override\n  public void foo() {}\n}\n"};
        if (new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L) {
            this.runNegativeTest(sources, "----------\n1. ERROR in Y.java (at line 3)\r\n\tpublic void foo() {}\r\n\t            ^^^^^\nThe method foo() of type Y must override a superclass method\n----------\n");
        } else {
            this.runConformTest(sources, "");
        }
    }

    public void test216() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\npublic class X {\n  void bar(MyConstructor constructor, Class<Ann> ann) {\n    constructor.getAnnotation(ann).message();\n  }\n}\n@interface Ann {\n  String message();\n}\nclass MyConstructor<V> {\n  public <T extends Annotation> T getAnnotation(Class<T> c) { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tvoid bar(MyConstructor constructor, Class<Ann> ann) {\n\t         ^^^^^^^^^^^^^\nMyConstructor is a raw type. References to generic type MyConstructor<V> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tconstructor.getAnnotation(ann).message();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method getAnnotation(Class) belongs to the raw type MyConstructor. References to generic type MyConstructor<V> should be parameterized\n----------\n3. ERROR in X.java (at line 4)\n\tconstructor.getAnnotation(ann).message();\n\t                               ^^^^^^^\nThe method message() is undefined for the type Annotation\n----------\n");
    }

    public void test217() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\npublic class X {\n  void bar(MyConstructor constructor, Class<Ann> ann) {\n    constructor.getAnnotation(ann).message();\n  }\n}\n@interface Ann {\n  String message();\n}\ninterface Z {\n  <T extends Annotation> T getAnnotation(Class<T> c);\n}\nclass MyAccessibleObject implements Z {\n  public <T extends Annotation> T getAnnotation(Class<T> c) { return null; }\n}\nclass MyConstructor<V> {\n  public <T extends Annotation> T getAnnotation(Class<T> c) { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tvoid bar(MyConstructor constructor, Class<Ann> ann) {\n\t         ^^^^^^^^^^^^^\nMyConstructor is a raw type. References to generic type MyConstructor<V> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tconstructor.getAnnotation(ann).message();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method getAnnotation(Class) belongs to the raw type MyConstructor. References to generic type MyConstructor<V> should be parameterized\n----------\n3. ERROR in X.java (at line 4)\n\tconstructor.getAnnotation(ann).message();\n\t                               ^^^^^^^\nThe method message() is undefined for the type Annotation\n----------\n");
    }

    public void test218() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.lang.reflect.Constructor;\npublic class X {\n  void bar(Constructor constructor, Class<Ann> ann) {\n    constructor.getAnnotation(ann).message();\n  }\n}\n@interface Ann {\n  String message();\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid bar(Constructor constructor, Class<Ann> ann) {\n\t         ^^^^^^^^^^^\nConstructor is a raw type. References to generic type Constructor<T> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tconstructor.getAnnotation(ann).message();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method getAnnotation(Class) belongs to the raw type Constructor. References to generic type Constructor<T> should be parameterized\n----------\n3. ERROR in X.java (at line 5)\n\tconstructor.getAnnotation(ann).message();\n\t                               ^^^^^^^\nThe method message() is undefined for the type Annotation\n----------\n");
    }

    public void test219() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        @MyB1(MyA2.XX)\n        public void foo(){}\n}", "MyA1.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA1 {\n}", "MyA2.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA2 {\n        public static final MyA1 XX = null;\n}", "MyB1.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE, METHOD\n})\npublic @interface MyB1 {\n        MyA1 value();\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@MyB1(MyA2.XX)\n\t      ^^^^^^^\nThe value for annotation attribute MyB1.value must be some @MyA1 annotation \n----------\n");
    }

    public void test220() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        @MyB1({MyA2.XX})\n        public void foo(){}\n}", "MyA1.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA1 {\n}", "MyA2.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA2 {\n        public static final MyA1 XX = null;\n}", "MyB1.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE, METHOD\n})\npublic @interface MyB1 {\n        MyA1[] value();\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@MyB1({MyA2.XX})\n\t       ^^^^^^^\nThe value for annotation attribute MyB1.value must be some @MyA1 annotation \n----------\n");
    }

    public void test221() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        @MyB1(null)\n        public void foo(){}\n}", "MyA1.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA1 {\n}", "MyA2.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA2 {\n        public static final MyA1 XX = null;\n}", "MyB1.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE, METHOD\n})\npublic @interface MyB1 {\n        MyA1 value();\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@MyB1(null)\n\t      ^^^^\nThe value for annotation attribute MyB1.value must be some @MyA1 annotation \n----------\n");
    }

    public void test222() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        @MyB1({null})\n        public void foo(){}\n}", "MyA1.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA1 {\n}", "MyA2.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA2 {\n        public static final MyA1 XX = null;\n}", "MyB1.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE, METHOD\n})\npublic @interface MyB1 {\n        MyA1[] value();\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@MyB1({null})\n\t       ^^^^\nThe value for annotation attribute MyB1.value must be some @MyA1 annotation \n----------\n");
    }

    public void test223() {
        this.runConformTest(new String[]{"X.java", "public class X {\n        @MyB1(@MyA1())\n        public void foo(){}\n}", "MyA1.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA1 {\n}", "MyA2.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA2 {\n        public static final MyA1 XX = null;\n}", "MyB1.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE, METHOD\n})\npublic @interface MyB1 {\n        MyA1 value();\n}"}, "");
    }

    public void test224() {
        this.runConformTest(new String[]{"X.java", "public class X {\n        @MyB1({@MyA1(), @MyA1})\n        public void foo(){}\n}", "MyA1.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA1 {\n}", "MyA2.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA2 {\n        public static final MyA1 XX = null;\n}", "MyB1.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE, METHOD\n})\npublic @interface MyB1 {\n        MyA1[] value();\n}"}, "");
    }
}

