/* The following code was generated by JFlex 1.4.2 on 7/17/08 1:09 AM */

/*******************************************************************************
 * Copyright (c) 2004, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*nlsXXX*/
package org.eclipse.wst.css.core.internal.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.wst.css.core.internal.parser.regions.CSSTextRegionFactory;
import org.eclipse.wst.css.core.internal.parserz.CSSRegionContexts;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.2
 * on 7/17/08 1:09 AM from the specification file
 * <tt>CSSTokenizer.jflex</tt>
 */
public class CSSTokenizer implements CSSRegionContexts, ICSSTokenizer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ST_SELECTOR_ATTRIBUTE_NAME = 26;
  public static final int ST_IMPORT_DELIMITER = 10;
  public static final int ST_DECLARATION_PRE_VALUE = 38;
  public static final int ST_SELECTOR = 22;
  public static final int ST_CHARSET_DELIMITER = 4;
  public static final int ST_DECLARATION_VALUE = 40;
  public static final int ST_PAGE_PSEUDO_PAGE = 16;
  public static final int ST_IMPORT_URI = 6;
  public static final int ST_SELECTOR_ATTRIBUTE_END = 32;
  public static final int ST_SELECTOR_ATTRIBUTE_OPERATOR = 28;
  public static final int ST_DECLARATION = 34;
  public static final int ST_PAGE_DELIMITER = 18;
  public static final int ST_SELECTOR_ATTRIBUTE_VALUE = 30;
  public static final int ST_MEDIA_MEDIUM = 12;
  public static final int ST_CHARSET_NAME = 2;
  public static final int ST_IMPORT_MEDIUM = 8;
  public static final int ST_DECLARATION_SEPARATOR = 36;
  public static final int ST_FONT_FACE_DELIMITER = 20;
  public static final int ST_MEDIA_DELIMITER = 14;
  public static final int ST_SELECTOR_MODIFIER = 24;
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9,  9,  9,  0,  0, 10, 10, 11, 11, 12, 12, 13, 13, 
    14, 14, 15, 15, 16, 16, 17, 17, 18, 18
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\17\1\0\1\4\1\20\22\0\1\6\1\31\1\11"+
    "\1\21\1\16\1\72\1\16\1\5\1\25\1\13\1\35\1\15\1\55"+
    "\1\10\1\14\1\34\12\1\1\62\1\50\1\30\1\67\1\32\1\27"+
    "\1\36\1\43\1\26\1\40\1\57\1\46\1\64\1\61\1\41\1\51"+
    "\2\2\1\24\1\52\1\65\1\54\1\53\1\2\1\23\1\44\1\47"+
    "\1\22\5\2\1\66\1\3\1\71\1\16\1\2\1\16\1\42\1\7"+
    "\1\37\1\56\1\45\1\63\1\61\1\41\1\51\2\2\1\24\1\52"+
    "\1\65\1\54\1\53\1\2\1\23\1\44\1\47\1\22\5\2\1\60"+
    "\1\70\1\33\1\70\1\0\uff80\2";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\23\0\1\1\1\2\1\1\1\3\4\1\1\4\1\1"+
    "\1\5\1\1\1\6\1\7\3\1\1\10\3\1\1\11"+
    "\2\1\1\12\1\13\2\1\1\14\1\15\1\16\2\1"+
    "\1\17\1\1\1\3\1\20\1\21\1\22\2\1\1\23"+
    "\1\1\1\24\1\25\4\1\1\26\2\1\1\27\1\30"+
    "\1\31\1\32\4\1\1\33\3\1\1\32\1\1\2\34"+
    "\1\3\1\0\1\2\1\0\1\35\1\0\1\36\10\0"+
    "\1\6\4\0\1\37\4\0\1\40\4\0\1\11\1\0"+
    "\1\13\1\0\1\16\1\0\1\41\1\0\1\22\1\0"+
    "\1\25\2\0\1\25\3\0\1\26\1\42\3\0\1\43"+
    "\1\0\1\32\1\44\1\32\2\0\1\45\2\0\1\31"+
    "\1\46\2\0\1\32\2\0\1\47\1\2\1\50\1\35"+
    "\1\36\10\0\1\6\1\0\1\37\2\0\1\37\2\0"+
    "\1\40\2\0\1\40\2\0\1\11\1\13\1\16\1\22"+
    "\1\25\1\0\1\25\2\0\1\25\1\0\1\26\1\42"+
    "\1\32\1\0\1\32\1\0\1\45\2\0\1\45\1\0"+
    "\1\46\1\51\1\32\1\0\1\2\1\35\1\36\1\52"+
    "\1\53\10\0\1\6\5\0\1\11\1\13\1\16\1\22"+
    "\1\25\2\0\1\26\1\42\2\32\2\0\1\46\1\51"+
    "\1\0\1\44\1\0\1\2\1\35\1\36\3\0\1\54"+
    "\2\0\1\6\1\0\1\6\10\0\1\55\1\11\1\13"+
    "\1\16\1\22\1\25\2\0\1\26\1\42\2\32\2\0"+
    "\1\46\2\51\5\0\1\56\1\0\1\2\1\35\1\36"+
    "\2\0\1\57\2\0\1\6\6\0\1\55\2\0\1\11"+
    "\1\13\1\16\1\22\1\25\2\0\1\26\1\42\2\32"+
    "\2\0\1\46\2\51\2\0\1\56\3\0\1\2\1\35"+
    "\1\36\1\0\1\60\2\0\1\6\13\0\1\11\1\13"+
    "\1\16\1\22\1\25\2\0\1\26\1\42\2\32\2\0"+
    "\1\46\2\51\10\0\1\35\1\36\1\61\2\0\1\6"+
    "\6\0\1\55\1\0\1\55\2\0\1\42\1\32\2\0"+
    "\1\46\2\51\2\0\1\56\1\0\1\56\6\0\1\32"+
    "\1\51\4\0\1\62\4\0\1\51\3\0\1\63\12\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[434];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\73\0\166\0\261\0\354\0\u0127\0\u0162\0\u019d"+
    "\0\u01d8\0\u0213\0\u024e\0\u0289\0\u02c4\0\u02ff\0\u033a\0\u0375"+
    "\0\u03b0\0\u03eb\0\u0426\0\u0461\0\u049c\0\u04d7\0\u0512\0\u054d"+
    "\0\u0588\0\u05c3\0\u05fe\0\u0461\0\u0639\0\u0461\0\u0674\0\u06af"+
    "\0\u0461\0\u06ea\0\u0725\0\u0760\0\u0461\0\u079b\0\u07d6\0\u0811"+
    "\0\u084c\0\u0887\0\u08c2\0\u0461\0\u08fd\0\u0938\0\u0973\0\u0461"+
    "\0\u0461\0\u09ae\0\u09e9\0\u0a24\0\u0461\0\u0a5f\0\u0a9a\0\u0461"+
    "\0\u0461\0\u0ad5\0\u0b10\0\u0b4b\0\u0461\0\u0b86\0\u0461\0\u0bc1"+
    "\0\u0bfc\0\u0c37\0\u0c72\0\u0cad\0\u0ce8\0\u0d23\0\u0d5e\0\u0461"+
    "\0\u0461\0\u0d99\0\u0dd4\0\u0e0f\0\u0e4a\0\u0e85\0\u0ec0\0\u0461"+
    "\0\u0efb\0\u0f36\0\u0f71\0\u0fac\0\u0fe7\0\u0639\0\u0461\0\u1022"+
    "\0\u04d7\0\u105d\0\u1098\0\u0588\0\u10d3\0\u05c3\0\u110e\0\u1149"+
    "\0\u1184\0\u11bf\0\u11fa\0\u1235\0\u1270\0\u12ab\0\u12e6\0\u1321"+
    "\0\u135c\0\u06ea\0\u1397\0\u0461\0\u0760\0\u13d2\0\u079b\0\u140d"+
    "\0\u0461\0\u07d6\0\u1448\0\u1483\0\u0887\0\u14be\0\u0938\0\u14f9"+
    "\0\u09e9\0\u1534\0\u156f\0\u0461\0\u0b10\0\u15aa\0\u0bfc\0\u15e5"+
    "\0\u0c37\0\u1620\0\u0461\0\u0cad\0\u165b\0\u0d23\0\u1696\0\u16d1"+
    "\0\u170c\0\u1747\0\u0efb\0\u0461\0\u0e0f\0\u1782\0\u0461\0\u17bd"+
    "\0\u0e4a\0\u17f8\0\u0461\0\u0ec0\0\u1833\0\u186e\0\u0f71\0\u18a9"+
    "\0\u18e4\0\u191f\0\u0fe7\0\u195a\0\u0461\0\u1995\0\u0461\0\u19d0"+
    "\0\u1a0b\0\u1a46\0\u1a81\0\u1abc\0\u1af7\0\u1b32\0\u1b6d\0\u1ba8"+
    "\0\u1be3\0\u1c1e\0\u1c59\0\u06ea\0\u1c94\0\u1ccf\0\u0760\0\u1d0a"+
    "\0\u1d45\0\u079b\0\u1d80\0\u1dbb\0\u07d6\0\u1df6\0\u1e31\0\u1e6c"+
    "\0\u1ea7\0\u1ee2\0\u1f1d\0\u1f58\0\u1f93\0\u0c37\0\u1fce\0\u2009"+
    "\0\u0cad\0\u2044\0\u207f\0\u20ba\0\u20f5\0\u2130\0\u216b\0\u21a6"+
    "\0\u0e4a\0\u21e1\0\u221c\0\u0ec0\0\u2257\0\u2292\0\u22cd\0\u2308"+
    "\0\u2343\0\u237e\0\u23b9\0\u23f4\0\u0461\0\u0461\0\u242f\0\u246a"+
    "\0\u24a5\0\u24e0\0\u251b\0\u2556\0\u2591\0\u25cc\0\u2607\0\u2642"+
    "\0\u267d\0\u26b8\0\u26f3\0\u272e\0\u2769\0\u27a4\0\u27df\0\u281a"+
    "\0\u2855\0\u2890\0\u28cb\0\u2906\0\u2941\0\u297c\0\u29b7\0\u29f2"+
    "\0\u2a2d\0\u2a68\0\u2aa3\0\u2ade\0\u2b19\0\u2b54\0\u2b8f\0\u2bca"+
    "\0\u2c05\0\u2c40\0\u2c7b\0\u2cb6\0\u0461\0\u2cf1\0\u2d2c\0\u0461"+
    "\0\u2d67\0\u2da2\0\u2ddd\0\u2e18\0\u2e53\0\u2e8e\0\u2ec9\0\u2f04"+
    "\0\u2f3f\0\u2f7a\0\u0461\0\u2fb5\0\u2ff0\0\u302b\0\u3066\0\u30a1"+
    "\0\u30dc\0\u3117\0\u3152\0\u318d\0\u31c8\0\u3203\0\u323e\0\u3279"+
    "\0\u32b4\0\u32ef\0\u332a\0\u3365\0\u33a0\0\u2b19\0\u33db\0\u3416"+
    "\0\u0461\0\u3451\0\u348c\0\u34c7\0\u3502\0\u353d\0\u3578\0\u0461"+
    "\0\u35b3\0\u35ee\0\u3629\0\u3664\0\u369f\0\u36da\0\u3715\0\u3750"+
    "\0\u378b\0\u2ec9\0\u37c6\0\u3801\0\u383c\0\u3877\0\u38b2\0\u38ed"+
    "\0\u3928\0\u3963\0\u399e\0\u39d9\0\u3a14\0\u3a4f\0\u3a8a\0\u3ac5"+
    "\0\u3b00\0\u3b3b\0\u3b76\0\u3bb1\0\u3bec\0\u3c27\0\u3365\0\u3c62"+
    "\0\u3c9d\0\u3cd8\0\u3d13\0\u3d4e\0\u3d89\0\u3dc4\0\u0461\0\u3dff"+
    "\0\u3e3a\0\u3e75\0\u3eb0\0\u3eeb\0\u3f26\0\u3f61\0\u3f9c\0\u3fd7"+
    "\0\u4012\0\u404d\0\u4088\0\u40c3\0\u40fe\0\u4139\0\u4174\0\u41af"+
    "\0\u41ea\0\u4225\0\u4260\0\u429b\0\u42d6\0\u4311\0\u434c\0\u4387"+
    "\0\u43c2\0\u43fd\0\u4438\0\u4473\0\u44ae\0\u44e9\0\u4524\0\u455f"+
    "\0\u459a\0\u45d5\0\u4610\0\u464b\0\u4686\0\u46c1\0\u46fc\0\u0461"+
    "\0\u4737\0\u4772\0\u47ad\0\u47e8\0\u4823\0\u485e\0\u4899\0\u48d4"+
    "\0\u490f\0\u2f3f\0\u494a\0\u2f7a\0\u4985\0\u49c0\0\u49fb\0\u4a36"+
    "\0\u4a71\0\u4aac\0\u4ae7\0\u4b22\0\u4b5d\0\u4b98\0\u4bd3\0\u33db"+
    "\0\u4c0e\0\u3416\0\u4c49\0\u4c84\0\u4cbf\0\u4cfa\0\u4d35\0\u4d70"+
    "\0\u4dab\0\u4de6\0\u4e21\0\u4e5c\0\u4e97\0\u4ed2\0\u0461\0\u4f0d"+
    "\0\u4f48\0\u4f83\0\u4fbe\0\u0461\0\u4ff9\0\u5034\0\u506f\0\u0461"+
    "\0\u50aa\0\u50e5\0\u5120\0\u515b\0\u5196\0\u51d1\0\u520c\0\u5247"+
    "\0\u5282\0\u52bd";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[434];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\2\24\1\25\1\26\1\27\1\24\1\27\1\25\1\30"+
    "\1\24\1\27\1\24\1\31\2\24\2\27\1\32\3\25"+
    "\1\24\1\25\1\24\1\33\2\24\1\34\1\35\1\36"+
    "\1\37\11\25\1\24\4\25\1\24\2\25\1\24\1\25"+
    "\1\40\3\25\1\41\10\24\1\27\1\42\1\27\1\24"+
    "\1\43\1\44\1\27\4\24\2\27\7\24\1\33\2\24"+
    "\1\34\1\35\1\24\1\37\40\24\1\27\1\24\1\27"+
    "\1\24\1\43\1\24\1\27\4\24\2\27\7\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\11\24\1\45\26\24"+
    "\1\27\1\46\1\27\1\24\1\43\1\47\1\27\4\24"+
    "\2\27\1\24\1\50\5\24\1\33\2\24\1\34\1\35"+
    "\1\24\1\37\11\24\1\45\24\24\1\51\1\52\1\27"+
    "\1\24\1\27\1\51\1\53\1\24\1\27\4\24\2\27"+
    "\1\24\3\51\1\24\1\51\1\24\1\33\2\24\1\34"+
    "\1\35\1\24\1\37\11\51\1\45\4\51\1\24\2\51"+
    "\1\24\1\51\1\24\3\51\11\24\1\27\1\24\1\27"+
    "\1\24\1\43\1\24\1\27\4\24\2\27\7\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\11\24\1\45\4\24"+
    "\1\54\17\24\1\55\1\56\1\27\1\24\1\27\1\55"+
    "\1\57\1\24\1\27\4\24\2\27\1\24\3\55\1\24"+
    "\1\55\1\24\1\33\2\24\1\34\1\35\1\24\1\37"+
    "\11\55\1\24\4\55\1\24\2\55\1\24\1\55\1\24"+
    "\3\55\11\24\1\27\1\24\1\27\1\24\1\43\1\24"+
    "\1\27\4\24\2\27\7\24\1\33\2\24\1\34\1\35"+
    "\1\24\1\37\16\24\1\60\2\24\1\61\14\24\1\62"+
    "\1\63\1\27\1\24\1\27\1\62\1\64\1\24\1\27"+
    "\4\24\2\27\1\24\3\62\1\24\1\62\1\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\11\62\1\24\4\62"+
    "\1\24\2\62\1\65\1\62\1\66\3\62\11\24\1\27"+
    "\1\24\1\27\1\24\1\43\1\24\1\27\4\24\2\27"+
    "\7\24\1\33\2\24\1\34\1\35\1\24\1\37\21\24"+
    "\1\65\16\24\1\67\1\24\1\67\1\24\1\43\1\24"+
    "\1\67\1\24\1\31\1\70\1\24\2\67\1\32\6\24"+
    "\1\33\1\24\1\70\1\34\1\35\1\36\1\37\16\24"+
    "\1\71\2\24\1\65\1\24\1\40\3\24\1\41\6\24"+
    "\1\72\1\73\1\27\1\24\1\27\1\72\1\74\1\24"+
    "\1\27\4\24\2\27\1\24\3\72\1\24\1\72\1\24"+
    "\1\33\2\24\1\34\1\35\1\24\1\37\11\72\1\24"+
    "\4\72\1\24\2\72\1\24\1\72\1\24\3\72\11\24"+
    "\1\27\1\24\1\27\1\24\1\43\1\24\1\27\4\24"+
    "\2\27\7\24\1\33\2\24\1\34\1\35\1\24\1\37"+
    "\30\24\1\75\1\76\1\77\3\24\1\100\1\101\1\27"+
    "\1\102\1\27\1\100\1\103\1\104\1\27\4\24\2\27"+
    "\1\24\3\100\1\24\1\100\1\24\1\33\2\24\1\34"+
    "\1\35\1\24\1\37\11\100\1\24\4\100\1\24\2\100"+
    "\1\24\1\100\1\24\3\100\11\24\1\27\1\24\1\27"+
    "\1\24\1\43\1\24\1\27\4\24\2\27\7\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\32\24\1\77\3\24"+
    "\1\105\1\106\1\27\1\24\1\27\1\105\1\107\1\24"+
    "\1\27\4\24\2\27\1\24\3\105\1\24\1\105\1\24"+
    "\1\33\2\24\1\34\1\35\1\24\1\37\11\105\1\110"+
    "\4\105\1\24\2\105\1\24\1\105\1\24\3\105\11\24"+
    "\1\27\1\24\1\27\1\24\1\43\1\24\1\27\4\24"+
    "\2\27\7\24\1\33\2\24\1\34\1\35\1\24\1\37"+
    "\11\24\1\110\11\24\1\111\11\24\1\112\1\113\1\114"+
    "\1\27\1\115\1\27\1\113\1\116\1\117\1\27\1\120"+
    "\1\121\1\122\1\24\2\27\1\123\1\124\2\113\1\24"+
    "\1\113\1\24\1\33\1\125\1\24\1\34\1\126\1\24"+
    "\1\37\11\113\1\110\4\113\1\127\2\113\1\24\1\113"+
    "\1\24\3\113\6\24\1\112\1\113\1\114\1\130\1\115"+
    "\1\130\1\113\1\116\1\117\1\130\1\120\1\121\1\122"+
    "\1\24\2\130\1\123\1\124\2\113\1\24\1\113\1\24"+
    "\1\33\1\125\1\24\1\34\1\126\1\24\1\37\11\113"+
    "\1\110\4\113\1\127\2\113\1\24\1\113\1\24\3\113"+
    "\5\24\74\0\2\25\1\131\3\0\2\25\11\0\3\25"+
    "\1\0\1\25\10\0\11\25\1\0\4\25\1\0\2\25"+
    "\1\0\1\25\1\0\3\25\6\0\1\132\2\25\1\0"+
    "\2\25\1\132\2\25\1\0\4\25\2\0\16\25\1\132"+
    "\2\25\1\132\2\25\1\132\10\25\1\132\4\25\1\132"+
    "\7\25\4\0\1\27\1\0\1\27\3\0\1\27\4\0"+
    "\2\27\54\0\1\25\1\131\3\0\1\25\1\133\11\0"+
    "\3\25\1\0\1\25\10\0\11\25\1\0\4\25\1\0"+
    "\2\25\1\0\1\25\1\0\3\25\6\0\2\134\1\135"+
    "\3\0\2\134\11\0\3\134\1\0\1\134\10\0\11\134"+
    "\1\0\4\134\1\0\2\134\1\0\1\134\1\0\3\134"+
    "\6\0\2\136\1\137\3\0\2\136\11\0\3\136\1\0"+
    "\1\136\10\0\11\136\1\0\4\136\1\0\2\136\1\0"+
    "\1\136\1\0\3\136\36\0\1\140\76\0\1\141\74\0"+
    "\2\142\10\0\1\143\1\144\1\145\7\0\2\146\10\0"+
    "\1\147\1\150\3\0\1\147\1\151\11\0\3\147\1\0"+
    "\1\147\10\0\11\147\1\0\4\147\1\0\2\147\1\0"+
    "\1\147\1\0\3\147\6\0\2\152\1\153\1\0\1\154"+
    "\11\152\2\0\52\152\10\0\1\133\63\0\2\155\1\156"+
    "\1\0\4\155\1\154\5\155\2\0\52\155\1\0\2\157"+
    "\1\160\1\0\1\161\11\157\2\0\52\157\1\0\2\162"+
    "\1\163\1\0\4\162\1\161\5\162\2\0\52\162\23\0"+
    "\1\164\50\0\2\51\1\165\3\0\2\51\11\0\3\51"+
    "\1\0\1\51\10\0\11\51\1\0\4\51\1\0\2\51"+
    "\1\0\1\51\1\0\3\51\6\0\1\166\2\51\1\0"+
    "\2\51\1\166\2\51\1\0\4\51\2\0\16\51\1\166"+
    "\2\51\1\166\2\51\1\166\10\51\1\166\4\51\1\166"+
    "\7\51\2\0\1\51\1\165\3\0\1\51\1\133\11\0"+
    "\3\51\1\0\1\51\10\0\11\51\1\0\4\51\1\0"+
    "\2\51\1\0\1\51\1\0\3\51\6\0\2\55\1\167"+
    "\3\0\2\55\11\0\3\55\1\0\1\55\10\0\11\55"+
    "\1\0\4\55\1\0\2\55\1\0\1\55\1\0\3\55"+
    "\6\0\1\170\2\55\1\0\2\55\1\170\2\55\1\0"+
    "\4\55\2\0\16\55\1\170\2\55\1\170\2\55\1\170"+
    "\10\55\1\170\4\55\1\170\7\55\2\0\1\55\1\167"+
    "\3\0\1\55\1\133\11\0\3\55\1\0\1\55\10\0"+
    "\11\55\1\0\4\55\1\0\2\55\1\0\1\55\1\0"+
    "\3\55\6\0\2\62\1\171\3\0\2\62\11\0\3\62"+
    "\1\0\1\62\10\0\11\62\1\0\4\62\1\0\2\62"+
    "\1\0\1\62\1\0\3\62\6\0\1\172\2\62\1\0"+
    "\2\62\1\172\2\62\1\0\4\62\2\0\16\62\1\172"+
    "\2\62\1\172\2\62\1\172\10\62\1\172\4\62\1\172"+
    "\7\62\2\0\1\62\1\171\3\0\1\62\1\133\11\0"+
    "\3\62\1\0\1\62\10\0\11\62\1\0\4\62\1\0"+
    "\2\62\1\0\1\62\1\0\3\62\7\0\1\62\1\171"+
    "\3\0\1\62\1\173\11\0\3\62\1\0\1\62\10\0"+
    "\11\62\1\0\4\62\1\0\2\62\1\0\1\62\1\0"+
    "\3\62\5\0\4\174\1\67\1\174\1\67\3\174\1\67"+
    "\2\174\1\0\1\174\2\67\11\174\1\0\1\174\1\0"+
    "\20\174\1\0\2\174\1\0\12\174\1\0\2\72\1\175"+
    "\3\0\2\72\11\0\3\72\1\0\1\72\10\0\11\72"+
    "\1\0\4\72\1\0\2\72\1\0\1\72\1\0\3\72"+
    "\6\0\1\176\2\72\1\0\2\72\1\176\2\72\1\0"+
    "\4\72\2\0\16\72\1\176\2\72\1\176\2\72\1\176"+
    "\10\72\1\176\4\72\1\176\7\72\2\0\1\72\1\175"+
    "\3\0\1\72\1\133\11\0\3\72\1\0\1\72\10\0"+
    "\11\72\1\0\4\72\1\0\2\72\1\0\1\72\1\0"+
    "\3\72\74\0\1\75\4\0\2\100\1\177\3\0\2\100"+
    "\11\0\3\100\1\0\1\100\10\0\11\100\1\0\4\100"+
    "\1\0\2\100\1\0\1\100\1\0\3\100\6\0\1\200"+
    "\2\100\1\0\2\100\1\200\2\100\1\0\4\100\2\0"+
    "\16\100\1\200\2\100\1\200\2\100\1\200\10\100\1\200"+
    "\4\100\1\200\7\100\1\0\2\201\1\202\1\0\1\203"+
    "\11\201\2\0\52\201\2\0\1\100\1\177\3\0\1\100"+
    "\1\133\11\0\3\100\1\0\1\100\10\0\11\100\1\0"+
    "\4\100\1\0\2\100\1\0\1\100\1\0\3\100\6\0"+
    "\2\204\1\205\1\0\4\204\1\203\5\204\2\0\52\204"+
    "\1\0\2\105\1\206\3\0\2\105\11\0\3\105\1\0"+
    "\1\105\10\0\11\105\1\0\4\105\1\0\2\105\1\0"+
    "\1\105\1\0\3\105\6\0\1\207\2\105\1\0\2\105"+
    "\1\207\2\105\1\0\4\105\2\0\16\105\1\207\2\105"+
    "\1\207\2\105\1\207\10\105\1\207\4\105\1\207\7\105"+
    "\2\0\1\105\1\206\3\0\1\105\1\133\11\0\3\105"+
    "\1\0\1\105\10\0\11\105\1\0\4\105\1\0\2\105"+
    "\1\0\1\105\1\0\3\105\6\0\1\112\1\210\1\211"+
    "\3\0\1\210\1\212\3\0\1\213\5\0\3\210\1\0"+
    "\1\210\10\0\11\210\1\0\4\210\1\0\2\210\1\0"+
    "\1\210\1\0\3\210\4\0\1\214\1\0\2\113\1\215"+
    "\3\0\2\113\3\0\1\216\5\0\3\113\1\217\1\113"+
    "\10\0\11\113\1\0\4\113\1\0\2\113\1\0\1\113"+
    "\1\0\3\113\6\0\1\220\2\113\1\0\2\113\1\220"+
    "\2\113\1\0\4\113\2\0\16\113\1\220\2\113\1\220"+
    "\2\113\1\220\10\113\1\220\4\113\1\220\7\113\1\0"+
    "\2\221\1\222\1\0\1\223\11\221\2\0\52\221\1\0"+
    "\1\112\1\113\1\215\3\0\1\113\1\133\3\0\1\213"+
    "\5\0\3\113\1\0\1\113\10\0\11\113\1\0\4\113"+
    "\1\0\2\113\1\0\1\113\1\0\3\113\6\0\2\224"+
    "\1\225\1\0\4\224\1\223\5\224\2\0\52\224\1\0"+
    "\1\226\72\0\1\112\12\0\1\213\57\0\2\227\1\230"+
    "\3\0\2\227\11\0\3\227\1\0\1\227\10\0\11\227"+
    "\1\0\4\227\1\0\2\227\1\0\1\227\1\0\3\227"+
    "\6\0\2\113\1\215\3\0\2\113\3\0\1\216\1\231"+
    "\4\0\1\113\1\232\1\113\1\217\1\113\10\0\11\113"+
    "\1\0\4\113\1\0\2\113\1\0\1\113\1\0\3\113"+
    "\11\0\1\233\1\0\1\233\3\0\1\233\4\0\2\233"+
    "\30\0\1\234\21\0\4\235\1\130\1\235\1\130\3\235"+
    "\1\130\4\235\2\130\12\235\1\0\14\235\1\0\22\235"+
    "\1\0\1\236\1\25\1\131\1\25\1\0\1\25\1\236"+
    "\1\25\1\0\1\25\4\0\2\25\1\0\3\25\1\0"+
    "\1\25\10\0\1\236\2\25\1\236\2\25\1\236\2\25"+
    "\1\0\4\25\1\0\1\236\1\25\1\0\1\25\1\0"+
    "\1\236\2\25\37\0\1\237\41\0\1\240\2\134\1\0"+
    "\2\134\1\240\2\134\1\0\4\134\2\0\16\134\1\240"+
    "\2\134\1\240\2\134\1\240\10\134\1\240\4\134\1\240"+
    "\7\134\1\0\1\241\2\136\1\0\2\136\1\241\2\136"+
    "\1\0\4\136\2\0\16\136\1\241\2\136\1\241\2\136"+
    "\1\241\10\136\1\241\4\136\1\241\7\136\10\0\1\242"+
    "\62\0\35\141\1\243\35\141\41\0\1\244\103\0\1\245"+
    "\65\0\2\246\66\0\2\247\103\0\1\250\17\0\2\147"+
    "\1\150\3\0\2\147\11\0\3\147\1\251\1\147\10\0"+
    "\11\147\1\0\4\147\1\0\2\147\1\0\1\147\1\0"+
    "\3\147\6\0\1\252\2\147\1\0\2\147\1\252\2\147"+
    "\1\0\4\147\2\0\16\147\1\252\2\147\1\252\2\147"+
    "\1\252\10\147\1\252\4\147\1\252\7\147\2\0\1\147"+
    "\1\150\3\0\1\147\12\0\3\147\1\0\1\147\10\0"+
    "\11\147\1\0\4\147\1\0\2\147\1\0\1\147\1\0"+
    "\3\147\6\0\1\253\1\152\1\153\1\152\1\254\1\152"+
    "\1\253\10\152\1\255\16\152\1\253\2\152\1\253\2\152"+
    "\1\253\10\152\1\253\4\152\1\253\7\152\1\0\1\256"+
    "\1\155\1\156\3\155\1\256\1\155\1\257\6\155\1\260"+
    "\16\155\1\256\2\155\1\256\2\155\1\256\10\155\1\256"+
    "\4\155\1\256\7\155\1\0\1\261\1\157\1\160\1\157"+
    "\1\262\1\157\1\261\10\157\1\263\16\157\1\261\2\157"+
    "\1\261\2\157\1\261\10\157\1\261\4\157\1\261\7\157"+
    "\1\0\1\264\1\162\1\163\3\162\1\264\1\162\1\265"+
    "\6\162\1\266\16\162\1\264\2\162\1\264\2\162\1\264"+
    "\10\162\1\264\4\162\1\264\7\162\24\0\1\267\47\0"+
    "\1\270\1\51\1\165\1\51\1\0\1\51\1\270\1\51"+
    "\1\0\1\51\4\0\2\51\1\0\3\51\1\0\1\51"+
    "\10\0\1\270\2\51\1\270\2\51\1\270\2\51\1\0"+
    "\4\51\1\0\1\270\1\51\1\0\1\51\1\0\1\270"+
    "\2\51\6\0\1\271\1\55\1\167\1\55\1\0\1\55"+
    "\1\271\1\55\1\0\1\55\4\0\2\55\1\0\3\55"+
    "\1\0\1\55\10\0\1\271\2\55\1\271\2\55\1\271"+
    "\2\55\1\0\4\55\1\0\1\271\1\55\1\0\1\55"+
    "\1\0\1\271\2\55\6\0\1\272\1\62\1\171\1\62"+
    "\1\0\1\62\1\272\1\62\1\0\1\62\4\0\2\62"+
    "\1\0\3\62\1\0\1\62\10\0\1\272\2\62\1\272"+
    "\2\62\1\272\2\62\1\0\4\62\1\0\1\272\1\62"+
    "\1\0\1\62\1\0\1\272\2\62\7\0\1\62\1\171"+
    "\3\0\1\62\12\0\3\62\1\0\1\62\10\0\11\62"+
    "\1\0\4\62\1\0\2\62\1\0\1\62\1\0\3\62"+
    "\6\0\1\273\1\72\1\175\1\72\1\0\1\72\1\273"+
    "\1\72\1\0\1\72\4\0\2\72\1\0\3\72\1\0"+
    "\1\72\10\0\1\273\2\72\1\273\2\72\1\273\2\72"+
    "\1\0\4\72\1\0\1\273\1\72\1\0\1\72\1\0"+
    "\1\273\2\72\6\0\1\274\1\100\1\177\1\100\1\0"+
    "\1\100\1\274\1\100\1\0\1\100\4\0\2\100\1\0"+
    "\3\100\1\0\1\100\10\0\1\274\2\100\1\274\2\100"+
    "\1\274\2\100\1\0\4\100\1\0\1\274\1\100\1\0"+
    "\1\100\1\0\1\274\2\100\6\0\1\275\1\201\1\202"+
    "\1\201\1\276\1\201\1\275\10\201\1\277\16\201\1\275"+
    "\2\201\1\275\2\201\1\275\10\201\1\275\4\201\1\275"+
    "\7\201\1\0\1\300\1\204\1\205\3\204\1\300\1\204"+
    "\1\301\6\204\1\302\16\204\1\300\2\204\1\300\2\204"+
    "\1\300\10\204\1\300\4\204\1\300\7\204\1\0\1\303"+
    "\1\105\1\206\1\105\1\0\1\105\1\303\1\105\1\0"+
    "\1\105\4\0\2\105\1\0\3\105\1\0\1\105\10\0"+
    "\1\303\2\105\1\303\2\105\1\303\2\105\1\0\4\105"+
    "\1\0\1\303\1\105\1\0\1\105\1\0\1\303\2\105"+
    "\6\0\2\210\1\211\3\0\2\210\11\0\3\210\1\0"+
    "\1\210\10\0\11\210\1\0\4\210\1\0\2\210\1\0"+
    "\1\210\1\0\3\210\6\0\1\304\2\210\1\0\2\210"+
    "\1\304\2\210\1\0\4\210\2\0\16\210\1\304\2\210"+
    "\1\304\2\210\1\304\10\210\1\304\4\210\1\304\7\210"+
    "\2\0\1\210\1\211\3\0\1\210\12\0\3\210\1\0"+
    "\1\210\10\0\11\210\1\0\4\210\1\0\2\210\1\0"+
    "\1\210\1\0\3\210\6\0\2\305\1\306\3\0\2\305"+
    "\11\0\3\305\1\0\1\305\10\0\11\305\1\0\4\305"+
    "\1\0\2\305\1\0\1\305\1\0\3\305\6\0\1\307"+
    "\1\113\1\215\1\113\1\0\1\113\1\307\1\113\1\0"+
    "\1\113\1\0\1\216\2\0\2\113\1\0\3\113\1\217"+
    "\1\113\10\0\1\307\2\113\1\307\2\113\1\307\2\113"+
    "\1\0\4\113\1\0\1\307\1\113\1\0\1\113\1\0"+
    "\1\307\2\113\6\0\1\310\1\221\1\222\1\221\1\311"+
    "\1\221\1\310\10\221\1\312\16\221\1\310\2\221\1\310"+
    "\2\221\1\310\10\221\1\310\4\221\1\310\7\221\1\0"+
    "\1\313\1\224\1\225\3\224\1\313\1\224\1\314\6\224"+
    "\1\315\16\224\1\313\2\224\1\313\2\224\1\313\10\224"+
    "\1\313\4\224\1\313\7\224\1\0\1\226\1\210\1\211"+
    "\3\0\1\210\1\212\11\0\3\210\1\0\1\210\10\0"+
    "\11\210\1\0\4\210\1\0\2\210\1\0\1\210\1\0"+
    "\3\210\4\0\1\214\1\0\1\316\2\227\1\0\2\227"+
    "\1\316\2\227\1\0\4\227\2\0\16\227\1\316\2\227"+
    "\1\316\2\227\1\316\10\227\1\316\4\227\1\316\7\227"+
    "\1\0\1\317\5\0\1\317\16\0\2\317\7\0\2\317"+
    "\1\0\2\317\1\0\2\317\7\0\2\317\3\0\2\317"+
    "\7\0\2\113\1\215\3\0\2\113\3\0\1\216\5\0"+
    "\2\113\1\320\1\217\1\113\10\0\11\113\1\0\4\113"+
    "\1\0\2\113\1\0\1\113\1\0\3\113\57\0\1\321"+
    "\21\0\1\322\1\25\1\131\1\25\1\0\1\25\1\322"+
    "\1\25\1\0\1\25\4\0\2\25\1\0\3\25\1\0"+
    "\1\25\10\0\1\322\2\25\1\322\2\25\1\322\2\25"+
    "\1\0\4\25\1\0\1\322\1\25\1\0\1\25\1\0"+
    "\1\322\2\25\6\0\1\323\1\134\1\135\1\134\1\0"+
    "\1\134\1\323\1\134\1\0\1\134\4\0\2\134\1\0"+
    "\3\134\1\0\1\134\10\0\1\323\2\134\1\323\2\134"+
    "\1\323\2\134\1\0\4\134\1\0\1\323\1\134\1\0"+
    "\1\134\1\0\1\323\2\134\6\0\1\324\1\136\1\137"+
    "\1\136\1\0\1\136\1\324\1\136\1\0\1\136\4\0"+
    "\2\136\1\0\3\136\1\0\1\136\10\0\1\324\2\136"+
    "\1\324\2\136\1\324\2\136\1\0\4\136\1\0\1\324"+
    "\1\136\1\0\1\136\1\0\1\324\2\136\15\0\1\325"+
    "\62\0\34\141\1\326\1\243\35\141\42\0\2\327\102\0"+
    "\1\330\75\0\2\331\74\0\1\332\76\0\1\333\7\0"+
    "\1\334\1\335\1\251\1\0\1\251\1\334\1\336\1\0"+
    "\1\251\4\0\2\251\1\0\3\334\1\0\1\334\10\0"+
    "\11\334\1\0\4\334\1\0\2\334\1\0\1\334\1\0"+
    "\3\334\6\0\1\337\1\147\1\150\1\147\1\0\1\147"+
    "\1\337\1\147\1\0\1\147\4\0\2\147\1\0\3\147"+
    "\1\251\1\147\10\0\1\337\2\147\1\337\2\147\1\337"+
    "\2\147\1\0\4\147\1\0\1\337\1\147\1\0\1\147"+
    "\1\0\1\337\2\147\6\0\1\340\1\152\1\153\1\152"+
    "\1\154\1\152\1\340\27\152\1\340\2\152\1\340\2\152"+
    "\1\340\10\152\1\340\4\152\1\340\7\152\1\0\2\152"+
    "\1\153\1\0\1\154\12\152\1\0\52\152\1\0\1\341"+
    "\1\155\1\156\3\155\1\341\1\155\1\154\25\155\1\341"+
    "\2\155\1\341\2\155\1\341\10\155\1\341\4\155\1\341"+
    "\7\155\1\0\2\155\1\156\1\0\4\155\1\154\6\155"+
    "\1\0\52\155\1\0\1\342\1\157\1\160\1\157\1\161"+
    "\1\157\1\342\27\157\1\342\2\157\1\342\2\157\1\342"+
    "\10\157\1\342\4\157\1\342\7\157\1\0\2\157\1\160"+
    "\1\0\1\161\12\157\1\0\52\157\1\0\1\343\1\162"+
    "\1\163\3\162\1\343\1\162\1\161\25\162\1\343\2\162"+
    "\1\343\2\162\1\343\10\162\1\343\4\162\1\343\7\162"+
    "\1\0\2\162\1\163\1\0\4\162\1\161\6\162\1\0"+
    "\52\162\25\0\1\344\46\0\1\345\1\51\1\165\1\51"+
    "\1\0\1\51\1\345\1\51\1\0\1\51\4\0\2\51"+
    "\1\0\3\51\1\0\1\51\10\0\1\345\2\51\1\345"+
    "\2\51\1\345\2\51\1\0\4\51\1\0\1\345\1\51"+
    "\1\0\1\51\1\0\1\345\2\51\6\0\1\346\1\55"+
    "\1\167\1\55\1\0\1\55\1\346\1\55\1\0\1\55"+
    "\4\0\2\55\1\0\3\55\1\0\1\55\10\0\1\346"+
    "\2\55\1\346\2\55\1\346\2\55\1\0\4\55\1\0"+
    "\1\346\1\55\1\0\1\55\1\0\1\346\2\55\6\0"+
    "\1\347\1\62\1\171\1\62\1\0\1\62\1\347\1\62"+
    "\1\0\1\62\4\0\2\62\1\0\3\62\1\0\1\62"+
    "\10\0\1\347\2\62\1\347\2\62\1\347\2\62\1\0"+
    "\4\62\1\0\1\347\1\62\1\0\1\62\1\0\1\347"+
    "\2\62\6\0\1\350\1\72\1\175\1\72\1\0\1\72"+
    "\1\350\1\72\1\0\1\72\4\0\2\72\1\0\3\72"+
    "\1\0\1\72\10\0\1\350\2\72\1\350\2\72\1\350"+
    "\2\72\1\0\4\72\1\0\1\350\1\72\1\0\1\72"+
    "\1\0\1\350\2\72\6\0\1\351\1\100\1\177\1\100"+
    "\1\0\1\100\1\351\1\100\1\0\1\100\4\0\2\100"+
    "\1\0\3\100\1\0\1\100\10\0\1\351\2\100\1\351"+
    "\2\100\1\351\2\100\1\0\4\100\1\0\1\351\1\100"+
    "\1\0\1\100\1\0\1\351\2\100\6\0\1\352\1\201"+
    "\1\202\1\201\1\203\1\201\1\352\27\201\1\352\2\201"+
    "\1\352\2\201\1\352\10\201\1\352\4\201\1\352\7\201"+
    "\1\0\2\201\1\202\1\0\1\203\12\201\1\0\52\201"+
    "\1\0\1\353\1\204\1\205\3\204\1\353\1\204\1\203"+
    "\25\204\1\353\2\204\1\353\2\204\1\353\10\204\1\353"+
    "\4\204\1\353\7\204\1\0\2\204\1\205\1\0\4\204"+
    "\1\203\6\204\1\0\52\204\1\0\1\354\1\105\1\206"+
    "\1\105\1\0\1\105\1\354\1\105\1\0\1\105\4\0"+
    "\2\105\1\0\3\105\1\0\1\105\10\0\1\354\2\105"+
    "\1\354\2\105\1\354\2\105\1\0\4\105\1\0\1\354"+
    "\1\105\1\0\1\105\1\0\1\354\2\105\6\0\1\355"+
    "\1\210\1\211\1\210\1\0\1\210\1\355\1\210\1\0"+
    "\1\210\4\0\2\210\1\0\3\210\1\0\1\210\10\0"+
    "\1\355\2\210\1\355\2\210\1\355\2\210\1\0\4\210"+
    "\1\0\1\355\1\210\1\0\1\210\1\0\1\355\2\210"+
    "\6\0\2\305\1\306\3\0\2\305\3\0\1\216\5\0"+
    "\3\305\1\0\1\305\10\0\11\305\1\0\4\305\1\0"+
    "\2\305\1\0\1\305\1\0\3\305\6\0\1\356\2\305"+
    "\1\0\2\305\1\356\2\305\1\0\4\305\2\0\16\305"+
    "\1\356\2\305\1\356\2\305\1\356\10\305\1\356\4\305"+
    "\1\356\7\305\1\0\1\357\1\113\1\215\1\113\1\0"+
    "\1\113\1\357\1\113\1\0\1\113\1\0\1\216\2\0"+
    "\2\113\1\0\3\113\1\217\1\113\10\0\1\357\2\113"+
    "\1\357\2\113\1\357\2\113\1\0\4\113\1\0\1\357"+
    "\1\113\1\0\1\113\1\0\1\357\2\113\6\0\1\360"+
    "\1\221\1\222\1\221\1\223\1\221\1\360\27\221\1\360"+
    "\2\221\1\360\2\221\1\360\10\221\1\360\4\221\1\360"+
    "\7\221\1\0\2\221\1\222\1\0\1\223\12\221\1\0"+
    "\52\221\1\0\1\361\1\224\1\225\3\224\1\361\1\224"+
    "\1\223\25\224\1\361\2\224\1\361\2\224\1\361\10\224"+
    "\1\361\4\224\1\361\7\224\1\0\2\224\1\225\1\0"+
    "\4\224\1\223\6\224\1\0\52\224\1\0\1\362\1\227"+
    "\1\230\1\227\1\0\1\227\1\362\1\227\1\0\1\227"+
    "\4\0\2\227\1\0\3\227\1\0\1\227\10\0\1\362"+
    "\2\227\1\362\2\227\1\362\2\227\1\0\4\227\1\0"+
    "\1\362\1\227\1\0\1\227\1\0\1\362\2\227\6\0"+
    "\1\363\5\0\1\363\1\364\15\0\2\363\7\0\2\363"+
    "\1\0\2\363\1\0\2\363\7\0\2\363\3\0\2\363"+
    "\7\0\2\113\1\215\3\0\2\113\3\0\1\216\5\0"+
    "\3\113\1\365\1\113\10\0\11\113\1\0\4\113\1\0"+
    "\2\113\1\0\1\113\1\0\3\113\60\0\1\366\20\0"+
    "\1\367\1\25\1\131\1\25\1\0\1\25\1\367\1\25"+
    "\1\0\1\25\4\0\2\25\1\0\3\25\1\0\1\25"+
    "\10\0\1\367\2\25\1\367\2\25\1\367\2\25\1\0"+
    "\4\25\1\0\1\367\1\25\1\0\1\25\1\0\1\367"+
    "\2\25\6\0\1\370\1\134\1\135\1\134\1\0\1\134"+
    "\1\370\1\134\1\0\1\134\4\0\2\134\1\0\3\134"+
    "\1\0\1\134\10\0\1\370\2\134\1\370\2\134\1\370"+
    "\2\134\1\0\4\134\1\0\1\370\1\134\1\0\1\134"+
    "\1\0\1\370\2\134\6\0\1\371\1\136\1\137\1\136"+
    "\1\0\1\136\1\371\1\136\1\0\1\136\4\0\2\136"+
    "\1\0\3\136\1\0\1\136\10\0\1\371\2\136\1\371"+
    "\2\136\1\371\2\136\1\0\4\136\1\0\1\371\1\136"+
    "\1\0\1\136\1\0\1\371\2\136\30\0\1\372\123\0"+
    "\1\373\67\0\1\374\66\0\2\375\73\0\1\376\24\0"+
    "\2\334\1\335\1\377\1\0\1\377\2\334\1\0\1\377"+
    "\1\u0100\3\0\2\377\1\0\3\334\1\0\1\334\10\0"+
    "\11\334\1\0\4\334\1\0\2\334\1\0\1\334\1\0"+
    "\3\334\6\0\1\u0101\2\334\1\0\2\334\1\u0101\2\334"+
    "\1\0\4\334\2\0\16\334\1\u0101\2\334\1\u0101\2\334"+
    "\1\u0101\10\334\1\u0101\4\334\1\u0101\7\334\2\0\1\334"+
    "\1\335\3\0\1\334\12\0\3\334\1\0\1\334\10\0"+
    "\11\334\1\0\4\334\1\0\2\334\1\0\1\334\1\0"+
    "\3\334\6\0\1\u0102\1\147\1\150\1\147\1\0\1\147"+
    "\1\u0102\1\147\1\0\1\147\4\0\2\147\1\0\3\147"+
    "\1\251\1\147\10\0\1\u0102\2\147\1\u0102\2\147\1\u0102"+
    "\2\147\1\0\4\147\1\0\1\u0102\1\147\1\0\1\147"+
    "\1\0\1\u0102\2\147\6\0\1\u0103\1\152\1\153\1\152"+
    "\1\154\1\152\1\u0103\27\152\1\u0103\2\152\1\u0103\2\152"+
    "\1\u0103\10\152\1\u0103\4\152\1\u0103\7\152\1\0\1\u0104"+
    "\1\155\1\156\3\155\1\u0104\1\155\1\154\25\155\1\u0104"+
    "\2\155\1\u0104\2\155\1\u0104\10\155\1\u0104\4\155\1\u0104"+
    "\7\155\1\0\1\u0105\1\157\1\160\1\157\1\161\1\157"+
    "\1\u0105\27\157\1\u0105\2\157\1\u0105\2\157\1\u0105\10\157"+
    "\1\u0105\4\157\1\u0105\7\157\1\0\1\u0106\1\162\1\163"+
    "\3\162\1\u0106\1\162\1\161\25\162\1\u0106\2\162\1\u0106"+
    "\2\162\1\u0106\10\162\1\u0106\4\162\1\u0106\7\162\1\0"+
    "\2\u0107\1\u0108\1\344\1\u0109\1\344\2\u0107\1\u010a\1\344"+
    "\1\u010b\3\u0107\2\344\4\u0107\1\0\45\u0107\1\0\1\u010c"+
    "\1\51\1\165\1\51\1\0\1\51\1\u010c\1\51\1\0"+
    "\1\51\4\0\2\51\1\0\3\51\1\0\1\51\10\0"+
    "\1\u010c\2\51\1\u010c\2\51\1\u010c\2\51\1\0\4\51"+
    "\1\0\1\u010c\1\51\1\0\1\51\1\0\1\u010c\2\51"+
    "\6\0\1\u010d\1\55\1\167\1\55\1\0\1\55\1\u010d"+
    "\1\55\1\0\1\55\4\0\2\55\1\0\3\55\1\0"+
    "\1\55\10\0\1\u010d\2\55\1\u010d\2\55\1\u010d\2\55"+
    "\1\0\4\55\1\0\1\u010d\1\55\1\0\1\55\1\0"+
    "\1\u010d\2\55\6\0\1\u010e\1\62\1\171\1\62\1\0"+
    "\1\62\1\u010e\1\62\1\0\1\62\4\0\2\62\1\0"+
    "\3\62\1\0\1\62\10\0\1\u010e\2\62\1\u010e\2\62"+
    "\1\u010e\2\62\1\0\4\62\1\0\1\u010e\1\62\1\0"+
    "\1\62\1\0\1\u010e\2\62\6\0\1\u010f\1\72\1\175"+
    "\1\72\1\0\1\72\1\u010f\1\72\1\0\1\72\4\0"+
    "\2\72\1\0\3\72\1\0\1\72\10\0\1\u010f\2\72"+
    "\1\u010f\2\72\1\u010f\2\72\1\0\4\72\1\0\1\u010f"+
    "\1\72\1\0\1\72\1\0\1\u010f\2\72\6\0\1\u0110"+
    "\1\100\1\177\1\100\1\0\1\100\1\u0110\1\100\1\0"+
    "\1\100\4\0\2\100\1\0\3\100\1\0\1\100\10\0"+
    "\1\u0110\2\100\1\u0110\2\100\1\u0110\2\100\1\0\4\100"+
    "\1\0\1\u0110\1\100\1\0\1\100\1\0\1\u0110\2\100"+
    "\6\0\1\u0111\1\201\1\202\1\201\1\203\1\201\1\u0111"+
    "\27\201\1\u0111\2\201\1\u0111\2\201\1\u0111\10\201\1\u0111"+
    "\4\201\1\u0111\7\201\1\0\1\u0112\1\204\1\205\3\204"+
    "\1\u0112\1\204\1\203\25\204\1\u0112\2\204\1\u0112\2\204"+
    "\1\u0112\10\204\1\u0112\4\204\1\u0112\7\204\1\0\1\u0113"+
    "\1\105\1\206\1\105\1\0\1\105\1\u0113\1\105\1\0"+
    "\1\105\4\0\2\105\1\0\3\105\1\0\1\105\10\0"+
    "\1\u0113\2\105\1\u0113\2\105\1\u0113\2\105\1\0\4\105"+
    "\1\0\1\u0113\1\105\1\0\1\105\1\0\1\u0113\2\105"+
    "\6\0\1\u0114\1\210\1\211\1\210\1\0\1\210\1\u0114"+
    "\1\210\1\0\1\210\4\0\2\210\1\0\3\210\1\0"+
    "\1\210\10\0\1\u0114\2\210\1\u0114\2\210\1\u0114\2\210"+
    "\1\0\4\210\1\0\1\u0114\1\210\1\0\1\210\1\0"+
    "\1\u0114\2\210\6\0\1\u0115\1\305\1\306\1\305\1\0"+
    "\1\305\1\u0115\1\305\1\0\1\305\1\0\1\216\2\0"+
    "\2\305\1\0\3\305\1\0\1\305\10\0\1\u0115\2\305"+
    "\1\u0115\2\305\1\u0115\2\305\1\0\4\305\1\0\1\u0115"+
    "\1\305\1\0\1\305\1\0\1\u0115\2\305\6\0\1\u0116"+
    "\1\113\1\215\1\113\1\0\1\113\1\u0116\1\113\1\0"+
    "\1\113\1\0\1\216\2\0\2\113\1\0\3\113\1\217"+
    "\1\113\10\0\1\u0116\2\113\1\u0116\2\113\1\u0116\2\113"+
    "\1\0\4\113\1\0\1\u0116\1\113\1\0\1\113\1\0"+
    "\1\u0116\2\113\6\0\1\u0117\1\221\1\222\1\221\1\223"+
    "\1\221\1\u0117\27\221\1\u0117\2\221\1\u0117\2\221\1\u0117"+
    "\10\221\1\u0117\4\221\1\u0117\7\221\1\0\1\u0118\1\224"+
    "\1\225\3\224\1\u0118\1\224\1\223\25\224\1\u0118\2\224"+
    "\1\u0118\2\224\1\u0118\10\224\1\u0118\4\224\1\u0118\7\224"+
    "\1\0\1\u0119\1\227\1\230\1\227\1\0\1\227\1\u0119"+
    "\1\227\1\0\1\227\4\0\2\227\1\0\3\227\1\0"+
    "\1\227\10\0\1\u0119\2\227\1\u0119\2\227\1\u0119\2\227"+
    "\1\0\4\227\1\0\1\u0119\1\227\1\0\1\227\1\0"+
    "\1\u0119\2\227\6\0\1\u011a\5\0\1\u011a\1\364\15\0"+
    "\2\u011a\7\0\2\u011a\1\0\2\u011a\1\0\2\u011a\7\0"+
    "\2\u011a\3\0\2\u011a\7\0\1\u011b\5\0\1\u011b\16\0"+
    "\2\u011b\7\0\2\u011b\1\0\2\u011b\1\0\2\u011b\7\0"+
    "\2\u011b\3\0\2\u011b\7\0\2\u011c\1\u011d\1\u011e\1\u011f"+
    "\1\u011e\2\u011c\1\u0120\1\u011e\1\u0121\3\u011c\2\u011e\4\u011c"+
    "\1\0\45\u011c\54\0\1\u0122\17\0\1\u0123\1\25\1\131"+
    "\1\25\1\0\1\25\1\u0123\1\25\1\0\1\25\4\0"+
    "\2\25\1\0\3\25\1\0\1\25\10\0\1\u0123\2\25"+
    "\1\u0123\2\25\1\u0123\2\25\1\0\4\25\1\0\1\u0123"+
    "\1\25\1\0\1\25\1\0\1\u0123\2\25\6\0\1\u0124"+
    "\1\134\1\135\1\134\1\0\1\134\1\u0124\1\134\1\0"+
    "\1\134\4\0\2\134\1\0\3\134\1\0\1\134\10\0"+
    "\1\u0124\2\134\1\u0124\2\134\1\u0124\2\134\1\0\4\134"+
    "\1\0\1\u0124\1\134\1\0\1\134\1\0\1\u0124\2\134"+
    "\6\0\1\u0125\1\136\1\137\1\136\1\0\1\136\1\u0125"+
    "\1\136\1\0\1\136\4\0\2\136\1\0\3\136\1\0"+
    "\1\136\10\0\1\u0125\2\136\1\u0125\2\136\1\u0125\2\136"+
    "\1\0\4\136\1\0\1\u0125\1\136\1\0\1\136\1\0"+
    "\1\u0125\2\136\51\0\1\u0126\51\0\1\u0127\111\0\2\u0128"+
    "\37\0\1\u0129\66\0\1\377\1\0\1\377\3\0\1\377"+
    "\1\u0100\3\0\2\377\53\0\1\u012a\1\334\1\335\1\334"+
    "\1\0\1\334\1\u012a\1\334\1\0\1\334\1\u0100\3\0"+
    "\2\334\1\0\3\334\1\0\1\334\10\0\1\u012a\2\334"+
    "\1\u012a\2\334\1\u012a\2\334\1\0\4\334\1\0\1\u012a"+
    "\1\334\1\0\1\334\1\0\1\u012a\2\334\6\0\1\u012b"+
    "\1\147\1\150\1\147\1\0\1\147\1\u012b\1\147\1\0"+
    "\1\147\4\0\2\147\1\0\3\147\1\251\1\147\10\0"+
    "\1\u012b\2\147\1\u012b\2\147\1\u012b\2\147\1\0\4\147"+
    "\1\0\1\u012b\1\147\1\0\1\147\1\0\1\u012b\2\147"+
    "\6\0\1\u012c\1\152\1\153\1\152\1\154\1\152\1\u012c"+
    "\27\152\1\u012c\2\152\1\u012c\2\152\1\u012c\10\152\1\u012c"+
    "\4\152\1\u012c\7\152\1\0\1\u012d\1\155\1\156\3\155"+
    "\1\u012d\1\155\1\154\25\155\1\u012d\2\155\1\u012d\2\155"+
    "\1\u012d\10\155\1\u012d\4\155\1\u012d\7\155\1\0\1\u012e"+
    "\1\157\1\160\1\157\1\161\1\157\1\u012e\27\157\1\u012e"+
    "\2\157\1\u012e\2\157\1\u012e\10\157\1\u012e\4\157\1\u012e"+
    "\7\157\1\0\1\u012f\1\162\1\163\3\162\1\u012f\1\162"+
    "\1\161\25\162\1\u012f\2\162\1\u012f\2\162\1\u012f\10\162"+
    "\1\u012f\4\162\1\u012f\7\162\1\0\2\u0107\1\u0108\1\u0130"+
    "\1\0\3\u0107\1\0\1\u0130\1\u010b\3\u0107\2\u0130\4\u0107"+
    "\1\0\45\u0107\1\0\1\u0131\1\u0107\1\u0108\1\u0130\2\u0107"+
    "\1\u0131\2\u0107\1\u0130\1\u0132\3\u0107\2\u0130\16\u0107\1\u0131"+
    "\2\u0107\1\u0131\2\u0107\1\u0131\10\u0107\1\u0131\4\u0107\1\u0131"+
    "\7\u0107\1\0\2\u0109\1\u0133\1\0\1\u0130\11\u0109\2\0"+
    "\52\u0109\1\0\2\u010a\1\u0134\1\0\4\u010a\1\u0130\5\u010a"+
    "\2\0\52\u010a\1\0\1\u0135\1\51\1\165\1\51\1\0"+
    "\1\51\1\u0135\1\51\1\0\1\51\4\0\2\51\1\0"+
    "\3\51\1\0\1\51\10\0\1\u0135\2\51\1\u0135\2\51"+
    "\1\u0135\2\51\1\0\4\51\1\0\1\u0135\1\51\1\0"+
    "\1\51\1\0\1\u0135\2\51\6\0\1\u0136\1\55\1\167"+
    "\1\55\1\0\1\55\1\u0136\1\55\1\0\1\55\4\0"+
    "\2\55\1\0\3\55\1\0\1\55\10\0\1\u0136\2\55"+
    "\1\u0136\2\55\1\u0136\2\55\1\0\4\55\1\0\1\u0136"+
    "\1\55\1\0\1\55\1\0\1\u0136\2\55\6\0\1\u0137"+
    "\1\62\1\171\1\62\1\0\1\62\1\u0137\1\62\1\0"+
    "\1\62\4\0\2\62\1\0\3\62\1\0\1\62\10\0"+
    "\1\u0137\2\62\1\u0137\2\62\1\u0137\2\62\1\0\4\62"+
    "\1\0\1\u0137\1\62\1\0\1\62\1\0\1\u0137\2\62"+
    "\6\0\1\u0138\1\72\1\175\1\72\1\0\1\72\1\u0138"+
    "\1\72\1\0\1\72\4\0\2\72\1\0\3\72\1\0"+
    "\1\72\10\0\1\u0138\2\72\1\u0138\2\72\1\u0138\2\72"+
    "\1\0\4\72\1\0\1\u0138\1\72\1\0\1\72\1\0"+
    "\1\u0138\2\72\6\0\1\u0139\1\100\1\177\1\100\1\0"+
    "\1\100\1\u0139\1\100\1\0\1\100\4\0\2\100\1\0"+
    "\3\100\1\0\1\100\10\0\1\u0139\2\100\1\u0139\2\100"+
    "\1\u0139\2\100\1\0\4\100\1\0\1\u0139\1\100\1\0"+
    "\1\100\1\0\1\u0139\2\100\6\0\1\u013a\1\201\1\202"+
    "\1\201\1\203\1\201\1\u013a\27\201\1\u013a\2\201\1\u013a"+
    "\2\201\1\u013a\10\201\1\u013a\4\201\1\u013a\7\201\1\0"+
    "\1\u013b\1\204\1\205\3\204\1\u013b\1\204\1\203\25\204"+
    "\1\u013b\2\204\1\u013b\2\204\1\u013b\10\204\1\u013b\4\204"+
    "\1\u013b\7\204\1\0\1\u013c\1\105\1\206\1\105\1\0"+
    "\1\105\1\u013c\1\105\1\0\1\105\4\0\2\105\1\0"+
    "\3\105\1\0\1\105\10\0\1\u013c\2\105\1\u013c\2\105"+
    "\1\u013c\2\105\1\0\4\105\1\0\1\u013c\1\105\1\0"+
    "\1\105\1\0\1\u013c\2\105\6\0\1\u013d\1\210\1\211"+
    "\1\210\1\0\1\210\1\u013d\1\210\1\0\1\210\4\0"+
    "\2\210\1\0\3\210\1\0\1\210\10\0\1\u013d\2\210"+
    "\1\u013d\2\210\1\u013d\2\210\1\0\4\210\1\0\1\u013d"+
    "\1\210\1\0\1\210\1\0\1\u013d\2\210\6\0\1\u013e"+
    "\1\305\1\306\1\305\1\0\1\305\1\u013e\1\305\1\0"+
    "\1\305\1\0\1\216\2\0\2\305\1\0\3\305\1\0"+
    "\1\305\10\0\1\u013e\2\305\1\u013e\2\305\1\u013e\2\305"+
    "\1\0\4\305\1\0\1\u013e\1\305\1\0\1\305\1\0"+
    "\1\u013e\2\305\6\0\1\u013f\1\113\1\215\1\113\1\0"+
    "\1\113\1\u013f\1\113\1\0\1\113\1\0\1\216\2\0"+
    "\2\113\1\0\3\113\1\217\1\113\10\0\1\u013f\2\113"+
    "\1\u013f\2\113\1\u013f\2\113\1\0\4\113\1\0\1\u013f"+
    "\1\113\1\0\1\113\1\0\1\u013f\2\113\6\0\1\u0140"+
    "\1\221\1\222\1\221\1\223\1\221\1\u0140\27\221\1\u0140"+
    "\2\221\1\u0140\2\221\1\u0140\10\221\1\u0140\4\221\1\u0140"+
    "\7\221\1\0\1\u0141\1\224\1\225\3\224\1\u0141\1\224"+
    "\1\223\25\224\1\u0141\2\224\1\u0141\2\224\1\u0141\10\224"+
    "\1\u0141\4\224\1\u0141\7\224\1\0\1\u0142\1\227\1\230"+
    "\1\227\1\0\1\227\1\u0142\1\227\1\0\1\227\4\0"+
    "\2\227\1\0\3\227\1\0\1\227\10\0\1\u0142\2\227"+
    "\1\u0142\2\227\1\u0142\2\227\1\0\4\227\1\0\1\u0142"+
    "\1\227\1\0\1\227\1\0\1\u0142\2\227\6\0\1\u0143"+
    "\5\0\1\u0143\1\364\15\0\2\u0143\7\0\2\u0143\1\0"+
    "\2\u0143\1\0\2\u0143\7\0\2\u0143\3\0\2\u0143\7\0"+
    "\1\u0144\5\0\1\u0144\16\0\2\u0144\7\0\2\u0144\1\0"+
    "\2\u0144\1\0\2\u0144\7\0\2\u0144\3\0\2\u0144\7\0"+
    "\2\u011c\1\u011d\1\u0145\1\0\3\u011c\1\0\1\u0145\1\u0121"+
    "\3\u011c\2\u0145\4\u011c\1\0\45\u011c\1\0\1\u0146\1\u011c"+
    "\1\u011d\1\u0145\2\u011c\1\u0146\2\u011c\1\u0145\1\u0147\3\u011c"+
    "\2\u0145\16\u011c\1\u0146\2\u011c\1\u0146\2\u011c\1\u0146\10\u011c"+
    "\1\u0146\4\u011c\1\u0146\7\u011c\1\0\2\u011f\1\u0148\1\0"+
    "\1\u0145\11\u011f\2\0\52\u011f\1\0\2\u0120\1\u0149\1\0"+
    "\4\u0120\1\u0145\5\u0120\2\0\52\u0120\23\0\1\u014a\50\0"+
    "\1\u014b\1\25\1\131\1\25\1\0\1\25\1\u014b\1\25"+
    "\1\0\1\25\4\0\2\25\1\0\3\25\1\0\1\25"+
    "\10\0\1\u014b\2\25\1\u014b\2\25\1\u014b\2\25\1\0"+
    "\4\25\1\0\1\u014b\1\25\1\0\1\25\1\0\1\u014b"+
    "\2\25\6\0\1\u014c\1\134\1\135\1\134\1\0\1\134"+
    "\1\u014c\1\134\1\0\1\134\4\0\2\134\1\0\3\134"+
    "\1\0\1\134\10\0\1\u014c\2\134\1\u014c\2\134\1\u014c"+
    "\2\134\1\0\4\134\1\0\1\u014c\1\134\1\0\1\134"+
    "\1\0\1\u014c\2\134\6\0\1\u014d\1\136\1\137\1\136"+
    "\1\0\1\136\1\u014d\1\136\1\0\1\136\4\0\2\136"+
    "\1\0\3\136\1\0\1\136\10\0\1\u014d\2\136\1\u014d"+
    "\2\136\1\u014d\2\136\1\0\4\136\1\0\1\u014d\1\136"+
    "\1\0\1\136\1\0\1\u014d\2\136\52\0\2\u014e\73\0"+
    "\1\u014f\106\0\2\u0150\7\0\1\u0151\1\334\1\335\1\334"+
    "\1\0\1\334\1\u0151\1\334\1\0\1\334\1\u0100\3\0"+
    "\2\334\1\0\3\334\1\0\1\334\10\0\1\u0151\2\334"+
    "\1\u0151\2\334\1\u0151\2\334\1\0\4\334\1\0\1\u0151"+
    "\1\334\1\0\1\334\1\0\1\u0151\2\334\6\0\1\u0152"+
    "\1\147\1\150\1\147\1\0\1\147\1\u0152\1\147\1\0"+
    "\1\147\4\0\2\147\1\0\3\147\1\251\1\147\10\0"+
    "\1\u0152\2\147\1\u0152\2\147\1\u0152\2\147\1\0\4\147"+
    "\1\0\1\u0152\1\147\1\0\1\147\1\0\1\u0152\2\147"+
    "\6\0\1\u0153\1\152\1\153\1\152\1\154\1\152\1\u0153"+
    "\27\152\1\u0153\2\152\1\u0153\2\152\1\u0153\10\152\1\u0153"+
    "\4\152\1\u0153\7\152\1\0\1\u0154\1\155\1\156\3\155"+
    "\1\u0154\1\155\1\154\25\155\1\u0154\2\155\1\u0154\2\155"+
    "\1\u0154\10\155\1\u0154\4\155\1\u0154\7\155\1\0\1\u0155"+
    "\1\157\1\160\1\157\1\161\1\157\1\u0155\27\157\1\u0155"+
    "\2\157\1\u0155\2\157\1\u0155\10\157\1\u0155\4\157\1\u0155"+
    "\7\157\1\0\1\u0156\1\162\1\163\3\162\1\u0156\1\162"+
    "\1\161\25\162\1\u0156\2\162\1\u0156\2\162\1\u0156\10\162"+
    "\1\u0156\4\162\1\u0156\7\162\4\0\1\u0130\1\0\1\u0130"+
    "\3\0\1\u0130\1\u010b\3\0\2\u0130\53\0\1\u0157\1\u0107"+
    "\1\u0108\1\u0107\1\0\1\u0107\1\u0157\1\u0107\1\0\1\u0107"+
    "\1\u010b\11\u0107\1\0\11\u0107\1\u0157\2\u0107\1\u0157\2\u0107"+
    "\1\u0157\10\u0107\1\u0157\4\u0107\1\u0157\7\u0107\1\0\1\u0158"+
    "\1\u0109\1\u0133\1\u0109\1\u0159\1\u0109\1\u0158\10\u0109\1\u015a"+
    "\16\u0109\1\u0158\2\u0109\1\u0158\2\u0109\1\u0158\10\u0109\1\u0158"+
    "\4\u0109\1\u0158\7\u0109\1\0\1\u015b\1\u010a\1\u0134\3\u010a"+
    "\1\u015b\1\u010a\1\u015c\6\u010a\1\u015d\16\u010a\1\u015b\2\u010a"+
    "\1\u015b\2\u010a\1\u015b\10\u010a\1\u015b\4\u010a\1\u015b\7\u010a"+
    "\1\0\1\u015e\1\51\1\165\1\51\1\0\1\51\1\u015e"+
    "\1\51\1\0\1\51\4\0\2\51\1\0\3\51\1\0"+
    "\1\51\10\0\1\u015e\2\51\1\u015e\2\51\1\u015e\2\51"+
    "\1\0\4\51\1\0\1\u015e\1\51\1\0\1\51\1\0"+
    "\1\u015e\2\51\6\0\1\u015f\1\55\1\167\1\55\1\0"+
    "\1\55\1\u015f\1\55\1\0\1\55\4\0\2\55\1\0"+
    "\3\55\1\0\1\55\10\0\1\u015f\2\55\1\u015f\2\55"+
    "\1\u015f\2\55\1\0\4\55\1\0\1\u015f\1\55\1\0"+
    "\1\55\1\0\1\u015f\2\55\6\0\1\u0160\1\62\1\171"+
    "\1\62\1\0\1\62\1\u0160\1\62\1\0\1\62\4\0"+
    "\2\62\1\0\3\62\1\0\1\62\10\0\1\u0160\2\62"+
    "\1\u0160\2\62\1\u0160\2\62\1\0\4\62\1\0\1\u0160"+
    "\1\62\1\0\1\62\1\0\1\u0160\2\62\6\0\1\u0161"+
    "\1\72\1\175\1\72\1\0\1\72\1\u0161\1\72\1\0"+
    "\1\72\4\0\2\72\1\0\3\72\1\0\1\72\10\0"+
    "\1\u0161\2\72\1\u0161\2\72\1\u0161\2\72\1\0\4\72"+
    "\1\0\1\u0161\1\72\1\0\1\72\1\0\1\u0161\2\72"+
    "\6\0\1\u0162\1\100\1\177\1\100\1\0\1\100\1\u0162"+
    "\1\100\1\0\1\100\4\0\2\100\1\0\3\100\1\0"+
    "\1\100\10\0\1\u0162\2\100\1\u0162\2\100\1\u0162\2\100"+
    "\1\0\4\100\1\0\1\u0162\1\100\1\0\1\100\1\0"+
    "\1\u0162\2\100\6\0\1\u0163\1\201\1\202\1\201\1\203"+
    "\1\201\1\u0163\27\201\1\u0163\2\201\1\u0163\2\201\1\u0163"+
    "\10\201\1\u0163\4\201\1\u0163\7\201\1\0\1\u0164\1\204"+
    "\1\205\3\204\1\u0164\1\204\1\203\25\204\1\u0164\2\204"+
    "\1\u0164\2\204\1\u0164\10\204\1\u0164\4\204\1\u0164\7\204"+
    "\1\0\1\u0165\1\105\1\206\1\105\1\0\1\105\1\u0165"+
    "\1\105\1\0\1\105\4\0\2\105\1\0\3\105\1\0"+
    "\1\105\10\0\1\u0165\2\105\1\u0165\2\105\1\u0165\2\105"+
    "\1\0\4\105\1\0\1\u0165\1\105\1\0\1\105\1\0"+
    "\1\u0165\2\105\6\0\1\u0166\1\210\1\211\1\210\1\0"+
    "\1\210\1\u0166\1\210\1\0\1\210\4\0\2\210\1\0"+
    "\3\210\1\0\1\210\10\0\1\u0166\2\210\1\u0166\2\210"+
    "\1\u0166\2\210\1\0\4\210\1\0\1\u0166\1\210\1\0"+
    "\1\210\1\0\1\u0166\2\210\6\0\1\u0167\1\305\1\306"+
    "\1\305\1\0\1\305\1\u0167\1\305\1\0\1\305\1\0"+
    "\1\216\2\0\2\305\1\0\3\305\1\0\1\305\10\0"+
    "\1\u0167\2\305\1\u0167\2\305\1\u0167\2\305\1\0\4\305"+
    "\1\0\1\u0167\1\305\1\0\1\305\1\0\1\u0167\2\305"+
    "\6\0\1\u0168\1\113\1\215\1\113\1\0\1\113\1\u0168"+
    "\1\113\1\0\1\113\1\0\1\216\2\0\2\113\1\0"+
    "\3\113\1\217\1\113\10\0\1\u0168\2\113\1\u0168\2\113"+
    "\1\u0168\2\113\1\0\4\113\1\0\1\u0168\1\113\1\0"+
    "\1\113\1\0\1\u0168\2\113\6\0\1\u0169\1\221\1\222"+
    "\1\221\1\223\1\221\1\u0169\27\221\1\u0169\2\221\1\u0169"+
    "\2\221\1\u0169\10\221\1\u0169\4\221\1\u0169\7\221\1\0"+
    "\1\u016a\1\224\1\225\3\224\1\u016a\1\224\1\223\25\224"+
    "\1\u016a\2\224\1\u016a\2\224\1\u016a\10\224\1\u016a\4\224"+
    "\1\u016a\7\224\1\0\1\u016b\1\227\1\230\1\227\1\0"+
    "\1\227\1\u016b\1\227\1\0\1\227\4\0\2\227\1\0"+
    "\3\227\1\0\1\227\10\0\1\u016b\2\227\1\u016b\2\227"+
    "\1\u016b\2\227\1\0\4\227\1\0\1\u016b\1\227\1\0"+
    "\1\227\1\0\1\u016b\2\227\6\0\1\u016c\5\0\1\u016c"+
    "\1\364\15\0\2\u016c\7\0\2\u016c\1\0\2\u016c\1\0"+
    "\2\u016c\7\0\2\u016c\3\0\2\u016c\7\0\1\u016d\5\0"+
    "\1\u016d\16\0\2\u016d\7\0\2\u016d\1\0\2\u016d\1\0"+
    "\2\u016d\7\0\2\u016d\3\0\2\u016d\12\0\1\u0145\1\0"+
    "\1\u0145\3\0\1\u0145\1\u0121\3\0\2\u0145\53\0\1\u016e"+
    "\1\u011c\1\u011d\1\u011c\1\0\1\u011c\1\u016e\1\u011c\1\0"+
    "\1\u011c\1\u0121\11\u011c\1\0\11\u011c\1\u016e\2\u011c\1\u016e"+
    "\2\u011c\1\u016e\10\u011c\1\u016e\4\u011c\1\u016e\7\u011c\1\0"+
    "\1\u016f\1\u011f\1\u0148\1\u011f\1\u0170\1\u011f\1\u016f\10\u011f"+
    "\1\u0171\16\u011f\1\u016f\2\u011f\1\u016f\2\u011f\1\u016f\10\u011f"+
    "\1\u016f\4\u011f\1\u016f\7\u011f\1\0\1\u0172\1\u0120\1\u0149"+
    "\3\u0120\1\u0172\1\u0120\1\u0173\6\u0120\1\u0174\16\u0120\1\u0172"+
    "\2\u0120\1\u0172\2\u0120\1\u0172\10\u0120\1\u0172\4\u0120\1\u0172"+
    "\7\u0120\47\0\1\u0175\24\0\2\25\1\131\1\25\1\0"+
    "\3\25\1\0\1\25\4\0\2\25\1\0\3\25\1\0"+
    "\1\25\10\0\11\25\1\0\4\25\1\0\2\25\1\0"+
    "\1\25\1\0\3\25\6\0\1\u0176\1\134\1\135\1\134"+
    "\1\0\1\134\1\u0176\1\134\1\0\1\134\4\0\2\134"+
    "\1\0\3\134\1\0\1\134\10\0\1\u0176\2\134\1\u0176"+
    "\2\134\1\u0176\2\134\1\0\4\134\1\0\1\u0176\1\134"+
    "\1\0\1\134\1\0\1\u0176\2\134\6\0\1\u0177\1\136"+
    "\1\137\1\136\1\0\1\136\1\u0177\1\136\1\0\1\136"+
    "\4\0\2\136\1\0\3\136\1\0\1\136\10\0\1\u0177"+
    "\2\136\1\u0177\2\136\1\u0177\2\136\1\0\4\136\1\0"+
    "\1\u0177\1\136\1\0\1\136\1\0\1\u0177\2\136\54\0"+
    "\1\u0178\65\0\2\u0179\30\0\1\u017a\1\334\1\335\1\334"+
    "\1\0\1\334\1\u017a\1\334\1\0\1\334\1\u0100\3\0"+
    "\2\334\1\0\3\334\1\0\1\334\10\0\1\u017a\2\334"+
    "\1\u017a\2\334\1\u017a\2\334\1\0\4\334\1\0\1\u017a"+
    "\1\334\1\0\1\334\1\0\1\u017a\2\334\6\0\1\u017b"+
    "\1\147\1\150\1\147\1\0\1\147\1\u017b\1\147\1\0"+
    "\1\147\4\0\2\147\1\0\3\147\1\251\1\147\10\0"+
    "\1\u017b\2\147\1\u017b\2\147\1\u017b\2\147\1\0\4\147"+
    "\1\0\1\u017b\1\147\1\0\1\147\1\0\1\u017b\2\147"+
    "\6\0\1\u017c\1\152\1\153\1\152\1\154\1\152\1\u017c"+
    "\27\152\1\u017c\2\152\1\u017c\2\152\1\u017c\10\152\1\u017c"+
    "\4\152\1\u017c\7\152\1\0\1\u017d\1\155\1\156\3\155"+
    "\1\u017d\1\155\1\154\25\155\1\u017d\2\155\1\u017d\2\155"+
    "\1\u017d\10\155\1\u017d\4\155\1\u017d\7\155\1\0\1\u017e"+
    "\1\157\1\160\1\157\1\161\1\157\1\u017e\27\157\1\u017e"+
    "\2\157\1\u017e\2\157\1\u017e\10\157\1\u017e\4\157\1\u017e"+
    "\7\157\1\0\1\u017f\1\162\1\163\3\162\1\u017f\1\162"+
    "\1\161\25\162\1\u017f\2\162\1\u017f\2\162\1\u017f\10\162"+
    "\1\u017f\4\162\1\u017f\7\162\1\0\1\u0180\1\u0107\1\u0108"+
    "\1\u0107\1\0\1\u0107\1\u0180\1\u0107\1\0\1\u0107\1\u010b"+
    "\11\u0107\1\0\11\u0107\1\u0180\2\u0107\1\u0180\2\u0107\1\u0180"+
    "\10\u0107\1\u0180\4\u0107\1\u0180\7\u0107\1\0\1\u0181\1\u0109"+
    "\1\u0133\1\u0109\1\u0130\1\u0109\1\u0181\27\u0109\1\u0181\2\u0109"+
    "\1\u0181\2\u0109\1\u0181\10\u0109\1\u0181\4\u0109\1\u0181\7\u0109"+
    "\1\0\2\u0109\1\u0133\2\u0130\1\u0159\3\u0109\1\u0159\1\u0182"+
    "\3\u0109\2\u0130\52\u0109\1\0\2\u0109\1\u0133\1\0\1\u0130"+
    "\12\u0109\1\0\52\u0109\1\0\1\u0183\1\u010a\1\u0134\3\u010a"+
    "\1\u0183\1\u010a\1\u0130\25\u010a\1\u0183\2\u010a\1\u0183\2\u010a"+
    "\1\u0183\10\u010a\1\u0183\4\u010a\1\u0183\7\u010a\1\0\2\u010a"+
    "\1\u0134\1\u0130\1\u010a\1\u015c\2\u010a\1\u0130\1\u015c\1\u0184"+
    "\3\u010a\2\u0130\52\u010a\1\0\2\u010a\1\u0134\1\0\4\u010a"+
    "\1\u0130\6\u010a\1\0\52\u010a\1\0\2\51\1\165\1\51"+
    "\1\0\3\51\1\0\1\51\4\0\2\51\1\0\3\51"+
    "\1\0\1\51\10\0\11\51\1\0\4\51\1\0\2\51"+
    "\1\0\1\51\1\0\3\51\6\0\2\55\1\167\1\55"+
    "\1\0\3\55\1\0\1\55\4\0\2\55\1\0\3\55"+
    "\1\0\1\55\10\0\11\55\1\0\4\55\1\0\2\55"+
    "\1\0\1\55\1\0\3\55\6\0\2\62\1\171\1\62"+
    "\1\0\3\62\1\0\1\62\4\0\2\62\1\0\3\62"+
    "\1\0\1\62\10\0\11\62\1\0\4\62\1\0\2\62"+
    "\1\0\1\62\1\0\3\62\6\0\2\72\1\175\1\72"+
    "\1\0\3\72\1\0\1\72\4\0\2\72\1\0\3\72"+
    "\1\0\1\72\10\0\11\72\1\0\4\72\1\0\2\72"+
    "\1\0\1\72\1\0\3\72\6\0\2\100\1\177\1\100"+
    "\1\0\3\100\1\0\1\100\4\0\2\100\1\0\3\100"+
    "\1\0\1\100\10\0\11\100\1\0\4\100\1\0\2\100"+
    "\1\0\1\100\1\0\3\100\6\0\1\u0185\1\201\1\202"+
    "\1\201\1\203\1\201\1\u0185\27\201\1\u0185\2\201\1\u0185"+
    "\2\201\1\u0185\10\201\1\u0185\4\201\1\u0185\7\201\1\0"+
    "\1\u0186\1\204\1\205\3\204\1\u0186\1\204\1\203\25\204"+
    "\1\u0186\2\204\1\u0186\2\204\1\u0186\10\204\1\u0186\4\204"+
    "\1\u0186\7\204\1\0\2\105\1\206\1\105\1\0\3\105"+
    "\1\0\1\105\4\0\2\105\1\0\3\105\1\0\1\105"+
    "\10\0\11\105\1\0\4\105\1\0\2\105\1\0\1\105"+
    "\1\0\3\105\6\0\1\u0187\1\210\1\211\1\210\1\0"+
    "\1\210\1\u0187\1\210\1\0\1\210\4\0\2\210\1\0"+
    "\3\210\1\0\1\210\10\0\1\u0187\2\210\1\u0187\2\210"+
    "\1\u0187\2\210\1\0\4\210\1\0\1\u0187\1\210\1\0"+
    "\1\210\1\0\1\u0187\2\210\6\0\1\u0188\1\305\1\306"+
    "\1\305\1\0\1\305\1\u0188\1\305\1\0\1\305\1\0"+
    "\1\216\2\0\2\305\1\0\3\305\1\0\1\305\10\0"+
    "\1\u0188\2\305\1\u0188\2\305\1\u0188\2\305\1\0\4\305"+
    "\1\0\1\u0188\1\305\1\0\1\305\1\0\1\u0188\2\305"+
    "\6\0\2\113\1\215\1\113\1\0\3\113\1\0\1\113"+
    "\1\0\1\216\2\0\2\113\1\0\3\113\1\217\1\113"+
    "\10\0\11\113\1\0\4\113\1\0\2\113\1\0\1\113"+
    "\1\0\3\113\6\0\1\u0189\1\221\1\222\1\221\1\223"+
    "\1\221\1\u0189\27\221\1\u0189\2\221\1\u0189\2\221\1\u0189"+
    "\10\221\1\u0189\4\221\1\u0189\7\221\1\0\1\u018a\1\224"+
    "\1\225\3\224\1\u018a\1\224\1\223\25\224\1\u018a\2\224"+
    "\1\u018a\2\224\1\u018a\10\224\1\u018a\4\224\1\u018a\7\224"+
    "\1\0\1\u018b\1\227\1\230\1\227\1\0\1\227\1\u018b"+
    "\1\227\1\0\1\227\4\0\2\227\1\0\3\227\1\0"+
    "\1\227\10\0\1\u018b\2\227\1\u018b\2\227\1\u018b\2\227"+
    "\1\0\4\227\1\0\1\u018b\1\227\1\0\1\227\1\0"+
    "\1\u018b\2\227\6\0\1\u018c\5\0\1\u018c\1\364\15\0"+
    "\2\u018c\7\0\2\u018c\1\0\2\u018c\1\0\2\u018c\7\0"+
    "\2\u018c\3\0\2\u018c\7\0\1\u018d\5\0\1\u018d\16\0"+
    "\2\u018d\7\0\2\u018d\1\0\2\u018d\1\0\2\u018d\7\0"+
    "\2\u018d\3\0\2\u018d\7\0\1\u018e\1\u011c\1\u011d\1\u011c"+
    "\1\0\1\u011c\1\u018e\1\u011c\1\0\1\u011c\1\u0121\11\u011c"+
    "\1\0\11\u011c\1\u018e\2\u011c\1\u018e\2\u011c\1\u018e\10\u011c"+
    "\1\u018e\4\u011c\1\u018e\7\u011c\1\0\1\u018f\1\u011f\1\u0148"+
    "\1\u011f\1\u0145\1\u011f\1\u018f\27\u011f\1\u018f\2\u011f\1\u018f"+
    "\2\u011f\1\u018f\10\u011f\1\u018f\4\u011f\1\u018f\7\u011f\1\0"+
    "\2\u011f\1\u0148\2\u0145\1\u0170\3\u011f\1\u0170\1\u0190\3\u011f"+
    "\2\u0145\52\u011f\1\0\2\u011f\1\u0148\1\0\1\u0145\12\u011f"+
    "\1\0\52\u011f\1\0\1\u0191\1\u0120\1\u0149\3\u0120\1\u0191"+
    "\1\u0120\1\u0145\25\u0120\1\u0191\2\u0120\1\u0191\2\u0120\1\u0191"+
    "\10\u0120\1\u0191\4\u0120\1\u0191\7\u0120\1\0\2\u0120\1\u0149"+
    "\1\u0145\1\u0120\1\u0173\2\u0120\1\u0145\1\u0173\1\u0192\3\u0120"+
    "\2\u0145\52\u0120\1\0\2\u0120\1\u0149\1\0\4\u0120\1\u0145"+
    "\6\u0120\1\0\52\u0120\42\0\2\u0193\30\0\2\134\1\135"+
    "\1\134\1\0\3\134\1\0\1\134\4\0\2\134\1\0"+
    "\3\134\1\0\1\134\10\0\11\134\1\0\4\134\1\0"+
    "\2\134\1\0\1\134\1\0\3\134\6\0\2\136\1\137"+
    "\1\136\1\0\3\136\1\0\1\136\4\0\2\136\1\0"+
    "\3\136\1\0\1\136\10\0\11\136\1\0\4\136\1\0"+
    "\2\136\1\0\1\136\1\0\3\136\44\0\2\u0194\33\0"+
    "\1\u0195\1\334\1\335\1\334\1\0\1\334\1\u0195\1\334"+
    "\1\0\1\334\1\u0100\3\0\2\334\1\0\3\334\1\0"+
    "\1\334\10\0\1\u0195\2\334\1\u0195\2\334\1\u0195\2\334"+
    "\1\0\4\334\1\0\1\u0195\1\334\1\0\1\334\1\0"+
    "\1\u0195\2\334\6\0\2\147\1\150\1\147\1\0\3\147"+
    "\1\0\1\147\4\0\2\147\1\0\3\147\1\251\1\147"+
    "\10\0\11\147\1\0\4\147\1\0\2\147\1\0\1\147"+
    "\1\0\3\147\6\0\2\152\1\153\1\152\1\154\65\152"+
    "\1\0\2\155\1\156\5\155\1\154\61\155\1\0\2\157"+
    "\1\160\1\157\1\161\65\157\1\0\2\162\1\163\5\162"+
    "\1\161\61\162\1\0\1\u0196\1\u0107\1\u0108\1\u0107\1\0"+
    "\1\u0107\1\u0196\1\u0107\1\0\1\u0107\1\u010b\11\u0107\1\0"+
    "\11\u0107\1\u0196\2\u0107\1\u0196\2\u0107\1\u0196\10\u0107\1\u0196"+
    "\4\u0107\1\u0196\7\u0107\1\0\1\u0197\1\u0109\1\u0133\1\u0109"+
    "\1\u0130\1\u0109\1\u0197\27\u0109\1\u0197\2\u0109\1\u0197\2\u0109"+
    "\1\u0197\10\u0109\1\u0197\4\u0109\1\u0197\7\u0109\1\0\1\u0198"+
    "\1\u010a\1\u0134\3\u010a\1\u0198\1\u010a\1\u0130\25\u010a\1\u0198"+
    "\2\u010a\1\u0198\2\u010a\1\u0198\10\u010a\1\u0198\4\u010a\1\u0198"+
    "\7\u010a\1\0\2\201\1\202\1\201\1\203\65\201\1\0"+
    "\2\204\1\205\5\204\1\203\61\204\1\0\2\210\1\211"+
    "\1\210\1\0\3\210\1\0\1\210\4\0\2\210\1\0"+
    "\3\210\1\0\1\210\10\0\11\210\1\0\4\210\1\0"+
    "\2\210\1\0\1\210\1\0\3\210\6\0\1\u0199\1\305"+
    "\1\306\1\305\1\0\1\305\1\u0199\1\305\1\0\1\305"+
    "\1\0\1\216\2\0\2\305\1\0\3\305\1\0\1\305"+
    "\10\0\1\u0199\2\305\1\u0199\2\305\1\u0199\2\305\1\0"+
    "\4\305\1\0\1\u0199\1\305\1\0\1\305\1\0\1\u0199"+
    "\2\305\6\0\2\221\1\222\1\221\1\223\65\221\1\0"+
    "\2\224\1\225\5\224\1\223\61\224\1\0\2\227\1\230"+
    "\1\227\1\0\3\227\1\0\1\227\4\0\2\227\1\0"+
    "\3\227\1\0\1\227\10\0\11\227\1\0\4\227\1\0"+
    "\2\227\1\0\1\227\1\0\3\227\15\0\1\364\63\0"+
    "\1\u019a\5\0\1\u019a\16\0\2\u019a\7\0\2\u019a\1\0"+
    "\2\u019a\1\0\2\u019a\7\0\2\u019a\3\0\2\u019a\7\0"+
    "\1\u019b\1\u011c\1\u011d\1\u011c\1\0\1\u011c\1\u019b\1\u011c"+
    "\1\0\1\u011c\1\u0121\11\u011c\1\0\11\u011c\1\u019b\2\u011c"+
    "\1\u019b\2\u011c\1\u019b\10\u011c\1\u019b\4\u011c\1\u019b\7\u011c"+
    "\1\0\1\u019c\1\u011f\1\u0148\1\u011f\1\u0145\1\u011f\1\u019c"+
    "\27\u011f\1\u019c\2\u011f\1\u019c\2\u011f\1\u019c\10\u011f\1\u019c"+
    "\4\u011f\1\u019c\7\u011f\1\0\1\u019d\1\u0120\1\u0149\3\u0120"+
    "\1\u019d\1\u0120\1\u0145\25\u0120\1\u019d\2\u0120\1\u019d\2\u0120"+
    "\1\u019d\10\u0120\1\u019d\4\u0120\1\u019d\7\u0120\65\0\1\u019e"+
    "\52\0\2\u019f\25\0\1\u01a0\1\334\1\335\1\334\1\0"+
    "\1\334\1\u01a0\1\334\1\0\1\334\1\u0100\3\0\2\334"+
    "\1\0\3\334\1\0\1\334\10\0\1\u01a0\2\334\1\u01a0"+
    "\2\334\1\u01a0\2\334\1\0\4\334\1\0\1\u01a0\1\334"+
    "\1\0\1\334\1\0\1\u01a0\2\334\6\0\1\u01a1\1\u0107"+
    "\1\u0108\1\u0107\1\0\1\u0107\1\u01a1\1\u0107\1\0\1\u0107"+
    "\1\u010b\11\u0107\1\0\11\u0107\1\u01a1\2\u0107\1\u01a1\2\u0107"+
    "\1\u01a1\10\u0107\1\u01a1\4\u0107\1\u01a1\7\u0107\1\0\1\u01a2"+
    "\1\u0109\1\u0133\1\u0109\1\u0130\1\u0109\1\u01a2\27\u0109\1\u01a2"+
    "\2\u0109\1\u01a2\2\u0109\1\u01a2\10\u0109\1\u01a2\4\u0109\1\u01a2"+
    "\7\u0109\1\0\1\u01a3\1\u010a\1\u0134\3\u010a\1\u01a3\1\u010a"+
    "\1\u0130\25\u010a\1\u01a3\2\u010a\1\u01a3\2\u010a\1\u01a3\10\u010a"+
    "\1\u01a3\4\u010a\1\u01a3\7\u010a\1\0\2\305\1\306\1\305"+
    "\1\0\3\305\1\0\1\305\1\0\1\216\2\0\2\305"+
    "\1\0\3\305\1\0\1\305\10\0\11\305\1\0\4\305"+
    "\1\0\2\305\1\0\1\305\1\0\3\305\6\0\1\u01a4"+
    "\5\0\1\u01a4\16\0\2\u01a4\7\0\2\u01a4\1\0\2\u01a4"+
    "\1\0\2\u01a4\7\0\2\u01a4\3\0\2\u01a4\7\0\1\u01a5"+
    "\1\u011c\1\u011d\1\u011c\1\0\1\u011c\1\u01a5\1\u011c\1\0"+
    "\1\u011c\1\u0121\11\u011c\1\0\11\u011c\1\u01a5\2\u011c\1\u01a5"+
    "\2\u011c\1\u01a5\10\u011c\1\u01a5\4\u011c\1\u01a5\7\u011c\1\0"+
    "\1\u01a6\1\u011f\1\u0148\1\u011f\1\u0145\1\u011f\1\u01a6\27\u011f"+
    "\1\u01a6\2\u011f\1\u01a6\2\u011f\1\u01a6\10\u011f\1\u01a6\4\u011f"+
    "\1\u01a6\7\u011f\1\0\1\u01a7\1\u0120\1\u0149\3\u0120\1\u01a7"+
    "\1\u0120\1\u0145\25\u0120\1\u01a7\2\u0120\1\u01a7\2\u0120\1\u01a7"+
    "\10\u0120\1\u01a7\4\u0120\1\u01a7\7\u0120\47\0\1\u01a8\24\0"+
    "\2\334\1\335\1\334\1\0\3\334\1\0\1\334\1\u0100"+
    "\3\0\2\334\1\0\3\334\1\0\1\334\10\0\11\334"+
    "\1\0\4\334\1\0\2\334\1\0\1\334\1\0\3\334"+
    "\6\0\1\u01a9\1\u0107\1\u0108\1\u0107\1\0\1\u0107\1\u01a9"+
    "\1\u0107\1\0\1\u0107\1\u010b\11\u0107\1\0\11\u0107\1\u01a9"+
    "\2\u0107\1\u01a9\2\u0107\1\u01a9\10\u0107\1\u01a9\4\u0107\1\u01a9"+
    "\7\u0107\1\0\1\u01aa\1\u0109\1\u0133\1\u0109\1\u0130\1\u0109"+
    "\1\u01aa\27\u0109\1\u01aa\2\u0109\1\u01aa\2\u0109\1\u01aa\10\u0109"+
    "\1\u01aa\4\u0109\1\u01aa\7\u0109\1\0\1\u01ab\1\u010a\1\u0134"+
    "\3\u010a\1\u01ab\1\u010a\1\u0130\25\u010a\1\u01ab\2\u010a\1\u01ab"+
    "\2\u010a\1\u01ab\10\u010a\1\u01ab\4\u010a\1\u01ab\7\u010a\1\0"+
    "\1\u01ac\1\u011c\1\u011d\1\u011c\1\0\1\u011c\1\u01ac\1\u011c"+
    "\1\0\1\u011c\1\u0121\11\u011c\1\0\11\u011c\1\u01ac\2\u011c"+
    "\1\u01ac\2\u011c\1\u01ac\10\u011c\1\u01ac\4\u011c\1\u01ac\7\u011c"+
    "\1\0\1\u01ad\1\u011f\1\u0148\1\u011f\1\u0145\1\u011f\1\u01ad"+
    "\27\u011f\1\u01ad\2\u011f\1\u01ad\2\u011f\1\u01ad\10\u011f\1\u01ad"+
    "\4\u011f\1\u01ad\7\u011f\1\0\1\u01ae\1\u0120\1\u0149\3\u0120"+
    "\1\u01ae\1\u0120\1\u0145\25\u0120\1\u01ae\2\u0120\1\u01ae\2\u0120"+
    "\1\u01ae\10\u0120\1\u01ae\4\u0120\1\u01ae\7\u0120\1\0\2\u0107"+
    "\1\u0108\1\u0107\1\0\3\u0107\1\0\1\u0107\1\u010b\11\u0107"+
    "\1\0\45\u0107\1\0\1\u01af\1\u0109\1\u0133\1\u0109\1\u0130"+
    "\1\u0109\1\u01af\27\u0109\1\u01af\2\u0109\1\u01af\2\u0109\1\u01af"+
    "\10\u0109\1\u01af\4\u0109\1\u01af\7\u0109\1\0\1\u01b0\1\u010a"+
    "\1\u0134\3\u010a\1\u01b0\1\u010a\1\u0130\25\u010a\1\u01b0\2\u010a"+
    "\1\u01b0\2\u010a\1\u01b0\10\u010a\1\u01b0\4\u010a\1\u01b0\7\u010a"+
    "\1\0\2\u011c\1\u011d\1\u011c\1\0\3\u011c\1\0\1\u011c"+
    "\1\u0121\11\u011c\1\0\45\u011c\1\0\1\u01b1\1\u011f\1\u0148"+
    "\1\u011f\1\u0145\1\u011f\1\u01b1\27\u011f\1\u01b1\2\u011f\1\u01b1"+
    "\2\u011f\1\u01b1\10\u011f\1\u01b1\4\u011f\1\u01b1\7\u011f\1\0"+
    "\1\u01b2\1\u0120\1\u0149\3\u0120\1\u01b2\1\u0120\1\u0145\25\u0120"+
    "\1\u01b2\2\u0120\1\u01b2\2\u0120\1\u01b2\10\u0120\1\u01b2\4\u0120"+
    "\1\u01b2\7\u0120\1\0\2\u0109\1\u0133\1\u0109\1\u0130\65\u0109"+
    "\1\0\2\u010a\1\u0134\5\u010a\1\u0130\61\u010a\1\0\2\u011f"+
    "\1\u0148\1\u011f\1\u0145\65\u011f\1\0\2\u0120\1\u0149\5\u0120"+
    "\1\u0145\61\u0120";

  private static int [] zzUnpackTrans() {
    int [] result = new int[21240];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\23\0\1\11\7\1\1\11\1\1\1\11\2\1\1\11"+
    "\3\1\1\11\6\1\1\11\3\1\2\11\3\1\1\11"+
    "\2\1\2\11\3\1\1\11\1\1\1\11\10\1\2\11"+
    "\6\1\1\11\6\1\1\11\1\1\1\0\1\1\1\0"+
    "\1\1\1\0\1\1\10\0\1\1\4\0\1\11\4\0"+
    "\1\11\4\0\1\1\1\0\1\1\1\0\1\1\1\0"+
    "\1\11\1\0\1\1\1\0\1\1\2\0\1\11\3\0"+
    "\2\1\3\0\1\11\1\0\1\1\1\11\1\1\2\0"+
    "\1\11\2\0\2\1\2\0\1\1\2\0\1\11\1\1"+
    "\1\11\2\1\10\0\1\1\1\0\1\1\2\0\1\1"+
    "\2\0\1\1\2\0\1\1\2\0\5\1\1\0\1\1"+
    "\2\0\1\1\1\0\3\1\1\0\1\1\1\0\1\1"+
    "\2\0\1\1\1\0\3\1\1\0\3\1\2\11\10\0"+
    "\1\1\5\0\5\1\2\0\4\1\2\0\2\1\1\0"+
    "\1\1\1\0\3\1\3\0\1\11\2\0\1\11\1\0"+
    "\1\1\10\0\1\11\5\1\2\0\4\1\2\0\3\1"+
    "\5\0\1\11\1\0\3\1\2\0\1\11\2\0\1\1"+
    "\6\0\1\1\2\0\5\1\2\0\4\1\2\0\3\1"+
    "\2\0\1\1\3\0\3\1\1\0\1\11\2\0\1\1"+
    "\13\0\5\1\2\0\4\1\2\0\3\1\10\0\2\1"+
    "\1\11\2\0\1\1\6\0\1\1\1\0\1\1\2\0"+
    "\2\1\2\0\3\1\2\0\1\1\1\0\1\1\6\0"+
    "\2\1\4\0\1\11\4\0\1\11\3\0\1\11\12\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[434];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
	private final static String UNDEFINED = "undefined";
	private String fBufferedContext = null;
	private int fBufferedStart;
//	private int fBufferedTextLength;
	private int fBufferedLength;
//	private StringBuffer fBufferedText = null;
	private CSSTextRegionFactory fRegionFactory = CSSTextRegionFactory.getInstance();
	private int fInitialState = YYINITIAL;
	public final static int BUFFER_SIZE_NORMAL = 16384;
	public final static int BUFFER_SIZE_SMALL = 256;
	private int fInitialBufferSize = BUFFER_SIZE_NORMAL;

	public void setInitialState(int state) {
		fInitialState = state;
	}
	
	public void setInitialBufferSize(int size) {
		fInitialBufferSize = size;
	}

	/* user method */
  	public final ITextRegion getNextToken() throws IOException {
		String context;
		String nextTokenType;
		boolean spaceFollows;
//		StringBuffer text;
		int start;
		int textLength;
		int length;
		if (fBufferedContext != null) {
			context = fBufferedContext;
//			text = fBufferedText;
			start = fBufferedStart;
			textLength = length = fBufferedLength;

			fBufferedContext = null;
		} else {
			context = primGetNextToken();
//			text = new StringBuffer(yytext());
			start = yychar;
			textLength = length = yylength();
		}

		if (context != null) {
			if (context == UNDEFINED) {
				// undef -> concatenate undef's
				nextTokenType = primGetNextToken();
				while (nextTokenType == UNDEFINED) {
//					text.append(yytext());
					textLength += yylength();
					length = textLength;
					nextTokenType = primGetNextToken();
				}
				fBufferedContext = nextTokenType;
//				fBufferedText = new StringBuffer(yytext());
				fBufferedStart = yychar;
				fBufferedLength = yylength();
			} else {
				nextTokenType = null;
				spaceFollows = false;
				if (CSSRegionUtil.isDeclarationValueType(context)) { // declaration value can contain VALUE_S
					nextTokenType = primGetNextToken();
					spaceFollows = (nextTokenType == CSS_DECLARATION_VALUE_S);
				} else if (canContainSpace(context)) {
					nextTokenType = primGetNextToken();
					spaceFollows = (nextTokenType == CSS_S);
				}
				if (nextTokenType != null) { // nextToken is retrieved
					if (spaceFollows) {
						// next is space -> append
//						text.append(yytext());
						length += yylength();
					} else {
						// next is NOT space -> push this for next time, return itself
						fBufferedContext = nextTokenType;
//						fBufferedText = new StringBuffer(yytext());
						fBufferedStart = yychar;
						fBufferedLength = yylength();
					}
				}
			}
		}

		if (context != null) {
			if (context == UNDEFINED) {
				context = CSS_UNKNOWN;
			}
			return fRegionFactory.createRegion(context, start, textLength, length);
		} else {
			return null;
		}
  	}

	/* user method */
	/* for standalone use */
  	public final List parseText() throws IOException {
  		List tokens = new ArrayList();

  		CSSTextToken token;
		for (String kind = primGetNextToken(); kind != null; kind = primGetNextToken()) {
			token = new CSSTextToken();
			token.kind = kind;  				
			token.start = yychar;
			token.length = yylength();
			token.image = yytext();
			tokens.add(token);
		}

  		return tokens;
  	}
  	
  	/* user method */
  	private boolean canContainSpace(String type) {
  		if (type == CSS_DELIMITER || type == CSS_RBRACE || type == CSS_DECLARATION_DELIMITER) {
  			return false;
  		} else {
  			return true;
  		}
  	}

	/* user method */
	public final int getOffset() {
		return yychar;
	}
	
	/* user method */
	public final boolean isEOF() {
		return zzAtEOF;
	}

	/* user method */
	public void reset(char[] charArray) {
		reset(new CharArrayReader(charArray), 0);
	}

	/* user method */
	public final void reset(java.io.Reader in, int newOffset) {
		/** the input device */
		zzReader = in;

		/** the current state of the DFA */
		zzState = 0;

		/** the current lexical state */
		zzLexicalState = fInitialState; //YYINITIAL;

		/** this buffer contains the current text to be matched and is
			the source of the yytext() string */
		if (zzBuffer.length != fInitialBufferSize) {
			zzBuffer = new char[fInitialBufferSize];
		}
		java.util.Arrays.fill(zzBuffer, (char)0);

		/** the textposition at the last accepting state */
		zzMarkedPos = 0;

		/** the textposition at the last state to be included in yytext */
//		yy_pushbackPos = 0;

		/** the current text position in the buffer */
		zzCurrentPos = 0;

		/** startRead marks the beginning of the yytext() string in the buffer */
		zzStartRead = 0;

		/** endRead marks the last character in the buffer, that has been read
			from input */
		zzEndRead = 0;

		/** number of newlines encountered up to the start of the matched text */
		yyline = 0;

		/** the number of characters up to the start of the matched text */
		yychar = 0;

		/**
		 * the number of characters from the last newline up to the start of the 
		 * matched text
		 */
//		yycolumn = 0; 

		/** 
		 * yy_atBOL == true <=> the scanner is currently at the beginning of a line
		 */
//		yy_atBOL = false;
		
		/** zzAtEOF == true <=> the scanner has returned a value for EOF */
		zzAtEOF = false;

		/* user variables */
		//		fUndefined.delete(0, fUndefined.length());
	}

	/* user method */
	public CSSTokenizer() {
		super();
	}

	/**
	 * Added to workaround stricter compilation options without creating
	 * an alternate skeleton file
	 */
	void _usePrivates() {
		System.out.print(yycolumn);
		System.out.print(yyline);
		System.out.print(Boolean.toString(zzAtBOL));
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public CSSTokenizer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public CSSTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 170) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 32: 
          { yybegin(ST_IMPORT_MEDIUM); return CSS_STRING;
          }
        case 52: break;
        case 34: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_DIMENSION;
          }
        case 53: break;
        case 39: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { return CSS_DECLARATION_VALUE_S;
          }
        case 54: break;
        case 36: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_FUNCTION;
          }
        case 55: break;
        case 20: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ATTRIBUTE_END;
          }
        case 56: break;
        case 1: 
          { return UNDEFINED;
          }
        case 57: break;
        case 9: 
          { yybegin(ST_IMPORT_DELIMITER); return CSS_MEDIUM;
          }
        case 58: break;
        case 37: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_STRING;
          }
        case 59: break;
        case 29: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_CLASS;
          }
        case 60: break;
        case 13: 
          { yybegin(YYINITIAL); return CSS_LBRACE;
          }
        case 61: break;
        case 4: 
          { yybegin(YYINITIAL); return CSS_RBRACE;
          }
        case 62: break;
        case 11: 
          { yybegin(ST_MEDIA_DELIMITER); return CSS_MEDIUM;
          }
        case 63: break;
        case 10: 
          { yybegin(ST_IMPORT_MEDIUM); return CSS_MEDIA_SEPARATOR;
          }
        case 64: break;
        case 24: 
          { yybegin(ST_DECLARATION_PRE_VALUE); return CSS_DECLARATION_SEPARATOR;
          }
        case 65: break;
        case 50: 
          { yybegin(ST_FONT_FACE_DELIMITER); return CSS_FONT_FACE;
          }
        case 66: break;
        case 49: 
          { yybegin(ST_CHARSET_NAME); return CSS_CHARSET;
          }
        case 67: break;
        case 45: 
          { yybegin(ST_IMPORT_MEDIUM); return CSS_URI;
          }
        case 68: break;
        case 19: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_VALUE); return CSS_SELECTOR_ATTRIBUTE_OPERATOR;
          }
        case 69: break;
        case 40: 
          { return CSS_CDC;
          }
        case 70: break;
        case 15: 
          { yybegin(ST_DECLARATION); return CSS_LBRACE;
          }
        case 71: break;
        case 5: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_UNIVERSAL;
          }
        case 72: break;
        case 7: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_NAME); return CSS_SELECTOR_ATTRIBUTE_START;
          }
        case 73: break;
        case 42: 
          { return CSS_CDO;
          }
        case 74: break;
        case 8: 
          { yybegin(YYINITIAL); return CSS_DELIMITER;
          }
        case 75: break;
        case 18: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_OPERATOR); return CSS_SELECTOR_ATTRIBUTE_NAME;
          }
        case 76: break;
        case 38: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_HASH;
          }
        case 77: break;
        case 44: 
          { yybegin(ST_PAGE_PSEUDO_PAGE); return CSS_PAGE;
          }
        case 78: break;
        case 2: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ELEMENT_NAME;
          }
        case 79: break;
        case 31: 
          { yybegin(ST_CHARSET_DELIMITER); return CSS_STRING;
          }
        case 80: break;
        case 25: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_NUMBER;
          }
        case 81: break;
        case 16: 
          { yybegin(ST_SELECTOR); return CSS_SELECTOR_COMBINATOR;
          }
        case 82: break;
        case 33: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { yybegin(ST_SELECTOR); return CSS_SELECTOR_COMBINATOR;
          }
        case 83: break;
        case 41: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_UNICODE_RANGE;
          }
        case 84: break;
        case 35: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_PERCENTAGE;
          }
        case 85: break;
        case 12: 
          { yybegin(ST_MEDIA_MEDIUM); return CSS_MEDIA_SEPARATOR;
          }
        case 86: break;
        case 26: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_IDENT;
          }
        case 87: break;
        case 14: 
          { yybegin(ST_PAGE_DELIMITER); return CSS_PAGE_SELECTOR;
          }
        case 88: break;
        case 28: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_OPERATOR;
          }
        case 89: break;
        case 43: 
          { return CSS_COMMENT;
          }
        case 90: break;
        case 51: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_IMPORTANT;
          }
        case 91: break;
        case 21: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_END); return CSS_SELECTOR_ATTRIBUTE_VALUE;
          }
        case 92: break;
        case 17: 
          { yybegin(ST_SELECTOR); return CSS_SELECTOR_SEPARATOR;
          }
        case 93: break;
        case 3: 
          { return CSS_S;
          }
        case 94: break;
        case 30: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ID;
          }
        case 95: break;
        case 48: 
          { yybegin(ST_IMPORT_URI); return CSS_IMPORT;
          }
        case 96: break;
        case 27: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_PARENTHESIS_CLOSE;
          }
        case 97: break;
        case 47: 
          { yybegin(ST_MEDIA_MEDIUM); return CSS_MEDIA;
          }
        case 98: break;
        case 23: 
          { yybegin(ST_DECLARATION); return CSS_DECLARATION_DELIMITER;
          }
        case 99: break;
        case 22: 
          { yybegin(ST_DECLARATION_SEPARATOR); return CSS_DECLARATION_PROPERTY;
          }
        case 100: break;
        case 6: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_PSEUDO;
          }
        case 101: break;
        case 46: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_URI;
          }
        case 102: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            return null;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
