/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.jsp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.AbstractContextSymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.IAdditionalContextSymbolInfo;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.jsp.AdditionalContextSymbolInfo;
import org.eclipse.jst.jsf.designtime.internal.jsp.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPModelProcessor {
    public static final boolean FORCE_REFRESH = true;
    public static final Runnable NO_RUN_AFTER = null;
    public static final Runnable RUN_ON_CURRENT_THREAD = new Runnable(){

        public void run() {
        }
    };
    private static final boolean DISABLE_WKSPACE_CHANGE_REFRESH = System.getProperty("org.eclipse.jst.jsf.jspmodelprocessor.disable.wkspace.change.refresh") != null;
    private static final Map<IFile, JSPModelProcessor> RESOURCE_MAP = new HashMap<IFile, JSPModelProcessor>();
    private static final Lock CRITICAL_SECTION = new ReentrantLock();
    private static LifecycleListener LIFECYCLE_LISTENER;
    private final IFile _file;
    private LifecycleListener _lifecycleListener;
    private IResourceLifecycleListener _resListener;
    private volatile boolean _isDisposed;
    private Map<Object, ISymbol> _requestMap;
    private Map<Object, ISymbol> _sessionMap;
    private Map<Object, ISymbol> _applicationMap;
    private Map<Object, ISymbol> _noneMap;
    private final CountingMutex _lastModificationStampMonitor = new CountingMutex();

    public static JSPModelProcessor get(IFile file) throws CoreException {
        CRITICAL_SECTION.lock();
        try {
            if (!file.isAccessible()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", "File must be accessible"));
            }
            JSPModelProcessor processor = RESOURCE_MAP.get(file);
            if (processor == null) {
                if (LIFECYCLE_LISTENER == null) {
                    LIFECYCLE_LISTENER = new LifecycleListener((IResource)file);
                } else {
                    LIFECYCLE_LISTENER.addResource((IResource)file);
                }
                processor = new JSPModelProcessor(file, LIFECYCLE_LISTENER);
                RESOURCE_MAP.put(file, processor);
            }
            JSPModelProcessor jSPModelProcessor = processor;
            return jSPModelProcessor;
        }
        finally {
            CRITICAL_SECTION.unlock();
        }
    }

    private static void dispose(IFile file) {
        CRITICAL_SECTION.lock();
        try {
            JSPModelProcessor processor = RESOURCE_MAP.get(file);
            if (processor != null) {
                RESOURCE_MAP.remove(file);
                if (!processor.isDisposed()) {
                    processor.dispose();
                    LIFECYCLE_LISTENER.removeResource((IResource)file);
                }
            }
            if (RESOURCE_MAP.isEmpty()) {
                LIFECYCLE_LISTENER.dispose();
                LIFECYCLE_LISTENER = null;
            }
        }
        finally {
            CRITICAL_SECTION.unlock();
        }
    }

    private JSPModelProcessor(IFile file, LifecycleListener lifecycleListener) {
        this._file = file;
        this._lifecycleListener = lifecycleListener;
        this._resListener = new IResourceLifecycleListener(){

            public IResourceLifecycleListener.EventResult acceptEvent(ResourceLifecycleEvent event) {
                IResourceLifecycleListener.EventResult result = IResourceLifecycleListener.EventResult.getDefaultEventResult();
                if (!JSPModelProcessor.this._file.equals((Object)event.getAffectedResource())) {
                    return result;
                }
                if (event.getEventType() == ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE) {
                    JSPModelProcessor.dispose(JSPModelProcessor.this._file);
                } else if (event.getEventType() == ResourceLifecycleEvent.EventType.RESOURCE_CHANGED && event.getReasonType() == ResourceLifecycleEvent.ReasonType.RESOURCE_CHANGED_CONTENTS && !DISABLE_WKSPACE_CHANGE_REFRESH) {
                    JSPModelProcessor.this.refresh(false, NO_RUN_AFTER);
                }
                return result;
            }
        };
        lifecycleListener.addListener(this._resListener);
    }

    private IDOMModel getModelForFile(IFile file) throws CoreException, IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.getModelForRead(file);
        if (model instanceof IDOMModel) {
            return (IDOMModel)model;
        }
        if (model != null) {
            model.releaseFromRead();
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.blah", 0, "model not of expected type", new Throwable()));
    }

    private void dispose() {
        if (!this._isDisposed) {
            this._lifecycleListener.removeListener(this._resListener);
            this._resListener = null;
            this._lifecycleListener = null;
            if (this._requestMap != null) {
                this._requestMap.clear();
                this._requestMap = null;
            }
            if (this._sessionMap != null) {
                this._sessionMap.clear();
                this._sessionMap = null;
            }
            if (this._applicationMap != null) {
                this._applicationMap.clear();
                this._applicationMap = null;
            }
            if (this._noneMap != null) {
                this._noneMap.clear();
                this._noneMap = null;
            }
            this._isDisposed = true;
        }
    }

    public boolean isDisposed() {
        return this._isDisposed;
    }

    public boolean isModelDirty() {
        long currentModificationStamp = this._file.getModificationStamp();
        return this._lastModificationStampMonitor.hasChanged(currentModificationStamp);
    }

    public void refresh(boolean forceRefresh, Runnable runAfter) {
        if (this.isDisposed()) {
            throw new IllegalStateException("Processor is disposed for file: " + this._file.toString());
        }
        if (runAfter == RUN_ON_CURRENT_THREAD) {
            try {
                this.runOnCurrentThread(forceRefresh);
            }
            catch (CoreException e) {
                JSFCorePlugin.log((Exception)((Object)e), "Running JSP model processor");
            }
            catch (OperationCanceledException operationCanceledException) {}
        } else {
            this.runOnWorkspaceJob(forceRefresh, runAfter);
        }
    }

    private void runOnWorkspaceJob(final boolean forceRefresh, final Runnable runAfter) {
        WorkspaceJob refreshJob = new WorkspaceJob(NLS.bind((String)Messages.getString("JSPModelProcessor.0"), (Object)this._file)){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                RefreshRunnable runnable = new RefreshRunnable(forceRefresh);
                runnable.run(monitor);
                return Status.OK_STATUS;
            }
        };
        refreshJob.setSystem(true);
        refreshJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        if (runAfter != null) {
            refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    runAfter.run();
                }
            });
        }
        refreshJob.schedule();
    }

    private void runOnCurrentThread(boolean forceRefresh) throws CoreException, OperationCanceledException {
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new RefreshRunnable(forceRefresh), (ISchedulingRule)this._file, 0, null);
    }

    private void refreshInternal(IDOMModel model) {
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)model.getStructuredDocument(), -1);
        ITaglibContextResolver taglibResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
        IDOMDocument document = model.getDocument();
        this.getApplicationMap().clear();
        this.getRequestMap().clear();
        this.getSessionMap().clear();
        this.recurseChildNodes(model, document.getChildNodes(), taglibResolver);
    }

    private void recurseChildNodes(IDOMModel model, NodeList nodes, ITaglibContextResolver taglibResolver) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node child = nodes.item(i);
            this.processAttributes(model, child, taglibResolver);
            this.recurseChildNodes(model, child.getChildNodes(), taglibResolver);
            ++i;
        }
    }

    private void processAttributes(IDOMModel model, Node node, ITaglibContextResolver taglibResolver) {
        if (taglibResolver.hasTag(node)) {
            String uri = taglibResolver.getTagURIForNodeName(node);
            String elementName = node.getLocalName();
            int i = 0;
            while (i < node.getAttributes().getLength()) {
                Node attribute = node.getAttributes().item(i);
                this.processSymbolContrib(model, uri, elementName, attribute);
                this.processSetsLocale(uri, elementName, attribute);
                ++i;
            }
        }
    }

    private void processSymbolContrib(IDOMModel model, String uri, String elementName, Node attribute) {
        SymbolContribAggregator aggregator = SymbolContribAggregator.create(this._file.getProject(), uri, elementName, attribute.getLocalName());
        if (aggregator != null) {
            AbstractContextSymbolFactory factory = aggregator.getFactory();
            String symbolName = attribute.getNodeValue();
            if (factory != null) {
                ArrayList problems;
                ISymbol symbol;
                IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)model.getStructuredDocument(), attribute);
                if (factory.supports((IAdaptable)context) && (symbol = factory.create(symbolName, 1, (IAdaptable)context, problems = new ArrayList(), (IAdditionalContextSymbolInfo)new AdditionalContextSymbolInfo(aggregator.getStaticType(), aggregator.getValueExpressionAttr()))) != null) {
                    this.updateMap(symbol, aggregator.getScope());
                }
            } else {
                IComponentSymbol componentSymbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
                componentSymbol.setName(symbolName);
                this.updateMap((ISymbol)componentSymbol, aggregator.getScope());
            }
        }
    }

    private void processSetsLocale(String uri, String elementName, Node attribute) {
        DTFacesContext facesContext;
        DesignTimeApplicationManager dtAppMgr;
        LocaleSetAggregator aggregator = LocaleSetAggregator.create(this._file.getProject(), uri, elementName, attribute.getLocalName());
        if (aggregator != null && (dtAppMgr = DesignTimeApplicationManager.getInstance(this._file.getProject())) != null && (facesContext = dtAppMgr.getFacesContext(this._file)) != null) {
            facesContext.setLocaleString(attribute.getNodeValue());
        }
    }

    public Map<Object, ISymbol> getMapForScope(String scopeName) {
        Map<Object, ISymbol> map = this.getMapForScopeInternal(scopeName);
        if (map != null) {
            return Collections.unmodifiableMap(map);
        }
        return Collections.EMPTY_MAP;
    }

    private void updateMap(ISymbol symbol, String scopeName) {
        Map<Object, ISymbol> map = this.getMapForScopeInternal(scopeName);
        if (map != null) {
            map.put(symbol.getName(), symbol);
        } else {
            Platform.getLog((Bundle)JSFCorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Scope not found: " + scopeName, new Throwable()));
        }
    }

    private Map<Object, ISymbol> getMapForScopeInternal(String scopeName) {
        if ("request".equals(scopeName)) {
            return this.getRequestMap();
        }
        if ("session".equals(scopeName)) {
            return this.getSessionMap();
        }
        if ("application".equals(scopeName)) {
            return this.getApplicationMap();
        }
        if ("none".equals(scopeName)) {
            return this.getNoneMap();
        }
        Platform.getLog((Bundle)JSFCorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Scope not found: " + scopeName, new Throwable()));
        return null;
    }

    private Map getRequestMap() {
        if (this._requestMap == null) {
            this._requestMap = new HashMap<Object, ISymbol>();
        }
        return this._requestMap;
    }

    private Map<Object, ISymbol> getSessionMap() {
        if (this._sessionMap == null) {
            this._sessionMap = new HashMap<Object, ISymbol>();
        }
        return this._sessionMap;
    }

    private Map<Object, ISymbol> getApplicationMap() {
        if (this._applicationMap == null) {
            this._applicationMap = new HashMap<Object, ISymbol>();
        }
        return this._applicationMap;
    }

    private Map<Object, ISymbol> getNoneMap() {
        if (this._noneMap == null) {
            this._noneMap = new HashMap<Object, ISymbol>();
        }
        return this._noneMap;
    }

    private static final class CountingMutex {
        private long _lastModificationStamp = -1L;
        private boolean _signalled = false;
        private final ILock _lock = Job.getJobManager().newLock();

        private CountingMutex() {
        }

        public boolean compareAndSetSignalled(final boolean expect, final boolean update) {
            final boolean[] value = new boolean[1];
            this.safeRun(new Runnable(){

                public void run() {
                    if (CountingMutex.this._signalled == expect) {
                        CountingMutex.this._signalled = update;
                        value[0] = true;
                    } else {
                        value[0] = false;
                    }
                }
            });
            return value[0];
        }

        public boolean hasChanged(final long currentModificationStamp) {
            final boolean[] value = new boolean[1];
            this.safeRun(new Runnable(){

                public void run() {
                    value[0] = CountingMutex.this._lastModificationStamp != currentModificationStamp;
                }
            });
            return value[0];
        }

        public void setSignalled(final boolean signalled) {
            this.safeRun(new Runnable(){

                public void run() {
                    CountingMutex.this._signalled = signalled;
                }
            });
        }

        public void setModificationStamp(final long newValue) {
            this.safeRun(new Runnable(){

                public void run() {
                    CountingMutex.this._lastModificationStamp = newValue;
                }
            });
        }

        private void safeRun(Runnable runnable) {
            this._lock.acquire();
            try {
                runnable.run();
            }
            finally {
                this._lock.release();
            }
        }
    }

    private static class LocaleSetAggregator {
        private static final String SETS_LOCALE = "sets-locale";

        private LocaleSetAggregator() {
        }

        private static LocaleSetAggregator create(IProject project, String uri, String elementName, String attributeName) {
            ITaglibDomainMetaDataModelContext mdContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)project, (String)uri);
            Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)mdContext, (String)(String.valueOf(elementName) + "/" + attributeName), (String)SETS_LOCALE);
            if (TraitValueHelper.getValueAsBoolean((Trait)trait)) {
                return new LocaleSetAggregator();
            }
            return null;
        }
    }

    private final class RefreshRunnable
    implements IWorkspaceRunnable {
        private final boolean _forceRefresh;

        public RefreshRunnable(boolean forceRefresh) {
            this._forceRefresh = forceRefresh;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor) throws CoreException {
            CountingMutex countingMutex = JSPModelProcessor.this._lastModificationStampMonitor;
            synchronized (countingMutex) {
                if (!JSPModelProcessor.this._lastModificationStampMonitor.compareAndSetSignalled(false, true)) {
                    return;
                }
                IDOMModel model = null;
                try {
                    try {
                        if (this._forceRefresh || JSPModelProcessor.this.isModelDirty()) {
                            model = JSPModelProcessor.this.getModelForFile(JSPModelProcessor.this._file);
                            JSPModelProcessor.this.refreshInternal(model);
                            JSPModelProcessor.this._lastModificationStampMonitor.setModificationStamp(JSPModelProcessor.this._file.getModificationStamp());
                        }
                    }
                    catch (IOException e) {
                        Status status = new Status(4, "org.eclipse.jst.jsf.core", "Error refreshing internal model", (Throwable)e);
                        CoreException e2 = new CoreException((IStatus)status);
                        throw e2;
                    }
                }
                finally {
                    JSPModelProcessor.this._lastModificationStampMonitor.setSignalled(false);
                    if (model != null) {
                        model.releaseFromRead();
                    }
                }
            }
        }
    }

    private static class SymbolContribAggregator {
        private static final String CONTRIBUTES_VALUE_BINDING = "contributes-value-binding";
        private static final String VALUE_BINDING_SCOPE = "value-binding-scope";
        private static final String VALUE_BINDING_SYMBOL_FACTORY = "value-binding-symbol-factory";
        private static final String STATIC_TYPE_KEY = "optional-value-binding-static-type";
        private static final String VALUEEXPRESSION_ATTR_NAME_KEY = "optional-value-binding-valueexpr-attr";
        private final Map<String, String> _metadata = new HashMap<String, String>(4);

        private static SymbolContribAggregator create(IProject project, String uri, String elementName, String attributeName) {
            String entityKey = String.valueOf(elementName) + "/" + attributeName;
            ITaglibDomainMetaDataModelContext mdContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)project, (String)uri);
            Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)mdContext, (String)entityKey, (String)CONTRIBUTES_VALUE_BINDING);
            boolean contribsValueBindings = TraitValueHelper.getValueAsBoolean((Trait)trait);
            if (contribsValueBindings) {
                String scope = null;
                String symbolFactory = null;
                trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)mdContext, (String)entityKey, (String)VALUE_BINDING_SCOPE);
                scope = TraitValueHelper.getValueAsString((Trait)trait);
                if (scope != null && !scope.equals("")) {
                    trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)mdContext, (String)entityKey, (String)VALUE_BINDING_SYMBOL_FACTORY);
                    symbolFactory = TraitValueHelper.getValueAsString((Trait)trait);
                }
                trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)mdContext, (String)entityKey, (String)STATIC_TYPE_KEY);
                String staticType = null;
                if (trait != null) {
                    staticType = TraitValueHelper.getValueAsString((Trait)trait);
                }
                trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)mdContext, (String)entityKey, (String)VALUEEXPRESSION_ATTR_NAME_KEY);
                String valueExprAttr = null;
                if (trait != null) {
                    valueExprAttr = TraitValueHelper.getValueAsString((Trait)trait);
                }
                return new SymbolContribAggregator(scope, symbolFactory, staticType, valueExprAttr);
            }
            return null;
        }

        SymbolContribAggregator(String scope, String factory, String staticType, String valueExprAttr) {
            this._metadata.put("scope", scope);
            this._metadata.put("factory", factory);
            this._metadata.put("staticType", staticType);
            this._metadata.put("valueExprAttr", valueExprAttr);
        }

        public String getScope() {
            return this._metadata.get("scope");
        }

        public AbstractContextSymbolFactory getFactory() {
            return (AbstractContextSymbolFactory)JSFCommonPlugin.getSymbolFactories().get(this._metadata.get("factory"));
        }

        public String getStaticType() {
            return this._metadata.get("staticType");
        }

        public String getValueExpressionAttr() {
            return this._metadata.get("valueExprAttr");
        }
    }
}

