/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.appclient;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.applicationclient.ApplicationClient;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.jee.ui.internal.Messages;
import org.eclipse.jst.jee.ui.internal.navigator.appclient.AbstractAppClientGroupProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.jst.jee.ui.plugin.JEEUIPluginIcons;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class GroupAppClientProvider
extends AbstractAppClientGroupProvider
implements IAdaptable {
    private final IProject project;
    private static final String PROJECT_RELATIVE_PATH = "META-INF/application-client.xml";
    private static Image APP_CLIENT50;
    private IFile ddFile;

    public GroupAppClientProvider(ApplicationClient javaee, IProject project) {
        super((JavaEEObject)javaee);
        this.project = project;
    }

    private ApplicationClient getModel() {
        if (this.javaee != null) {
            return (ApplicationClient)this.javaee;
        }
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)this.project);
        Object modelObject = null;
        try {
            modelObject = modelProvider.getModelObject();
        }
        catch (Exception e) {
            JEEUIPlugin.logError("Error during initializing model", e);
        }
        if (modelObject != null && modelObject instanceof ApplicationClient) {
            return (ApplicationClient)modelObject;
        }
        return null;
    }

    public String getText() {
        String result = null;
        result = this.project == null ? NLS.bind((String)Messages.DEPLOYMENT_DESCRIPTOR, (Object[])new Object[]{""}) : NLS.bind((String)Messages.DEPLOYMENT_DESCRIPTOR, (Object)this.project.getName());
        return result;
    }

    public List getChildren() {
        ArrayList result = new ArrayList();
        if (this.javaee != null) {
            result.addAll(((ApplicationClient)this.javaee).getEjbRefs());
            result.addAll(((ApplicationClient)this.javaee).getResourceRefs());
            result.addAll(((ApplicationClient)this.javaee).getResourceEnvRefs());
            result.addAll(((ApplicationClient)this.javaee).getEnvEntries());
            result.addAll(((ApplicationClient)this.javaee).getMessageDestinationRefs());
            result.addAll(((ApplicationClient)this.javaee).getPersistenceUnitRefs());
            result.addAll(((ApplicationClient)this.javaee).getServiceRefs());
        }
        return result;
    }

    public Image getImage() {
        if (APP_CLIENT50 == null) {
            ImageDescriptor imageDescriptor = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.APP_CLIENT50);
            APP_CLIENT50 = imageDescriptor.createImage();
        }
        return APP_CLIENT50;
    }

    public IFile getDDFile() {
        if (this.ddFile != null) {
            return this.ddFile;
        }
        IVirtualFolder virtualFolder = ComponentCore.createComponent((IProject)this.project).getRootFolder();
        this.ddFile = virtualFolder.getFile(PROJECT_RELATIVE_PATH).getUnderlyingFile();
        return this.ddFile;
    }

    public IProject getProject() {
        return this.project;
    }

    public Object getAdapter(Class adapter) {
        if (IProject.class == adapter) {
            return this.getProject();
        }
        return null;
    }
}

