/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAspectAdapterTests
extends TestCase {
    private TestSubject subject1;
    private WritablePropertyValueModel<TestSubject> subjectHolder1;
    private PropertyAspectAdapter<TestSubject, String> aa1;
    private PropertyChangeEvent event1;
    private PropertyChangeListener listener1;
    private TestSubject subject2;
    private PropertyChangeEvent multipleValueEvent;
    private PropertyChangeEvent customValueEvent;

    public PropertyAspectAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.subject1 = new TestSubject("foo", "test subject 1");
        this.subjectHolder1 = new SimplePropertyValueModel((Object)this.subject1);
        this.aa1 = this.buildAspectAdapter((PropertyValueModel<TestSubject>)this.subjectHolder1);
        this.listener1 = this.buildValueChangeListener1();
        this.aa1.addPropertyChangeListener("value", this.listener1);
        this.event1 = null;
        this.subject2 = new TestSubject("bar", "test subject 2");
    }

    private PropertyAspectAdapter<TestSubject, String> buildAspectAdapter(PropertyValueModel<TestSubject> subjectHolder) {
        return new PropertyAspectAdapter<TestSubject, String>(subjectHolder, new String[]{"name"}){

            protected String buildValue_() {
                if (this.propertyNames[0] == "name") {
                    return ((TestSubject)((Object)this.subject)).getName();
                }
                if (this.propertyNames[0] == "description") {
                    return ((TestSubject)((Object)this.subject)).getDescription();
                }
                throw new IllegalStateException("invalid aspect name: " + this.propertyNames[0]);
            }

            protected void setValue_(String value) {
                if (this.propertyNames[0] == "name") {
                    ((TestSubject)((Object)this.subject)).setName(value);
                } else if (this.propertyNames[0] == "description") {
                    ((TestSubject)((Object)this.subject)).setDescription(value);
                } else {
                    throw new IllegalStateException("invalid aspect name: " + this.propertyNames[0]);
                }
            }
        };
    }

    private PropertyChangeListener buildValueChangeListener1() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                PropertyAspectAdapterTests.this.value1Changed(e);
            }
        };
    }

    void value1Changed(PropertyChangeEvent e) {
        this.event1 = e;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSubjectHolder() {
        PropertyAspectAdapterTests.assertEquals((String)"foo", (String)((String)this.aa1.getValue()));
        PropertyAspectAdapterTests.assertNull((Object)this.event1);
        this.subjectHolder1.setValue((Object)this.subject2);
        PropertyAspectAdapterTests.assertNotNull((Object)this.event1);
        PropertyAspectAdapterTests.assertEquals(this.aa1, (Object)this.event1.getSource());
        PropertyAspectAdapterTests.assertEquals((String)"value", (String)this.event1.getPropertyName());
        PropertyAspectAdapterTests.assertEquals((Object)"foo", (Object)this.event1.getOldValue());
        PropertyAspectAdapterTests.assertEquals((Object)"bar", (Object)this.event1.getNewValue());
        PropertyAspectAdapterTests.assertEquals((String)"bar", (String)((String)this.aa1.getValue()));
        this.event1 = null;
        this.subjectHolder1.setValue(null);
        PropertyAspectAdapterTests.assertNotNull((Object)this.event1);
        PropertyAspectAdapterTests.assertEquals(this.aa1, (Object)this.event1.getSource());
        PropertyAspectAdapterTests.assertEquals((String)"value", (String)this.event1.getPropertyName());
        PropertyAspectAdapterTests.assertEquals((Object)"bar", (Object)this.event1.getOldValue());
        PropertyAspectAdapterTests.assertNull((Object)this.event1.getNewValue());
        PropertyAspectAdapterTests.assertNull((Object)this.aa1.getValue());
        this.event1 = null;
        this.subjectHolder1.setValue((Object)this.subject1);
        PropertyAspectAdapterTests.assertNotNull((Object)this.event1);
        PropertyAspectAdapterTests.assertEquals(this.aa1, (Object)this.event1.getSource());
        PropertyAspectAdapterTests.assertEquals((String)"value", (String)this.event1.getPropertyName());
        PropertyAspectAdapterTests.assertEquals(null, (Object)this.event1.getOldValue());
        PropertyAspectAdapterTests.assertEquals((Object)"foo", (Object)this.event1.getNewValue());
        PropertyAspectAdapterTests.assertEquals((String)"foo", (String)((String)this.aa1.getValue()));
    }

    public void testPropertyChange() {
        PropertyAspectAdapterTests.assertEquals((String)"foo", (String)((String)this.aa1.getValue()));
        PropertyAspectAdapterTests.assertNull((Object)this.event1);
        this.subject1.setName("baz");
        PropertyAspectAdapterTests.assertNotNull((Object)this.event1);
        PropertyAspectAdapterTests.assertEquals(this.aa1, (Object)this.event1.getSource());
        PropertyAspectAdapterTests.assertEquals((String)"value", (String)this.event1.getPropertyName());
        PropertyAspectAdapterTests.assertEquals((Object)"foo", (Object)this.event1.getOldValue());
        PropertyAspectAdapterTests.assertEquals((Object)"baz", (Object)this.event1.getNewValue());
        PropertyAspectAdapterTests.assertEquals((String)"baz", (String)((String)this.aa1.getValue()));
        this.event1 = null;
        this.subject1.setName(null);
        PropertyAspectAdapterTests.assertNotNull((Object)this.event1);
        PropertyAspectAdapterTests.assertEquals(this.aa1, (Object)this.event1.getSource());
        PropertyAspectAdapterTests.assertEquals((String)"value", (String)this.event1.getPropertyName());
        PropertyAspectAdapterTests.assertEquals((Object)"baz", (Object)this.event1.getOldValue());
        PropertyAspectAdapterTests.assertEquals(null, (Object)this.event1.getNewValue());
        PropertyAspectAdapterTests.assertEquals(null, (String)((String)this.aa1.getValue()));
        this.event1 = null;
        this.subject1.setName("foo");
        PropertyAspectAdapterTests.assertNotNull((Object)this.event1);
        PropertyAspectAdapterTests.assertEquals(this.aa1, (Object)this.event1.getSource());
        PropertyAspectAdapterTests.assertEquals((String)"value", (String)this.event1.getPropertyName());
        PropertyAspectAdapterTests.assertEquals(null, (Object)this.event1.getOldValue());
        PropertyAspectAdapterTests.assertEquals((Object)"foo", (Object)this.event1.getNewValue());
        PropertyAspectAdapterTests.assertEquals((String)"foo", (String)((String)this.aa1.getValue()));
    }

    public void testValue() {
        PropertyAspectAdapterTests.assertEquals((String)"foo", (String)this.subject1.getName());
        PropertyAspectAdapterTests.assertEquals((String)"foo", (String)((String)this.aa1.getValue()));
    }

    public void testStaleValue() {
        PropertyAspectAdapterTests.assertEquals((String)"foo", (String)this.subject1.getName());
        PropertyAspectAdapterTests.assertEquals((String)"foo", (String)((String)this.aa1.getValue()));
        this.aa1.removePropertyChangeListener("value", this.listener1);
        PropertyAspectAdapterTests.assertEquals(null, (String)((String)this.aa1.getValue()));
        this.aa1.addPropertyChangeListener("value", this.listener1);
        PropertyAspectAdapterTests.assertEquals((String)"foo", (String)((String)this.aa1.getValue()));
        this.aa1.removePropertyChangeListener("value", this.listener1);
        this.subjectHolder1.setValue((Object)this.subject2);
        PropertyAspectAdapterTests.assertEquals(null, (String)((String)this.aa1.getValue()));
        this.aa1.addPropertyChangeListener("value", this.listener1);
        PropertyAspectAdapterTests.assertEquals((String)"bar", (String)((String)this.aa1.getValue()));
    }

    public void testSetValue() {
        this.aa1.setValue((Object)"baz");
        PropertyAspectAdapterTests.assertEquals((String)"baz", (String)((String)this.aa1.getValue()));
        PropertyAspectAdapterTests.assertEquals((String)"baz", (String)this.subject1.getName());
    }

    public void testHasListeners() {
        PropertyAspectAdapterTests.assertTrue((boolean)this.aa1.hasAnyPropertyChangeListeners("value"));
        PropertyAspectAdapterTests.assertTrue((boolean)this.subject1.hasAnyPropertyChangeListeners("name"));
        this.aa1.removePropertyChangeListener("value", this.listener1);
        PropertyAspectAdapterTests.assertFalse((boolean)this.subject1.hasAnyPropertyChangeListeners("name"));
        PropertyAspectAdapterTests.assertFalse((boolean)this.aa1.hasAnyPropertyChangeListeners("value"));
        PropertyChangeListener listener2 = this.buildValueChangeListener1();
        this.aa1.addPropertyChangeListener(listener2);
        PropertyAspectAdapterTests.assertTrue((boolean)this.aa1.hasAnyPropertyChangeListeners("value"));
        PropertyAspectAdapterTests.assertTrue((boolean)this.subject1.hasAnyPropertyChangeListeners("name"));
        this.aa1.removePropertyChangeListener(listener2);
        PropertyAspectAdapterTests.assertFalse((boolean)this.subject1.hasAnyPropertyChangeListeners("name"));
        PropertyAspectAdapterTests.assertFalse((boolean)this.aa1.hasAnyPropertyChangeListeners("value"));
    }

    public void testMultipleAspectAdapter() {
        TestSubject testSubject = new TestSubject("fred", "husband");
        SimplePropertyValueModel testSubjectHolder = new SimplePropertyValueModel((Object)testSubject);
        WritablePropertyValueModel<String> testAA = this.buildMultipleAspectAdapter((PropertyValueModel<TestSubject>)testSubjectHolder);
        PropertyChangeListener testListener = this.buildMultipleValueChangeListener();
        testAA.addPropertyChangeListener("value", testListener);
        PropertyAspectAdapterTests.assertEquals((String)"fred:husband", (String)((String)testAA.getValue()));
        this.multipleValueEvent = null;
        testSubject.setName("wilma");
        PropertyAspectAdapterTests.assertEquals((String)"wilma:husband", (String)((String)testAA.getValue()));
        PropertyAspectAdapterTests.assertEquals((Object)"fred:husband", (Object)this.multipleValueEvent.getOldValue());
        PropertyAspectAdapterTests.assertEquals((Object)"wilma:husband", (Object)this.multipleValueEvent.getNewValue());
        this.multipleValueEvent = null;
        testSubject.setDescription("wife");
        PropertyAspectAdapterTests.assertEquals((String)"wilma:wife", (String)((String)testAA.getValue()));
        PropertyAspectAdapterTests.assertEquals((Object)"wilma:husband", (Object)this.multipleValueEvent.getOldValue());
        PropertyAspectAdapterTests.assertEquals((Object)"wilma:wife", (Object)this.multipleValueEvent.getNewValue());
    }

    private WritablePropertyValueModel<String> buildMultipleAspectAdapter(PropertyValueModel<TestSubject> subjectHolder) {
        return new PropertyAspectAdapter<TestSubject, String>(subjectHolder, new String[]{"name", "description"}){

            protected String buildValue_() {
                return String.valueOf(((TestSubject)((Object)this.subject)).getName()) + ":" + ((TestSubject)((Object)this.subject)).getDescription();
            }
        };
    }

    private PropertyChangeListener buildMultipleValueChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                PropertyAspectAdapterTests.this.multipleValueChanged(e);
            }
        };
    }

    void multipleValueChanged(PropertyChangeEvent e) {
        this.multipleValueEvent = e;
    }

    public void testCustomBuildValueWithNullSubject() {
        TestSubject customSubject = new TestSubject("fred", "laborer");
        SimplePropertyValueModel customSubjectHolder = new SimplePropertyValueModel((Object)customSubject);
        WritablePropertyValueModel<String> customAA = this.buildCustomAspectAdapter((PropertyValueModel<TestSubject>)customSubjectHolder);
        PropertyChangeListener customListener = this.buildCustomValueChangeListener();
        customAA.addPropertyChangeListener("value", customListener);
        PropertyAspectAdapterTests.assertEquals((String)"fred", (String)((String)customAA.getValue()));
        this.customValueEvent = null;
        customSubject.setName("wilma");
        PropertyAspectAdapterTests.assertEquals((String)"wilma", (String)((String)customAA.getValue()));
        PropertyAspectAdapterTests.assertEquals((Object)"fred", (Object)this.customValueEvent.getOldValue());
        PropertyAspectAdapterTests.assertEquals((Object)"wilma", (Object)this.customValueEvent.getNewValue());
        this.customValueEvent = null;
        customSubjectHolder.setValue(null);
        PropertyAspectAdapterTests.assertEquals((String)"<unnamed>", (String)((String)customAA.getValue()));
        PropertyAspectAdapterTests.assertEquals((Object)"wilma", (Object)this.customValueEvent.getOldValue());
        PropertyAspectAdapterTests.assertEquals((Object)"<unnamed>", (Object)this.customValueEvent.getNewValue());
    }

    private WritablePropertyValueModel<String> buildCustomAspectAdapter(PropertyValueModel<TestSubject> subjectHolder) {
        return new PropertyAspectAdapter<TestSubject, String>(subjectHolder, new String[]{"name"}){

            protected String buildValue() {
                return this.subject == null ? "<unnamed>" : ((TestSubject)((Object)this.subject)).getName();
            }
        };
    }

    private PropertyChangeListener buildCustomValueChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                PropertyAspectAdapterTests.this.customValueChanged(e);
            }
        };
    }

    void customValueChanged(PropertyChangeEvent e) {
        this.customValueEvent = e;
    }

    private class TestSubject
    extends AbstractModel {
        private String name;
        public static final String NAME_PROPERTY = "name";
        private String description;
        public static final String DESCRIPTION_PROPERTY = "description";

        public TestSubject(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            String old = this.description;
            this.description = description;
            this.firePropertyChanged(DESCRIPTION_PROPERTY, old, description);
        }
    }
}

