/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.io.Serializable;
import java.util.EventListener;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.ListenerList;

public class ListenerListTests
extends TestCase {
    public ListenerListTests(String name) {
        super(name);
    }

    public void testGetListeners() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        Object[] listeners = (Listener[])listenerList.getListeners();
        ListenerListTests.assertEquals((int)0, (int)listeners.length);
        listenerList.add((EventListener)listener1);
        listenerList.add((EventListener)listener2);
        listeners = (Listener[])listenerList.getListeners();
        ListenerListTests.assertEquals((int)2, (int)listeners.length);
        ListenerListTests.assertTrue((boolean)CollectionTools.contains((Object[])listeners, (Object)listener1));
        ListenerListTests.assertTrue((boolean)CollectionTools.contains((Object[])listeners, (Object)listener2));
    }

    public void testSize() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        ListenerListTests.assertEquals((int)0, (int)listenerList.size());
        listenerList.add((EventListener)listener1);
        listenerList.add((EventListener)listener2);
        ListenerListTests.assertEquals((int)2, (int)listenerList.size());
    }

    public void testIsEmpty() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        ListenerListTests.assertTrue((boolean)listenerList.isEmpty());
        listenerList.add((EventListener)listener1);
        listenerList.add((EventListener)listener2);
        ListenerListTests.assertFalse((boolean)listenerList.isEmpty());
    }

    public void testAdd_null() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        boolean exCaught = false;
        try {
            listenerList.add(null);
            ListenerListTests.fail((String)("invalid listener list: " + listenerList));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ListenerListTests.assertTrue((boolean)exCaught);
    }

    public void testAdd_duplicate() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener = new LocalListener();
        listenerList.add((EventListener)listener);
        boolean exCaught = false;
        try {
            listenerList.add((EventListener)listener);
            ListenerListTests.fail((String)("invalid listener list: " + listenerList));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ListenerListTests.assertTrue((boolean)exCaught);
    }

    public void testRemove() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        listenerList.add((EventListener)listener1);
        listenerList.add((EventListener)listener2);
        ListenerListTests.assertTrue((boolean)CollectionTools.contains((Object[])listenerList.getListeners(), (Object)listener1));
        ListenerListTests.assertTrue((boolean)CollectionTools.contains((Object[])listenerList.getListeners(), (Object)listener2));
        listenerList.remove((EventListener)listener1);
        ListenerListTests.assertFalse((boolean)CollectionTools.contains((Object[])listenerList.getListeners(), (Object)listener1));
        ListenerListTests.assertTrue((boolean)CollectionTools.contains((Object[])listenerList.getListeners(), (Object)listener2));
        listenerList.remove((EventListener)listener2);
        ListenerListTests.assertFalse((boolean)CollectionTools.contains((Object[])listenerList.getListeners(), (Object)listener2));
    }

    public void testRemove_null() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        boolean exCaught = false;
        try {
            listenerList.remove(null);
            ListenerListTests.fail((String)("invalid listener list: " + listenerList));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ListenerListTests.assertTrue((boolean)exCaught);
    }

    public void testRemove_unregistered() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener = new LocalListener();
        listenerList.add((EventListener)listener);
        listenerList.remove((EventListener)listener);
        boolean exCaught = false;
        try {
            listenerList.remove((EventListener)listener);
            ListenerListTests.fail((String)("invalid listener list: " + listenerList));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ListenerListTests.assertTrue((boolean)exCaught);
    }

    public void testClear() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        listenerList.add((EventListener)listener1);
        listenerList.add((EventListener)listener2);
        ListenerListTests.assertTrue((boolean)CollectionTools.contains((Object[])listenerList.getListeners(), (Object)listener1));
        ListenerListTests.assertTrue((boolean)CollectionTools.contains((Object[])listenerList.getListeners(), (Object)listener2));
        listenerList.clear();
        ListenerListTests.assertFalse((boolean)CollectionTools.contains((Object[])listenerList.getListeners(), (Object)listener1));
        ListenerListTests.assertFalse((boolean)CollectionTools.contains((Object[])listenerList.getListeners(), (Object)listener2));
    }

    static interface Listener
    extends EventListener {
        public void somethingHappened();
    }

    static class LocalListener
    implements Listener,
    Serializable {
        LocalListener() {
        }

        public void somethingHappened() {
        }
    }

    static class NonSerializableListener
    implements Listener {
        NonSerializableListener() {
        }

        public void somethingHappened() {
        }
    }
}

