/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.CustomConverter;
import org.eclipse.jpt.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.ConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaCustomConverter
extends EclipseLinkJavaConverter
implements CustomConverter {
    private String converterClass;

    public EclipseLinkJavaCustomConverter(JavaJpaContextNode parent) {
        super(parent);
    }

    @Override
    public String getType() {
        return "customConverter";
    }

    @Override
    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Converter";
    }

    @Override
    protected ConverterAnnotation getAnnotation() {
        return (ConverterAnnotation)super.getAnnotation();
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String newConverterClass) {
        String oldConverterClass = this.converterClass;
        this.converterClass = newConverterClass;
        this.getAnnotation().setConverterClass(newConverterClass);
        this.firePropertyChanged("converterClass", oldConverterClass, newConverterClass);
    }

    protected void setConverterClass_(String newConverterClass) {
        String oldConverterClass = this.converterClass;
        this.converterClass = newConverterClass;
        this.firePropertyChanged("converterClass", oldConverterClass, newConverterClass);
    }

    @Override
    protected void initialize(JavaResourcePersistentMember jrpm) {
        super.initialize(jrpm);
        this.converterClass = this.converterClass(this.getAnnotation());
    }

    @Override
    public void update(JavaResourcePersistentMember jrpm) {
        super.update(jrpm);
        this.setConverterClass_(this.converterClass(this.getAnnotation()));
    }

    protected String converterClass(ConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getConverterClass();
    }

    public TextRange getConverterClassTextRange(CompilationUnit astRoot) {
        return this.getAnnotation().getConverterClassTextRange(astRoot);
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateConverterClass(messages, astRoot);
    }

    protected void validateConverterClass(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.converterClass == null) {
            return;
        }
        if (!this.getAnnotation().converterClassImplementsInterface("org.eclipse.persistence.mappings.converters.Converter", astRoot)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_IMPLEMENTS_CONVERTER", new String[]{this.converterClass}, this, this.getConverterClassTextRange(astRoot)));
        }
    }
}

