/*******************************************************************************
 * Copyright (c) 2009 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 *******************************************************************************/
package org.eclipse.jpt.eclipselink.core.internal.operations;

import org.eclipse.core.resources.IFile;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationOperation;
import org.eclipse.jpt.core.resource.AbstractXmlResourceProvider;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitMetadata;
import org.eclipse.jpt.eclipselink.core.internal.resource.orm.EclipseLink1_1OrmXmlResourceProvider;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EclipseLink1_1OrmFileCreationOperation extends OrmFileCreationOperation
{
	public EclipseLink1_1OrmFileCreationOperation(IDataModel dataModel) {
		super(dataModel);
	}
	
	@Override
	protected AbstractXmlResourceProvider getXmlResourceProvider(IFile file) {
		return EclipseLink1_1OrmXmlResourceProvider.getXmlResourceProvider(file);
	}
	
	@Override
	protected XmlPersistenceUnitMetadata createXmlPersistenceUnitMetadata() {
		return EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata();
	}

}
