/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.Cascade;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmOneToOneMappingTests
extends ContextModelTestCase {
    public OrmOneToOneMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertEquals((String)"oneToOneMapping", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertEquals((String)"oneToOneMapping", (String)oneToOne.getName());
        oneToOne.setName("newName");
        OrmOneToOneMappingTests.assertEquals((String)"newName", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertEquals((String)"newName", (String)oneToOne.getName());
        oneToOne.setName(null);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertEquals((String)"oneToOneMapping", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertEquals((String)"oneToOneMapping", (String)oneToOne.getName());
        ormOneToOneMapping.setName("newName");
        OrmOneToOneMappingTests.assertEquals((String)"newName", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertEquals((String)"newName", (String)oneToOne.getName());
        ormOneToOneMapping.setName(null);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getName());
    }

    public void testUpdateSpecifiedTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
        oneToOne.setTargetEntity("newTargetEntity");
        OrmOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOne.getTargetEntity());
        oneToOne.setTargetEntity(null);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
    }

    public void testModifySpecifiedTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
        ormOneToOneMapping.setSpecifiedTargetEntity("newTargetEntity");
        OrmOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOne.getTargetEntity());
        ormOneToOneMapping.setSpecifiedTargetEntity(null);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getFetch());
        oneToOneResource.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.EAGER);
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)oneToOneResource.getFetch());
        oneToOneResource.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.LAZY);
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)oneToOneResource.getFetch());
        oneToOneResource.setFetch(null);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getFetch());
        ormOneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        OrmOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)oneToOneResource.getFetch());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getSpecifiedFetch());
        ormOneToOneMapping.setSpecifiedFetch(FetchType.LAZY);
        OrmOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)oneToOneResource.getFetch());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToOneMapping.getSpecifiedFetch());
        ormOneToOneMapping.setSpecifiedFetch(null);
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getFetch());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
    }

    public void testUpdateMappedBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmMappedByJoiningStrategy strategy = ormOneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
        oneToOne.setMappedBy("newMappedBy");
        OrmOneToOneMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmOneToOneMappingTests.assertEquals((String)"newMappedBy", (String)oneToOne.getMappedBy());
        oneToOne.setMappedBy(null);
        OrmOneToOneMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmMappedByJoiningStrategy strategy = ormOneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
        strategy.setMappedByAttribute("newMappedBy");
        OrmOneToOneMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmOneToOneMappingTests.assertEquals((String)"newMappedBy", (String)oneToOne.getMappedBy());
        strategy.setMappedByAttribute(null);
        OrmOneToOneMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
    }

    public void testUpdateSpecifiedOptional() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getOptional());
        oneToOneResource.setOptional(Boolean.TRUE);
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneResource.getOptional());
        oneToOneResource.setOptional(Boolean.FALSE);
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneResource.getOptional());
        oneToOneResource.setOptional(null);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getOptional());
    }

    public void testModifySpecifiedOptional() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getOptional());
        ormOneToOneMapping.setSpecifiedOptional(Boolean.TRUE);
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneResource.getOptional());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormOneToOneMapping.getSpecifiedOptional());
        ormOneToOneMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneResource.getOptional());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormOneToOneMapping.getSpecifiedOptional());
        ormOneToOneMapping.setSpecifiedOptional(null);
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getOptional());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnJoiningStrategy strategy = ormOneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmJoinColumn joinColumn = strategy.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        OrmJoinColumn joinColumn2 = strategy.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(1)).getName());
        OrmJoinColumn joinColumn3 = strategy.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(1)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(2)).getName());
        ListIterator joinColumns = strategy.specifiedJoinColumns();
        OrmOneToOneMappingTests.assertEquals((Object)joinColumn2, joinColumns.next());
        OrmOneToOneMappingTests.assertEquals((Object)joinColumn3, joinColumns.next());
        OrmOneToOneMappingTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = strategy.specifiedJoinColumns();
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnJoiningStrategy strategy = ormOneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        strategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        strategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        strategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        OrmOneToOneMappingTests.assertEquals((int)3, (int)oneToOneResource.getJoinColumns().size());
        strategy.removeSpecifiedJoinColumn(0);
        OrmOneToOneMappingTests.assertEquals((int)2, (int)oneToOneResource.getJoinColumns().size());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(1)).getName());
        strategy.removeSpecifiedJoinColumn(0);
        OrmOneToOneMappingTests.assertEquals((int)1, (int)oneToOneResource.getJoinColumns().size());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        strategy.removeSpecifiedJoinColumn(0);
        OrmOneToOneMappingTests.assertEquals((int)0, (int)oneToOneResource.getJoinColumns().size());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnJoiningStrategy strategy = ormOneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        strategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        strategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        strategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        OrmOneToOneMappingTests.assertEquals((int)3, (int)oneToOneResource.getJoinColumns().size());
        strategy.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = strategy.specifiedJoinColumns();
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(1)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(2)).getName());
        strategy.moveSpecifiedJoinColumn(0, 1);
        joinColumns = strategy.specifiedJoinColumns();
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(1)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(2)).getName());
    }

    public void testOneToOneMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "foo");
        OrmOneToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertEquals((String)"foo", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getFetch());
        OrmOneToOneMappingTests.assertEquals((boolean)true, (boolean)ormOneToOneMapping.isOptional());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getTargetEntity());
        OrmOneToOneMappingTests.assertTrue((ormOneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().joinColumnsSize() > 0 ? 1 : 0) != 0);
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isAll());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmOneToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertEquals((String)"Address", (String)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmJoinColumn ormJoinColumn = (OrmJoinColumn)ormOneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().specifiedJoinColumns().next();
        OrmOneToOneMappingTests.assertEquals((String)"MY_COLUMN", (String)ormJoinColumn.getSpecifiedName());
        OrmOneToOneMappingTests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedUnique());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedNullable());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedInsertable());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        OrmOneToOneMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormJoinColumn.getColumnDefinition());
        OrmOneToOneMappingTests.assertEquals((String)"MY_TABLE", (String)ormJoinColumn.getSpecifiedTable());
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmOneToOneMappingTests.assertTrue((boolean)cascade.isAll());
        OrmOneToOneMappingTests.assertTrue((boolean)cascade.isMerge());
        OrmOneToOneMappingTests.assertTrue((boolean)cascade.isPersist());
        OrmOneToOneMappingTests.assertTrue((boolean)cascade.isRemove());
        OrmOneToOneMappingTests.assertTrue((boolean)cascade.isRefresh());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmOneToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmOneToOneMappingTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
        ormPersistentAttribute.makeSpecified("oneToOne");
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getFetch());
        OrmOneToOneMappingTests.assertEquals((boolean)true, (boolean)ormOneToOneMapping.isOptional());
        OrmOneToOneMappingTests.assertEquals((String)"test.Address", (String)ormOneToOneMapping.getTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isAll());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "address");
        OrmOneToOneMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getFetch());
        OrmOneToOneMappingTests.assertEquals((boolean)true, (boolean)ormOneToOneMapping.isOptional());
        OrmOneToOneMappingTests.assertTrue((ormOneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().joinColumnsSize() > 0 ? 1 : 0) != 0);
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isAll());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
    }

    public void testOneToOneMorphToIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("id");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToOneMorphToVersionMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("version");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToOneMorphToTransientMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("transient");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToOneMorphToEmbeddedMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embedded");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToOneMorphToEmbeddedIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embeddedId");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToOneMorphToManyToManyMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToMany");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToOneMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertEquals((String)"mappedBy", (String)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testOneToOneMorphToOneToManyMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToMany");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((OneToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToOneMappingTests.assertEquals((String)"TargetEntity", (String)((OneToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertEquals((String)"mappedBy", (String)((OneToManyMapping)ormPersistentAttribute.getMapping()).getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmOneToOneMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToOneMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToOneMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToOneMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToOneMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testOneToOneMorphToManyToOneMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToOne");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToOneMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
        joinColumn = (JoinColumn)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getRelationshipReference().getJoinColumnJoiningStrategy().specifiedJoinColumns().next();
        OrmOneToOneMappingTests.assertEquals((String)"name", (String)joinColumn.getName());
        OrmOneToOneMappingTests.assertEquals((String)"referenceName", (String)joinColumn.getReferencedColumnName());
    }

    public void testOneToOneMorphToBasicMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("basic");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testAddPrimaryKeyJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmPrimaryKeyJoinColumnJoiningStrategy strategy = ormOneToOneMapping.getRelationshipReference().getPrimaryKeyJoinColumnJoiningStrategy();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmPrimaryKeyJoinColumn joinColumn = strategy.addPrimaryKeyJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmPrimaryKeyJoinColumn joinColumn2 = strategy.addPrimaryKeyJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmPrimaryKeyJoinColumn joinColumn3 = strategy.addPrimaryKeyJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(2)).getName());
        ListIterator joinColumns = strategy.primaryKeyJoinColumns();
        OrmOneToOneMappingTests.assertEquals((Object)joinColumn2, joinColumns.next());
        OrmOneToOneMappingTests.assertEquals((Object)joinColumn3, joinColumns.next());
        OrmOneToOneMappingTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = strategy.primaryKeyJoinColumns();
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
    }

    public void testRemovePrimaryKeyJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmPrimaryKeyJoinColumnJoiningStrategy strategy = ormOneToOneMapping.getRelationshipReference().getPrimaryKeyJoinColumnJoiningStrategy();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        strategy.addPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        strategy.addPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        OrmOneToOneMappingTests.assertEquals((int)3, (int)oneToOneResource.getPrimaryKeyJoinColumns().size());
        strategy.removePrimaryKeyJoinColumn(0);
        OrmOneToOneMappingTests.assertEquals((int)2, (int)oneToOneResource.getPrimaryKeyJoinColumns().size());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(1)).getName());
        strategy.removePrimaryKeyJoinColumn(0);
        OrmOneToOneMappingTests.assertEquals((int)1, (int)oneToOneResource.getPrimaryKeyJoinColumns().size());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        strategy.removePrimaryKeyJoinColumn(0);
        OrmOneToOneMappingTests.assertEquals((int)0, (int)oneToOneResource.getPrimaryKeyJoinColumns().size());
    }

    public void testMovePrimaryKeyJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmPrimaryKeyJoinColumnJoiningStrategy strategy = ormOneToOneMapping.getRelationshipReference().getPrimaryKeyJoinColumnJoiningStrategy();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        strategy.addPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        strategy.addPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        OrmOneToOneMappingTests.assertEquals((int)3, (int)oneToOneResource.getPrimaryKeyJoinColumns().size());
        strategy.movePrimaryKeyJoinColumn(2, 0);
        ListIterator joinColumns = strategy.primaryKeyJoinColumns();
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(2)).getName());
        strategy.movePrimaryKeyJoinColumn(0, 1);
        joinColumns = strategy.primaryKeyJoinColumns();
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(2)).getName());
    }
}

