/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.initialization;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebService;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.initialization.AnnotationAttributeInitializer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestWrapperAttributeInitializer
extends AnnotationAttributeInitializer {
    public List<MemberValuePair> getMemberValuePairs(IJavaElement javaElement, AST ast, Class<? extends Annotation> annotationClass) {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        if (javaElement.getElementType() == 9) {
            IMethod method = (IMethod)javaElement;
            IType type = method.getCompilationUnit().findPrimaryType();
            MemberValuePair classNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"className", (Object)this.getClassName(type, method));
            MemberValuePair localNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"localName", (Object)this.getLocalName(type, method));
            MemberValuePair targetNamespaceValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"targetNamespace", (Object)this.getTargetNamespace(type));
            memberValuePairs.add(classNameValuePair);
            memberValuePairs.add(localNameValuePair);
            memberValuePairs.add(targetNamespaceValuePair);
        }
        return memberValuePairs;
    }

    public List<ICompletionProposal> getCompletionProposalsForMemberValuePair(IJavaElement javaElement, MemberValuePair memberValuePair) {
        ArrayList<ICompletionProposal> completionProposals = new ArrayList<ICompletionProposal>(1);
        if (javaElement.getElementType() == 9) {
            IMethod method = (IMethod)javaElement;
            IType type = method.getCompilationUnit().findPrimaryType();
            String memberValuePairName = memberValuePair.getName().getIdentifier();
            if (memberValuePairName.equals("className")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getClassName(type, method), memberValuePair.getValue()));
            }
            if (memberValuePairName.equals("localName")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getLocalName(type, method), memberValuePair.getValue()));
            }
            if (memberValuePairName.equals("targetNamespace")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getTargetNamespace(type), memberValuePair.getValue()));
            }
        }
        return completionProposals;
    }

    protected String getPackageName(IType type) {
        StringBuilder packageName = new StringBuilder(type.getPackageFragment().getElementName());
        if (packageName.length() > 0) {
            packageName.append(".");
        }
        packageName.append("jaxws");
        packageName.append(".");
        return packageName.toString();
    }

    protected String getClassName(IType type, IMethod method) {
        try {
            String methodName = method.getElementName();
            return String.valueOf(this.getPackageName(type)) + methodName.substring(0, 1).toUpperCase() + methodName.substring(1) + AnnotationUtils.accountForOverloadedMethods((IType)type, (IMethod)method);
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
            return "";
        }
    }

    protected String getLocalName(IType type, IMethod method) {
        try {
            String operationName;
            IAnnotation annotation = AnnotationUtils.getAnnotation((IAnnotatable)method, WebMethod.class);
            if (annotation != null && (operationName = AnnotationUtils.getStringValue((IAnnotation)annotation, (String)"operationName")) != null) {
                return operationName;
            }
            return String.valueOf(method.getElementName()) + AnnotationUtils.accountForOverloadedMethods((IType)type, (IMethod)method);
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
            return "";
        }
    }

    protected String getTargetNamespace(IType type) {
        try {
            String targetNamespace;
            IAnnotation annotation = AnnotationUtils.getAnnotation((IAnnotatable)type, WebService.class);
            if (annotation != null && (targetNamespace = AnnotationUtils.getStringValue((IAnnotation)annotation, (String)"targetNamespace")) != null && targetNamespace.length() > 0) {
                return targetNamespace;
            }
            return JDTUtils.getTargetNamespaceFromPackageName((String)type.getPackageFragment().getElementName());
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
            return "";
        }
    }
}

