/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal.dnd;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.internal.wizard.ImportUtil;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.part.IDropActionDelegate;
import org.eclipse.wst.common.frameworks.internal.AdaptabilityUtility;

public class J2EEImportDropAction
implements IDropActionDelegate {
    private ArchiveOptions readOnlyArchiveOptions = new ArchiveOptions();

    public J2EEImportDropAction() {
        this.readOnlyArchiveOptions.setIsReadOnly(true);
    }

    private boolean fileExistsOnDisk(String fileName) {
        if (fileName != null && fileName.length() > 0) {
            File file = new File(fileName);
            return file.exists() && !file.isDirectory();
        }
        return false;
    }

    public boolean validateDrop(CommonDropAdapter dropAdapter, Object target, int operation, TransferData transferType) {
        if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
            if (sourceNames == null || sourceNames.length != 1) {
                return false;
            }
            String fileName = sourceNames[0];
            if (!(fileName.endsWith(".ear") || fileName.endsWith(".jar") || fileName.endsWith(".war") || fileName.endsWith(".rar"))) {
                return false;
            }
            if (!this.fileExistsOnDisk(fileName)) {
                return false;
            }
            Object archive = null;
            if (archive != null && archive.isOpen()) {
                archive.close();
            }
            return true;
        }
        return false;
    }

    public boolean run(Object source, Object target) {
        TransferData currentTransfer = null;
        if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
            String[] fileNames = (String[])source;
            String fileName = fileNames[0];
            Object wizard = null;
            Object dataModel = null;
            int archiveType = 0;
            Archive archive = null;
            try {
                archive = CommonarchiveFactoryImpl.getActiveFactory().openArchive(fileName);
                archiveType = ImportUtil.getArchiveType((Archive)archive);
                switch (archiveType) {
                    case 1: {
                        dataModel = null;
                        break;
                    }
                    case 2: {
                        dataModel = null;
                        break;
                    }
                    case 4: {
                        dataModel = null;
                        break;
                    }
                    case 3: {
                        dataModel = null;
                        break;
                    }
                    case 5: {
                        dataModel = null;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            catch (OpenFailureException openFailureException) {
                return false;
            }
            finally {
                if (archive != null && archive.isOpen()) {
                    archive.close();
                }
            }
            dataModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)fileName);
            IProject project = (IProject)AdaptabilityUtility.getAdapter((Object)target, IProject.class);
            if (project != null) {
                try {
                    if (archiveType == 1) {
                        dataModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)project.getName());
                    } else {
                        dataModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)project.getName());
                        dataModel.setBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", true);
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
            switch (archiveType) {
                case 1: {
                    wizard = null;
                    break;
                }
                case 2: {
                    wizard = null;
                    break;
                }
                case 4: {
                    wizard = null;
                    break;
                }
                case 3: {
                    wizard = null;
                    break;
                }
                case 5: {
                    wizard = null;
                }
            }
            if (wizard != null) {
                return true;
            }
        }
        return false;
    }
}

