/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.resolvers.IReferenceResolver;
import org.eclipse.wst.common.componentcore.resolvers.ReferenceResolverUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.internal.HashUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualComponent
implements IVirtualComponent {
    IPath runtimePath;
    IProject componentProject;
    IVirtualFolder rootFolder;
    String componentTypeId;
    private int flag = 0;
    String name = null;
    String deploymentName = null;
    Map<String, IVirtualReference> referenceMap = null;
    IVirtualReference[] rawReferencesArray = null;
    IVirtualReference[] referencesArray = null;
    Properties metaProperties = null;
    IPath[] cacheMetaResources = null;
    IVirtualReference[] allReferences = null;
    Resource projectResource;
    protected ResourceAdapter resourceAdapter = new ResourceAdapter();

    protected void resourceChanged(Resource aResource) {
        this.clearCache();
    }

    private void addManagedResource() {
        if (this.projectResource == null) {
            this.projectResource = this.createResource();
        }
        if (this.projectResource != null && !this.projectResource.eAdapters().contains((Object)this.resourceAdapter)) {
            this.projectResource.eAdapters().add((Object)this.resourceAdapter);
        }
    }

    protected void removeResource() {
        if (this.projectResource != null) {
            this.projectResource.eAdapters().remove((Object)this.resourceAdapter);
            this.projectResource = null;
        }
    }

    protected void initializeResource() {
        this.projectResource = this.createResource();
        this.addManagedResource();
    }

    protected Resource createResource() {
        StructureEdit core = null;
        Resource res = null;
        try {
            core = StructureEdit.getStructureEditForRead(this.getProject());
            if (core == null) {
                return null;
            }
            WorkbenchComponent component = core.getComponent();
            if (component != null) {
                res = component.eResource();
            }
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
        return res;
    }

    public void dispose() {
        this.removeResource();
    }

    protected VirtualComponent() {
    }

    public VirtualComponent(IProject aProject, IPath aRuntimePath) {
        if (aProject == null) {
            throw new NullPointerException();
        }
        this.componentProject = aProject;
        this.runtimePath = aRuntimePath;
        this.rootFolder = ComponentCore.createFolder(this.componentProject, (IPath)new Path("/"));
        this.initializeResource();
    }

    @Override
    public IVirtualComponent getComponent() {
        return this;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getProject().getName();
        }
        return this.name;
    }

    @Override
    public String getDeployedName() {
        if (this.deploymentName != null) {
            return this.deploymentName;
        }
        StructureEdit core = null;
        IProject project = this.getProject();
        try {
            WorkbenchComponent component;
            if (project != null && this.getName() != null && (core = StructureEdit.getStructureEditForRead(project)) != null && core.getComponent() != null && (component = core.getComponent()).getName() != null && component.getName().length() > 0) {
                String string = this.deploymentName = component.getName();
                return string;
            }
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
        this.deploymentName = this.getProject().getName();
        return this.deploymentName;
    }

    @Override
    public boolean exists() {
        IProject project = this.getProject();
        return ModuleCoreNature.isFlexibleProject(project);
    }

    @Override
    public Properties getMetaProperties() {
        Properties props;
        if (this.metaProperties != null) {
            return this.metaProperties;
        }
        StructureEdit core = null;
        this.metaProperties = props = new Properties();
        try {
            core = StructureEdit.getStructureEditForRead(this.getProject());
            if (core == null) {
                Properties properties = props;
                return properties;
            }
            WorkbenchComponent component = core.getComponent();
            if (component == null) {
                Properties properties = props;
                return properties;
            }
            EList propList = component.getProperties();
            if (propList != null) {
                int i = 0;
                while (i < propList.size()) {
                    Property property = (Property)propList.get(i);
                    String name = property.getName();
                    String value = property.getValue();
                    if (value == null) {
                        value = "";
                        String message = "WARNING:  The component file in " + this.getProject().getName() + " has no value defined for the property: " + name;
                        ModulecorePlugin.logError(4, message, null);
                    }
                    props.setProperty(name, value);
                    ++i;
                }
            }
            this.metaProperties = props;
            Properties properties = props;
            return properties;
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
    }

    @Override
    public void setMetaProperties(Properties properties) {
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = core.getComponent();
            EList propList = component.getProperties();
            if (properties != null && !properties.isEmpty()) {
                Enumeration<Object> itr = properties.keys();
                while (itr.hasMoreElements()) {
                    String key = (String)itr.nextElement();
                    Property prop = ComponentcoreFactory.eINSTANCE.createProperty();
                    prop.setName(key);
                    prop.setValue(properties.getProperty(key));
                    int i = 0;
                    while (i < propList.size()) {
                        Property existing = (Property)propList.get(i);
                        if (existing.getName().equals(key)) {
                            propList.remove(existing);
                            break;
                        }
                        ++i;
                    }
                    propList.add(prop);
                }
                this.clearCache();
            }
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
    }

    public void clearMetaProperties() {
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = core.getComponent();
            component.getProperties().clear();
            this.clearCache();
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
    }

    @Override
    public void setMetaProperty(String key, String value) {
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = core.getComponent();
            EList properties = component.getProperties();
            int i = 0;
            while (i < properties.size()) {
                Property existing = (Property)properties.get(i);
                if (existing.getName().equals(key)) {
                    properties.remove(existing);
                    break;
                }
                ++i;
            }
            Property prop = ComponentcoreFactory.eINSTANCE.createProperty();
            prop.setName(key);
            prop.setValue(value);
            component.getProperties().add((Object)prop);
            this.clearCache();
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
    }

    @Override
    public IPath[] getMetaResources() {
        if (this.cacheMetaResources != null) {
            return this.cacheMetaResources;
        }
        StructureEdit moduleCore = null;
        ArrayList metaResources = new ArrayList();
        try {
            WorkbenchComponent component;
            moduleCore = StructureEdit.getStructureEditForRead(this.getProject());
            if (moduleCore != null && (component = moduleCore.getComponent()) != null) {
                metaResources.addAll(component.getMetadataResources());
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.dispose();
            }
        }
        this.cacheMetaResources = metaResources.toArray(new IPath[metaResources.size()]);
        return this.cacheMetaResources;
    }

    @Override
    public void setMetaResources(IPath[] theMetaResourcePaths) {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = moduleCore.getComponent();
            if (component != null) {
                int i = 0;
                while (i < theMetaResourcePaths.length) {
                    if (!component.getMetadataResources().contains((Object)theMetaResourcePaths[i])) {
                        component.getMetadataResources().add((Object)theMetaResourcePaths[i]);
                    }
                    ++i;
                }
                this.clearCache();
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(null);
                moduleCore.dispose();
            }
        }
    }

    public int getType() {
        return 64;
    }

    @Override
    public boolean isBinary() {
        boolean ret = (this.flag & 1) == 1;
        return ret;
    }

    @Override
    public void create(int updateFlags, IProgressMonitor aMonitor) throws CoreException {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = moduleCore.getComponent();
            if (component == null) {
                component = moduleCore.createWorkbenchModule(this.getProject().getName());
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(null);
                moduleCore.dispose();
            }
        }
    }

    public final IVirtualReference[] getRawReferences() {
        if (this.rawReferencesArray != null) {
            return this.rawReferencesArray;
        }
        StructureEdit core = null;
        ArrayList<IVirtualReference> references = new ArrayList<IVirtualReference>();
        try {
            WorkbenchComponent component;
            core = StructureEdit.getStructureEditForRead(this.getProject());
            if (core != null && core.getComponent() != null && (component = core.getComponent()) != null) {
                EList referencedComponents = component.getReferencedComponents();
                for (ReferencedComponent referencedComponent : referencedComponents) {
                    IVirtualReference vReference;
                    if (referencedComponent == null || (vReference = StructureEdit.createVirtualReference(this, referencedComponent)) == null || vReference.getReferencedComponent() == null || !vReference.getReferencedComponent().exists()) continue;
                    references.add(vReference);
                }
            }
            this.rawReferencesArray = references.toArray(new IVirtualReference[references.size()]);
            IVirtualReference[] iVirtualReferenceArray = this.rawReferencesArray;
            return iVirtualReferenceArray;
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
    }

    @Override
    public IVirtualReference[] getReferences(Map<String, Object> options) {
        if (this.referencesArray != null) {
            return this.referencesArray;
        }
        StructureEdit core = null;
        ArrayList<IVirtualReference> references = new ArrayList<IVirtualReference>();
        try {
            WorkbenchComponent component;
            core = StructureEdit.getStructureEditForRead(this.getProject());
            if (core != null && core.getComponent() != null && (component = core.getComponent()) != null) {
                EList referencedComponents = component.getReferencedComponents();
                for (ReferencedComponent referencedComponent : referencedComponents) {
                    IVirtualReference vReference;
                    if (referencedComponent == null || (vReference = StructureEdit.createVirtualReference(this, referencedComponent)) == null || vReference.getReferencedComponent() == null || !vReference.getReferencedComponent().exists()) continue;
                    references.add(vReference);
                    this.customizeCreatedReference(vReference, referencedComponent);
                }
            }
            this.referencesArray = references.toArray(new IVirtualReference[references.size()]);
            IVirtualReference[] iVirtualReferenceArray = this.referencesArray;
            return iVirtualReferenceArray;
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
    }

    protected void customizeCreatedReference(IVirtualReference reference, Object dependentObject) {
    }

    @Override
    public IVirtualReference[] getReferences() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return this.getReferences(map);
    }

    @Override
    public void addReferences(IVirtualReference[] references) {
        if (references == null || references.length == 0) {
            return;
        }
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.getProject());
            if (core == null) {
                return;
            }
            this.clearCache();
            WorkbenchComponent component = core.getComponent();
            ReferencedComponent referencedComponent = null;
            ComponentcorePackage.eINSTANCE.getComponentcoreFactory();
            IReferenceResolver resolver = null;
            int i = 0;
            while (i < references.length) {
                if (references[i] != null) {
                    resolver = ReferenceResolverUtil.getDefault().getResolver(references[i]);
                    referencedComponent = resolver.resolve(references[i]);
                    if (component != null) {
                        component.getReferencedComponents().add((Object)referencedComponent);
                    }
                }
                ++i;
            }
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
    }

    @Override
    public void setReferences(IVirtualReference[] references) {
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = core.getComponent();
            ReferencedComponent referencedComponent = null;
            this.clearCache();
            component.getReferencedComponents().clear();
            ComponentcorePackage.eINSTANCE.getComponentcoreFactory();
            IReferenceResolver resolver = null;
            int i = 0;
            while (i < references.length) {
                resolver = ReferenceResolverUtil.getDefault().getResolver(references[i]);
                referencedComponent = resolver.resolve(references[i]);
                if (referencedComponent != null) {
                    component.getReferencedComponents().add((Object)referencedComponent);
                }
                ++i;
            }
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
    }

    public int hashCode() {
        if (this.componentProject == null) {
            return super.hashCode();
        }
        int hash = HashUtil.SEED;
        hash = HashUtil.hash((int)hash, (Object)this.getProject().getName());
        hash = HashUtil.hash((int)hash, (Object)this.getName());
        hash = HashUtil.hash((int)hash, (boolean)this.isBinary());
        return hash;
    }

    public boolean equals(Object anOther) {
        if (this.componentProject == null) {
            return super.equals(anOther);
        }
        if (anOther == this) {
            return true;
        }
        if (anOther instanceof IVirtualComponent) {
            IVirtualComponent otherComponent = (IVirtualComponent)anOther;
            return this.getProject().equals((Object)otherComponent.getProject()) && this.getName().equals(otherComponent.getName()) && this.isBinary() == otherComponent.isBinary();
        }
        return false;
    }

    @Override
    public IVirtualReference getReference(String aComponentName) {
        if (this.referenceMap == null) {
            this.referenceMap = new Hashtable<String, IVirtualReference>();
        } else if (this.referenceMap.containsKey(aComponentName)) {
            return this.referenceMap.get(aComponentName);
        }
        IVirtualReference[] refs = this.getReferences();
        int i = 0;
        while (i < refs.length) {
            IVirtualReference reference = refs[i];
            if (reference.getReferencedComponent() != null && reference.getReferencedComponent().getName().equals(aComponentName)) {
                this.referenceMap.put(aComponentName, reference);
                return reference;
            }
            ++i;
        }
        return null;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    @Override
    public IVirtualFolder getRootFolder() {
        return this.rootFolder;
    }

    @Override
    public IProject getProject() {
        return this.componentProject;
    }

    @Override
    public IVirtualComponent[] getReferencingComponents() {
        Set<IProject> projects = IDependencyGraph.INSTANCE.getReferencingComponents(this.getProject());
        IVirtualComponent[] result = new IVirtualComponent[projects.size()];
        Iterator<IProject> i = projects.iterator();
        int j = 0;
        while (j < projects.size()) {
            result[j] = ComponentCore.createComponent(i.next());
            ++j;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeReference(IVirtualReference aReference) {
        StructureEdit core = null;
        try {
            if (aReference == null) {
                return;
            }
            core = StructureEdit.getStructureEditForWrite(this.getProject());
            if (core == null) {
                return;
            }
            this.clearCache();
            WorkbenchComponent component = core.getComponent();
            ReferencedComponent refComponent = this.getWorkbenchReferencedComponent(aReference, component);
            if (component == null) return;
            if (refComponent == null) return;
            component.getReferencedComponents().remove((Object)refComponent);
            return;
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
    }

    protected ReferencedComponent getWorkbenchReferencedComponent(IVirtualReference aReference, WorkbenchComponent component) {
        if (aReference == null || aReference.getReferencedComponent() == null || component == null) {
            return null;
        }
        EList referencedComponents = component.getReferencedComponents();
        URI uri = ReferenceResolverUtil.getDefault().getResolver(aReference).resolve(aReference).getHandle();
        int i = 0;
        while (i < referencedComponents.size()) {
            ReferencedComponent ref = (ReferencedComponent)referencedComponents.get(i);
            if (ref.getHandle().equals((Object)uri)) {
                return ref;
            }
            ++i;
        }
        return null;
    }

    protected boolean shouldCacheReferences() {
        return true;
    }

    public IVirtualReference[] getAllReferences() {
        if (this.shouldCacheReferences() && this.allReferences != null) {
            return this.allReferences;
        }
        StructureEdit core = null;
        ArrayList<IVirtualReference> references = new ArrayList<IVirtualReference>();
        try {
            WorkbenchComponent component;
            core = StructureEdit.getStructureEditForRead(this.getProject());
            if (core != null && core.getComponent() != null && (component = core.getComponent()) != null) {
                EList referencedComponents = component.getReferencedComponents();
                for (ReferencedComponent referencedComponent : referencedComponents) {
                    if (referencedComponent == null) continue;
                    IVirtualReference vReference = StructureEdit.createVirtualReference(this, referencedComponent);
                    if (vReference != null) {
                        vReference.setArchiveName(referencedComponent.getArchiveName());
                    }
                    if (vReference == null || vReference.getReferencedComponent() == null) continue;
                    references.add(vReference);
                }
            }
            this.allReferences = references.toArray(new IVirtualReference[references.size()]);
            IVirtualReference[] iVirtualReferenceArray = this.allReferences;
            return iVirtualReferenceArray;
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
    }

    public void flushCache() {
        this.clearCache();
    }

    protected void clearCache() {
        this.name = null;
        this.deploymentName = null;
        if (this.referenceMap != null) {
            this.referenceMap.clear();
        }
        this.rawReferencesArray = null;
        this.referencesArray = null;
        this.metaProperties = null;
        this.cacheMetaResources = null;
        this.allReferences = null;
    }

    public String toString() {
        return this.componentProject.toString();
    }

    protected class ResourceAdapter
    extends AdapterImpl {
        protected ResourceAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getFeatureID(null) == 3) {
                VirtualComponent.this.resourceChanged((Resource)notification.getNotifier());
            }
        }

        public boolean equals(Object arg0) {
            return ((Object)((Object)this)).getClass().equals(arg0.getClass());
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }
}

