/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.SnippetsPlugin;
import org.eclipse.wst.common.snippets.internal.VariableItemHelper;
import org.eclipse.wst.common.snippets.internal.dnd.SnippetTextTransfer;
import org.eclipse.wst.common.snippets.internal.ui.EntrySerializer;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;
import org.eclipse.wst.common.snippets.ui.ISnippetInsertion;

public class DefaultSnippetInsertion
implements ISnippetInsertion {
    private ISnippetItem fItem = null;
    private Transfer[] fSupportedTransfers = null;
    static /* synthetic */ Class class$0;

    protected Transfer[] createTransfers() {
        return new Transfer[]{SnippetTextTransfer.getTransferInstance(), TextTransfer.getInstance()};
    }

    protected void doInsert(IEditorPart editorPart, ITextEditor textEditor, IDocument document, ITextSelection textSelection) throws BadLocationException {
        String replacement = this.getInsertString(editorPart.getEditorSite().getShell());
        if (replacement != null && (replacement.length() > 0 || textSelection.getLength() > 0)) {
            replacement = StringUtils.replace(replacement, "\r\n", "\n");
            replacement = StringUtils.replace(replacement, "\r", "\n");
            String preferredEOL = null;
            if (document instanceof IDocumentExtension4) {
                preferredEOL = ((IDocumentExtension4)document).getDefaultLineDelimiter();
            } else {
                Method getLineDelimiter = null;
                try {
                    getLineDelimiter = document.getClass().getMethod("getLineDelimiter", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (getLineDelimiter != null) {
                    try {
                        preferredEOL = (String)getLineDelimiter.invoke((Object)document, new Object[0]);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }
            }
            if (preferredEOL == null) {
                preferredEOL = System.getProperty("line.separator");
            }
            if (!"\n".equals(preferredEOL) && preferredEOL != null) {
                replacement = StringUtils.replace(replacement, "\n", preferredEOL);
            }
            document.replace(textSelection.getOffset(), textSelection.getLength(), replacement);
        }
    }

    public void dragSetData(DragSourceEvent event, ISnippetItem item) {
        boolean isSimpleText = TextTransfer.getInstance().isSupportedType(event.dataType);
        if (isSimpleText) {
            IWorkbenchWindow window = SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            Shell shell = null;
            if (window != null) {
                shell = window.getShell();
            }
            String content = VariableItemHelper.getInsertString(shell, item);
            String systemEOL = System.getProperty("line.separator");
            content = StringUtils.replace(content, "\r\n", "\n");
            content = StringUtils.replace(content, "\r", "\n");
            if (!"\n".equals(systemEOL) && systemEOL != null) {
                content = StringUtils.replace(content, "\n", systemEOL);
            }
            event.data = content;
        } else {
            event.data = EntrySerializer.getInstance().toXML(item);
        }
    }

    protected String getInsertString(Shell host) {
        if (this.fItem == null) {
            return "";
        }
        String insertString = null;
        insertString = this.fItem.getVariables().length > 0 ? VariableItemHelper.getInsertString(host, this.fItem) : StringUtils.replace(this.fItem.getContentString(), "${cursor}", "");
        if (insertString == null) {
            insertString = "";
        }
        return insertString;
    }

    public Transfer[] getTransfers() {
        if (this.fSupportedTransfers == null) {
            this.fSupportedTransfers = this.createTransfers();
        }
        return this.fSupportedTransfers;
    }

    public void insert(IEditorPart editorPart) {
        if (editorPart == null) {
            return;
        }
        ITextEditor textEditor = null;
        if (editorPart instanceof ITextEditor) {
            textEditor = (ITextEditor)editorPart;
        }
        if (textEditor == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            textEditor = (ITextEditor)editorPart.getAdapter((Class)clazz);
        }
        if (textEditor == null) {
            Method getTextEditor = null;
            try {
                getTextEditor = editorPart.getClass().getMethod("getTextEditor", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            Object editor = null;
            if (getTextEditor != null) {
                try {
                    editor = getTextEditor.invoke((Object)editorPart, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
                if (editor instanceof IEditorPart && editor != editorPart && editor instanceof ITextEditor) {
                    textEditor = (ITextEditor)editor;
                }
            }
        }
        if (textEditor != null) {
            this.insertIntoTextEditor(textEditor);
        }
    }

    private void insertIntoTextEditor(ITextEditor editor) {
        if (this.isEditable(editor)) {
            IDocumentProvider docprovider = editor.getDocumentProvider();
            ISelectionProvider selprovider = editor.getSelectionProvider();
            if (docprovider != null && selprovider != null) {
                IDocument document = docprovider.getDocument((Object)editor.getEditorInput());
                ISelection selection = selprovider.getSelection();
                if (document != null && selection != null && selection instanceof ITextSelection) {
                    ITextSelection textSel = (ITextSelection)selection;
                    try {
                        this.doInsert((IEditorPart)editor, editor, document, textSel);
                    }
                    catch (Exception t) {
                        Logger.logException("Could not insert " + this.fItem, t);
                        editor.getSite().getShell().getDisplay().beep();
                    }
                }
            }
        }
    }

    private boolean isEditable(ITextEditor editor) {
        if (editor instanceof ITextEditorExtension2) {
            return ((ITextEditorExtension2)editor).validateEditorInputState();
        }
        return editor.isEditable();
    }

    public void setEditorPart(IEditorPart editorPart) {
    }

    public void setItem(ISnippetItem item) {
        this.fItem = item;
    }
}

