/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMCategory;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMNode;
import org.eclipse.wst.css.core.internal.metamodel.CSSMetaModel;
import org.eclipse.wst.css.core.internal.metamodel.util.CSSMetaModelFinder;
import org.eclipse.wst.css.core.internal.metamodel.util.CSSMetaModelUtil;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNodeList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.ui.internal.CSSUIMessages;
import org.eclipse.wst.css.ui.internal.properties.CSSTextPropertyDescriptor;
import org.eclipse.wst.sse.ui.views.properties.IPropertySourceExtension;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSPropertySource
implements IPropertySource,
IPropertySourceExtension {
    protected ICSSNode fNode = null;
    static final Class ADAPTER_KEY;
    final boolean PERF_GETDESCRIPTORS = false;
    private long time0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ADAPTER_KEY = clazz;
    }

    public CSSPropertySource(ICSSNode target) {
        this.fNode = target;
    }

    protected IPropertyDescriptor createDefaultPropertyDescriptor(String attributeName) {
        CSSTextPropertyDescriptor descriptor = new CSSTextPropertyDescriptor(attributeName, attributeName, this.fNode);
        return descriptor;
    }

    protected IPropertyDescriptor createPropertyDescriptor(CSSMMNode node, String category) {
        return this.createPropertyDescriptor(node.getName(), category);
    }

    protected IPropertyDescriptor createPropertyDescriptor(String name, String category) {
        CSSTextPropertyDescriptor descriptor = null;
        if (name != null && name.length() > 0) {
            name = name.toLowerCase();
            if (category == null) {
                category = CSSUIMessages.INFO_Not_Categorized_1;
            }
            descriptor = new CSSTextPropertyDescriptor(name, name, this.fNode, category);
        }
        return descriptor;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        CSSStyleDeclaration declaration;
        this.time0 = System.currentTimeMillis();
        CSSMetaModel metamodel = CSSMetaModelFinder.getInstance().findMetaModelFor(this.fNode);
        Iterator<CSSMMNode> iProperties = Collections.EMPTY_LIST.iterator();
        switch (this.fNode.getNodeType()) {
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                CSSMMNode mmParent = new CSSMetaModelUtil(metamodel).getMetaModelNodeFor(this.fNode);
                if (mmParent == null) break;
                iProperties = mmParent.getChildNodes();
                break;
            }
            case 9: {
                CSSMMNode mmNode = new CSSMetaModelUtil(metamodel).getMetaModelNodeFor(this.fNode);
                if (mmNode == null) break;
                iProperties = Collections.singletonList(mmNode).iterator();
                break;
            }
        }
        HashMap<String, String> categories = new HashMap<String, String>();
        Iterator iCategories = metamodel.getCategories();
        while (iCategories.hasNext()) {
            CSSMMCategory category = (CSSMMCategory)iCategories.next();
            categories.put(category.getName(), category.getCaption());
        }
        HashSet<String> declaredProperties = new HashSet<String>();
        if (iProperties.hasNext() && (declaration = this.getDeclarationNode()) != null) {
            ICSSNodeList nodeList = ((ICSSNode)declaration).getChildNodes();
            int nProps = nodeList != null ? nodeList.getLength() : 0;
            int i = 0;
            while (i < nProps) {
                String name;
                ICSSNode node = nodeList.item(i);
                if (node instanceof ICSSStyleDeclItem && (name = ((ICSSStyleDeclItem)node).getPropertyName()) != null && name.length() > 0) {
                    declaredProperties.add(name.toLowerCase());
                }
                ++i;
            }
        }
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
        while (iProperties.hasNext()) {
            IPropertyDescriptor descriptor;
            CSSMMNode node = iProperties.next();
            if (node.getType() != "CSSMM.Property" && node.getType() != "CSSMM.Descriptor") continue;
            String category = (String)categories.get(node.getAttribute("category"));
            String name = node.getName().toLowerCase();
            if (declaredProperties.contains(name)) {
                declaredProperties.remove(name);
            }
            if ((descriptor = this.createPropertyDescriptor(name, category)) == null) continue;
            descriptors.add(descriptor);
        }
        Iterator iRemains = declaredProperties.iterator();
        while (iRemains.hasNext()) {
            IPropertyDescriptor descriptor = this.createPropertyDescriptor((String)iRemains.next(), null);
            if (descriptor == null) continue;
            descriptors.add(descriptor);
        }
        IPropertyDescriptor[] resultArray = new IPropertyDescriptor[descriptors.size()];
        return descriptors.toArray(resultArray);
    }

    public Object getPropertyValue(Object name) {
        if (name == null) {
            return "";
        }
        String valueString = null;
        String nameString = name.toString();
        CSSStyleDeclaration declaration = null;
        switch (this.fNode.getNodeType()) {
            case 9: {
                valueString = ((ICSSStyleDeclItem)this.fNode).getCSSValueText();
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                declaration = (CSSStyleDeclaration)this.fNode.getFirstChild();
                if (declaration == null) break;
                valueString = declaration.getPropertyValue(nameString);
                break;
            }
            case 8: {
                valueString = ((CSSStyleDeclaration)this.fNode).getPropertyValue(nameString);
                break;
            }
            case 11: {
                ICSSNode parent = this.fNode;
                while (parent != null && !(parent instanceof ICSSStyleDeclItem)) {
                    parent = parent.getParentNode();
                }
                if (parent == null) break;
                valueString = ((ICSSStyleDeclItem)parent).getCSSValueText();
                break;
            }
        }
        if (valueString == null) {
            valueString = "";
        }
        return valueString;
    }

    public boolean isPropertySet(Object property) {
        String value;
        if (property == null) {
            return false;
        }
        CSSStyleDeclaration declaration = this.getDeclarationNode();
        return declaration != null && (value = declaration.getPropertyValue(property.toString())) != null && value.length() > 0;
    }

    public void resetPropertyValue(Object str) {
        if (str == null) {
            return;
        }
        CSSStyleDeclaration declaration = this.getDeclarationNode();
        if (declaration != null) {
            declaration.removeProperty(str.toString());
        }
    }

    public void setPropertyValue(Object name, Object value) {
        if (name == null) {
            return;
        }
        String valueString = value != null ? value.toString() : null;
        String nameString = name.toString();
        CSSStyleDeclaration declaration = this.getDeclarationNode();
        if (declaration != null) {
            try {
                if (valueString == null || valueString.length() <= 0) {
                    declaration.removeProperty(nameString);
                } else {
                    declaration.setProperty(nameString, valueString, "");
                }
            }
            catch (Exception exception) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                String title = CSSUIMessages.Title_InvalidValue;
                String message = CSSUIMessages.Message_InvalidValue;
                MessageDialog.openWarning((Shell)window.getShell(), (String)title, (String)message);
            }
        }
    }

    private CSSStyleDeclaration getDeclarationNode() {
        CSSStyleDeclaration declaration = null;
        switch (this.fNode.getNodeType()) {
            case 9: {
                declaration = (CSSStyleDeclaration)this.fNode.getParentNode();
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                declaration = (CSSStyleDeclaration)this.fNode.getFirstChild();
                break;
            }
            case 8: {
                declaration = (CSSStyleDeclaration)this.fNode;
                break;
            }
            case 11: {
                ICSSNode parent = this.fNode;
                while (parent != null && !(parent instanceof CSSStyleDeclaration)) {
                    parent = parent.getParentNode();
                }
                if (parent == null) break;
                declaration = (CSSStyleDeclaration)parent;
                break;
            }
        }
        return declaration;
    }

    public boolean isPropertyRemovable(Object name) {
        return true;
    }

    public void removeProperty(Object name) {
        if (name == null) {
            return;
        }
        CSSStyleDeclaration declaration = this.getDeclarationNode();
        if (declaration != null) {
            declaration.removeProperty(name.toString());
        }
    }
}

