/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDSchemaBuildingTools;

public class AddXSDModelGroupCommand
extends BaseCommand {
    XSDConcreteComponent parent;
    XSDCompositor xsdCompositor;
    XSDModelGroup newModelGroup;

    public AddXSDModelGroupCommand(String label, XSDConcreteComponent parent, XSDCompositor xsdCompositor) {
        super(label);
        this.parent = parent;
        this.xsdCompositor = xsdCompositor;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            this.beginRecording(this.parent.getElement());
            XSDConcreteComponent owner = this.getOwner();
            if (owner != null) {
                XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
                this.newModelGroup = this.createModelGroup();
                particle.setContent((XSDParticleContent)this.newModelGroup);
                XSDComplexTypeDefinition ctd = (XSDComplexTypeDefinition)owner;
                ctd.setContent((XSDComplexTypeContent)particle);
            }
            this.formatChild(this.parent.getElement());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endRecording();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.endRecording();
    }

    public void undo() {
        super.undo();
        if (this.parent instanceof XSDModelGroup) {
            XSDModelGroup model = (XSDModelGroup)this.parent;
            model.getContents().remove((Object)this.newModelGroup.getContainer());
        }
    }

    private XSDConcreteComponent getOwner() {
        XSDConcreteComponent owner = null;
        if (this.parent instanceof XSDElementDeclaration) {
            XSDElementDeclaration ed = (XSDElementDeclaration)this.parent;
            if (ed.getTypeDefinition() != null) {
                if (ed.getAnonymousTypeDefinition() == null) {
                    ed.setTypeDefinition(null);
                    XSDComplexTypeDefinition td = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
                    ed.setAnonymousTypeDefinition((XSDTypeDefinition)td);
                    owner = ed.getTypeDefinition();
                } else {
                    XSDComplexTypeDefinition td = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
                    ed.setAnonymousTypeDefinition((XSDTypeDefinition)td);
                    owner = td;
                }
            } else if (ed.getAnonymousTypeDefinition() == null) {
                XSDComplexTypeDefinition td = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
                ed.setAnonymousTypeDefinition((XSDTypeDefinition)td);
                owner = td;
            } else if (ed.getAnonymousTypeDefinition() instanceof XSDComplexTypeDefinition) {
                owner = ed.getAnonymousTypeDefinition();
            } else if (ed.getAnonymousTypeDefinition() instanceof XSDSimpleTypeDefinition) {
                XSDComplexTypeDefinition td = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
                ed.setAnonymousTypeDefinition((XSDTypeDefinition)td);
                owner = td;
            }
        } else if (this.parent instanceof XSDModelGroup) {
            this.newModelGroup = this.createModelGroup();
            ((XSDModelGroup)this.parent).getContents().add((Object)this.newModelGroup.getContainer());
        } else if (this.parent instanceof XSDComplexTypeDefinition) {
            XSDParticle particle;
            XSDComplexTypeDefinition ct = (XSDComplexTypeDefinition)this.parent;
            owner = this.parent;
            if (ct.getContent() instanceof XSDParticle && (particle = (XSDParticle)ct.getContent()).getContent() instanceof XSDModelGroup) {
                owner = null;
                this.newModelGroup = this.createModelGroup();
                XSDModelGroup newParent = (XSDModelGroup)particle.getContent();
                newParent.getContents().add((Object)this.newModelGroup.getContainer());
            }
        }
        return owner;
    }

    protected boolean adopt(XSDConcreteComponent model) {
        return false;
    }

    protected XSDModelGroup createModelGroup() {
        XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
        XSDParticle particle = factory.createXSDParticle();
        XSDModelGroup modelGroup = factory.createXSDModelGroup();
        modelGroup.setCompositor(this.xsdCompositor);
        particle.setContent((XSDParticleContent)modelGroup);
        this.addedXSDConcreteComponent = modelGroup;
        return modelGroup;
    }
}

