package org.rsdc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Database {

	/**
	 * Looks up the full name of a user in the database.
	 * 
	 * @param userid
	 *          the user id string
	 * @return the full name string
	 * @throws SQLException
	 *           if a database problem occurs
	 */
	public String lookupFullname(String userid) throws SQLException {

		Connection connection = null;
		PreparedStatement statement = null;
		ResultSet resultset = null;
		String fullname = "";

		try {
			Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
			connection = DriverManager.getConnection("jdbc:derby:C:\\Project1db");
			statement = connection
			    .prepareStatement("SELECT FULLNAME FROM WEB1.LOGIN WHERE USERID = ?");
			statement.setString(1, userid);
			resultset = statement.executeQuery();

			if (resultset.next())
				fullname = resultset.getString("FULLNAME").trim();

		} catch (Exception e) {
			e.printStackTrace();
		} finally {

			if (resultset != null)
				resultset.close();

			if (statement != null)
				statement.close();

			if (connection != null)
				connection.close();
		}

		return fullname;
	}
}
