/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.jpa.annotate.mapping.EntityRefPropertyElem;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.AssociationAnnotationWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.MappingAnnotationCtl;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.OrmUiUtil;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.SelectOrderByDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EntityMappingPage
extends WizardPage {
    protected static final int JOIN_PROPS_GROUP_MIN_HEIGHT = 400;
    private PersistenceUnit persistenceUnit;
    private ResourceManager resourceManager;
    protected IProject project;
    protected EntityRefPropertyElem refElem;
    protected IWizardPage nextPage;
    private MappingAnnotationCtl mappingCtl;
    private Group mappingGroup;
    private Text targetEntityText;
    private Button targetEntityBrowseBtn;
    private Text orderByText;
    private Button orderByBrowseBtn;

    public EntityMappingPage(PersistenceUnit persistenceUnit, ResourceManager resourceManager, IProject project, EntityRefPropertyElem refElem, IWizardPage nextPage) {
        super("Mapping Properties Page");
        this.persistenceUnit = persistenceUnit;
        this.resourceManager = resourceManager;
        this.project = project;
        this.refElem = refElem;
        this.nextPage = nextPage;
        this.setTitle(JptJpaUiMakePersistentMessages.MAPPING_PAGE_TITLE);
        this.setMessage(JptJpaUiMakePersistentMessages.MAPPING_PAGE_DESC);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        composite.setLayoutData((Object)gd);
        this.mappingCtl = new MappingAnnotationCtl(this.resourceManager, this.refElem);
        this.mappingGroup = (Group)this.mappingCtl.createMappingPropGroup(composite, 0);
        this.createTargetEntityGroup(composite);
        this.initFields();
        this.addListeners();
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.refElem.isOneToMany()) {
                this.mappingGroup.setText(JptJpaUiMakePersistentMessages.ONE_TO_MANY_PROP_DESC);
            } else if (this.refElem.isManyToMany()) {
                this.mappingGroup.setText(JptJpaUiMakePersistentMessages.MANY_TO_MANY_PROP_DESC);
            } else if (this.refElem.isManyToOne()) {
                this.mappingGroup.setText(JptJpaUiMakePersistentMessages.MANY_TO_ONE_PROP_DESC);
            } else if (this.refElem.isOneToOne()) {
                this.mappingGroup.setText(JptJpaUiMakePersistentMessages.ONE_TO_ONE_PROP_DESC);
            }
        }
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    protected Group createTargetEntityGroup(Composite parent) {
        Group targetEntityGroup = new Group(parent, 0);
        targetEntityGroup.setText(JptJpaUiMakePersistentMessages.TARGET_ENTITY_GROUP_DESC);
        GridLayout gl = new GridLayout(3, false);
        targetEntityGroup.setLayout((Layout)gl);
        targetEntityGroup.setLayoutData((Object)new GridData(768));
        AssociationAnnotationWizard.createLabel((Composite)targetEntityGroup, 1, JptJpaUiMakePersistentMessages.TARGET_ENTITY_GROUP_LABEL, -1);
        this.targetEntityText = AssociationAnnotationWizard.createText((Composite)targetEntityGroup, true, 1, 2048);
        this.targetEntityBrowseBtn = AssociationAnnotationWizard.createImageButton((Composite)targetEntityGroup, this.resourceManager.createImage(JptJpaUiImages.LIST_OF_VALUES), 1, 0, JptJpaUiMakePersistentMessages.BROWSE);
        AssociationAnnotationWizard.createLabel((Composite)targetEntityGroup, 1, JptJpaUiMakePersistentMessages.ORDER_BY_LABEL, -1);
        this.orderByText = AssociationAnnotationWizard.createText((Composite)targetEntityGroup, true, 1, 2048);
        this.orderByBrowseBtn = AssociationAnnotationWizard.createImageButton((Composite)targetEntityGroup, this.resourceManager.createImage(JptJpaUiImages.LIST_OF_VALUES), 1, 0, JptJpaUiMakePersistentMessages.BROWSE);
        return targetEntityGroup;
    }

    protected PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    protected void initFields() {
        this.mappingCtl.initFields();
        if (this.refElem.getRefEntityClassName() != null && this.targetEntityText != null) {
            this.targetEntityText.setText(this.refElem.getRefEntityClassName());
        }
        if (this.refElem.getOrderBy() != null && this.orderByText != null) {
            this.orderByText.setText(this.refElem.getOrderBy());
        }
    }

    protected void addListeners() {
        this.mappingCtl.addListeners();
        if (this.targetEntityText != null) {
            this.targetEntityText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EntityMappingPage.this.refElem.setRefEntityClassName(EntityMappingPage.this.targetEntityText.getText());
                }
            });
        }
        if (this.targetEntityBrowseBtn != null) {
            this.targetEntityBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String selectedClass = OrmUiUtil.selectJavaClass(EntityMappingPage.this.project);
                    if (selectedClass != null) {
                        EntityMappingPage.this.targetEntityText.setText(selectedClass);
                    }
                }
            });
        }
        if (this.orderByBrowseBtn != null) {
            this.orderByBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (EntityMappingPage.this.refElem.getRefEntityClassName() == null) {
                        AssociationAnnotationWizard.displayNoTargetEntityError(EntityMappingPage.this.refElem.getPropertyName());
                        return;
                    }
                    SelectOrderByDialog dlg = new SelectOrderByDialog(Display.getDefault().getActiveShell(), EntityMappingPage.this.resourceManager, EntityMappingPage.this.project, EntityMappingPage.this.refElem.getRefEntityClassName(), EntityMappingPage.this.refElem.getOrderBy());
                    if (dlg.open() == 0) {
                        String orderBy = dlg.getOrderByDisplayStr();
                        if (orderBy != null) {
                            EntityMappingPage.this.orderByText.setText(orderBy);
                        } else {
                            EntityMappingPage.this.orderByText.setText("");
                        }
                    }
                }
            });
        }
        if (this.orderByText != null) {
            this.orderByText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (EntityMappingPage.this.orderByText.getText().length() != 0) {
                        EntityMappingPage.this.refElem.setOrderBy(EntityMappingPage.this.orderByText.getText());
                    } else {
                        EntityMappingPage.this.refElem.setOrderBy(null);
                    }
                }
            });
        }
    }
}

