/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation;

import java.util.Collection;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.itemcreation.CreationData;
import org.eclipse.jst.pagedesigner.itemcreation.ITagCreationAdvisor;
import org.eclipse.jst.pagedesigner.itemcreation.command.ContainerCreationCommand;
import org.eclipse.jst.pagedesigner.itemcreation.command.ElementCustomizationCommand;
import org.eclipse.jst.pagedesigner.utils.BodyHelper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;

public abstract class AbstractTagCreationAdvisor
implements ITagCreationAdvisor {
    protected final CreationData _creationData;

    public AbstractTagCreationAdvisor(CreationData creationData) {
        this._creationData = creationData;
    }

    @Override
    public final void applyCustomization(IDOMModel model, Element tagElement) {
        ElementCustomizationCommand command = this.getElementCustomizationCommand(model, tagElement);
        if (command != null && command.canExecute()) {
            command.execute();
        }
    }

    protected abstract ElementCustomizationCommand getElementCustomizationCommand(IDOMModel var1, Element var2);

    @Override
    public final IDOMPosition checkAndApplyNecessaryContainers(IDOMModel model, IDOMPosition domPosition) {
        IDOMPosition position = DOMPositionHelper.splitText(domPosition);
        position = BodyHelper.adjustInsertPosition(this._creationData.getUri(), this._creationData.getTagName(), position);
        ContainerCreationCommand command = this.getContainerCreationCommand(position);
        if (command != null) {
            command.execute();
            Collection<IDOMPosition> collection = command.getResult();
            position = collection.size() == 1 ? collection.iterator().next() : null;
        }
        if (position == null) {
            return null;
        }
        return DOMPositionHelper.toDOMRefPosition(position);
    }

    protected abstract ContainerCreationCommand getContainerCreationCommand(IDOMPosition var1);
}

