/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.DebugEventListener;
import org.eclipse.wst.jsdt.chromium.InvalidContextException;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.Version;
import org.eclipse.wst.jsdt.chromium.internal.v8native.BreakpointManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ContextBuilder;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSessionManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DefaultResponseHandler;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ScriptManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8BlockingCallback;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandCallbackBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandOutput;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8ContextFilter;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8Helper;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8VersionFeatures;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.V8ProtocolUtil;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.CommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FailedCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SuccessCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.ContextlessDebuggerMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessageFactory;
import org.eclipse.wst.jsdt.chromium.util.AsyncFuture;
import org.eclipse.wst.jsdt.chromium.util.AsyncFutureRef;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;

public class DebugSession {
    private static final Logger LOGGER = Logger.getLogger(DebugSession.class.getName());
    private final ScriptManager scriptManager;
    private final V8CommandProcessor v8CommandProcessor;
    private final ContextBuilder contextBuilder;
    private DebugSessionManager sessionManager;
    private final BreakpointManager breakpointManager;
    private final ScriptManagerProxy scriptManagerProxy = new ScriptManagerProxy(this);
    private final DefaultResponseHandler defaultResponseHandler;
    private final JavascriptVm javascriptVm;
    private volatile Version vmVersion = null;

    public DebugSession(DebugSessionManager sessionManager, V8ContextFilter contextFilter, V8CommandOutput v8CommandOutput, JavascriptVm javascriptVm) {
        this.scriptManager = new ScriptManager(contextFilter, this);
        this.sessionManager = sessionManager;
        this.javascriptVm = javascriptVm;
        this.breakpointManager = new BreakpointManager(this);
        this.defaultResponseHandler = new DefaultResponseHandler(this);
        this.v8CommandProcessor = new V8CommandProcessor(v8CommandOutput, this.defaultResponseHandler, this);
        this.contextBuilder = new ContextBuilder(this);
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public V8CommandProcessor getV8CommandProcessor() {
        return this.v8CommandProcessor;
    }

    public DebugSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void onDebuggerDetached() {
        this.getSessionManager().onDebuggerDetached();
        this.getScriptManager().reset();
        this.contextBuilder.forceCancelContext();
    }

    public RelayOk sendMessageAsync(ContextlessDebuggerMessage message, boolean isImmediate, V8CommandProcessor.V8HandlerCallback commandCallback, SyncCallback syncCallback) {
        return this.v8CommandProcessor.sendV8CommandAsync(message, isImmediate, commandCallback, syncCallback);
    }

    JavascriptVm getJavascriptVm() {
        return this.javascriptVm;
    }

    public Version getVmVersion() {
        return this.vmVersion;
    }

    public DebugEventListener getDebugEventListener() {
        return this.getSessionManager().getDebugEventListener();
    }

    public BreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public ScriptManagerProxy getScriptManagerProxy() {
        return this.scriptManagerProxy;
    }

    public ContextBuilder getContextBuilder() {
        return this.contextBuilder;
    }

    public boolean recreateCurrentContext() {
        ContextBuilder.ExpectingBacktraceStep step = this.contextBuilder.startRebuildCurrentContext();
        if (step == null) {
            return false;
        }
        this.defaultResponseHandler.getBreakpointProcessor().processNextStep(step);
        return true;
    }

    public void suspend(final JavascriptVm.SuspendCallback suspendCallback) {
        V8CommandCallbackBase v8Callback = new V8CommandCallbackBase(){

            @Override
            public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                if (suspendCallback != null) {
                    suspendCallback.failure(new Exception(message));
                }
            }

            @Override
            public void success(SuccessCommandResponse successResponse) {
                ContextBuilder.ExpectingBreakEventStep step1;
                if (suspendCallback != null) {
                    suspendCallback.success();
                }
                if ((step1 = DebugSession.this.contextBuilder.buildNewContextWhenIdle()) == null) {
                    return;
                }
                ContextBuilder.ExpectingBacktraceStep step2 = step1.setContextState(Collections.<Breakpoint>emptyList(), null);
                DebugSession.this.defaultResponseHandler.getBreakpointProcessor().processNextStep(step2);
            }
        };
        this.sendMessageAsync(DebuggerMessageFactory.suspend(), true, v8Callback, null);
    }

    public void startCommunication() throws MethodIsBlockingException {
        V8BlockingCallback<Void> callback = new V8BlockingCallback<Void>(){

            @Override
            public Void messageReceived(CommandResponse response) {
                ContextBuilder.ExpectingBreakEventStep step1;
                Boolean running;
                SuccessCommandResponse successResponse = response.asSuccess();
                if (successResponse == null) {
                    return null;
                }
                Version vmVersion = V8ProtocolUtil.parseVersionResponse(successResponse);
                DebugSession.this.vmVersion = vmVersion;
                if (V8VersionFeatures.isRunningAccurate(vmVersion) && (running = Boolean.valueOf(successResponse.running())) == Boolean.FALSE && (step1 = DebugSession.this.contextBuilder.buildNewContextWhenIdle()) != null) {
                    ContextBuilder.ExpectingBacktraceStep step2 = step1.setContextState(Collections.<Breakpoint>emptyList(), null);
                    DebugSession.this.defaultResponseHandler.getBreakpointProcessor().processNextStep(step2);
                }
                return null;
            }

            @Override
            protected Void handleSuccessfulResponse(SuccessCommandResponse response) {
                throw new UnsupportedOperationException();
            }
        };
        V8Helper.callV8Sync(this.v8CommandProcessor, DebuggerMessageFactory.version(), callback);
    }

    public RelayOk sendLoopbackMessage(Runnable callback, SyncCallback syncCallback) {
        return this.v8CommandProcessor.runInDispatchThread(callback, syncCallback);
    }

    public void maybeRethrowContextException(InternalContext.ContextDismissedCheckedException e) {
    }

    public RelayOk maybeRethrowContextException(InternalContext.ContextDismissedCheckedException e, SyncCallback syncCallback) {
        if (syncCallback != null) {
            syncCallback.callbackDone(new InvalidContextException(e));
        }
        return new RelayOk(){};
    }

    public static class ScriptManagerProxy {
        private final DebugSession debugSession;
        private final AsyncFutureRef<Void> scriptsLoadedFuture = new AsyncFutureRef();

        ScriptManagerProxy(DebugSession debugSession) {
            this.debugSession = debugSession;
        }

        public RelayOk getAllScripts(final JavascriptVm.ScriptsCallback callback, SyncCallback syncCallback) {
            if (!this.scriptsLoadedFuture.isInitialized()) {
                this.scriptsLoadedFuture.initializeRunning(new ScriptsRequester());
            }
            RelaySyncCallback relay = new RelaySyncCallback(syncCallback);
            final RelaySyncCallback.Guard guard = relay.newGuard();
            AsyncFuture.Callback<Void> futureCallback = new AsyncFuture.Callback<Void>(){

                @Override
                public void done(Void res) {
                    if (callback != null) {
                        RelayOk relayOk = ScriptManagerProxy.this.getAllScriptsAsync(callback, guard.getRelay());
                        guard.discharge(relayOk);
                    }
                }
            };
            return this.scriptsLoadedFuture.getAsync(futureCallback, guard.asSyncCallback());
        }

        private RelayOk getAllScriptsAsync(final JavascriptVm.ScriptsCallback callback, RelaySyncCallback relay) {
            return this.debugSession.getV8CommandProcessor().runInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    callback.success(ScriptManagerProxy.this.debugSession.getScriptManager().allScripts());
                }
            }, relay.getUserSyncCallback());
        }

        private class ScriptsRequester
        implements AsyncFuture.Operation<Void> {
            private ScriptsRequester() {
            }

            @Override
            public RelayOk start(final AsyncFuture.Callback<Void> requestCallback, SyncCallback syncCallback) {
                V8Helper.ScriptLoadCallback scriptLoadCallback = new V8Helper.ScriptLoadCallback(){

                    @Override
                    public void success() {
                        requestCallback.done(null);
                    }

                    @Override
                    public void failure(String message) {
                        LOGGER.log(Level.SEVERE, null, new Exception("Failed to load scripts from remote: " + message));
                        requestCallback.done(null);
                    }
                };
                return V8Helper.reloadAllScriptsAsync(ScriptManagerProxy.this.debugSession, scriptLoadCallback, syncCallback);
            }
        }
    }
}

