/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.refactor;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.impl.WSDLElementImpl;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.util.NodeAssociationManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;

public class RenameEnablementTester
extends PropertyTester {
    public static final String RENAME_ENABLED = "renameEnabled";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!RENAME_ENABLED.equals(property)) {
            return false;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return false;
        }
        IEditorPart editor = activePage.getActiveEditor();
        if (editor == null) {
            return false;
        }
        Definition definition = (Definition)editor.getAdapter(Definition.class);
        if (definition == null) {
            return false;
        }
        return this.canEnable(definition, receiver);
    }

    private boolean canEnable(Definition definition, Object selectedObject) {
        if (selectedObject instanceof IStructuredSelection) {
            IStructuredSelection fStructuredSelection = (IStructuredSelection)selectedObject;
            if ((selectedObject = fStructuredSelection.getFirstElement()) instanceof WSDLBaseAdapter) {
                WSDLBaseAdapter wsdlObject = (WSDLBaseAdapter)selectedObject;
                if (wsdlObject.isReadOnly()) {
                    return false;
                }
                selectedObject = wsdlObject.getTarget();
            }
            if (selectedObject instanceof XSDNamedComponent) {
                return this.doCanEnableXSDSelection((XSDNamedComponent)selectedObject);
            }
            if (selectedObject instanceof WSDLElementImpl) {
                return this.doCanEnableWSDLSelection((WSDLElement)((WSDLElementImpl)selectedObject));
            }
            if (selectedObject instanceof Element) {
                Element node = (Element)selectedObject;
                if (definition != null) {
                    Object concreteComponent = new NodeAssociationManager().getModelObjectForNode(definition, node);
                    return this.canEnable(definition, concreteComponent);
                }
            }
        }
        return false;
    }

    private boolean doCanEnableXSDSelection(XSDNamedComponent selectedObject) {
        XSDElementDeclaration element;
        XSDTypeDefinition type;
        XSDConcreteComponent parent;
        XSDElementDeclaration element2;
        if (!(selectedObject.getElement() instanceof IDOMElement)) {
            return false;
        }
        if (selectedObject instanceof XSDElementDeclaration && (element2 = (XSDElementDeclaration)selectedObject).isElementDeclarationReference()) {
            return false;
        }
        return !(selectedObject instanceof XSDTypeDefinition) || !((parent = (type = (XSDTypeDefinition)selectedObject).getContainer()) instanceof XSDElementDeclaration ? (element = (XSDElementDeclaration)parent).getAnonymousTypeDefinition().equals(type) : parent instanceof XSDAttributeDeclaration && (element = (XSDAttributeDeclaration)parent).getAnonymousTypeDefinition().equals(type));
    }

    private boolean doCanEnableWSDLSelection(WSDLElement selectedObject) {
        return selectedObject instanceof Binding || selectedObject instanceof PortType || selectedObject instanceof Message;
    }
}

