/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.util;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowMessages;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLink;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowNode;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;
import org.eclipse.osgi.util.NLS;

public class PageflowValidation {
    private static PageflowValidation instance;

    private PageflowValidation() {
    }

    public static PageflowValidation getInstance() {
        if (instance == null) {
            instance = new PageflowValidation();
        }
        return instance;
    }

    public boolean isValidLinkForCreation(PageflowNode source, PageflowNode target) {
        return source != null && target != null;
    }

    public boolean isValidLinkForProperty(PageflowLink link) {
        return true;
    }

    public boolean isValidLinkForNavigationRule(PageflowLink link) {
        return true;
    }

    public String isValidLink(PageflowLink link) {
        String outcome;
        String errorMessage = null;
        if (link.getSource() instanceof PageflowPage && link.getTarget() instanceof PageflowPage && (outcome = link.getOutcome()) != null && outcome.length() >= 0) {
            String webPath = ((PageflowPage)link.getSource()).getPath();
            if (webPath != null) {
                String projectPath = WebrootUtil.getProjectPath(link, webPath);
                Path resourcePath = new Path(projectPath);
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IResource resource = workspaceRoot.findMember((IPath)resourcePath);
                if (resource == null || !resource.exists()) {
                    errorMessage = NLS.bind((String)PageflowMessages.Pageflow_Validation_UndefinedOutcome, (Object)outcome, (Object)webPath);
                }
            } else {
                errorMessage = PageflowMessages.Pageflow_Validation_MissingSourcePage;
            }
        }
        return errorMessage;
    }

    public boolean isExistedPage(Pageflow pageflow, PageflowPage page) {
        if (pageflow == null || page == null || page.getPath() == null) {
            return false;
        }
        return this.isExistedPage(pageflow, page.getPath());
    }

    public boolean isExistedPage(Pageflow pageflow, String pagePath) {
        if (pageflow == null || pagePath == null) {
            return false;
        }
        for (PageflowNode existedNode : pageflow.getNodes()) {
            if (!(existedNode instanceof PageflowPage) || ((PageflowPage)existedNode).getPath() == null || !((PageflowPage)existedNode).getPath().equalsIgnoreCase(pagePath)) continue;
            return true;
        }
        return false;
    }

    public String getNotifyMessage(PageflowPage page) {
        String errorMessage = null;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String pagePath = page.getPath();
        if (pagePath != null && pagePath.length() > 0) {
            String resourceName = WebrootUtil.getProjectPath(page, pagePath);
            Path resourcePath = new Path(resourceName);
            IResource resource = workspaceRoot.findMember((IPath)resourcePath);
            if (resource != null && resource.exists()) {
                if (resourcePath.getFileExtension() != null && !WebrootUtil.isValidWebFile((IPath)resourcePath)) {
                    errorMessage = NLS.bind((String)PageflowMessages.Pageflow_Validation_InvalidWebPage, (Object)pagePath);
                }
            } else {
                errorMessage = NLS.bind((String)PageflowMessages.Pageflow_Validation_NotExitedWebPage, (Object)pagePath);
            }
        } else {
            errorMessage = PageflowMessages.Pageflow_Validation_MissingWebPage;
        }
        return errorMessage;
    }

    public static boolean isValidActionEL(String actionEL) {
        return actionEL != null && actionEL.length() > 3 && actionEL.substring(0, 2).equalsIgnoreCase("#{") && actionEL.substring(actionEL.length() - 1, actionEL.length()).equalsIgnoreCase("}");
    }

    public static String getManagedBeanforAction(String actionEL) {
        String managedBeanName = null;
        if (PageflowValidation.isValidActionEL(actionEL)) {
            actionEL = actionEL.substring(2, actionEL.length() - 1);
            String[] actionParts = actionEL.split("[.]");
            managedBeanName = actionParts[0];
        }
        return managedBeanName;
    }
}

