/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.ui;

import java.lang.ref.WeakReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditor;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.ui.JPADiagramEditorInput;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.CreateDiagramJob;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.Wrp;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenJpaDiagramActionDelegate
implements IObjectActionDelegate {
    private static final String ERROR_OPENING_DIAGRAM = JPAEditorMessages.OpenJpaDiagramActionDelegate_openJPADiagramErrorMsg;
    private Shell shell;
    private WeakReference<ISelection> selectionRef = new WeakReference<Object>(null);

    public static IDiagramContainer openDiagramEditor(final Diagram diagram) {
        String diagramName = diagram.getName();
        ModelIntegrationUtil.getProjectByDiagram(diagramName);
        JPADiagramEditorInput diagramEditorInput = JPADiagramEditorInput.createEditorInput(diagram, "org.eclipse.jpt.jpadiagrameditor.ui.provider.JPAEditorDiagramTypeProvider");
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        final IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        Wrp wrp = new Wrp();
        try {
            final IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)workbenchPage, (IEditorInput)diagramEditorInput, (String)"org.eclipse.jpt.jpadiagrameditor.ui");
            if (editorPart instanceof JPADiagramEditor) {
                PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                    public boolean preShutdown(IWorkbench workbench, boolean forced) {
                        ModelIntegrationUtil.deleteDiagramXMIFile(diagram);
                        workbenchPage.closeEditor(editorPart, true);
                        return true;
                    }

                    public void postShutdown(IWorkbench workbench) {
                    }
                });
            }
        }
        catch (PartInitException e) {
            JPADiagramEditorPlugin.logError("Can't open JPA editor", e);
        }
        return (JPADiagramEditor)((Object)wrp.getObj());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        PersistenceUnit persistenceUnit = null;
        try {
            persistenceUnit = this.obtainJpaProjectAndPersistenceUnit((ISelection)this.selectionRef.get());
        }
        catch (Exception e) {
            this.handleException(e);
            return;
        }
        if (persistenceUnit == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)JPAEditorMessages.OpenJpaDiagramActionDelegate_noPersistenceUnitTitle, (String)JPAEditorMessages.OpenJpaDiagramActionDelegate_noPersistenceUnitMsg);
            return;
        }
        final CreateDiagramJob createDiagramRunnable = new CreateDiagramJob(persistenceUnit, 10, true);
        createDiagramRunnable.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        createDiagramRunnable.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                OpenJpaDiagramActionDelegate.this.shell.getDisplay().syncExec((Runnable)new OpenEditorRunnable(createDiagramRunnable.getDiagram()));
            }
        });
        createDiagramRunnable.setUser(true);
        createDiagramRunnable.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectionRef = new WeakReference<ISelection>(selection);
    }

    protected PersistenceUnit obtainJpaProjectAndPersistenceUnit(ISelection selection) throws CoreException {
        JpaProject jpaProject = null;
        Object firstElement = ((IStructuredSelection)selection).getFirstElement();
        if (firstElement instanceof JpaModel) {
            jpaProject = ((JpaModel)firstElement).getJpaProject();
        } else if (firstElement instanceof IProject) {
            jpaProject = JpaArtifactFactory.instance().getJpaProject((IProject)firstElement);
            int cnt = 0;
            while (jpaProject == null && cnt < 25) {
                jpaProject = JpaArtifactFactory.instance().getJpaProject((IProject)firstElement);
                if (jpaProject == null) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        JPADiagramEditorPlugin.logError("Thread sleep interrupted", e);
                    }
                }
                ++cnt;
            }
        }
        return JpaArtifactFactory.instance().getPersistenceUnit(jpaProject);
    }

    private void handleException(Exception e) {
        JPADiagramEditorPlugin.logError(ERROR_OPENING_DIAGRAM, e);
        ErrStatus status = new ErrStatus(4, "org.eclipse.jpt.jpadiagrameditor.ui", e.toString(), e);
        ErrorDialog.openError((Shell)this.shell, (String)JPAEditorMessages.OpenJpaDiagramActionDelegate_openJPADiagramErrorMsgTitle, (String)ERROR_OPENING_DIAGRAM, (IStatus)status);
    }

    private class ErrStatus
    extends Status {
        public ErrStatus(int severity, String pluginId, String message, Throwable exception) {
            super(severity, message, message, exception);
        }

        public IStatus[] getChildren() {
            StackTraceElement[] st = this.getException().getStackTrace();
            IStatus[] res = new IStatus[st == null ? 0 : st.length];
            int i = 0;
            while (i < st.length) {
                res[i] = new Status(4, "org.eclipse.jpt.jpadiagrameditor.ui", st[i].toString());
                ++i;
            }
            return res;
        }
    }

    private class OpenEditorRunnable
    implements Runnable {
        private Diagram diagram;

        private OpenEditorRunnable(Diagram diagram) {
            this.diagram = diagram;
        }

        @Override
        public void run() {
            OpenJpaDiagramActionDelegate.openDiagramEditor(this.diagram);
        }
    }
}

