/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;

public class ResizeJPAEntityFeature
extends DefaultResizeShapeFeature {
    public ResizeJPAEntityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canResizeShape(IResizeShapeContext context) {
        boolean canResize = super.canResizeShape(context);
        if (canResize) {
            PersistentType c;
            Shape shape = context.getShape();
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
            if (bo == null) {
                return false;
            }
            if (bo instanceof PersistentType && (c = (PersistentType)bo).getName() != null && c.getName().length() == 1) {
                canResize = false;
            }
        }
        return canResize;
    }

    private void resizeContainerShape(IResizeShapeContext context) {
        super.resizeShape(context);
    }

    public void resizeShape(final IResizeShapeContext context) {
        final ContainerShape entityShape = (ContainerShape)context.getShape();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)entityShape);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                ResizeJPAEntityFeature.this.resizeContainerShape(context);
                JPAEditorUtil.rearrangeAllConnections(entityShape, ResizeJPAEntityFeature.this.getFeatureProvider(), false);
            }
        });
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }
}

