/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jpt.common.ui.internal.jface.ModelItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.internal.jface.NullItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.internal.jface.StaticItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumConstant;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaEnum;
import org.eclipse.jpt.jaxb.core.context.java.JavaEnumMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaType;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiImages;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.JaxbMappingImageHelper;

public abstract class AbstractNavigatorItemLabelProviderFactory
implements ItemExtendedLabelProvider.Factory {
    protected static final String[] IMAGE_ASPECT_NAMES = new String[]{"defaultMappingKey", "mapping"};

    protected AbstractNavigatorItemLabelProviderFactory() {
    }

    public ItemExtendedLabelProvider buildProvider(Object item, ItemExtendedLabelProvider.Manager manager) {
        if (item instanceof JaxbContextRoot) {
            return this.buildJaxbContextRootProvider((JaxbContextRoot)item, manager);
        }
        if (item instanceof JaxbPackage) {
            return this.buildJaxbPackageProvider((JaxbPackage)item, manager);
        }
        if (item instanceof JavaClass) {
            return this.buildJavaClassProvider((JavaClass)item, manager);
        }
        if (item instanceof JavaEnum) {
            return this.buildJavaEnumProvider((JavaEnum)item, manager);
        }
        if (item instanceof JavaPersistentAttribute) {
            return this.buildJavaPersistentAttributeProvider((JavaPersistentAttribute)item, manager);
        }
        if (item instanceof JaxbEnumConstant) {
            return this.buildJaxbEnumConstantProvider((JaxbEnumConstant)item, manager);
        }
        return NullItemExtendedLabelProvider.instance();
    }

    protected ItemExtendedLabelProvider buildJaxbEnumConstantProvider(JaxbEnumConstant enumConstant, ItemExtendedLabelProvider.Manager manager) {
        return new StaticItemExtendedLabelProvider(JptJaxbUiImages.ENUM_CONSTANT, enumConstant.getName(), manager);
    }

    protected ItemExtendedLabelProvider buildJaxbPackageProvider(JaxbPackage pkg, ItemExtendedLabelProvider.Manager manager) {
        return new StaticItemExtendedLabelProvider(JptJaxbUiImages.JAXB_PACKAGE, pkg.getName(), this.buildJaxbPackageDescription(pkg), manager);
    }

    protected String buildJaxbPackageDescription(JaxbPackage pkg) {
        StringBuilder sb = new StringBuilder();
        sb.append(pkg.getName());
        sb.append(" - ");
        sb.append(pkg.getResource().getFullPath().makeRelative());
        return sb.toString();
    }

    protected ItemExtendedLabelProvider buildJaxbContextRootProvider(JaxbContextRoot root, ItemExtendedLabelProvider.Manager manager) {
        return new StaticItemExtendedLabelProvider(JptJaxbUiImages.JAXB_CONTENT, JptJaxbUiMessages.JAXB_CONTENT_LABEL, this.buildJaxbContextRootDescription(root), manager);
    }

    protected String buildJaxbContextRootDescription(JaxbContextRoot root) {
        StringBuilder sb = new StringBuilder();
        sb.append(JptJaxbUiMessages.JAXB_CONTENT_LABEL);
        sb.append(" - ");
        sb.append(root.getResource().getFullPath().makeRelative());
        return sb.toString();
    }

    protected ItemExtendedLabelProvider buildJavaClassProvider(JavaClass item, ItemExtendedLabelProvider.Manager manager) {
        return new ModelItemExtendedLabelProvider((Object)item, manager, this.buildJavaClassImageDescriptorModel(item), this.buildJavaTypeTextModel((JavaType)item), this.buildJavaTypeDescriptionModel((JavaType)item));
    }

    public PropertyValueModel<ImageDescriptor> buildJavaClassImageDescriptorModel(JavaClass item) {
        return new JavaClassImageDescriptorModel(item);
    }

    protected ItemExtendedLabelProvider buildJavaEnumProvider(JavaEnum item, ItemExtendedLabelProvider.Manager manager) {
        return new ModelItemExtendedLabelProvider((Object)item, manager, this.buildJavaEnumImageDescriptorModel(item), this.buildJavaTypeTextModel((JavaType)item), this.buildJavaTypeDescriptionModel((JavaType)item));
    }

    public PropertyValueModel<ImageDescriptor> buildJavaEnumImageDescriptorModel(JavaEnum item) {
        return new JavaEnumImageDescriptorModel(item);
    }

    public PropertyValueModel<String> buildJavaTypeTextModel(JavaType item) {
        return new StaticPropertyValueModel((Object)item.getTypeName().getTypeQualifiedName());
    }

    public PropertyValueModel<String> buildJavaTypeDescriptionModel(JavaType item) {
        return new StaticPropertyValueModel((Object)this.buildJavaTypeDescription(item));
    }

    protected String buildJavaTypeDescription(JavaType item) {
        StringBuilder sb = new StringBuilder();
        sb.append(item.getTypeName().getFullyQualifiedName());
        IResource resource = item.getResource();
        if (resource != null) {
            sb.append(" - ");
            sb.append(resource.getFullPath().makeRelative());
        }
        return sb.toString();
    }

    protected ItemExtendedLabelProvider buildJavaPersistentAttributeProvider(JavaPersistentAttribute item, ItemExtendedLabelProvider.Manager manager) {
        return new ModelItemExtendedLabelProvider((Object)item, manager, this.buildJavaPersistentAttributeImageDescriptorModel(item), this.buildJavaPersistentAttributeTextModel(item), this.buildJavaPersistentAttributeDescriptionModel(item));
    }

    public PropertyValueModel<ImageDescriptor> buildJavaPersistentAttributeImageDescriptorModel(JavaPersistentAttribute item) {
        return new PropertyAspectAdapter<JavaPersistentAttribute, ImageDescriptor>(IMAGE_ASPECT_NAMES, item){

            protected ImageDescriptor buildValue_() {
                return AbstractNavigatorItemLabelProviderFactory.this.buildJavaPersistentAttributeImageDescriptor(((JavaPersistentAttribute)this.subject).getMappingKey());
            }
        };
    }

    protected ImageDescriptor buildJavaPersistentAttributeImageDescriptor(String mappingKey) {
        return JaxbMappingImageHelper.imageDescriptorForAttributeMapping(mappingKey);
    }

    public PropertyValueModel<String> buildJavaPersistentAttributeTextModel(JavaPersistentAttribute item) {
        return new StaticPropertyValueModel((Object)this.buildJavaPersistentAttributeText(item));
    }

    protected String buildJavaPersistentAttributeText(JavaPersistentAttribute item) {
        StringBuffer sb = new StringBuffer();
        if (item.isInherited()) {
            sb.append(item.getDeclaringTypeName().getTypeQualifiedName());
            sb.append('.');
        }
        sb.append(item.getName());
        return sb.toString();
    }

    public PropertyValueModel<String> buildJavaPersistentAttributeDescriptionModel(JavaPersistentAttribute item) {
        return new StaticPropertyValueModel((Object)this.buildJavaPersistentAttributeDescription(item));
    }

    protected String buildJavaPersistentAttributeDescription(JavaPersistentAttribute item) {
        return item.getName();
    }

    protected class JavaClassImageDescriptorModel
    extends AspectPropertyValueModelAdapter<JavaClass, ImageDescriptor> {
        protected final PropertyValueModel<Boolean> isXmlRegistryModel;
        protected final PropertyValueModel<JavaClassMapping> mappingModel;
        protected final PropertyValueModel<Boolean> isXmlTransientModel;
        protected final PropertyChangeListener propertyChangeListener;

        public JavaClassImageDescriptorModel(JavaClass subject) {
            super((PropertyValueModel)new StaticPropertyValueModel((Object)subject));
            this.isXmlRegistryModel = this.buildIsXmlRegistryModel();
            this.mappingModel = this.buildMappingModel();
            this.isXmlTransientModel = this.buildIsXmlTransientModel();
            this.propertyChangeListener = this.buildPropertyChangeListener();
        }

        protected PropertyValueModel<Boolean> buildIsXmlRegistryModel() {
            return new PropertyAspectAdapter<JavaClass, Boolean>("xmlRegistry", (JavaClass)this.subject){

                protected Boolean buildValue_() {
                    return ((JavaClass)this.subject).getXmlRegistry() != null;
                }
            };
        }

        protected PropertyValueModel<JavaClassMapping> buildMappingModel() {
            return new PropertyAspectAdapter<JavaClass, JavaClassMapping>("mapping", (JavaClass)this.subject){

                protected JavaClassMapping buildValue_() {
                    return ((JavaClass)this.subject).getMapping();
                }
            };
        }

        protected PropertyValueModel<Boolean> buildIsXmlTransientModel() {
            return new PropertyAspectAdapter<JavaClassMapping, Boolean>(this.mappingModel, new String[]{"xmlTransient"}){

                protected Boolean buildValue_() {
                    return ((JavaClassMapping)this.subject).isXmlTransient();
                }
            };
        }

        protected PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    JavaClassImageDescriptorModel.this.aspectChanged();
                }
            };
        }

        protected void aspectChanged() {
            super.aspectChanged();
        }

        protected ImageDescriptor buildValue_() {
            if (this.mappingModel.getValue() != null && this.isXmlTransientModel.getValue() == Boolean.TRUE) {
                return JptJaxbUiImages.JAXB_TRANSIENT_CLASS;
            }
            if (this.isXmlRegistryModel.getValue() == Boolean.TRUE) {
                return JptJaxbUiImages.JAXB_REGISTRY;
            }
            return JptJaxbUiImages.JAXB_CLASS;
        }

        protected void engageSubject_() {
            this.isXmlRegistryModel.addPropertyChangeListener("value", this.propertyChangeListener);
            this.mappingModel.addPropertyChangeListener("value", this.propertyChangeListener);
            this.isXmlTransientModel.addPropertyChangeListener("value", this.propertyChangeListener);
        }

        protected void disengageSubject_() {
            this.isXmlRegistryModel.removePropertyChangeListener("value", this.propertyChangeListener);
            this.mappingModel.removePropertyChangeListener("value", this.propertyChangeListener);
            this.isXmlTransientModel.removePropertyChangeListener("value", this.propertyChangeListener);
        }
    }

    protected class JavaEnumImageDescriptorModel
    extends AspectPropertyValueModelAdapter<JavaEnum, ImageDescriptor> {
        protected final PropertyValueModel<JavaEnumMapping> mappingModel;
        protected final PropertyValueModel<Boolean> isXmlTransientModel;
        protected final PropertyChangeListener propertyChangeListener;

        public JavaEnumImageDescriptorModel(JavaEnum subject) {
            super((PropertyValueModel)new StaticPropertyValueModel((Object)subject));
            this.mappingModel = this.buildMappingModel();
            this.isXmlTransientModel = this.buildIsXmlTransientModel();
            this.propertyChangeListener = this.buildPropertyChangeListener();
        }

        protected PropertyValueModel<JavaEnumMapping> buildMappingModel() {
            return new PropertyAspectAdapter<JavaEnum, JavaEnumMapping>("mapping", (JavaEnum)this.subject){

                protected JavaEnumMapping buildValue_() {
                    return ((JavaEnum)this.subject).getMapping();
                }
            };
        }

        protected PropertyValueModel<Boolean> buildIsXmlTransientModel() {
            return new PropertyAspectAdapter<JavaEnumMapping, Boolean>(this.mappingModel, new String[]{"xmlTransient"}){

                protected Boolean buildValue_() {
                    return ((JavaEnumMapping)this.subject).isXmlTransient();
                }
            };
        }

        protected PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    JavaEnumImageDescriptorModel.this.aspectChanged();
                }
            };
        }

        protected void aspectChanged() {
            super.aspectChanged();
        }

        protected ImageDescriptor buildValue_() {
            if (this.mappingModel.getValue() != null && this.isXmlTransientModel.getValue() == Boolean.TRUE) {
                return JptJaxbUiImages.JAXB_TRANSIENT_ENUM;
            }
            return JptJaxbUiImages.JAXB_ENUM;
        }

        protected void engageSubject_() {
            this.mappingModel.addPropertyChangeListener("value", this.propertyChangeListener);
            this.isXmlTransientModel.addPropertyChangeListener("value", this.propertyChangeListener);
        }

        protected void disengageSubject_() {
            this.mappingModel.removePropertyChangeListener("value", this.propertyChangeListener);
            this.isXmlTransientModel.removePropertyChangeListener("value", this.propertyChangeListener);
        }
    }
}

