/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.ArrayList;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.ui.internal.Messages;
import org.eclipse.wst.xsl.ui.internal.contentassist.AttributeContentAssist;
import org.eclipse.wst.xsl.ui.internal.contentassist.XSLContentAssistRequestFactory;
import org.eclipse.wst.xsl.ui.internal.contentassist.XSLElementContentAssistRequest;
import org.eclipse.wst.xsl.ui.provisional.contentassist.AbstractXSLContentAssistProcessor;
import org.eclipse.wst.xsl.ui.provisional.contentassist.IContentAssistProposalRequest;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XSLContentAssistProcessor
extends AbstractXSLContentAssistProcessor
implements IContentAssistProcessor {
    private static final String attributeXpath = "{";
    private ArrayList<ICompletionProposal> xslProposals = new ArrayList();
    private ArrayList<ICompletionProposal> additionalProposals = new ArrayList();
    private ArrayList<ICompletionProposal> attributeProposals;
    private ArrayList<String> namespaces = new ArrayList();

    public XSLContentAssistProcessor() {
        this.namespaces.add("http://www.w3.org/1999/XSL/Transform");
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentPosition) {
        this.initializeProposalVariables(textViewer, documentPosition);
        this.additionalProposals = this.getAdditionalXSLElementProposals();
        this.xslProposals = this.getXSLNamespaceProposals();
        this.attributeProposals = this.getAttributeProposals();
        ArrayList<ICompletionProposal> proposalList = new ArrayList<ICompletionProposal>();
        proposalList.addAll(this.additionalProposals);
        proposalList.addAll(this.xslProposals);
        proposalList.addAll(this.attributeProposals);
        ICompletionProposal[] combinedProposals = this.combineProposals(proposalList);
        if (combinedProposals == null || combinedProposals.length == 0) {
            this.setErrorMessage(Messages.NoContentAssistance);
        }
        return combinedProposals;
    }

    private ArrayList<ICompletionProposal> getXSLNamespaceProposals() {
        if (XSLCore.isXSLNamespace((Node)this.xmlNode)) {
            XSLContentAssistRequestFactory requestFactory = new XSLContentAssistRequestFactory(this.textViewer, this.cursorPosition, this.xmlNode, this.sdRegion, this.completionRegion, this.matchString);
            IContentAssistProposalRequest contentAssistRequest = requestFactory.getContentAssistRequest();
            this.xslProposals = contentAssistRequest.getCompletionProposals();
        }
        return this.xslProposals;
    }

    private ArrayList<ICompletionProposal> getAdditionalXSLElementProposals() {
        if (!XSLCore.isXSLNamespace((Node)this.xmlNode)) {
            this.additionalProposals = new XSLElementContentAssistRequest((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.cursorPosition, 0, this.matchString, this.textViewer).getCompletionProposals();
        }
        return this.additionalProposals;
    }

    private ArrayList<ICompletionProposal> getAttributeProposals() {
        this.attributeProposals = new AttributeContentAssist((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.cursorPosition, 0, this.matchString, this.textViewer).getCompletionProposals();
        return this.attributeProposals;
    }

    private ICompletionProposal[] combineProposals(ArrayList<ICompletionProposal> proposalList) {
        ICompletionProposal[] combinedProposals = new ICompletionProposal[proposalList.size()];
        proposalList.toArray(combinedProposals);
        return combinedProposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    @Override
    public String getMaximumVersion() {
        return "2.0";
    }

    @Override
    public String getMinimumVersion() {
        return "1.0";
    }

    @Override
    public ArrayList<String> getNamespaces() {
        return null;
    }

    protected boolean assistanceOnAttribute(IDOMNode node, ITextRegion aRegion) {
        NamedNodeMap nodeMap = node.getAttributes();
        int i = 0;
        while (i < nodeMap.getLength()) {
            IDOMAttr attrNode = (IDOMAttr)nodeMap.item(i);
            if (attrNode.getValueRegion() != null && attrNode.getValueRegion().getStart() == aRegion.getStart() && attrNode.getValue().contains(attributeXpath)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

