/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.debugger.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.RhinoDebuggerImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoTransportService;
import org.eclipse.wst.jsdt.debug.rhino.debugger.shell.DebugShell;
import org.eclipse.wst.jsdt.debug.transport.TransportService;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Main;

public class DebugMain {
    public static final String ARG_DEBUG = "-debug";
    public static final String ARG_E = "-e";
    public static final String ARG_ENCODING = "-encoding";
    public static final String ARG_F = "-f";
    public static final String ARG_FATAL_WARNINGS = "-fatal-warnings";
    public static final String ARG_HELP = "-help";
    public static final String ARG_O = "-O";
    public static final String ARG_OPT = "-opt";
    public static final String ARG_QM = "-?";
    public static final String ARG_SEALEDLIB = "-sealedlib";
    public static final String ARG_STRICT = "-strict";
    private static final String ARG_VERSION = "-version";
    public static final String ARG_W = "-w";
    public static final String MSG_SHELL_INVALID = "msg.shell.invalid";
    public static final String MSG_SHELL_USAGE = "msg.shell.usage";
    public static final String FROM_EVAL = "<command>";
    public static final String GLOBAL_ARGUMENTS = "arguments";
    private static Evaluator evaluate = new Evaluator();

    public static void main(String[] args) {
        ToolErrorReporter reporter = new ToolErrorReporter(true);
        Main.shellContextFactory.setErrorReporter((ErrorReporter)reporter);
        DebugMain.startDebugger(args);
        ArrayList scripts = new ArrayList();
        DebugMain.processArgs(args, scripts, reporter);
        if (scripts.size() > 0) {
            DebugMain.checkGlobal();
            evaluate.reset();
            DebugMain.evaluate.scripts = scripts.toArray(new String[scripts.size()]);
            Main.shellContextFactory.call((ContextAction)evaluate);
        }
    }

    static void startDebugger(String[] args) {
        String port = "9888";
        boolean suspend = false;
        boolean trace = false;
        int i = 0;
        while (i < args.length) {
            if ("-port".equals(args[i])) {
                port = args[++i];
            } else if ("-suspend".equals(args[i])) {
                suspend = DebugShell.isSuspend(args[++i]);
            } else if ("-trace".equals(args[i])) {
                trace = Boolean.valueOf(args[++i]);
            }
            ++i;
        }
        RhinoTransportService service = new RhinoTransportService();
        RhinoDebuggerImpl debugger = new RhinoDebuggerImpl((TransportService)service, port, suspend, trace);
        try {
            debugger.start();
            Main.shellContextFactory.addListener((ContextFactory.Listener)debugger);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void processArgs(String[] originalargs, List scriptcollector, ToolErrorReporter reporter) {
        try {
            int i = 0;
            while (i < originalargs.length) {
                String arg = originalargs[i];
                if (ARG_DEBUG.equals(arg)) {
                    Main.shellContextFactory.setGeneratingDebug(true);
                } else if (ARG_E.equals(arg)) {
                    DebugMain.peekArg(originalargs, i, false);
                    DebugMain.checkGlobal();
                    DebugMain.evaluate.scriptsrc = originalargs[++i];
                    Main.shellContextFactory.call((ContextAction)evaluate);
                } else if (ARG_ENCODING.equals(arg)) {
                    DebugMain.peekArg(originalargs, i, false);
                    String enc = originalargs[++i];
                    Main.shellContextFactory.setCharacterEncoding(enc);
                } else if (ARG_F.equals(arg)) {
                    DebugMain.peekArg(originalargs, i, false);
                    String script = originalargs[++i];
                    try {
                        while (true) {
                            scriptcollector.add(script);
                            DebugMain.peekArg(originalargs, i, false);
                            script = originalargs[++i];
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (ARG_FATAL_WARNINGS.equals(arg)) {
                    Main.shellContextFactory.setWarningAsError(true);
                } else if (ARG_QM.equals(arg) || ARG_HELP.equals(arg)) {
                    Main.global.getOut().println(ToolErrorReporter.getMessage((String)MSG_SHELL_USAGE, (String)Main.class.getName()));
                    System.exit(1);
                } else if (ARG_VERSION.equals(arg)) {
                    int version;
                    DebugMain.peekArg(originalargs, i, false);
                    try {
                        version = Integer.parseInt(originalargs[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(originalargs[i]);
                    }
                    if (!Context.isValidLanguageVersion((int)version)) {
                        throw new IllegalArgumentException(originalargs[i]);
                    }
                    Main.shellContextFactory.setLanguageVersion(version);
                } else if (ARG_OPT.equals(arg) || ARG_O.equals(arg)) {
                    int opt;
                    DebugMain.peekArg(originalargs, i, true);
                    try {
                        opt = Integer.parseInt(originalargs[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(originalargs[i]);
                    }
                    if (opt == -2) {
                        opt = -1;
                    } else if (!Context.isValidOptimizationLevel((int)opt)) {
                        throw new IllegalArgumentException(originalargs[i]);
                    }
                    Main.shellContextFactory.setOptimizationLevel(opt);
                } else if (ARG_SEALEDLIB.equals(arg)) {
                    Main.global.setSealedStdLib(true);
                } else if (ARG_STRICT.equals(arg)) {
                    Main.shellContextFactory.setStrictMode(true);
                    reporter.setIsReportingWarnings(true);
                } else if (ARG_W.equals(arg)) {
                    reporter.setIsReportingWarnings(true);
                }
                ++i;
            }
        }
        catch (IllegalArgumentException iae) {
            Main.global.getOut().println(ToolErrorReporter.getMessage((String)MSG_SHELL_INVALID, (String)iae.getMessage()));
            Main.global.getOut().println(ToolErrorReporter.getMessage((String)MSG_SHELL_USAGE, (String)Main.class.getName()));
            System.exit(1);
        }
    }

    static void checkGlobal() {
        if (!Main.global.isInitialized()) {
            Main.global.init((ContextFactory)Main.shellContextFactory);
        }
    }

    static void peekArg(String[] args, int idx, boolean ignoreswitch) throws IllegalArgumentException {
        if (idx + 1 < args.length && (!args[idx + 1].startsWith("-") || ignoreswitch)) {
            return;
        }
        throw new IllegalArgumentException(args[idx]);
    }

    static class Evaluator
    implements ContextAction {
        String scriptsrc = null;
        String[] scripts = null;

        Evaluator() {
        }

        public Object run(Context cx) {
            Script script;
            if (this.scriptsrc == null && this.scripts == null) {
                throw Kit.codeBug();
            }
            if (this.scriptsrc != null && (script = cx.compileString(this.scriptsrc, this.scriptsrc, 0, null)) != null) {
                script.exec(cx, (Scriptable)Main.getGlobal());
            }
            Object[] array = new Object[this.scripts.length];
            System.arraycopy(this.scripts, 0, array, 0, this.scripts.length);
            Scriptable argsObj = cx.newArray((Scriptable)Main.global, array);
            Main.global.defineProperty(DebugMain.GLOBAL_ARGUMENTS, (Object)argsObj, 2);
            int i = 0;
            while (i < this.scripts.length) {
                try {
                    Main.processFile((Context)cx, (Scriptable)Main.global, (String)this.scripts[i]);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                ++i;
            }
            return null;
        }

        void reset() {
            this.scriptsrc = null;
            this.scripts = null;
        }
    }
}

