/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.tagregistry;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.types.ClassTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IComponentTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IConverterTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IValidatorTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.ViewMetadataGenerator;

class GenerateMetadataAction
extends Action {
    private Namespace _ns;

    public GenerateMetadataAction() {
        super("Generate metadata");
    }

    public void setNamespace(Namespace ns) {
        this._ns = ns;
    }

    public void run() {
        if (this._ns != null) {
            ViewMetadataGenerator generator = new ViewMetadataGenerator(this._ns.getNSUri());
            for (ITagElement element : this._ns.getViewElements()) {
                String tagName = element.getName();
                ClassTypeInfo typeInfo = this.getTypeInfo(element);
                if (typeInfo == null) continue;
                generator.addTagToViewObjectMapping(tagName, typeInfo, null, null);
            }
            try {
                generator.save((OutputStream)System.out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private ClassTypeInfo getTypeInfo(ITagElement element) {
        ComponentTypeInfo typeInfo = null;
        if (element instanceof IComponentTagElement) {
            typeInfo = ((IComponentTagElement)element).getComponent();
        } else if (element instanceof IConverterTagElement) {
            typeInfo = ((IConverterTagElement)element).getConverter();
        } else if (element instanceof IValidatorTagElement) {
            typeInfo = ((IValidatorTagElement)element).getValidator();
        }
        return typeInfo;
    }
}

