/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Assert;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContextWithEvents;

public abstract class AbstractWorkspaceContextWithEvents
implements IWorkspaceContextWithEvents {
    private AtomicBoolean _isInitialized = new AtomicBoolean(false);
    private AtomicBoolean _isDisposed = new AtomicBoolean(false);

    public final void init() throws Exception {
        if (this._isInitialized.compareAndSet(false, true)) {
            this.doInit();
            return;
        }
        throw new IllegalStateException();
    }

    protected abstract void doInit() throws Exception;

    public final void dispose() throws Exception {
        if (this._isDisposed.compareAndSet(false, true)) {
            this.doDispose();
            return;
        }
        throw new IllegalStateException();
    }

    protected abstract void doDispose() throws Exception;

    protected void assertInitialized() {
        Assert.assertTrue((String)"context must be initialized", (boolean)this._isInitialized.get());
        Assert.assertFalse((String)"context cannot be used after it is disposed", (boolean)this._isDisposed.get());
    }
}

