/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.junit4.TestDataBaseLocation;
import org.eclipse.jst.jsf.test.util.junit4.WorkspaceContext;
import org.eclipse.jst.jsf.test.util.junit4.WorkspaceRunner;
import org.eclipse.jst.jsf.test.util.mock.FileSystemZipLoader;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=WorkspaceRunner.class)
public class TestMockWorkspaceContext {
    @WorkspaceContext
    private IWorkspaceContext _wsContext;
    @TestDataBaseLocation
    private File _baseLoc;
    private IWorkspaceContext.ZipFileLoader _testZipFileLoader;

    @Before
    public void setUp() throws Exception {
        System.out.println(this._baseLoc);
        Path path = new Path(this._baseLoc.getAbsolutePath());
        path = path.append("/data/TestProject.zip");
        File file = path.toFile();
        Assert.assertTrue((boolean)file.exists());
        this._testZipFileLoader = new FileSystemZipLoader(file, "TestProject/");
    }

    @Test
    public void testDispose() throws Exception {
        this._wsContext.dispose();
    }

    @Test
    public void testGetWorkspace() {
        IWorkspace workspace = this._wsContext.getWorkspace();
        Assert.assertNotNull((Object)workspace);
        Assert.assertSame((Object)workspace, (Object)this._wsContext.getWorkspace());
    }

    @Test
    public void testGetProject() throws Exception {
        Path path = new Path("TestProject");
        IProject project = this._wsContext.getProject((IPath)path);
        Assert.assertNull((Object)project);
        project = this._wsContext.loadProject((IPath)path, this._testZipFileLoader);
        Assert.assertNotNull((Object)project);
    }

    @Test
    public void testGetResource() throws Exception {
        Path projPath = new Path("TestProject");
        Path path = new Path("/WebContent/test.xhtml");
        IPath fullPath = projPath.append((IPath)path);
        IResource resource = this._wsContext.getResource((IPath)path);
        Assert.assertNull((Object)resource);
        IProject project = this._wsContext.loadProject((IPath)projPath, this._testZipFileLoader);
        Assert.assertNotNull((Object)project);
        IFile file = project.getFile((IPath)path);
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((Object)file, (Object)this._wsContext.getResource(fullPath));
    }

    @Test
    public void testGetFile() throws Exception {
        Path projPath = new Path("TestProject");
        Path path = new Path("/WebContent/test.xhtml");
        IPath fullPath = projPath.append((IPath)path);
        IFile file = this._wsContext.getFile((IPath)path);
        Assert.assertNull((Object)file);
        IProject project = this._wsContext.loadProject((IPath)projPath, this._testZipFileLoader);
        Assert.assertNotNull((Object)project);
        IFile fileFromProject = project.getFile((IPath)path);
        Assert.assertNotNull((Object)fileFromProject);
        Assert.assertEquals((Object)fileFromProject, (Object)this._wsContext.getFile(fullPath));
    }

    @Test
    public void testCreateProjectString() {
        IProject project = this._wsContext.createProject("Foo");
        Assert.assertNotNull((Object)project);
        IProject project2 = this._wsContext.createProject("Foo");
        Assert.assertNotNull((Object)project2);
        Assert.assertFalse((boolean)project.equals((Object)project2));
    }

    @Test
    public void testCreateProjectIPath() {
        IProject project = this._wsContext.createProject((IPath)new Path("Foo"));
        Assert.assertNotNull((Object)project);
        Assert.assertEquals((Object)"Foo", (Object)project.getName());
    }

    @Test
    public void testLoadProjectIPathZipFile() throws Exception {
        IProject project = this._wsContext.loadProject((IPath)new Path("TestProject1"), this._testZipFileLoader);
        Assert.assertNotNull((Object)project);
        Assert.assertTrue((boolean)project.exists());
        IFile file = project.getFile((IPath)new Path("WebContent/test.xhtml"));
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.exists());
        InputStream contents = file.getContents();
        ByteArrayOutputStream data = JSFTestUtil.loadFromInputStream(contents);
        Assert.assertEquals((long)367L, (long)data.toByteArray().length);
    }
}

