/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import junit.framework.AssertionFailedError;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.test.util.mock.IMockResourceFactory;
import org.eclipse.jst.jsf.test.util.mock.MockProject;
import org.eclipse.jst.jsf.test.util.mock.MockResource;

public class MockContainer
extends MockResource
implements IContainer {
    private final IMockResourceFactory _resFactory;

    public MockContainer(int type, IPath path, IMockResourceFactory resFactory) {
        super(type, path);
        this._resFactory = resFactory;
    }

    public void loadAllMembers() throws Exception {
        this.getResFactory().forceLoad((MockProject)this.getProject());
    }

    public void dispose() throws Exception {
        try {
            this.getResFactory().dispose();
        }
        finally {
            super.dispose();
        }
    }

    public boolean exists(IPath path) {
        throw new UnsupportedOperationException();
    }

    public IResource findMember(String name) {
        throw new UnsupportedOperationException();
    }

    public IResource findMember(String name, boolean includePhantoms) {
        throw new UnsupportedOperationException();
    }

    public IResource findMember(IPath path) {
        throw new UnsupportedOperationException();
    }

    public IResource findMember(IPath path, boolean includePhantoms) {
        throw new UnsupportedOperationException();
    }

    public String getDefaultCharset() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public String getDefaultCharset(boolean checkImplicit) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IFile getFile(IPath path) {
        try {
            return (IFile)this.getResFactory().createFile(this, path);
        }
        catch (Exception e) {
            throw new AssertionFailedError(e.getLocalizedMessage());
        }
    }

    public IFile getFile(String path) {
        return this.getFile((IPath)new Path(path));
    }

    public IFolder getFolder(IPath path) {
        try {
            return this.getResFactory().createFolder(this, path);
        }
        catch (Exception e) {
            throw new AssertionFailedError(e.getLocalizedMessage());
        }
    }

    protected void visitMembers(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        IResource[] iResourceArray = this.members(memberFlags);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            res.accept(visitor, depth, memberFlags);
            ++n2;
        }
    }

    public IResource[] members() throws CoreException {
        return this.members(0);
    }

    public IResource[] members(boolean includePhantoms) throws CoreException {
        return this.members(includePhantoms ? 1 : 0);
    }

    public IResource[] members(int memberFlags) throws CoreException {
        return this.getResFactory().getCurrentMembers(this).toArray(new IResource[0]);
    }

    public IFile[] findDeletedMembersWithHistory(int depth, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setDefaultCharset(String charset) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setDefaultCharset(String charset, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IResourceFilterDescription createFilter(int type, FileInfoMatcherDescription matcherDescription, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IResourceFilterDescription[] getFilters() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IMockResourceFactory getResFactory() {
        return this._resFactory;
    }
}

