/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.crossfire.CFObject;

public class CFThrowable
extends Throwable {
    private Map frame = null;
    private Map error = null;
    private Map objects = null;

    public CFThrowable(Map json) {
        if (json != null) {
            this.frame = (Map)json.get("frame");
            if (this.frame != null) {
                this.processFrame();
            } else {
                Map map = (Map)json.get("stackTrace");
            }
            this.error = (Map)json.get("error");
        }
    }

    void processFrame() {
        if (this.frame != null) {
            this.objects = new HashMap(this.frame.size());
            Map vals = (Map)this.frame.remove("value");
            if (vals != null && (vals = (Map)vals.remove("script")) != null) {
                this.objects.put("script", new CFObject("script", (String)vals.get("type"), (Number)vals.get("handle")));
            }
            if ((vals = (Map)this.frame.remove("scope")) != null) {
                this.objects.put("scope", new CFObject("scope", (String)vals.get("type"), (Number)vals.get("handle")));
            }
            if ((vals = (Map)this.frame.remove("callingFrame")) != null) {
                this.objects.put("callingFrame", new CFObject("callingFrame", (String)vals.get("type"), (Number)vals.get("handle")));
            }
            if ((vals = (Map)this.frame.remove("executionContext")) != null) {
                this.objects.put("executionContext", new CFObject("executionContext", (String)vals.get("type"), (Number)vals.get("handle")));
            }
            if ((vals = (Map)this.frame.remove("callee")) != null) {
                this.objects.put("callee", new CFObject("callee", (String)vals.get("type"), (Number)vals.get("handle")));
            }
            if ((vals = (Map)this.frame.remove("thisValue")) != null) {
                this.objects.put("thisValue", new CFObject("thisValue", (String)vals.get("type"), (Number)vals.get("handle")));
            }
        }
    }

    public boolean isDebugger() {
        Boolean bool;
        if (this.frame != null && (bool = (Boolean)this.error.get("isDebugger")) != null) {
            return bool;
        }
        return false;
    }

    public boolean isValid() {
        Boolean bool;
        if (this.frame != null && (bool = (Boolean)this.error.get("isValid")) != null) {
            return bool;
        }
        return false;
    }

    public int lineNumber() {
        if (this.error != null) {
            Number val = (Number)this.error.get("lineNumber");
            if (val == null) {
                val = (Number)this.error.get("lineNo");
            }
            if (val != null) {
                return val.intValue();
            }
        }
        return -1;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        if (this.error != null) {
            String val = (String)this.error.get("message");
            if (val == null) {
                val = (String)this.error.get("errorMessage");
            }
            return val;
        }
        return null;
    }

    public int columnNumber() {
        Number val;
        if (this.error != null && (val = (Number)this.error.get("columnNumber")) != null) {
            return val.intValue();
        }
        return -1;
    }

    public int getFlags() {
        Number val;
        if (this.error != null && (val = (Number)this.error.get("flags")) != null) {
            return val.intValue();
        }
        return -1;
    }

    public String getCategory() {
        if (this.error != null) {
            String val = (String)this.error.get("category");
            return val;
        }
        return null;
    }

    public String scriptName() {
        if (this.error != null) {
            String val = (String)this.error.get("fileName");
            if (val == null) {
                val = (String)this.error.get("sourceName");
            }
            return val;
        }
        return null;
    }

    public String functionName() {
        if (this.frame != null) {
            String val = (String)this.frame.get("functionName");
            return val;
        }
        return null;
    }

    @Override
    public void printStackTrace() {
        if (this.frame != null) {
            return;
        }
        super.printStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.frame != null) {
            return;
        }
        super.printStackTrace(s);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.frame != null) {
            return;
        }
        super.printStackTrace(s);
    }
}

