/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.common.build.system.util;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.js.common.build.system.BuildSystemVisitor;
import org.eclipse.wst.jsdt.js.common.build.system.ITask;
import org.eclipse.wst.jsdt.js.common.util.WorkbenchResourceUtil;

public class ASTUtil {
    public static JavaScriptUnit getJavaScriptUnit(IFile file) throws JavaScriptModelException {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(ASTUtil.getCompilationUnit(file));
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        return (JavaScriptUnit)parser.createAST(null);
    }

    public static Set<ITask> getTasks(String pathToFile, BuildSystemVisitor visitor) throws JavaScriptModelException {
        IFile ifile;
        File file = WorkbenchResourceUtil.getFile(pathToFile);
        if (file != null && (ifile = WorkbenchResourceUtil.getFileForLocation(file.getAbsolutePath())) != null) {
            JavaScriptUnit unit = ASTUtil.getJavaScriptUnit(ifile);
            unit.accept((ASTVisitor)visitor);
            return visitor.getTasks();
        }
        return Collections.emptySet();
    }

    public static String beautify(Expression e) {
        if (e != null) {
            return e.toString().replaceAll("'", "").replaceAll("\"", "").trim();
        }
        return null;
    }

    private static IJavaScriptUnit getCompilationUnit(IFile file) {
        return (IJavaScriptUnit)JavaScriptCore.create((IFile)file);
    }
}

