/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InterceptionType;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationContextImpl
implements InvocationContext {
    private Map<String, Object> contextData = new HashMap<String, Object>();
    private Method method;
    private Object[] parameters;
    private List<InterceptorData> interceptorDatas;
    private Object target;
    private InterceptionType type;
    private int currentMethod = 1;
    private CreationalContext<?> creationalContext;
    private OwbBean<?> owbBean;
    private InvocationContext ejbInvocationContext;
    private WebBeansContext webBeansContext;
    private Object ccKey;

    public InvocationContextImpl(WebBeansContext webBeansContext, OwbBean<?> bean, Object instance, Method method, Object[] parameters, List<InterceptorData> datas, InterceptionType type) {
        this.webBeansContext = webBeansContext;
        this.owbBean = bean;
        this.method = method;
        this.parameters = parameters;
        this.interceptorDatas = datas;
        this.type = type;
        if (instance == null) {
            this.configureTarget(bean);
        } else {
            this.target = instance;
        }
    }

    public void setCreationalContext(CreationalContext<?> ownerCreationalContext) {
        this.creationalContext = ownerCreationalContext;
    }

    public void setEJBInvocationContext(InvocationContext c) {
        this.ejbInvocationContext = c;
    }

    private void configureTarget(OwbBean<?> bean) {
        Context webbeansContext = bean.getWebBeansContext().getBeanManagerImpl().getContext(bean.getScope());
        this.target = webbeansContext.get(bean, this.creationalContext);
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object proceed() throws Exception {
        try {
            if (this.type.equals((Object)InterceptionType.AROUND_INVOKE)) {
                return this.proceedAroundInvokes(this.interceptorDatas);
            }
            if (this.type.equals((Object)InterceptionType.AROUND_TIMEOUT)) {
                return this.proceedAroundTimeouts(this.interceptorDatas);
            }
            return this.proceedCommonAnnots(this.interceptorDatas, this.type);
        }
        catch (InvocationTargetException ite) {
            this.target = null;
            Throwable t = ite.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw ite;
        }
        catch (Exception e) {
            this.target = null;
            throw e;
        }
    }

    private Object proceedAroundInvokes(List<InterceptorData> datas) throws Exception {
        Object result = null;
        if (this.currentMethod <= datas.size()) {
            Object t;
            InterceptorData intc = datas.get(this.currentMethod - 1);
            Method aroundInvokeMethod = intc.getAroundInvoke();
            if (!aroundInvokeMethod.isAccessible()) {
                this.owbBean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)aroundInvokeMethod, true);
            }
            if ((t = intc.createNewInstance(this.ccKey != null ? this.ccKey : this.target, (CreationalContextImpl)this.creationalContext)) == null) {
                t = this.target;
            }
            ++this.currentMethod;
            result = aroundInvokeMethod.invoke(t, this);
        } else if (!(this.owbBean instanceof EnterpriseBeanMarker)) {
            if (!this.method.isAccessible()) {
                this.owbBean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.method, true);
            }
            result = this.method.invoke(this.target, this.parameters);
        } else if (this.ejbInvocationContext != null) {
            result = this.ejbInvocationContext.proceed();
        }
        return result;
    }

    private Object proceedAroundTimeouts(List<InterceptorData> datas) throws Exception {
        Object result = null;
        if (this.currentMethod <= datas.size()) {
            Object t;
            InterceptorData intc = datas.get(this.currentMethod - 1);
            Method aroundTimeoutMethod = intc.getAroundTimeout();
            if (!aroundTimeoutMethod.isAccessible()) {
                this.owbBean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)aroundTimeoutMethod, true);
            }
            if ((t = intc.createNewInstance(this.ccKey != null ? this.ccKey : this.target, (CreationalContextImpl)this.creationalContext)) == null) {
                t = this.target;
            }
            ++this.currentMethod;
            result = aroundTimeoutMethod.invoke(t, this);
        } else if (!(this.owbBean instanceof EnterpriseBeanMarker)) {
            if (!this.method.isAccessible()) {
                this.owbBean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.method, true);
            }
            result = this.method.invoke(this.target, this.parameters);
        } else if (this.ejbInvocationContext != null) {
            result = this.ejbInvocationContext.proceed();
        }
        return result;
    }

    private Object proceedCommonAnnots(List<InterceptorData> datas, InterceptionType type) throws Exception {
        Object result = null;
        if (this.currentMethod <= datas.size()) {
            InterceptorData intc = datas.get(this.currentMethod - 1);
            Method commonAnnMethod = null;
            if (type.equals((Object)InterceptionType.POST_CONSTRUCT)) {
                commonAnnMethod = intc.getPostConstruct();
            } else if (type.equals((Object)InterceptionType.POST_ACTIVATE)) {
                commonAnnMethod = intc.getPostActivate();
            } else if (type.equals((Object)InterceptionType.PRE_PASSIVATE)) {
                commonAnnMethod = intc.getPrePassivate();
            } else if (type.equals((Object)InterceptionType.PRE_DESTROY)) {
                commonAnnMethod = intc.getPreDestroy();
            } else {
                throw new IllegalArgumentException("Unsupportet InterceptionType: " + type);
            }
            if (commonAnnMethod == null) {
                throw new IllegalArgumentException("Could not find intercepted Method!");
            }
            if (!commonAnnMethod.isAccessible()) {
                this.webBeansContext.getSecurityService().doPrivilegedSetAccessible((AccessibleObject)commonAnnMethod, true);
            }
            ++this.currentMethod;
            Object t = intc.createNewInstance(this.ccKey != null ? this.ccKey : this.target, (CreationalContextImpl)this.creationalContext);
            if (t == null) {
                if (!(this.owbBean instanceof EnterpriseBeanMarker)) {
                    t = this.target;
                    result = commonAnnMethod.invoke(t, new Object[0]);
                    this.proceedCommonAnnots(datas, type);
                }
            } else {
                result = commonAnnMethod.invoke(t, this);
            }
        } else if (this.owbBean instanceof EnterpriseBeanMarker && this.ejbInvocationContext != null) {
            result = this.ejbInvocationContext.proceed();
        }
        return result;
    }

    public void setParameters(Object[] params) {
        if (this.getMethod() != null) {
            if (params == null) {
                if (this.parameters.length >= 0) {
                    throw new IllegalArgumentException("Gvien parameters is null but expected not null parameters");
                }
            } else {
                if (params.length != this.parameters.length) {
                    throw new IllegalArgumentException("Expected " + this.parameters.length + " " + "parameters, but only got " + params.length + " parameters");
                }
                Class<?>[] methodParameters = this.method.getParameterTypes();
                int i = 0;
                for (Object obj : params) {
                    Class<?> parameterType = methodParameters[i++];
                    if (obj == null) {
                        if (!parameterType.isPrimitive()) continue;
                        throw new IllegalArgumentException("Expected parameter " + i + " to be primitive type " + parameterType.getName() + ", but got a parameter that is null");
                    }
                    if (parameterType.isPrimitive()) {
                        parameterType = ClassUtil.getPrimitiveWrapper(parameterType);
                    }
                    if (parameterType.isInstance(obj)) continue;
                    throw new IllegalArgumentException("Expected parameter " + i + " to be of type " + parameterType.getName() + ", but got a parameter of type " + obj.getClass().getName());
                }
                System.arraycopy(params, 0, this.parameters, 0, params.length);
            }
        }
    }

    public Object getTimer() {
        return null;
    }

    public void setCcKey(Object ccKey) {
        this.ccKey = ccKey;
    }
}

