/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.openejb.core.CoreUserTransaction;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.webbeans.ee.event.TransactionalEventNotifier;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.TransactionService;

public class OpenEJBTransactionService
implements TransactionService {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(OpenEJBTransactionService.class);

    public Transaction getTransaction() {
        TransactionManager manager = this.getTransactionManager();
        if (manager != null) {
            try {
                return manager.getTransaction();
            }
            catch (SystemException e) {
                logger.error((Throwable)e);
            }
        }
        return null;
    }

    public TransactionManager getTransactionManager() {
        return (TransactionManager)SystemInstance.get().getComponent(TransactionManager.class);
    }

    public UserTransaction getUserTransaction() {
        UserTransaction ut = null;
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        try {
            ut = (UserTransaction)containerSystem.getJNDIContext().lookup("comp/UserTransaction");
        }
        catch (NamingException e) {
            logger.debug("User transaction is not bound to context, lets create it");
            ut = new CoreUserTransaction(this.getTransactionManager());
        }
        return ut;
    }

    public void registerTransactionSynchronization(TransactionPhase phase, ObserverMethod<? super Object> observer, Object event) throws Exception {
        TransactionalEventNotifier.registerTransactionSynchronization((TransactionPhase)phase, observer, (Object)event);
    }
}

