/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.core.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.apps.admin.core.BundleHolder;
import org.eclipse.virgo.apps.admin.core.ExportedPackageHolder;
import org.eclipse.virgo.apps.admin.core.ImportedPackageHolder;
import org.eclipse.virgo.apps.admin.core.state.ObjectFormatter;
import org.eclipse.virgo.apps.admin.core.state.StandardBundleHolder;
import org.eclipse.virgo.apps.admin.core.state.StandardImportedPackageHolder;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StandardExportedPackageHolder
implements ExportedPackageHolder {
    private final QuasiExportPackage exportPackage;
    private final ModuleContextAccessor moduleContextAccessor;

    public StandardExportedPackageHolder(QuasiExportPackage exportPackage, ModuleContextAccessor moduleContextAccessor) {
        this.exportPackage = exportPackage;
        this.moduleContextAccessor = moduleContextAccessor;
    }

    @Override
    public String getPackageName() {
        return this.exportPackage.getPackageName();
    }

    @Override
    public List<ImportedPackageHolder> getConsumers() {
        List consumers = this.exportPackage.getConsumers();
        ArrayList<ImportedPackageHolder> importedPackageHolders = new ArrayList<ImportedPackageHolder>();
        if (consumers != null) {
            for (QuasiImportPackage quasiImportPackage : consumers) {
                importedPackageHolders.add(new StandardImportedPackageHolder(quasiImportPackage, this.moduleContextAccessor));
            }
        }
        return importedPackageHolders;
    }

    @Override
    public BundleHolder getExportingBundle() {
        QuasiBundle exportingBundle = this.exportPackage.getExportingBundle();
        if (exportingBundle != null) {
            return new StandardBundleHolder(exportingBundle, this.moduleContextAccessor);
        }
        return null;
    }

    @Override
    public String getVersion() {
        return this.exportPackage.getVersion().toString();
    }

    @Override
    public Map<String, String> getAttributes() {
        return ObjectFormatter.formatMapValues(this.exportPackage.getAttributes());
    }

    @Override
    public Map<String, String> getDirectives() {
        return ObjectFormatter.formatMapValues(this.exportPackage.getDirectives());
    }
}

