/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.security;

import org.apache.felix.eventadmin.impl.security.TopicPermissions;
import org.apache.felix.eventadmin.impl.util.CacheMap;
import org.osgi.service.event.TopicPermission;

public class CacheTopicPermissions
implements TopicPermissions {
    private final CacheMap m_cache;
    private final String m_type;

    public CacheTopicPermissions(CacheMap cache, String type) {
        this.checkNull(cache, "CacheMap");
        this.checkNull(type, "Type");
        if (!"publish".equals(type) && !"subscribe".equals(type)) {
            throw new IllegalArgumentException("Type must be either PUBLISH or SUBSCRIBE");
        }
        this.m_cache = cache;
        this.m_type = type;
    }

    public String getType() {
        return this.m_type;
    }

    public Object createTopicPermission(String topic) {
        Object result = this.m_cache.get(topic);
        if (null == result) {
            try {
                result = new TopicPermission(topic, this.m_type);
            }
            catch (Throwable t) {
                result = new Object();
            }
            this.m_cache.add(topic, result);
        }
        return result;
    }

    private void checkNull(Object object, String name) {
        if (null == object) {
            throw new NullPointerException(name + " may not be null");
        }
    }
}

