/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.completers;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.virgo.repository.management.ArtifactDescriptorSummary;
import org.eclipse.virgo.repository.management.RepositoryInfo;
import org.eclipse.virgo.shell.CommandCompleter;

public class InstallCompleter
implements CommandCompleter {
    private static final String FILE_PREFIX = "file:";
    private static final String FILE_PATH_CANDIDATE_FORMAT = "file:%s%s";
    private static final String REPOSITORY_PREFIX = "repository:";
    private static final String REPOSITORY_TYPE_NAME_VERSION_FORMAT = "repository:%s/%s/%s";
    private static final String REPOSITORY_TYPE_NAME_FORMAT = "repository:%s/%s/";
    private static final String REPOSITORY_TYPE_FORMAT = "repository:%s/";
    private static final String[] SCHEMES = new String[]{"file:", "repository:"};
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName repositoryQuery = new ObjectName("org.eclipse.virgo.kernel:type=Repository,*");
    private final ObjectName hostedRepositoryQuery = new ObjectName("org.eclipse.virgo.server:type=HostedRepository,*");

    @Override
    public List<String> getCompletionCandidates(String subcommand, String ... arguments) {
        Set<Object> candidates;
        if (arguments.length == 0) {
            if (subcommand.startsWith(REPOSITORY_PREFIX)) {
                candidates = this.repository(subcommand);
            } else if (subcommand.startsWith(FILE_PREFIX)) {
                candidates = this.file(subcommand);
            } else {
                candidates = new HashSet();
                String[] stringArray = SCHEMES;
                int n = SCHEMES.length;
                int n2 = 0;
                while (n2 < n) {
                    String scheme = stringArray[n2];
                    if (scheme.startsWith(subcommand)) {
                        candidates.add(scheme);
                    }
                    ++n2;
                }
            }
        } else {
            candidates = new HashSet();
        }
        ArrayList<String> candidateList = new ArrayList<String>(candidates);
        Collections.sort(candidateList);
        return candidateList;
    }

    private Set<String> file(String subcommand) {
        ArrayList candidates = new ArrayList();
        String path = subcommand.substring(FILE_PREFIX.length());
        int completionIndex = 0;
        HashSet<String> candidateSet = new HashSet<String>(candidates.size());
        if (completionIndex >= 0) {
            String completablePath = path.substring(0, completionIndex);
            for (String candidate : candidates) {
                candidateSet.add(String.format(FILE_PATH_CANDIDATE_FORMAT, completablePath, candidate));
            }
        }
        return candidateSet;
    }

    private Set<String> repository(String subcommand) {
        List<String> uriParts = this.getUriParts(subcommand);
        if (uriParts.size() == 1) {
            return this.type(uriParts.get(0));
        }
        if (uriParts.size() == 2) {
            return this.name(uriParts.get(0), uriParts.get(1));
        }
        if (uriParts.size() == 3) {
            return this.version(uriParts.get(0), uriParts.get(1), uriParts.get(2));
        }
        return Collections.emptySet();
    }

    private List<String> getUriParts(String subcommand) {
        ArrayList<String> uriParts = new ArrayList<String>(Arrays.asList(subcommand.substring(REPOSITORY_PREFIX.length()).split("/")));
        if (subcommand.endsWith("/")) {
            uriParts.add("");
        }
        return uriParts;
    }

    private Set<String> type(String type) {
        HashSet<String> types = new HashSet<String>();
        for (RepositoryInfo repository : this.getRepositories()) {
            for (ArtifactDescriptorSummary artifact : repository.getAllArtifactDescriptorSummaries()) {
                if (!artifact.getType().startsWith(type)) continue;
                types.add(String.format(REPOSITORY_TYPE_FORMAT, artifact.getType()));
            }
        }
        return types;
    }

    private Set<String> name(String type, String name) {
        HashSet<String> names = new HashSet<String>();
        for (RepositoryInfo repository : this.getRepositories()) {
            for (ArtifactDescriptorSummary artifact : repository.getAllArtifactDescriptorSummaries()) {
                if (!artifact.getType().equals(type) || !artifact.getName().startsWith(name)) continue;
                names.add(String.format(REPOSITORY_TYPE_NAME_FORMAT, artifact.getType(), artifact.getName()));
            }
        }
        return names;
    }

    private Set<String> version(String type, String name, String version) {
        HashSet<String> versions = new HashSet<String>();
        for (RepositoryInfo repository : this.getRepositories()) {
            for (ArtifactDescriptorSummary artifact : repository.getAllArtifactDescriptorSummaries()) {
                if (!artifact.getType().equals(type) || !artifact.getName().equals(name) || !artifact.getVersion().startsWith(version)) continue;
                versions.add(String.format(REPOSITORY_TYPE_NAME_VERSION_FORMAT, artifact.getType(), artifact.getName(), artifact.getVersion()));
            }
        }
        return versions;
    }

    private Set<RepositoryInfo> getRepositories() {
        HashSet<String> hostedRepositoryNames = new HashSet<String>();
        for (ObjectName objectName : this.server.queryNames(this.hostedRepositoryQuery, null)) {
            hostedRepositoryNames.add(objectName.getKeyProperty("name"));
        }
        HashSet<RepositoryInfo> repositories = new HashSet<RepositoryInfo>();
        for (ObjectName objectName : this.server.queryNames(this.repositoryQuery, null)) {
            String name = objectName.getKeyProperty("name");
            if (hostedRepositoryNames.contains(name)) continue;
            repositories.add(JMX.newMXBeanProxy(this.server, objectName, RepositoryInfo.class));
        }
        return repositories;
    }
}

