/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.common;

public class SimpleByteBuffer {
    private static int INITAL_SIZE = 13;
    private byte[] buffer = new byte[INITAL_SIZE];
    private int pos = 0;
    private int size = 0;

    public void add(int b) {
        if (this.size >= this.buffer.length) {
            this.rezize();
        }
        this.buffer[this.size++] = (byte)b;
    }

    private void rezize() {
        byte[] newbuffeer = new byte[this.buffer.length << 1];
        System.arraycopy(this.buffer, 0, newbuffeer, 0, this.buffer.length);
        this.buffer = newbuffeer;
    }

    public void insert(int b) {
        int forCopy;
        if (this.size >= this.buffer.length) {
            this.rezize();
        }
        if ((forCopy = this.size - this.pos) > 0) {
            System.arraycopy(this.buffer, this.pos, this.buffer, this.pos + 1, forCopy);
        }
        this.buffer[this.pos++] = (byte)b;
        ++this.size;
    }

    public int goRight() {
        if (this.pos < this.size) {
            return this.buffer[this.pos++] & 0xFF;
        }
        return -1;
    }

    public boolean goLeft() {
        if (this.pos > 0) {
            --this.pos;
            return true;
        }
        return false;
    }

    public void delete() {
        if (this.pos < this.size) {
            int forCopy = this.size - this.pos;
            System.arraycopy(this.buffer, this.pos + 1, this.buffer, this.pos, forCopy);
            --this.size;
        }
    }

    public boolean backSpace() {
        if (this.pos > 0 && this.size > 0) {
            int forCopy = this.size - this.pos;
            System.arraycopy(this.buffer, this.pos, this.buffer, this.pos - 1, forCopy);
            --this.size;
            --this.pos;
            return true;
        }
        return false;
    }

    public void delAll() {
        this.pos = 0;
        this.size = 0;
    }

    public byte[] getCurrentData() {
        byte[] res = new byte[this.size];
        System.arraycopy(this.buffer, 0, res, 0, this.size);
        this.pos = 0;
        this.size = 0;
        return res;
    }

    public void set(byte[] newData) {
        this.pos = 0;
        this.size = 0;
        if (newData != null) {
            byte[] byArray = newData;
            int n = newData.length;
            int n2 = 0;
            while (n2 < n) {
                byte data = byArray[n2];
                this.insert(data);
                ++n2;
            }
        }
    }

    public int getPos() {
        return this.pos;
    }

    public byte[] copyCurrentData() {
        byte[] res = new byte[this.size];
        System.arraycopy(this.buffer, 0, res, 0, this.size);
        return res;
    }

    public int getCurrentChar() {
        if (this.pos < this.size) {
            return this.buffer[this.pos] & 0xFF;
        }
        return -1;
    }

    public int getSize() {
        return this.size;
    }

    public int resetPos() {
        int res = this.pos;
        this.pos = 0;
        return res;
    }

    public void replace(int b) {
        if (this.pos == this.size) {
            this.insert(b);
        } else {
            this.buffer[this.pos++] = (byte)b;
        }
    }
}

