/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.HandlerMethodSelector;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHandlerMethodMapping<T>
extends AbstractHandlerMapping {
    private boolean detectHandlerMethodsInAncestorContexts = false;
    private final Map<T, HandlerMethod> handlerMethods = new LinkedHashMap<T, HandlerMethod>();
    private final MultiValueMap<String, T> urlMap = new LinkedMultiValueMap();

    public void setDetectHandlerMethodsInAncestorContexts(boolean detectHandlerMethodsInAncestorContexts) {
        this.detectHandlerMethodsInAncestorContexts = detectHandlerMethodsInAncestorContexts;
    }

    public Map<T, HandlerMethod> getHandlerMethods() {
        return Collections.unmodifiableMap(this.handlerMethods);
    }

    @Override
    public void initApplicationContext() throws ApplicationContextException {
        super.initApplicationContext();
        this.initHandlerMethods();
    }

    protected void initHandlerMethods() {
        String[] beanNames;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for request mappings in application context: " + this.getApplicationContext()));
        }
        String[] stringArray = beanNames = this.detectHandlerMethodsInAncestorContexts ? BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), Object.class) : this.getApplicationContext().getBeanNamesForType(Object.class);
        int n = beanNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            if (this.isHandler(this.getApplicationContext().getType(beanName))) {
                this.detectHandlerMethods(beanName);
            }
            ++n2;
        }
        this.handlerMethodsInitialized(this.getHandlerMethods());
    }

    protected abstract boolean isHandler(Class<?> var1);

    protected void handlerMethodsInitialized(Map<T, HandlerMethod> handlerMethods) {
    }

    protected void detectHandlerMethods(Object handler) {
        Class handlerType = handler instanceof String ? this.getApplicationContext().getType((String)handler) : handler.getClass();
        final Class userType = ClassUtils.getUserClass((Class)handlerType);
        Set methods = HandlerMethodSelector.selectMethods((Class)userType, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return AbstractHandlerMethodMapping.this.getMappingForMethod(method, userType) != null;
            }
        });
        for (Method method : methods) {
            T mapping = this.getMappingForMethod(method, userType);
            this.registerHandlerMethod(handler, method, mapping);
        }
    }

    protected abstract T getMappingForMethod(Method var1, Class<?> var2);

    protected void registerHandlerMethod(Object handler, Method method, T mapping) {
        HandlerMethod handlerMethod;
        if (handler instanceof String) {
            String beanName = (String)handler;
            handlerMethod = new HandlerMethod(beanName, (BeanFactory)this.getApplicationContext(), method);
        } else {
            handlerMethod = new HandlerMethod(handler, method);
        }
        HandlerMethod oldHandlerMethod = this.handlerMethods.get(mapping);
        if (oldHandlerMethod != null && !oldHandlerMethod.equals((Object)handlerMethod)) {
            throw new IllegalStateException("Ambiguous mapping found. Cannot map '" + handlerMethod.getBean() + "' bean method \n" + handlerMethod + "\nto " + mapping + ": There is already '" + oldHandlerMethod.getBean() + "' bean method\n" + oldHandlerMethod + " mapped.");
        }
        this.handlerMethods.put(mapping, handlerMethod);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Mapped \"" + mapping + "\" onto " + handlerMethod));
        }
        Set<String> patterns = this.getMappingPathPatterns(mapping);
        for (String pattern : patterns) {
            if (this.getPathMatcher().isPattern(pattern)) continue;
            this.urlMap.add((Object)pattern, mapping);
        }
    }

    protected abstract Set<String> getMappingPathPatterns(T var1);

    protected HandlerMethod getHandlerInternal(HttpServletRequest request) throws Exception {
        String lookupPath = this.getUrlPathHelper().getLookupPathForRequest(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up handler method for path " + lookupPath));
        }
        HandlerMethod handlerMethod = this.lookupHandlerMethod(lookupPath, request);
        if (this.logger.isDebugEnabled()) {
            if (handlerMethod != null) {
                this.logger.debug((Object)("Returning handler method [" + handlerMethod + "]"));
            } else {
                this.logger.debug((Object)("Did not find handler method for [" + lookupPath + "]"));
            }
        }
        return handlerMethod != null ? handlerMethod.createWithResolvedBean() : null;
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        ArrayList mappings = (ArrayList)this.urlMap.get((Object)lookupPath);
        if (mappings == null) {
            mappings = new ArrayList(this.handlerMethods.keySet());
        }
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Object mapping : mappings) {
            Object match = this.getMatchingMapping(mapping, request);
            if (match == null) continue;
            matches.add(new Match(match, this.handlerMethods.get(mapping)));
        }
        if (!matches.isEmpty()) {
            Match secondBestMatch;
            MatchComparator comparator = new MatchComparator(this.getMappingComparator(request));
            Collections.sort(matches, comparator);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Found " + matches.size() + " matching mapping(s) for [" + lookupPath + "] : " + matches));
            }
            Match bestMatch = (Match)matches.get(0);
            if (matches.size() > 1 && comparator.compare(bestMatch, secondBestMatch = (Match)matches.get(1)) == 0) {
                Method m1 = bestMatch.handlerMethod.getMethod();
                Method m2 = secondBestMatch.handlerMethod.getMethod();
                throw new IllegalStateException("Ambiguous handler methods mapped for HTTP path '" + request.getRequestURL() + "': {" + m1 + ", " + m2 + "}");
            }
            this.handleMatch(bestMatch.mapping, lookupPath, request);
            return bestMatch.handlerMethod;
        }
        return this.handleNoMatch(this.handlerMethods.keySet(), lookupPath, request);
    }

    protected abstract T getMatchingMapping(T var1, HttpServletRequest var2);

    protected abstract Comparator<T> getMappingComparator(HttpServletRequest var1);

    protected void handleMatch(T mapping, String lookupPath, HttpServletRequest request) {
        request.setAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, (Object)lookupPath);
    }

    protected HandlerMethod handleNoMatch(Set<T> mappings, String lookupPath, HttpServletRequest request) throws Exception {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Match {
        private final T mapping;
        private final HandlerMethod handlerMethod;

        private Match(T mapping, HandlerMethod handlerMethod) {
            this.mapping = mapping;
            this.handlerMethod = handlerMethod;
        }

        public String toString() {
            return this.mapping.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatchComparator
    implements Comparator<Match> {
        private final Comparator<T> comparator;

        public MatchComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Match match1, Match match2) {
            return this.comparator.compare(match1.mapping, match2.mapping);
        }
    }
}

