/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.pde.core.internal;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.virgo.ide.pde.core.internal.Helper;
import org.eclipse.virgo.ide.pde.core.internal.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder
extends IncrementalProjectBuilder {
    private static final Path WEBCONTENT_PATH = new Path("WebContent");
    private static final Path OSGI_INF_PATH = new Path("OSGI-INF");
    private static final Path META_INF_PATH = new Path("META-INF");

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        Helper.forcePDEEditor(this.getProject());
        IPath outputLocation = Helper.getOutputLocation(this.getProject());
        if (Helper.DEBUG) {
            String typeStr = "UNKNOWN";
            switch (kind) {
                case 10: {
                    typeStr = "INCREMENTAL";
                    break;
                }
                case 9: {
                    typeStr = "AUTO";
                    break;
                }
                case 15: {
                    typeStr = "CLEAN";
                    break;
                }
                case 6: {
                    typeStr = "FULL";
                }
            }
            this.debug("Build type " + typeStr + " output location: " + outputLocation.toString());
        }
        if (kind == 15) {
            if (Helper.DEBUG) {
                this.debug("Doing nothing");
            }
            return null;
        }
        if (kind != 6) {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                if (Helper.DEBUG) {
                    this.debug("Incremental build was requested but delta is null, performing full build");
                }
                this.fullBuild(outputLocation, monitor);
                return null;
            }
            if (!Helper.checkMETAINFFolder(this.getProject())) {
                if (Helper.DEBUG) {
                    this.debug("Incremental build was requested but META-INF folder is missing from output location, performing full build");
                }
                this.fullBuild(outputLocation, monitor);
                return null;
            }
            if (!Helper.checkLibraries(this.getProject())) {
                if (Helper.DEBUG) {
                    this.debug("Incremental build was requested but some libraries are missing from output location, performing full build");
                }
                this.fullBuild(outputLocation, monitor);
                return null;
            }
            if (Helper.DEBUG) {
                this.debug("Incremental build");
            }
            this.incrementalBuild(outputLocation, delta, monitor);
            return null;
        }
        this.fullBuild(outputLocation, monitor);
        return null;
    }

    private void incrementalBuild(IPath outputLocation, final IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.Builder_IncrementalBuildMessage, 4);
        if (delta.findMember((IPath)META_INF_PATH) != null) {
            this.buildMetaInf(outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
        if (delta.findMember((IPath)OSGI_INF_PATH) != null) {
            this.buildOSGIInf(outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
        if (delta.findMember((IPath)WEBCONTENT_PATH) != null) {
            this.buildWebContent(outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
        Predicate<String> selectChanged = new Predicate<String>(){

            @Override
            public boolean accept(String t) {
                return delta.findMember((IPath)new Path(t)) != null;
            }
        };
        this.buildLibraries(selectChanged, outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    private void fullBuild(IPath outputLocation, IProgressMonitor monitor) throws CoreException {
        if (Helper.DEBUG) {
            this.debug("Full build, output location: " + outputLocation.toOSString());
        }
        monitor.beginTask(Messages.Builder_FullBuildMessage, 4);
        this.buildMetaInf(outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.buildOSGIInf(outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.buildWebContent(outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.buildLibraries(null, outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    private void buildLibraries(Predicate<String> predicate, IPath outputLocation, IProgressMonitor monitor) throws CoreException {
        IFolder binFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputLocation);
        binFolder.refreshLocal(1, null);
        List<String> toCopy = Helper.getLibraryEntries(this.getProject());
        monitor.beginTask(Messages.Builder_copy_libraries, toCopy.size());
        for (String path : toCopy) {
            if (predicate == null || predicate.accept(path)) {
                Helper.copyLibraryToBin(this.getProject(), path);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    private void buildWebContent(IPath outputLocation, IProgressMonitor monitor) throws CoreException, JavaModelException {
        IFolder webContentFolder = this.getProject().getFolder("WebContent");
        if (webContentFolder.exists()) {
            this.buildFilesInFolder(monitor, webContentFolder, ResourcesPlugin.getWorkspace().getRoot().getFolder(outputLocation), Predicate.<IResource>tautology(), true);
        }
    }

    private void buildMetaInf(IPath outputLocation, IProgressMonitor monitor) throws CoreException, JavaModelException {
        IProject project = this.getProject();
        IFolder infFolder = project.getFolder("META-INF");
        if (!infFolder.exists()) {
            this.error("META-INF folder not found for project: " + this.getProject().getName());
            return;
        }
        this.buildTopLevelFolder(outputLocation, monitor, infFolder, "META-INF");
    }

    private void buildOSGIInf(IPath outputLocation, IProgressMonitor monitor) throws CoreException, JavaModelException {
        IProject project = this.getProject();
        IFolder infFolder = project.getFolder("OSGI-INF");
        if (!infFolder.exists()) {
            return;
        }
        this.buildTopLevelFolder(outputLocation, monitor, infFolder, "OSGI-INF");
    }

    private void buildTopLevelFolder(IPath outputLocation, IProgressMonitor monitor, IFolder infFolder, String folder) throws CoreException {
        IFolder binFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputLocation);
        if (!binFolder.exists()) {
            binFolder.create(true, true, null);
        } else if (!binFolder.isSynchronized(1)) {
            binFolder.refreshLocal(1, null);
        }
        IFolder binaryInfFolder = binFolder.getFolder(folder);
        if (!binaryInfFolder.exists()) {
            binaryInfFolder.create(true, true, null);
        } else if (!binaryInfFolder.isSynchronized(1)) {
            binaryInfFolder.refreshLocal(1, null);
        }
        this.buildFilesInFolder(monitor, infFolder, binaryInfFolder, Predicate.<IResource>tautology(), false);
        monitor.done();
    }

    private void buildRootFolder(IPath outputLocation, IProgressMonitor monitor) throws CoreException, JavaModelException {
        IProject project = this.getProject();
        IFolder infFolder = project.getFolder("META-INF");
        if (!infFolder.exists()) {
            this.error("META-INF folder not found for project: " + this.getProject().getName());
            return;
        }
        IFolder binFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputLocation);
        if (!binFolder.exists()) {
            binFolder.create(true, true, null);
        } else if (!binFolder.isSynchronized(1)) {
            binFolder.refreshLocal(1, null);
        }
        IFolder binaryInfFolder = binFolder.getFolder("META-INF");
        if (!binaryInfFolder.exists()) {
            binaryInfFolder.create(true, true, null);
        } else if (!binaryInfFolder.isSynchronized(1)) {
            binaryInfFolder.refreshLocal(1, null);
        }
        this.buildFilesInFolder(monitor, infFolder, binaryInfFolder, Predicate.<IResource>tautology(), false);
        monitor.done();
    }

    private void buildFilesInFolder(IProgressMonitor monitor, IFolder from, IFolder to, Predicate<IResource> predicate, boolean merge) throws CoreException {
        IResource[] children = from.members();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)children.length);
        sub.beginTask(NLS.bind((String)Messages.Builder_CopyContent, (Object)from.getName()), children.length);
        IResource[] iResourceArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource sourceResource = iResourceArray[n2];
            if (predicate.accept(sourceResource)) {
                if (!sourceResource.isTeamPrivateMember() && !sourceResource.isDerived()) {
                    IPath targetPath = to.getFullPath().append(sourceResource.getName());
                    IResource targetResource = ResourcesPlugin.getWorkspace().getRoot().findMember(targetPath);
                    if (targetResource != null && targetResource.exists()) {
                        if (Helper.DEBUG) {
                            this.debug(String.valueOf(targetResource.getFullPath().toString()) + " exists");
                        }
                        targetResource.refreshLocal(2, null);
                        if (targetResource.getType() == 1) {
                            this.replaceFile(sourceResource, targetResource);
                        } else {
                            this.recurseInFolder(sourceResource, targetResource, predicate, merge);
                        }
                    } else {
                        sourceResource.copy(targetPath, true, null);
                        if (Helper.DEBUG) {
                            this.debug("Copied " + sourceResource.getFullPath().toString() + " to " + targetPath.toString());
                        }
                    }
                }
                sub.worked(1);
            }
            ++n2;
        }
        monitor.done();
    }

    private void recurseInFolder(IResource from, IResource to, Predicate<IResource> predicate, boolean merge) throws CoreException {
        IPath toPath = to.getFullPath();
        if (!merge) {
            to.delete(true, null);
            from.copy(toPath, true, null);
            if (Helper.DEBUG) {
                this.debug("Copied " + from.getFullPath().toString() + " to " + toPath.toString());
            }
        } else {
            this.buildFilesInFolder((IProgressMonitor)new NullProgressMonitor(), (IFolder)from, (IFolder)to, predicate, true);
            if (Helper.DEBUG) {
                this.debug("Merged " + from.getFullPath().toString() + " into " + toPath.toString());
            }
        }
    }

    private void replaceFile(IResource from, IResource to) throws CoreException {
        to.delete(true, null);
        if (Helper.DEBUG) {
            this.debug(String.valueOf(to.getFullPath().toString()) + " deleted");
        }
        from.copy(to.getFullPath(), true, null);
        if (Helper.DEBUG) {
            this.debug("Copied " + from.getFullPath().toString() + " to " + to.getFullPath().toString());
        }
    }

    private void debug(String string) {
        Helper.debug(String.valueOf(this.getProject().getName()) + " - " + string);
    }

    private void error(String string) {
        Helper.error(String.valueOf(this.getProject().getName()) + " - " + string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Predicate<T> {
        private Predicate() {
        }

        public abstract boolean accept(T var1);

        public static final <T> Predicate<T> tautology() {
            return new Predicate<T>(){

                @Override
                public boolean accept(T t) {
                    return true;
                }
            };
        }
    }
}

