/**
 * 
 *   Copyright (c) 2010-2013, Abel Hegedus, Zoltan Ujhelyi, Denes Harmath, Istvan Rath and Daniel Varro, IncQuery Labs Ltd.
 *   This program and the accompanying materials are made available under the
 *   terms of the Eclipse Public License v. 2.0 which is available at
 *   http://www.eclipse.org/legal/epl-v20.html.
 *   
 *   SPDX-License-Identifier: EPL-2.0
 *  
 */
package org.eclipse.viatra.integration.uml.derivedfeatures.internal;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.integration.uml.derivedfeatures.internal.StateMachineContainment;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecificationWithGenericMatcher;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PVisibility;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

/**
 * A pattern-specific query specification that can instantiate GenericPatternMatcher in a type-safe way.
 * 
 * <p>Original source:
 *         <code><pre>
 *         (memberEnd-{@literal >}reject(p | ownedEnd-{@literal >}includes(p.oclAsType(ExtensionEnd)))-{@literal >}any(true))
 *         
 *         // Can't compile OCL to VIATRA Query because of java.lang.IllegalArgumentException: Iterator expression kind must be collect, select or reject instead of any in self.memberEnd-{@literal >}reject(p : Property | self.ownedEnd-{@literal >}includes(p.oclAsType(uml::ExtensionEnd)))-{@literal >}any(temp1 : Property | true)
 *         //pattern extensionMetaclassEnd(source: Extension, target: Property) {}
 *         
 *         
 *         (if (lowerValue=null or lowerValue.integerValue()=null) then 1 else lowerValue.integerValue() endif)
 *         
 *         // Can't compile OCL to VIATRA Query because of java.lang.UnsupportedOperationException: integerValue
 *         //pattern multiplicityElementLowerBound(source: MultiplicityElement, target: Integer) {}
 *         
 *         
 *         (if (upperValue=null or upperValue.unlimitedValue()=null) then 1 else upperValue.unlimitedValue() endif)
 *         
 *         // Can't compile OCL to VIATRA Query because of java.lang.UnsupportedOperationException: unlimitedValue
 *         //pattern multiplicityElementUpperBound(source: MultiplicityElement, target: UnlimitedNatural) {}
 *         
 *         
 *         (ownedParameter-{@literal >}select (direction = ParameterDirectionKind::return)-{@literal >}asSet())
 *         
 *         //private pattern operationReturnResult(
 *         //    self : Operation,
 *         //    temp1 : Parameter
 *         //) {
 *         //    Parameter.direction(temp1, parameterDirectionKind);
 *         //    parameterDirectionKind_0 == ParameterDirectionKind::^return;
 *         //    parameterDirectionKind == parameterDirectionKind_0;
 *         //    BehavioralFeature.ownedParameter(self, parameter);
 *         //    temp1 == parameter;
 *         //}
 *         
 *         
 *         (member-{@literal >}select( m | m.oclIsKindOf(PackageableElement) and self.makesVisible(m))-{@literal >}collect(oclAsType(PackageableElement))-{@literal >}asSet())
 *         
 *         // Can't compile OCL to VIATRA Query because of java.lang.UnsupportedOperationException: makesVisible
 *         //pattern packageVisibleMembers(source: Package, target: PackageableElement) {}
 *         
 *         
 *         (if type.oclIsKindOf(Interface) 
 *         then type.oclAsType(Interface)-{@literal >}asSet() 
 *         else type.oclAsType(Classifier).allRealizedInterfaces() 
 *         endif)
 *         
 *         // Can't compile OCL to VIATRA Query because of java.lang.UnsupportedOperationException: allRealizedInterfaces
 *         //pattern portBasicProvided(source: Port, target: Interface) {}
 *         
 *         
 *         ( type.oclAsType(Classifier).allUsedInterfaces() )
 *         
 *         // Can't compile OCL to VIATRA Query because of java.lang.UnsupportedOperationException: allUsedInterfaces
 *         //pattern portBasicRequired(source: Port, target: Interface) {}
 *         
 *         
 *         (if stateMachine = null 
 *         then
 *           state.containingStateMachine()
 *         else
 *           stateMachine
 *         endif)
 *         
 *         // Can't compile OCL to VIATRA Query because of java.lang.UnsupportedOperationException: containingStateMachine
 *         private pattern regionContainingStateMachine(source: Region, target: StateMachine) {
 *             find stateMachineContainment+(source, target);
 *         }
 * </pre></code>
 * 
 * @see GenericPatternMatcher
 * @see GenericPatternMatch
 * 
 */
@SuppressWarnings("all")
public final class RegionContainingStateMachine extends BaseGeneratedEMFQuerySpecificationWithGenericMatcher {
  private RegionContainingStateMachine() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryRuntimeException if the pattern definition could not be loaded
   * 
   */
  public static RegionContainingStateMachine instance() {
    try{
        return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
        throw processInitializerError(err);
    }
  }
  
  /**
   * Inner class allowing the singleton instance of {@link RegionContainingStateMachine} to be created 
   *     <b>not</b> at the class load time of the outer class, 
   *     but rather at the first call to {@link RegionContainingStateMachine#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private static final RegionContainingStateMachine INSTANCE = new RegionContainingStateMachine();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private static final Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternal();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private static final RegionContainingStateMachine.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_source = new PParameter("source", "org.eclipse.uml2.uml.Region", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/uml2/5.0.0/UML", "Region")), PParameterDirection.INOUT);
    
    private final PParameter parameter_target = new PParameter("target", "org.eclipse.uml2.uml.StateMachine", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/uml2/5.0.0/UML", "StateMachine")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_source, parameter_target);
    
    private GeneratedPQuery() {
      super(PVisibility.PRIVATE);
    }
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.integration.uml.derivedfeatures.regionContainingStateMachine";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("source","target");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() {
      setEvaluationHints(new QueryEvaluationHint(null, QueryEvaluationHint.BackendRequirement.UNSPECIFIED));
      Set<PBody> bodies = new LinkedHashSet<>();
      {
          PBody body = new PBody(this);
          PVariable var_source = body.getOrCreateVariableByName("source");
          PVariable var_target = body.getOrCreateVariableByName("target");
          new TypeConstraint(body, Tuples.flatTupleOf(var_source), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Region")));
          new TypeConstraint(body, Tuples.flatTupleOf(var_target), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "StateMachine")));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_source, parameter_source),
             new ExportedParameter(body, var_target, parameter_target)
          ));
          //     find stateMachineContainment+(source, target)
          new BinaryTransitiveClosure(body, Tuples.flatTupleOf(var_source, var_target), StateMachineContainment.instance().getInternalQueryRepresentation());
          bodies.add(body);
      }
      return bodies;
    }
  }
}
