/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.unit;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.unit.BaseUnit;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.Units;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class UnitDimension
implements Dimension,
Serializable {
    private static final long serialVersionUID = 7806787530512644696L;
    private static final System.Logger LOGGER = System.getLogger(UnitDimension.class.getPackage().getName());
    public static final Dimension NONE = new UnitDimension(AbstractUnit.ONE);
    public static final Dimension LENGTH = new UnitDimension('L');
    public static final Dimension MASS = new UnitDimension('M');
    public static final Dimension TIME = new UnitDimension('T');
    public static final Dimension ELECTRIC_CURRENT = new UnitDimension('I');
    public static final Dimension TEMPERATURE = new UnitDimension('\u0398');
    public static final Dimension AMOUNT_OF_SUBSTANCE = new UnitDimension('N');
    public static final Dimension LUMINOUS_INTENSITY = new UnitDimension('J');
    private final Unit<?> pseudoUnit;

    public static <Q extends Quantity<Q>> Dimension of(Class<Q> quantityType) {
        Unit<Q> siUnit = Units.getInstance().getUnit(quantityType);
        if (siUnit == null && LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Quantity type: " + quantityType + " unknown");
        }
        return siUnit != null ? siUnit.getDimension() : null;
    }

    public static Dimension parse(char symbol) {
        return new UnitDimension(symbol);
    }

    private UnitDimension(char symbol) {
        this.pseudoUnit = new BaseUnit("[" + symbol + "]", NONE);
    }

    private UnitDimension(Unit<?> pseudoUnit) {
        this.pseudoUnit = pseudoUnit;
    }

    protected UnitDimension() {
        this(AbstractUnit.ONE);
    }

    public Dimension multiply(Dimension that) {
        return that instanceof UnitDimension ? this.multiply((UnitDimension)that) : this.multiply(that);
    }

    private UnitDimension multiply(UnitDimension that) {
        return new UnitDimension(this.pseudoUnit.multiply(that.pseudoUnit));
    }

    public Dimension divide(Dimension that) {
        return that instanceof UnitDimension ? this.divide((UnitDimension)that) : this.divide(that);
    }

    private UnitDimension divide(UnitDimension that) {
        return new UnitDimension(ProductUnit.ofQuotient(this.pseudoUnit, that.pseudoUnit));
    }

    public UnitDimension pow(int n) {
        return new UnitDimension(this.pseudoUnit.pow(n));
    }

    public UnitDimension root(int n) {
        return new UnitDimension(this.pseudoUnit.root(n));
    }

    public Map<? extends Dimension, Integer> getBaseDimensions() {
        Map pseudoUnits = this.pseudoUnit.getBaseUnits();
        if (pseudoUnits == null) {
            return null;
        }
        HashMap<UnitDimension, Integer> baseDimensions = new HashMap<UnitDimension, Integer>();
        for (Map.Entry entry : pseudoUnits.entrySet()) {
            baseDimensions.put(new UnitDimension((Unit)entry.getKey()), (Integer)entry.getValue());
        }
        return baseDimensions;
    }

    public String toString() {
        return this.pseudoUnit.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnitDimension) {
            UnitDimension other = (UnitDimension)obj;
            return Objects.equals(this.pseudoUnit, other.pseudoUnit);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.pseudoUnit);
    }
}

