/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core.tests.htStore;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTCoreNodeTest;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTNodeTest;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.IHTNode;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.tests.historytree.SegmentTreeNodeStub;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@NonNullByDefault
public class SegmentTreeCoreNodeTest
extends HTCoreNodeTest<BasicSegment, SegmentTreeNodeStub> {
    private static final HTNodeTest.ObjectFactory<BasicSegment> BASE_SEGMENT_FACTORY = (s, e) -> new BasicSegment(s, e);

    public SegmentTreeCoreNodeTest(String name, int headerSize, AbstractHistoryTree.IHTNodeFactory<BasicSegment, SegmentTreeNodeStub> factory, IHTIntervalReader<BasicSegment> objReader, HTNodeTest.ObjectFactory<BasicSegment> objFactory) throws IOException {
        super(name, headerSize, factory, objReader, objFactory);
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList(new Object[][]{{"Segment tree core node", 222, SegmentTreeNodeStub.NODE_FACTORY, BasicSegment.BASIC_SEGMENT_READ_FACTORY, BASE_SEGMENT_FACTORY}});
    }

    @Test
    public void testSpecifics() {
        long start = 10L;
        int shortLen = 10;
        int longLen = 50;
        SegmentTreeNodeStub stub = (SegmentTreeNodeStub)this.newNode(0, -1, start);
        Assert.assertEquals((long)start, (long)stub.getMaxStart());
        Assert.assertEquals((long)start, (long)stub.getMinEnd());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)stub.getShortest());
        Assert.assertEquals((long)0L, (long)stub.getLongest());
        BasicSegment segment = new BasicSegment(start, start + (long)shortLen);
        stub.add((ISegment)segment);
        Assert.assertEquals((long)start, (long)stub.getMaxStart());
        Assert.assertEquals((long)(start + (long)shortLen), (long)stub.getMinEnd());
        Assert.assertEquals((long)shortLen, (long)stub.getShortest());
        Assert.assertEquals((long)shortLen, (long)stub.getLongest());
        segment = new BasicSegment(start + (long)shortLen, start + (long)longLen);
        stub.add((ISegment)segment);
        Assert.assertEquals((long)(start + (long)shortLen), (long)stub.getMaxStart());
        Assert.assertEquals((long)(start + (long)shortLen), (long)stub.getMinEnd());
        Assert.assertEquals((long)shortLen, (long)stub.getShortest());
        Assert.assertEquals((long)(longLen - shortLen), (long)stub.getLongest());
    }

    @Test
    public void testChildren() {
        long start = 10L;
        int shortLen = 10;
        int longLen = 50;
        SegmentTreeNodeStub parentStub = (SegmentTreeNodeStub)this.newNode(0, -1, start);
        SegmentTreeNodeStub stub = (SegmentTreeNodeStub)this.newNode(0, -1, start);
        parentStub.linkNewChild((IHTNode)stub);
        Assert.assertEquals((long)start, (long)parentStub.getMaxStart(0));
        Assert.assertEquals((long)start, (long)parentStub.getMinEnd(0));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)parentStub.getShortest(0));
        Assert.assertEquals((long)0L, (long)parentStub.getLongest(0));
        BasicSegment segment = new BasicSegment(start, start + (long)shortLen);
        stub.add((ISegment)segment);
        segment = new BasicSegment(start + (long)shortLen, start + (long)longLen);
        stub.add((ISegment)segment);
        Assert.assertEquals((long)(start + (long)shortLen), (long)stub.getMaxStart());
        Assert.assertEquals((long)(start + (long)shortLen), (long)stub.getMinEnd());
        Assert.assertEquals((long)shortLen, (long)stub.getShortest());
        Assert.assertEquals((long)(longLen - shortLen), (long)stub.getLongest());
        stub.closeThisNode(start + (long)longLen);
        Assert.assertEquals((long)(start + (long)shortLen), (long)parentStub.getMaxStart(0));
        Assert.assertEquals((long)(start + (long)shortLen), (long)parentStub.getMinEnd(0));
        Assert.assertEquals((long)shortLen, (long)parentStub.getShortest(0));
        Assert.assertEquals((long)(longLen - shortLen), (long)parentStub.getLongest(0));
        Assert.assertEquals((long)start, (long)parentStub.getMaxStart());
        Assert.assertEquals((long)start, (long)parentStub.getMinEnd());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)parentStub.getShortest());
        Assert.assertEquals((long)0L, (long)parentStub.getLongest());
    }

    @Test
    public void testIntersectingChildren() {
        long start = 10L;
        long step = 1000L;
        SegmentTreeNodeStub parentStub = (SegmentTreeNodeStub)this.newNode(0, -1, start);
        SegmentTreeNodeStub stub = (SegmentTreeNodeStub)this.newNode(1, 0, start);
        SegmentTreeNodeStub stub2 = (SegmentTreeNodeStub)this.newNode(2, 0, start + step);
        SegmentTreeNodeStub stub3 = (SegmentTreeNodeStub)this.newNode(3, 0, start + 2L * step);
        parentStub.linkNewChild((IHTNode)stub);
        parentStub.linkNewChild((IHTNode)stub2);
        parentStub.linkNewChild((IHTNode)stub3);
        stub.closeThisNode(start + 2L * step);
        stub2.closeThisNode(start + 3L * step);
        stub3.closeThisNode(start + 4L * step);
        Collection children = parentStub.selectNextChildren(TimeRangeCondition.forContinuousRange((long)0L, (long)Long.MAX_VALUE));
        Assert.assertArrayEquals((Object[])ImmutableSet.of((Object)stub.getSequenceNumber(), (Object)stub2.getSequenceNumber(), (Object)stub3.getSequenceNumber()).toArray(), (Object[])children.toArray());
        children = parentStub.selectNextChildren(TimeRangeCondition.forContinuousRange((long)(start + step), (long)(start + 3L * step)));
        Assert.assertArrayEquals((Object[])ImmutableSet.of((Object)stub.getSequenceNumber(), (Object)stub2.getSequenceNumber(), (Object)stub3.getSequenceNumber()).toArray(), (Object[])children.toArray());
        children = parentStub.selectNextChildren(TimeRangeCondition.forContinuousRange((long)(start + step - 2L), (long)(start + 2L * step - 2L)));
        Assert.assertArrayEquals((Object[])ImmutableSet.of((Object)stub.getSequenceNumber(), (Object)stub2.getSequenceNumber()).toArray(), (Object[])children.toArray());
        children = parentStub.selectNextChildren(TimeRangeCondition.forContinuousRange((long)(start + 3L * step - 2L), (long)(start + 4L * step - 2L)));
        Assert.assertArrayEquals((Object[])ImmutableSet.of((Object)stub2.getSequenceNumber(), (Object)stub3.getSequenceNumber()).toArray(), (Object[])children.toArray());
    }
}

